/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// protocol.h -- communications protocols

#define	PROTOCOL_VERSION	15

// if the high bit of the servercmd is set, the low bits are fast update flags:
#define	U_MOREBITS	(1<<0)
#define	U_ORIGIN1	(1<<1)
#define	U_ORIGIN2	(1<<2)
#define	U_ORIGIN3	(1<<3)
#define	U_ANGLE2	(1<<4)
#define	U_NOLERP	(1<<5)		// don't interpolate movement
#define	U_FRAME		(1<<6)
#define U_SIGNAL	(1<<7)		// just differentiates from other updates

// svc_update can pass all of the fast update bits, plus more
#define	U_ANGLE1	(1<<8)
#define	U_ANGLE3	(1<<9)
#define	U_MODEL		(1<<10)
#define	U_COLORMAP	(1<<11)
#define	U_SKIN		(1<<12)
#define	U_EFFECTS	(1<<13)
#define	U_LONGENTITY	(1<<14)

// Tomaz - QC Alpha Scale Glow Control & More Frames Begin
#define	U_EXTEND1	(1<<15)

#define	U_SCALE		(1<<16)
#define	U_ALPHA		(1<<17)
#define	U_GLOW_SIZE	(1<<18)
#define	U_GLOW_RED	(1<<19)
#define	U_GLOW_GREEN (1<<20)
#define	U_GLOW_BLUE	(1<<21)
#define U_FRAME2	(1<<22) // 1 byte, this is .frame & 0xFF00 (second byte)
#define	U_EXTEND2	(1<<23) // another byte to follow
// Tomaz - QC Alpha Scale Glow Control & More Frames End

// Tei more effects 
#define	U_EFFECTS2	(1<<24) // more fx
#define	U_EFFECTS3	(1<<25) // more fx
// Tei more effects 


#define	SU_VIEWHEIGHT	(1<<0)
#define	SU_IDEALPITCH	(1<<1)
#define	SU_PUNCH1		(1<<2)
#define	SU_PUNCH2		(1<<3)
#define	SU_PUNCH3		(1<<4)
#define	SU_VELOCITY1	(1<<5)
#define	SU_VELOCITY2	(1<<6)
#define	SU_VELOCITY3	(1<<7)
//define	SU_AIMENT		(1<<8)  AVAILABLE BIT
#define	SU_ITEMS		(1<<9)
#define	SU_ONGROUND		(1<<10)		// no data follows, the bit is it
#define	SU_INWATER		(1<<11)		// no data follows, the bit is it
#define	SU_WEAPONFRAME	(1<<12)
#define	SU_ARMOR		(1<<13)
#define	SU_WEAPON		(1<<14)

// a sound with no channel is a local only sound
#define	SND_VOLUME		(1<<0)		// a byte
#define	SND_ATTENUATION	(1<<1)		// a byte
#define	SND_LOOPING		(1<<2)		// a long


// defaults for clientinfo messages
#define	DEFAULT_VIEWHEIGHT	22


// game types sent by serverinfo
// these determine which intermission screen plays
#define	GAME_COOP			0
#define	GAME_DEATHMATCH		1

//==================
// note that there are some defs.qc that is the same as these numbers
// also related to svc_strings[] in cl_parse
//==================

//
// server to client
//
#define	svc_bad				0
#define	svc_nop				1
#define	svc_disconnect		2
#define	svc_updatestat		3	// [byte] [long]
#define	svc_version			4	// [long] server version
#define	svc_setview			5	// [short] entity number
#define	svc_sound			6	// <see code>
#define	svc_time			7	// [float] server time
#define	svc_print			8	// [string] null terminated string
#define	svc_stufftext		9	// [string] stuffed into client's console buffer
								// the string should be \n terminated
#define	svc_setangle		10	// [angle3] set the view angle to this absolute value
	
#define	svc_serverinfo		11	// [long] version
						// [string] signon string
						// [string]..[0]model cache
						// [string]...[0]sounds cache
#define	svc_lightstyle		12	// [byte] [string]
#define	svc_updatename		13	// [byte] [string]
#define	svc_updatefrags		14	// [byte] [short]
#define	svc_clientdata		15	// <shortbits + data>
#define	svc_stopsound		16	// <see code>
#define	svc_updatecolors	17	// [byte] [byte]
#define	svc_particle		18	// [vec3] <variable>
#define	svc_damage			19
	
#define	svc_spawnstatic		20
//	svc_spawnbinary		21
#define	svc_spawnbaseline	22
	
#define	svc_temp_entity		23

#define	svc_setpause		24	// [byte] on / off
#define	svc_signonnum		25	// [byte]  used for the signon sequence

#define	svc_centerprint		26	// [string] to put in center of the screen

#define	svc_killedmonster	27
#define	svc_foundsecret		28

#define	svc_spawnstaticsound	29	// [coord3] [byte] samp [byte] vol [byte] aten

#define	svc_intermission	30		// [string] music
#define	svc_finale			31		// [string] music [string] text

#define	svc_cdtrack			32		// [byte] track [byte] looptrack
#define svc_sellscreen		33

#define svc_cutscene		34

#define	svc_showlmp			35		// Tomaz - Show LMP
#define	svc_hidelmp			36		// Tomaz - Hide LMP
#define	svc_skybox			37		// Tomaz - Skybox

#define	svc_changefov		38		// Tei - Changefov
#define svc_rexec			39		// Tei - rexec client

#define	svc_setflags		40		// FH!

#define svc_showlmp2		41		// Tei - best showlmp
#define svc_showlmp3		42		// Tei - best showlmp counters


//
// client to server
//
#define	clc_bad			0
#define	clc_nop 		1
#define	clc_disconnect	2
#define	clc_move		3			// [usercmd_t]
#define	clc_stringcmd	4		// [string] message


//
// temp entity events
//
#define	TE_SPIKE			0
#define	TE_SUPERSPIKE		1
#define	TE_GUNSHOT			2
#define	TE_EXPLOSION		3
#define	TE_TAREXPLOSION		4
#define	TE_LIGHTNING1		5
#define	TE_LIGHTNING2		6
#define	TE_WIZSPIKE			7
#define	TE_KNIGHTSPIKE		8
#define	TE_LIGHTNING3		9
#define	TE_LAVASPLASH		10
#define	TE_TELEPORT			11
#define TE_EXPLOSION2		12

// PGM 01/21/97 
#define TE_BEAM				13
// PGM 01/21/97 

#define TE_SNOW				14	// Tomaz - Snow
#define TE_RAIN				15	// Tomaz - Rain
#define	TE_PLASMA			16	// Tomaz - Plasma Gun
#define TE_RAILTRAIL		17	// Tomaz - RailGun

#define TE_CUSTOMFX			18	// Tei custom fx
#define TE_EXPLOSIONSMALL	19	// Tei custom fx
#define TE_EXPLOSIONSMALL2	20	// Tei custom fx
#define TE_EXPLOSIONSMALL3	21	// Tei custom fx


#define TE_TRAILS			46
#define	TE_LIGHTNING4		47
#define	TE_LIGHTNINGX		48	// Custom beam?
#define TE_PRJ				49	// StaticFX
#define TE_IMPLOSIONFX		50	// implosive particles 
#define TE_STATICFOG		51	// Static fog (for clouds?)
#define TE_PARTICLEBLAST	52	// flare alike blast of particles
////////////////////////
// FH! Code here
//

#define TE_FREE				22
#define TE_THRUST			23
#define TE_TRAIL			24
#define TE_BLOODTRAIL		25
#define	TE_SPARK			26
#define TE_BRIGHTFIELD		27
#define TE_SMALLPUFF		28
#define TE_GLOWPUFF			29

#define	TE_SMALLGLOW		30
#define	TE_BUBBLEGLOW		31
#define	TE_SPARKGLOW		32
#define	TE_BOLTGLOW			33
#define	TE_BIGGLOW			34
#define TE_SHOCKWAVE		35
#define	TE_BIGSHOCKWAVE		36
#define	TE_SPARKWAVE		37
//#define	TE_RAIN				38
//#define	TE_SNOW				39
#define	TE_GOLDGLOW			40
#define	TE_BLUEGLOW			41
#define TE_TORCHGLOW		42

#define TE_FIRE				42
#define TE_RADARBLIP		43
#define	TE_FLAMESPRAY		44
#define TE_BLOOD			45

// particle drawtypes
#define PFX_GLOW		0
#define PFX_TWINKLE		1
#define PFX_SPRITE		2
#define	PFX_HUD			3
#define PFX_DART		4

// Code Here
//
/////////////////////////