/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

//
// particle engine
//

#include "quakedef.h"

typedef enum	ptype_s		ptype_t;
typedef struct	particle_s	particle_t;

enum ptype_s
{
	pt_static		= 0 << 0, 
	pt_smoke		= 1 << 0, 
	pt_bubble		= 1 << 1,
	pt_explode		= 1 << 2, 
	pt_blood		= 1 << 3,
	pt_blood2		= 1 << 4,
	pt_snow			= 1 << 5,
	pt_rain			= 1 << 6,
	pt_bulletpuff	= 1 << 7, 
	pt_fade			= 1 << 8,
	pt_grav			= 1 << 9,
	pt_rail			= 1 << 10,
	pt_blob			= 1 << 11,
	pt_blob2		= 1 << 12,
	pt_smokeexp		= 1 << 13,
	pt_fire			= 1 << 14,
	pt_fire2		= 1 << 15,
	// Tei extra beahv
	pt_slowmoke		= 1 << 16,
	pt_expandfade	= 1 << 17,
	pt_expand		= 1 << 18,
	pt_slowmoke2	= 1 << 19,
	pt_snowfade		= 1 << 20,
	pt_fadeout		= 1 << 21,
	pt_fog			= 1 << 22,
	pt_gorigin		= 1 << 23
	// Tei extra beahv
};


#define FXC_NOFX		0
#define FXC_AUTOGRAY	1
#define FXC_AUTOGRAY2	2


struct particle_s
{
	int					texnum;
	int					contents;
	
	float				die;
	float				time;
	float				alpha;
	float				scale;

	float				scalex,scaley,scalez; // Tei particled scaled

	float				bounce;
	
	byte				colorred;
	byte				colorgreen;
	byte				colorblue;

	//Tei velcolor
	byte				fxcolor;
	//Tei velcolor
	
	vec3_t				origin;
	vec3_t				velocity;
	
	// Tei implosion
	vec3_t				gorigin;
	// Tei implosion

	ptype_t				type;

	qboolean			glow;
	//qboolean			volumetric; //Tei 

	particle_t			*next;
	particle_t			*prev;

	/////////////////////////////
	//+FH
	/*

	//vec3_t		org; <--origin
	//float		color;<---color rgb
	//struct particle_s	*next;
	//vec3_t		vel;<---velocity
	float		ramp;
	//float		die;
	//float		born;//time?
	//ptype_t		type;
	int			fxtype;
	//int			tex_num;
	int			drawtype;
	//float		scale;
	//float		alpha;

	float		angle;
	float		v_angle;
	*/
	//+FH
	////////////////////////////
};

int		particle_tex;
int		smoke1_tex;
int		smoke2_tex;
int		smoke3_tex;
int		smoke4_tex;
int		blood_tex;
int		bubble_tex;
int		snow_tex;
int		rain_tex;

// Tei new particles hardcoded
int		fire_tex;
int		flare_tex;
int		money_tex;
int		flama_tex;
int		circle_tex;
// Tei new particles hardcoded

particle_t	*active_particles, *free_particles, *particles;

int		r_numparticles;

vec3_t	r_pright, r_pup, r_ppn;

extern byte	particle[32][32];
extern byte	smoke1[32][32];
extern byte	smoke2[32][32];
extern byte	smoke3[32][32];
extern byte	smoke4[32][32];
extern byte	blood[32][32];
extern byte	bubble[32][32];
extern byte	snow[32][32];
extern byte	rain[32][32];

// Tei new particles hardcoded
extern byte	fire[32][32];
extern byte	flare[32][32];
extern byte	money[32][32];
extern byte	flama[32][32];
extern byte	circle[32][32];
// Tei new particles hardcoded

// FH!
int		smoke_texFH, fire_texFH, radar_texFH, explo_texFH, debris_texFH, spark_texFH, blood_texFH;
// FH!


void R_InitParticleTexture (void)
{
	int		x, y;
	byte	data[32][32][4];

	for (x=0 ; x<32 ; x++)
	{
		for (y=0 ; y<32 ; y++)
		{
			data[x][y][0]	= 255;
			data[x][y][1]	= 255;
			data[x][y][2]	= 255;
			data[x][y][3]	= particle[x][y];
		}
	}
	particle_tex = GL_LoadTexture ("particle", 32, 32, &data[0][0][0], true, true, 4);

	for (x=0 ; x<32 ; x++)
	{
		for (y=0 ; y<32 ; y++)
		{
			data[x][y][0]	= 255;
			data[x][y][1]	= 255;
			data[x][y][2]	= 255;
			data[x][y][3]	= smoke1[x][y];
		}
	}
	smoke1_tex = GL_LoadTexture ("smoke1", 32, 32, &data[0][0][0], true, true, 4);

	for (x=0 ; x<32 ; x++)
	{
		for (y=0 ; y<32 ; y++)
		{
			data[x][y][0]	= 255;
			data[x][y][1]	= 255;
			data[x][y][2]	= 255;
			data[x][y][3]	= smoke2[x][y];
		}
	}
	smoke2_tex = GL_LoadTexture ("smoke2", 32, 32, &data[0][0][0], true, true, 4);

	for (x=0 ; x<32 ; x++)
	{
		for (y=0 ; y<32 ; y++)
		{
			data[x][y][0]	= 255;
			data[x][y][1]	= 255;
			data[x][y][2]	= 255;
			data[x][y][3]	= smoke3[x][y];
		}
	}
	smoke3_tex = GL_LoadTexture ("smoke3", 32, 32, &data[0][0][0], true, true, 4);

	for (x=0 ; x<32 ; x++)
	{
		for (y=0 ; y<32 ; y++)
		{
			data[x][y][0]	= 255;
			data[x][y][1]	= 255;
			data[x][y][2]	= 255;
			data[x][y][3]	= smoke4[x][y];
		}
	}
	smoke4_tex = GL_LoadTexture ("smoke4", 32, 32, &data[0][0][0], true, true, 4);

	for (x=0 ; x<32 ; x++)
	{
		for (y=0 ; y<32 ; y++)
		{
			data[x][y][0]	= 255;
			data[x][y][1]	= 255;
			data[x][y][2]	= 255;
			data[x][y][3]	= blood[x][y];
		}
	}
	blood_tex = GL_LoadTexture ("blood", 32, 32, &data[0][0][0], true, true, 4);

	for (x=0 ; x<32 ; x++)
	{
		for (y=0 ; y<32 ; y++)
		{
			data[x][y][0]	= 255;
			data[x][y][1]	= 255;
			data[x][y][2]	= 255;
			data[x][y][3]	= bubble[x][y];
		}
	}
	bubble_tex = GL_LoadTexture ("bubble", 32, 32, &data[0][0][0], true, true, 4);

	for (x=0 ; x<32 ; x++)
	{
		for (y=0 ; y<32 ; y++)
		{
			data[x][y][0]	= 255;
			data[x][y][1]	= 255;
			data[x][y][2]	= 255;
			data[x][y][3]	= snow[x][y];
		}
	}
	snow_tex = GL_LoadTexture ("snow", 32, 32, &data[0][0][0], true, true, 4);

	for (x=0 ; x<32 ; x++)
	{
		for (y=0 ; y<32 ; y++)
		{
			data[x][y][0]	= 255;
			data[x][y][1]	= 255;
			data[x][y][2]	= 255;
			data[x][y][3]	= rain[x][y];
		}
	}
	rain_tex = GL_LoadTexture ("rain", 32, 32, &data[0][0][0], true, true, 4);

	// Tei new tex

	for (x=0 ; x<32 ; x++)
	{
		for (y=0 ; y<32 ; y++)
		{
			data[x][y][0]	= 255;
			data[x][y][1]	= 255;
			data[x][y][2]	= 255;
			data[x][y][3]	= fire[x][y];
		}
	}
	fire_tex = GL_LoadTexture ("fire", 32, 32, &data[0][0][0], true, true, 4);

	for (x=0 ; x<32 ; x++)
	{
		for (y=0 ; y<32 ; y++)
		{
			data[x][y][0]	= 255;
			data[x][y][1]	= 255;
			data[x][y][2]	= 255;
			data[x][y][3]	= flare[x][y];
		}
	}
	flare_tex = GL_LoadTexture ("flare", 32, 32, &data[0][0][0], true, true, 4);

	for (x=0 ; x<32 ; x++)
	{
		for (y=0 ; y<32 ; y++)
		{
			data[x][y][0]	= 255;
			data[x][y][1]	= 255;
			data[x][y][2]	= 255;
			data[x][y][3]	= money[x][y];
		}
	}
	money_tex = GL_LoadTexture ("money", 32, 32, &data[0][0][0], true, true, 4);

	for (x=0 ; x<32 ; x++)
	{
		for (y=0 ; y<32 ; y++)
		{
			data[x][y][0]	= 255;
			data[x][y][1]	= 255;
			data[x][y][2]	= 255;
			data[x][y][3]	= flama[x][y];
		}
	}
	flama_tex = GL_LoadTexture ("flama", 32, 32, &data[0][0][0], true, true, 4);

	for (x=0 ; x<32 ; x++)
	{
		for (y=0 ; y<32 ; y++)
		{
			data[x][y][0]	= 255;
			data[x][y][1]	= 255;
			data[x][y][2]	= 255;
			data[x][y][3]	= circle[x][y];
		}
	}
	circle_tex = GL_LoadTexture ("circle", 32, 32, &data[0][0][0], true, true, 4);
	// Tei new tex

	//FH!
	/*
	smoke_texFH = loadtextureimage("smoke1FH", true,true);
	loadtextureimage("smoke2FH", true,true);
	loadtextureimage("smoke3FH", true,true);
	loadtextureimage("smoke4FH", true,true);

	fire_texFH = loadtextureimage("fire1FH", true,true);
	loadtextureimage("fire2FH", true,true);
	loadtextureimage("fire3FH", true,true);
	loadtextureimage("fire4FH", true,true);
	loadtextureimage("fire5FH", true,true);
	loadtextureimage("fire6FH", true,true);
	
	radar_texFH = loadtextureimage("radar1FH", true,true);


	explo_texFH = loadtextureimage("explo1FH", true,true);
	loadtextureimage("explo2FH", true,true);
	loadtextureimage("explo3FH", true,true);
	loadtextureimage("explo4FH", true,true);

	debris_texFH = loadtextureimage("debris1FH", true,true);
	loadtextureimage("debris2FH", true,true);
	loadtextureimage("debris3FH", true,true);
	loadtextureimage("debris4FH", true,true);
	

	spark_texFH = loadtextureimage("splat1FH", true,true);
	loadtextureimage("splat2FH", true,true);
	loadtextureimage("splat3FH", true,true);
	loadtextureimage("splat4FH", true,true);
	
	blood_texFH = loadtextureimage("spark1FH", true,true);
	*/
	/*
	smoke_texFH = TA_LoadTGA("smoke1FH");
	i = TA_LoadTGA("smoke2FH");
	i = TA_LoadTGA("smoke3FH");
	i = TA_LoadTGA("smoke4FH");

	fire_texFH = TA_LoadTGA("fire1FH");
	i = TA_LoadTGA("fire2FH");
	i = TA_LoadTGA("fire3FH");
	i = TA_LoadTGA("fire4FH");
	i = TA_LoadTGA("fire5FH");
	i = TA_LoadTGA("fire6FH");

	radar_texFH = TA_LoadTGA("radarFH");

	explo_texFH = TA_LoadTGA("explo1FH");
	i = TA_LoadTGA("explo2FH");
	i = TA_LoadTGA("explo3FH");
	i = TA_LoadTGA("explo4FH");

	debris_texFH = TA_LoadTGA("debris1FH");
	i = TA_LoadTGA("debris2FH");
	i = TA_LoadTGA("debris3FH");
	i = TA_LoadTGA("debris4FH");

	blood_texFH = TA_LoadTGA("splat1FH");
	i = TA_LoadTGA("splat2FH");
	i = TA_LoadTGA("splat3FH");
	i = TA_LoadTGA("splat4FH");
	
	spark_texFH = TA_LoadTGA("spark1FH");
	*/
	//FH!
}

/*
===============
R_InitParticles
===============
*/
void R_InitParticles (void)
{
	int		i = COM_CheckParm ("-particles");

	r_numparticles = 4096;

	if (i)
	{
		r_numparticles = (int)(atoi(com_argv[i+1]));
	}

	particles = (particle_t *) Hunk_AllocName (r_numparticles * sizeof(particle_t), "particles");

	memset(particles, 0, r_numparticles * sizeof(particle_t));

	for( i = 0 ; i < r_numparticles ; ++i )
	{
		particles[i].prev	= &particles[i - 1];
		particles[i].next	= &particles[i + 1];
	}

	particles[0].prev		= NULL;
	particles[r_numparticles - 1].next	= NULL;

	free_particles			= &particles[0];
	active_particles		= NULL;

	R_InitParticleTexture ();
}

/*
===============
R_ClearParticles
===============
*/
void R_ClearParticles (void)
{
	int		i;

	free_particles			= &particles[0];
	active_particles		= NULL;

	memset(particles, 0, r_numparticles * sizeof(particle_t));

	for( i = 0 ; i < r_numparticles ; ++i )
	{
		particles[i].prev	= &particles[i - 1];
		particles[i].next	= &particles[i + 1];
	}

	particles[0].prev		= NULL;
	particles[r_numparticles - 1].next	= NULL;
}

particle_t* addParticle()
{
	particle_t*	p	= free_particles;

	if(!p)
	{
		return NULL;
	}

	free_particles	= p->next;

	if(free_particles)
	{
		free_particles->prev	= NULL;
	}

	p->next			= active_particles;

	if(active_particles)
	{
		active_particles->prev	= p;
	}

	active_particles			= p;

	// Tei scale part
	p->scalex = 1;
	p->scaley = 1;
	p->scalez = 1; 
	// Tei scale part

	return p;
}

particle_t* remParticle(particle_t*	p)
{
	particle_t*	next;

	if(!p)
	{
		return NULL;
	}

	// Tei static fix
	if( p->type == pt_static)
	{
			return p->next;
	}
	// Tei static fix

	//Tei snowfade
	if (p->type == pt_snowfade )
	{
			p->type = pt_expandfade;
			return p->next;
	}
	//Tei snowfade

	if(p == active_particles)
	{
		active_particles	= p->next;
	}

	if(p->next)
	{
		p->next->prev		= p->prev;
	}

	if(p->prev)
	{
		p->prev->next		= p->next;
	}

	if(free_particles)
	{
		free_particles->prev	= p;
	}

	next					= p->next;

	p->next					= free_particles;

	free_particles			= p;

	p->prev	= NULL;

	return next;
}

/*
===============
R_ReadPointFile
===============
*/
void R_ReadPointFile_f (void)
{
	FILE	*f;
	vec3_t	origin;
	int		r;
	int		c;
	particle_t	*p;
	char	name[MAX_OSPATH];
	byte	*color;

	sprintf (name,"maps/%s.pts", sv.name);

	COM_FOpenFile (name, &f);
	if (!f)
	{
		Con_Printf ("couldn't open %s\n", name);
		return;
	}
	
	Con_Printf ("Reading %s...\n", name);
	c = 0;
	for ( ;; )
	{

		r = fscanf (f,"%f %f %f\n", &origin[0], &origin[1], &origin[2]);
		if (r != 3)
			break;
		c++;
		
		p	= addParticle();
		if(!p)
		{
			Con_Printf ("Not enough free particles\n");
			break;
		}

		color = (byte *) &d_8to24table[(int)(-c)&15];		

		p->texnum			= particle_tex;
		p->contents			= 0;

		p->die				= 99;
		p->alpha			= 200;
		p->scale			= 2;
		p->bounce			= 0;

		p->colorred			= color[0];
		p->colorgreen		= color[1];
		p->colorblue		= color[2];
	
		p->origin[0]		= origin[0];
		p->origin[1]		= origin[1];
		p->origin[2]		= origin[2];

		p->velocity[0]		= vec3_origin[0];
		p->velocity[1]		= vec3_origin[1];
		p->velocity[2]		= vec3_origin[2];

		p->type				= pt_static;
		p->glow				= true;
	}

	fclose (f);
	Con_Printf ("%i points read\n", c);
}

/*
===============
R_EntityParticles
===============
*/

float	r_avertexnormals[162][3] = {
#include "anorms.h"
};

vec3_t			avelocities[128];


////////////////
// FH!
// Code fron Fiend Hunter

/*=====
R_Radar
=====*/

/*=============================================================
R_CreateParticle - silly little function that makes a particle.
=============================================================*/

/*
void R_CreateParticleFH(int count,
					  int fxtype,
					  int drawtype,
					  int tex_num,
					  float color,
					  ptype_t type,
					  float born,
					  float die,
					  float angle,
					  float v_angle,
					  float alpha,
					  float scale,
					  vec3_t org,
					  int org_rand,
					  int vel,
					  int vel_z,
					  int power)
{
	int i, j;
	particle_t *p;
	byte		*colorRGB;

	for(i=0; i<count;i++)
	{
		if (!free_particles)
			return;
		p = free_particles;
		free_particles = p->next;
		p->next = active_particles;
		active_particles = p;
		
		p->fxtype = fxtype;
		p->drawtype = drawtype;
		p->texnum = tex_num;
		
		colorRGB				= (byte *) &d_8to24table[(int)(rand() & 7) + 105];
		p->colorred = colorRGB[0];
		p->colorgreen = colorRGB[1];
		p->colorblue = colorRGB[2];

		p->type = type;
		p->time = born;
		p->die = die;
		p->angle = angle;
		p->v_angle = v_angle;
		p->alpha = alpha;
		p->scale = scale;

		if (power == 0) power = 1;

		//origin
		if (org_rand == 0)
		{
			VectorCopy(org, p->origin);
		}
		else
		{
			for (j=0 ; j<3 ; j++)
				p->origin[j] = org[j] + (rand()%(org_rand*2))-org_rand;
		}

		// velocity
		if (vel_z != 0 && vel != 0)
		{
			for (j=0 ; j<2 ; j++)
				p->velocity[j] = ((rand()%(vel*2))-vel) * power;
			p->velocity[2] = (rand()%vel_z) + power;
		}
		else if (vel != 0)
		{
			for (j=0 ; j<3 ; j++)
				p->velocity[j] = ((rand()%(vel*2))-vel) * power;
		}
		else if (vel_z != 0)
		{
			p->velocity[2] = (rand()%vel_z) + power;
			p->velocity[0] = 0.0f;
			p->velocity[1] = 0.0f;
		}
		else
		{
			p->velocity[0] = 0.0f;
			p->velocity[1] = 0.0f;
			p->velocity[2] = 0.0f;
		}

	}
}

void R_Radar (vec3_t org, vec3_t dir)
{
	R_CreateParticleFH(1, TE_RADARBLIP, PFX_HUD, radar_texFH, 224 + (rand()&7), pt_static, cl.time,
			cl.time + 10, 0, 1.57, 1, 1, org, 0, 0, 0, 0);
}

*/

// End FH! code
////////////////

// Tei id old code

void R_DarkFieldParticles (entity_t *ent)
{
	int			i, j, k;
	particle_t	*p;
	float		vel;
	vec3_t		dir;
	vec3_t		org;

	org[0] = ent->origin[0];
	org[1] = ent->origin[1];
	org[2] = ent->origin[2];
	for (i=-16 ; i<16 ; i+=8)
		for (j=-16 ; j<16 ; j+=8)
			for (k=0 ; k<32 ; k+=8)
			{
				p	= addParticle();
				if(!p)	
				{
					return;
				}
		
				p->die = cl.time + 0.2 + (rand()&7) * 0.02;
				p->colorred			= 150 + rand()%6;
				p->colorgreen		= 150 + rand()%6;
				p->colorblue		= 150 + rand()%6;

				p->scale			= 2;
				p->alpha			= 200;
				p->texnum			= bubble_tex;//particle_tex;
				p->bounce			= 1;
				p->glow				= false;


				p->type = pt_grav;
				
				dir[0] = j*8;
				dir[1] = i*8;
				dir[2] = k*8;
	
				p->origin[0] = org[0] + i + (rand()&3);
				p->origin[1] = org[1] + j + (rand()&3);
				p->origin[2] = org[2] + k + (rand()&3);
	
				VectorNormalize (dir);						
				vel = 50 + (rand()&63);
				VectorScale (dir, vel, p->velocity);
			}
}
// Tei id old code


void R_EntityParticles (entity_t *ent)
{
	int			i;
	float		sp, sy, cp, cy, angle;
	vec3_t		forward;
	particle_t	*p;

	if (!avelocities[0][0])
	{
		for (i=0 ; i<384 ; i++)
		{
			avelocities[0][i] = (rand() & 255) * 0.01;
		}
	}

	for (i=0 ; i<128 ; i++)
	{
		angle				= cl.time * avelocities[i][0];
		sy					= sin(angle);
		cy					= cos(angle);

		angle				= cl.time * avelocities[i][1];
		sp					= sin(angle);
		cp					= cos(angle);
	
		forward[0]			= cp*cy;
		forward[1]			= cp*sy;
		forward[2]			= -sp;

		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->scale			= 2;
		p->alpha			= 200;
		p->die				= cl.time + 0.01;

		p->texnum			= particle_tex;
		p->bounce			= 0;
		p->colorred			= 255;
		p->colorgreen		= 243;
		p->colorblue		= 27;
		p->type				= pt_static;
		p->glow				= true;
		
		p->origin[0]		= ent->origin[0] + r_avertexnormals[i][0]*64 + forward[0]*16;			
		p->origin[1]		= ent->origin[1] + r_avertexnormals[i][1]*64 + forward[1]*16;			
		p->origin[2]		= ent->origin[2] + r_avertexnormals[i][2]*64 + forward[2]*16;			
	}
}

// Tei entpar2
void R_ShadowParticles (entity_t *ent)
{
	int			i;
	float		sp, sy, cp, cy, angle;
	vec3_t		forward;
	particle_t	*p;

	if (!avelocities[0][0])
	{
		for (i=0 ; i<384 ; i++)
		{
			avelocities[0][i] = (rand() & 255) * 0.01;
		}
	}

	for (i=0 ; i<128 ; i++)
	{
		angle				= cl.time * avelocities[i][0];
		sy					= sin(angle);
		cy					= cos(angle);

		angle				= cl.time * avelocities[i][1];
		sp					= sin(angle);
		cp					= cos(angle);
	
		forward[0]			= cp*cy;
		forward[1]			= cp*sy;
		forward[2]			= -sp;

		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->scale			= 12;
		p->alpha			= 200;
		p->die				= cl.time + 0.1;

		p->texnum			= smoke1_tex;
		if (rand()&1)
			p->texnum			= smoke2_tex;
		if (rand()&1)
			p->texnum			= particle_tex;

		p->bounce			= 0;
		p->colorred			= 0;
		p->colorgreen		= 0;
		p->colorblue		= 0;
		p->type				= pt_static;
		p->glow				= false;
		
		p->origin[0]		= ent->origin[0] + r_avertexnormals[i][0]*64 + forward[0]*16;			
		p->origin[1]		= ent->origin[1] + r_avertexnormals[i][1]*64 + forward[1]*16;			
		p->origin[2]		= ent->origin[2] + r_avertexnormals[i][2]*64 + forward[2]*16;			
	}
}
// Tei entpar2

/*
===============
R_ParseParticleEffect

Parse an effect out of the server message
===============
*/
void R_ParseParticleEffect (void)
{
	vec3_t		origin, direction;
	int			count, color;

	origin[0]		= MSG_ReadCoord ();
	origin[1]		= MSG_ReadCoord ();
	origin[2]		= MSG_ReadCoord ();

	direction[0]	= MSG_ReadChar () * 0.0625;
	direction[1]	= MSG_ReadChar () * 0.0625;
	direction[2]	= MSG_ReadChar () * 0.0625;

	count			= MSG_ReadByte ();
	color			= MSG_ReadByte ();

	R_RunParticleEffect (origin, direction, color, count);
}
	
/*
===============
R_ParticleExplosion

===============
*/
void R_ParticleExplosion (vec3_t origin)
{
	int			i, contents;
	particle_t	*p;
	byte		*color;

	for (i=0 ; i<64 ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->scale			= 1;//2;

		p->alpha			= 200;

		p->texnum			= smoke1_tex + (rand() & 3);

		p->bounce			= 0;
		p->type				= pt_smokeexp;

		p->velocity[0]		= (rand() & 3) - 2;
		p->velocity[1]		= (rand() & 3) - 2;
		p->velocity[2]		= (rand() & 3) - 2;

		color				= (byte *) &d_8to24table[(int)(rand() & 7) + 105];
		p->colorred			= color[0];
		p->colorgreen		= color[1];
		p->colorblue		= color[2];

		p->die				= cl.time + 5;
		p->glow				= true;

		p->origin[0]		= origin[0] + (rand() &31) - 16;
		p->origin[1]		= origin[1] + (rand() &31) - 16;
		p->origin[2]		= origin[2] + (rand() &31) - 16;
	}

	for (i=0 ; i<256 ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		contents			= Mod_PointInLeaf(p->origin, cl.worldmodel)->contents;

		p->scale			= (rand() & 3) +1;
		p->alpha			= 200;
		p->die				= cl.time + 5;

		if ((contents		== CONTENTS_EMPTY) ||
			(contents		== CONTENTS_SOLID))
		{
			if (rand()&1)
				p->texnum		= particle_tex;
			else
				p->texnum		= flare_tex;

			p->bounce		= 1.5;

			p->colorred		= 255;
			p->colorgreen	= 243;
			p->colorblue	= 27;

			p->type			= pt_explode;
			p->glow			= true;
		}
		else
		{
			p->texnum		= bubble_tex;
			p->bounce		= 0;

			p->colorred		= 127;
			p->colorgreen	= 127;
			p->colorblue	= 255;

			p->type			= pt_bubble;
			p->glow			= false;
		}

		p->origin[0]		= origin[0] + ((rand() & 31) - 16);
		p->origin[1]		= origin[1] + ((rand() & 31) - 16);
		p->origin[2]		= origin[2] + ((rand() & 31) - 16);

		p->velocity[0]		= (rand() & 511) - 256;
		p->velocity[1]		= (rand() & 511) - 256;
		p->velocity[2]		= (rand() & 511) - 256;
	}
}


// Tei implosion

void R_ParticleImplosion (vec3_t origin)
{
	int			i, contents, k;
	particle_t	*p;
	vec3_t		vel;
	byte		*color;
	

	for (i=0 ; i<32 ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->scale			= 1;//2;
		p->alpha			= 200;
		p->texnum			= particle_tex;
		p->bounce			= 0;
		p->type				= pt_gorigin;

		p->gorigin[0]		= origin[0];
		p->gorigin[1]		= origin[1];
		p->gorigin[2]		= origin[2];

		//if (rand()&1) 
		//{
			p->colorred			= 255;
			p->colorgreen		= 255;
			p->colorblue		= 255;
			p->glow				= true;
		/*
		}
		else
		{
			p->colorred			= 0;
			p->colorgreen		= 0;
			p->colorblue		= 0;
			p->glow				= false;
		}
		*/
		p->die				= cl.time + 5;

		k = i  * 0.1;
		p->origin[0]		= origin[0] + (rand() &255*k) - 127*k;
		p->origin[1]		= origin[1] + (rand() &255*k) - 127*k;
		p->origin[2]		= origin[2] + (rand() &255*k) - 127*k;

		p->velocity[0] = (p->gorigin[0] - p->origin[0]) * 0.6;
		p->velocity[1] = (p->gorigin[1] - p->origin[1]) * 0.6;
		p->velocity[2] = (p->gorigin[2] - p->origin[2]) * 0.6;

	}

}

// Tei particle fog
extern cvar_t sv_stepsize;
void R_ParticleFog (vec3_t origin)
{
	int			i, contents, k;
	particle_t	*p;
	vec3_t		vel;
	byte		*color;

	p	= addParticle();
	if(!p)
	{
		return;
	}

	p->scale			= rand()&7;
	p->scalex			= 1+ rand()&15;
	p->scaley			= 1+ rand()&15;
	p->alpha			= rand()&7;
	p->texnum			= smoke1_tex + (rand() & 3);
	p->bounce			= 0;
	//p->type				= pt_snowfadein;

	p->type				= pt_fog;


	p->colorred			= 255;
	p->colorgreen		= 255;
	p->colorblue		= 255;
	p->glow				= false;//true;

	p->die				= cl.time + (rand()&15);//12

	p->origin[0]		= origin[0] + (rand() &255) - 127;
	p->origin[1]		= origin[1] + (rand() &255) - 127;
	p->origin[2]		= origin[2] + 1;

	p->velocity[0] = 0;
	p->velocity[1] = 0;
	p->velocity[2] = 0;
}
// Tei particle fog

// Tei day light emu
void R_ParticleDay (vec3_t origin)
{
	int			i, contents, k;
	particle_t	*p;
	vec3_t		vel;
	byte		*color;

	p	= addParticle();
	if(!p)
	{
		return;
	}

	p->scale			= rand()&3;
	p->scalez			= 1+ rand()&127;
	p->alpha			= rand()&3;
	p->texnum			= smoke1_tex + (rand() & 3);
	p->bounce			= 0;

	p->type				= pt_fog;


	p->colorred			= 255;
	p->colorgreen		= 255;
	p->colorblue		= 255;
	p->glow				= false;//true;

	p->die				= cl.time + (rand()&7);//12

	p->origin[0]		= origin[0] + (rand() &127) - 63;
	p->origin[1]		= origin[1] + (rand() &127) - 63;
	p->origin[2]		= origin[2] - 1;

	p->velocity[0] = 0;
	p->velocity[1] = 0;
	p->velocity[2] = 0;
}
// Tei day light emu


// Tei implosion sutil
void R_ParticleImplosionSutil (vec3_t origin)
{
	int			i, contents;
	particle_t	*p;
	vec3_t		vel;
	byte		*color;

	for (i=0 ; i<64 ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->scale			= 1;//2;
		p->alpha			= 200;
		p->texnum			= particle_tex;
		p->bounce			= 0;
		p->type				= pt_gorigin;

		p->gorigin[0]		= origin[0];
		p->gorigin[1]		= origin[1];
		p->gorigin[2]		= origin[2];

		p->colorred			= 255;
		p->colorgreen		= 255;
		p->colorblue		= 255;

		p->die				= cl.time + 15;
		p->glow				= true;

		p->origin[0]		= origin[0] + (rand() &127) - 63;
		p->origin[1]		= origin[1] + (rand() &127) - 63;
		p->origin[2]		= origin[2] + (rand() &127) - 63;

		p->velocity[0] = (p->origin[0] - p->gorigin[0]) * 0.1;
		p->velocity[1] = (p->origin[1] - p->gorigin[1]) * 0.1;
		p->velocity[2] = (p->origin[2] - p->gorigin[2]) * 0.1;

	}

}






// Tei implosion






// Tei par 2

void R_ParticleExplosion3 (vec3_t origin)
{
	int			i, contents;
	particle_t	*p;
//	byte		*color;

	for (i=0 ; i<64 ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

			
		p->scale			= 2 + (rand()&6);

		p->alpha			= 200+(rand()&32);

		p->texnum			= smoke1_tex + (rand() & 3);

		p->bounce			= 0;

		p->type				= pt_fire;//pt_snow;//pt_smokeexp;

		p->velocity[0]		= (rand() & 3) - 2;
		p->velocity[1]		= (rand() & 3) - 2;
		p->velocity[2]		= (rand() & 3) - 2;

		//color				= (byte *) &d_8to24table[(int)(rand() & 7) + 105];
		p->colorred			= 0;//color[0];
		p->colorgreen		= 0;//color[1];
		p->colorblue		= 0;//color[2];

		p->die				= cl.time + 3;
		p->glow				= false;//true;

		p->origin[0]		= origin[0] + (rand() &16) - 7;
		p->origin[1]		= origin[1] + (rand() &16) - 7;
		p->origin[2]		= origin[2] + (rand() &16) - 7;
	}

	for (i=0 ; i<256 ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		contents			= Mod_PointInLeaf(p->origin, cl.worldmodel)->contents;

		p->scale			= (rand() & 2) +1;
		p->alpha			= 100;
		p->die				= cl.time + 3;

		if ((contents		== CONTENTS_EMPTY) ||
			(contents		== CONTENTS_SOLID))
		{
			if (rand()&1)
				p->texnum		= particle_tex;
			else
				p->texnum		= flare_tex;

			p->bounce		= 1.5;

			p->colorred		= 255;
			p->colorgreen	= 243;
			p->colorblue	= 255;

			p->type			= pt_explode;
			p->glow			= true;
		}
		else
		{
			p->texnum		= bubble_tex;
			p->bounce		= 0;

			p->colorred		= 127;
			p->colorgreen	= 127;
			p->colorblue	= 255;

			p->type			= pt_bubble;
			p->glow			= false;
		}

		p->origin[0]		= origin[0] + ((rand() & 31) - 16);
		p->origin[1]		= origin[1] + ((rand() & 31) - 16);
		p->origin[2]		= origin[2] + ((rand() & 31) - 16);

		p->velocity[0]		= (rand() & 128) - 64;
		p->velocity[1]		= (rand() & 128) - 64;
		p->velocity[2]		= (rand() & 128) - 64;
	}
}

void R_ParticleExplosion4 (vec3_t origin) //Dark
{
	int			i, contents;
	particle_t	*p;
//	byte		*color;

	for (i=0 ; i<16 ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

			
		p->scale			= 12 + (rand()&7);

		p->alpha			= 200+(rand()&32);

		p->texnum			= smoke1_tex + (rand() & 3);

		p->bounce			= 0;

		p->type				= pt_fire;//pt_snow;//pt_smokeexp;

		p->velocity[0]		= (rand() & 7) - 4;
		p->velocity[1]		= (rand() & 7) - 4;
		p->velocity[2]		= (rand() & 7) - 4;

		//color				= (byte *) &d_8to24table[(int)(rand() & 7) + 105];
		p->colorred			= 0;//color[0];
		p->colorgreen		= 0;//color[1];
		p->colorblue		= 0;//color[2];

		p->die				= cl.time + 6;
		p->glow				= false;//true;

		p->origin[0]		= origin[0] + (rand() &31) - 16;
		p->origin[1]		= origin[1] + (rand() &31) - 16;
		p->origin[2]		= origin[2] + (rand() &31) - 16;
	}

	for (i=0 ; i<256 ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		contents			= Mod_PointInLeaf(p->origin, cl.worldmodel)->contents;

		p->scale			= (rand() & 8) +5;
		p->alpha			= 200;
		p->die				= cl.time + 3;

		if ((contents		== CONTENTS_EMPTY) ||
			(contents		== CONTENTS_SOLID))
		{
			if (rand()&1)
				p->texnum		= particle_tex;
			else
				p->texnum		= flare_tex;

			p->bounce		= 1.5;

			p->colorred		= 255;
			p->colorgreen	= 243;
			p->colorblue	= 255;

			p->type			= pt_fire;//pt_explode;
			p->glow			= false;//true;
		}
		else
		{
			p->texnum		= bubble_tex;
			p->bounce		= 0;

			p->colorred		= 127;
			p->colorgreen	= 127;
			p->colorblue	= 255;

			p->type			= pt_bubble;
			p->glow			= false;
		}

		p->origin[0]		= origin[0] + ((rand() & 31) - 16);
		p->origin[1]		= origin[1] + ((rand() & 31) - 16);
		p->origin[2]		= origin[2] + ((rand() & 31) - 16);

		p->velocity[0]		= (rand() & 128) - 64;
		p->velocity[1]		= (rand() & 128) - 64;
		p->velocity[2]		= (rand() & 128) - 64;
	}
}

void R_ParticleExplosion5 (vec3_t origin) //Dark
{
	int			i, contents;
	particle_t	*p;
//	byte		*color;

	for (i=0 ; i<8 ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

			
		p->scale			= 23 + (rand()&31);
		p->alpha			= 210+(rand()&32);
		p->texnum			= smoke1_tex + (rand() & 3);
		p->bounce			= 1;
		p->type				= pt_slowmoke;//pt_snow;//pt_snow;//pt_smokeexp;

		p->velocity[0]		= (rand() & 7) - 4;
		p->velocity[1]		= (rand() & 7) - 4;
		p->velocity[2]		= (rand() & 15) - 4;

		//color				= (byte *) &d_8to24table[(int)(rand() & 7) + 105];
		p->colorred			= 40;//color[0];
		p->colorgreen		= 20;//color[1];
		p->colorblue		= 10;//color[2];

		p->die				= cl.time + 16;
		p->glow				= false;//true;

		p->origin[0]		= origin[0] + (rand() &31) - 16;
		p->origin[1]		= origin[1] + (rand() &31) - 16;
		p->origin[2]		= origin[2] + (rand() &31) - 8;
	}

	for (i=0 ; i<64 ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		contents			= Mod_PointInLeaf(p->origin, cl.worldmodel)->contents;

		p->scale			= 1;
		p->alpha			= 200;
		p->die				= cl.time + 13;

		if ((contents		== CONTENTS_EMPTY) ||
			(contents		== CONTENTS_SOLID))
		{
			if (rand()&1)
				p->texnum		= particle_tex;
			else
				p->texnum		= flare_tex;

			p->bounce		= 1.5;

			p->colorred		= 33;
			p->colorgreen	= 33;
			p->colorblue	= 33;

			p->type			= pt_smoke;//explode;
			p->glow			= false;//true;
		}
		else
		{
			p->texnum		= bubble_tex;
			p->bounce		= 0;

			p->colorred		= 127;
			p->colorgreen	= 127;
			p->colorblue	= 255;

			p->type			= pt_bubble;
			p->glow			= false;
		}

		p->origin[0]		= origin[0] + ((rand() & 31) - 16);
		p->origin[1]		= origin[1] + ((rand() & 31) - 16);
		p->origin[2]		= origin[2] + ((rand() & 31) - 8);

		p->velocity[0]		= (rand() & 255) - 128;
		p->velocity[1]		= (rand() & 255) - 128;
		p->velocity[2]		= (rand() & 255) - 16;
	}
}


// Tei par 2

/*
===============
R_ParticleExplosion2

===============
*/
void R_ParticleExplosion2 (vec3_t origin, int colorStart, int colorLength)
{
	int			i,contents;
	particle_t	*p;
	int			colorMod = 0;
	byte		*color;

	for (i=0; i<384; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		contents			= Mod_PointInLeaf(p->origin, cl.worldmodel)->contents;

		p->scale			= (rand() & 3) +1;
		p->alpha			= 200;
		p->die				= cl.time + 5;

		if ((contents		== CONTENTS_EMPTY) ||
			(contents		== CONTENTS_SOLID))
		{
			p->texnum		= particle_tex;
			p->bounce		= 0;
			color			= (byte *) &d_8to24table[(int)colorStart + (colorMod % colorLength)];

			p->colorred		= color[0];
			p->colorgreen	= color[1];
			p->colorblue	= color[2];

			colorMod++;
			p->type			= pt_explode;
			p->glow			= true;
		}
		else
		{
			p->texnum		= bubble_tex;
			p->bounce		= 0;
			p->colorred		= 127;
			p->colorgreen	= 127;
			p->colorblue	= 255;
			p->type			= pt_bubble;
			p->glow			= false;
		}

		p->origin[0]		= origin[0] + ((rand() & 31) - 16);
		p->origin[1]		= origin[1] + ((rand() & 31) - 16);
		p->origin[2]		= origin[2] + ((rand() & 31) - 16);

		p->velocity[0]		= (rand() & 511) - 256;
		p->velocity[1]		= (rand() & 511) - 256;
		p->velocity[2]		= (rand() & 511) - 256;
	}
}

/*
===============
R_BlobExplosion

===============
*/
void R_BlobExplosion (vec3_t origin)
{
	int			i;
	particle_t	*p;
	byte		*color;
	
	for (i=0 ; i<384 ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->die				= cl.time + 1;

		p->type				= pt_blob;
		p->glow				= true;

		color				= (byte *) &d_8to24table[(int)(rand() & 7) + 66];

		p->colorred			= color[0];
		p->colorgreen		= color[1];
		p->colorblue		= color[2];

		p->origin[0]		= origin[0] + (rand() & 31) - 16;
		p->origin[1]		= origin[1] + (rand() & 31) - 16;
		p->origin[2]		= origin[2] + (rand() & 31) - 16;

		p->velocity[0]		= (rand() & 511) - 256;
		p->velocity[1]		= (rand() & 511) - 256;
		p->velocity[2]		= (rand() & 511) - 256;
		
		if (i & 1)
		{
			p->type			= pt_blob2;

			color			= (byte *) &d_8to24table[(int)(rand() & 7) + 150];

			p->colorred		= color[0];
			p->colorgreen	= color[1];
			p->colorblue	= color[2];
		}
	}
}

/*
===============
R_RunParticleEffect

===============
*/

void R_RunParticleEffect (vec3_t origin, vec3_t direction, int color, int count)
{
	int			i, contents;
	particle_t	*p;
	byte		*color24;

	if (count == 128)
	{
		for (i=0 ; i<count ; i++)
		{	// rocket explosion
			p	= addParticle();
			if(!p)
			{
				return;
			}

			contents			= Mod_PointInLeaf(p->origin, cl.worldmodel)->contents;

			p->scale			= 2;
			p->alpha			= 200;
			p->die				= cl.time + 5;
			
			if ((contents		== CONTENTS_EMPTY) ||
				(contents		== CONTENTS_SOLID))
			{
				p->texnum		= particle_tex;
				p->bounce		= 0;

				p->colorred		= 255;
				p->colorgreen	= 243;
				p->colorblue	= 147;

				p->type			= pt_explode;
				p->glow			= true;
			}
			else
			{
				p->texnum		= bubble_tex;
				p->bounce		= 0;

				p->colorred		= 127;
				p->colorgreen	= 127;
				p->colorblue	= 255;

				p->type			= pt_bubble;
				p->glow			= false;
			}

			p->origin[0]		= origin[0] + ((rand() & 31) - 16);
			p->origin[1]		= origin[1] + ((rand() & 31) - 16);
			p->origin[2]		= origin[2] + ((rand() & 31) - 16);

			p->velocity[0]		= (rand() & 511) - 256;
			p->velocity[1]		= (rand() & 511) - 256;
			p->velocity[2]		= (rand() & 511) - 256;
		}
		return;
	}

	for (i=0 ; i<count ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->texnum			= blood_tex;
		p->bounce			= 0;
		p->scale			= 2;
		p->alpha			= 200;
		p->die				= cl.time + 5;

		color24				= (byte *) &d_8to24table[(int)(rand() & 3) + color];

		p->colorred			= color24[0];
		p->colorgreen		= color24[1];
		p->colorblue		= color24[2];

		p->type				= pt_blood2;
		p->glow				= false;

		p->origin[0]		= origin[0] + ((rand() & 15) - 8);
		p->origin[1]		= origin[1] + ((rand() & 15) - 8);
		p->origin[2]		= origin[2] + ((rand() & 15) - 8);

		p->velocity[0]		= direction[0] * 15;
		p->velocity[1]		= direction[1] * 15;
		p->velocity[2]		= direction[2] * 15;
	}
}

/*
===============
R_SparkShower

===============
*/
void R_SparkShower (vec3_t origin, vec3_t direction)
{
	int			i, contents;
	particle_t	*p;

	p	= addParticle();
	if (!free_particles)
	{
		return;
	}

	contents			= Mod_PointInLeaf(p->origin, cl.worldmodel)->contents;

	if ((contents		== CONTENTS_EMPTY) ||
		(contents		== CONTENTS_SOLID))
	{
		p->scale			= 2;
		p->alpha			= 200;
		p->texnum			= smoke1_tex + (rand() & 3);
		//p->texnum			= smoke_texFH + (rand() & 1)+(rand() & 1);

		p->bounce			= 0;
		p->type				= pt_bulletpuff;
		p->glow				= false;

		p->colorred			= 187;
		p->colorgreen		= 187;
		p->colorblue		= 187;

		p->die				= cl.time + 5;

		p->origin[0]		= origin[0];
		p->origin[1]		= origin[1];
		p->origin[2]		= origin[2];

		p->velocity[0]		= (rand() & 7) - 4;
		p->velocity[1]		= (rand() & 7) - 4;
		p->velocity[2]		= (rand() & 7) - 4;
	}

	for (i=0 ; i<10 ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		contents			= Mod_PointInLeaf(p->origin, cl.worldmodel)->contents;

		p->scale			= (rand() & 3) +1;

		p->alpha			= 200;
		p->die				= cl.time + 5;

		if ((contents		== CONTENTS_EMPTY) ||
			(contents		== CONTENTS_SOLID))
		{
			p->texnum		= particle_tex;
			p->bounce		= 1.5;

			p->colorred		= 255;
			p->colorgreen	= 243;
			p->colorblue	= 147;

			p->type			= pt_explode;
			p->glow			= true;
		}
		else
		{
			p->texnum		= bubble_tex;
			p->bounce		= 0;

			p->colorred		= 127;
			p->colorgreen	= 127;
			p->colorblue	= 255;

			p->type			= pt_bubble;
			p->glow			= false;
		}

		p->origin[0]		= origin[0] + ((rand() & 7) - 4);
		p->origin[1]		= origin[1] + ((rand() & 7) - 4);
		p->origin[2]		= origin[2] + ((rand() & 7) - 4);

		p->velocity[0]		= direction[0] + (rand() & 127) - 64;
		p->velocity[1]		= direction[1] + (rand() & 127) - 64;
		p->velocity[2]		= direction[2] + (rand() & 127) - 64;
	}
}

/*
===============
R_Snow
===============
*/
void R_Snow (vec3_t min, vec3_t max, int flakes)
{
	int			i;
	vec3_t		difference;
	particle_t	*p;

	for (i=0 ; i<flakes ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		VectorSubtract(max, min, difference);

		p->die				= cl.time + 10;

		p->scale			= 1;//(rand() & 3) +1;
		p->alpha			= 100;//200;
		p->texnum			= snow_tex;

		if (rand()&1)
			p->texnum			= rain_tex;

		p->bounce			= 0;
		p->type				= pt_snow;
		p->glow				= false;

		p->colorred			= 255;
		p->colorgreen		= 255;
		p->colorblue		= 255;		

		p->origin[0]		= difference[0] * (rand () & 2047) * 0.00048828125 + min[0];	// Tomaz - Speed
		p->origin[1]		= difference[1] * (rand () & 2047) * 0.00048828125 + min[1];	// Tomaz - Speed
		p->origin[2]		= max[2] - 10;

		p->velocity[0]		= 0;
		p->velocity[1]		= 0;
		p->velocity[2]		= -50;
	}
}

// Tei printemps

void R_TempusVivendi (vec3_t min, vec3_t max, int flakes)
{
	int			i;
	vec3_t		difference;
	particle_t	*p;

	for (i=0 ; i<flakes ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		VectorSubtract(max, min, difference);

		p->die				= cl.time + 10 * (rand() & 3);

		p->scale			= (rand() & 13) +1;
		p->alpha			= 200 + (rand() & 8) +1;
		p->texnum			= snow_tex;
		p->bounce			= 0;
		p->type				= pt_snow;
		p->glow				= true;//false;

		
		p->colorred			= 215 + rand()&3 * 10 ;
		p->colorgreen		= 215 + rand()&3 * 10;
		p->colorblue		= 215 + rand()&3 * 10;		

		p->origin[0]		= difference[0] * (rand () & 2047) * 0.00048828125 + min[0];	// Tomaz - Speed
		p->origin[1]		= difference[1] * (rand () & 2047) * 0.00048828125 + min[1];	// Tomaz - Speed
		p->origin[2]		= max[2] - 10;

		/*
		p->velocity[0]		= 0;
		p->velocity[1]		= 0;
		p->velocity[2]		= -50;
		*/
		p->velocity[0]		= (50 - rand()&50) * 90;
		p->velocity[1]		= (50 - rand()&50) * 90;
		p->velocity[2]		= 25 - rand()&75;
	}
}

// Tei printemps


// Tei firetemps
/*
===============
R_Snow
===============
*/
void R_TempusFire (vec3_t min, vec3_t max, int flakes)
{
	int			i;
	vec3_t		difference;
	particle_t	*p;

	for (i=0 ; i<flakes ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		VectorSubtract(max, min, difference);

		p->die				= cl.time + 10 * (rand() & 3);

		p->scale			= 10 + (rand() & 13) +1;
		p->alpha			= 200 + (rand() & 8) +1;
		
		p->texnum			= smoke1_tex;
		if (rand()&1)
			p->texnum			= smoke2_tex;
		p->bounce			= 0;
		p->type				= pt_snow;
		p->glow				= true;//false;

		
		p->colorred			= 215 + rand()&3 * 10 ;
		p->colorgreen		= 215 + rand()&3 * 10;
		p->colorblue		= 215 + rand()&3 * 10;		


		p->colorred		= 227;
		p->colorgreen	= 151;
		p->colorblue	= 79;

		p->origin[0]		= difference[0] * (rand () & 2047) * 0.00048828125 + min[0];	// Tomaz - Speed
		p->origin[1]		= difference[1] * (rand () & 2047) * 0.00048828125 + min[1];	// Tomaz - Speed
		p->origin[2]		= max[2] - 10;

		/*
		p->velocity[0]		= 0;
		p->velocity[1]		= 0;
		p->velocity[2]		= -50;
		*/
		p->velocity[0]		= (50 - rand()&50) * 90 - 1140;
		p->velocity[1]		= (50 - rand()&50) * 90 - 1140;
		p->velocity[2]		= 25 - rand()&75;
	}
}

// Tei firetemps



// Tei smoketemps
/*
===============
R_Snow
===============
*/
void R_TempusSmoke (vec3_t min, vec3_t max, int flakes)
{
	int			i;
	vec3_t		difference;
	particle_t	*p;

	for (i=0 ; i<flakes ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		VectorSubtract(max, min, difference);

		p->die				= cl.time + 10 * (rand() & 3);

		p->scale			= 10 + (rand() & 13) +1;
		p->alpha			= 200 + (rand() & 8) +1;
		
		p->texnum			= smoke1_tex;
		if (rand()&1)
			p->texnum			= smoke2_tex;
		if (rand()&1)
			p->texnum			= smoke3_tex;
		if (rand()&1)
			p->texnum			= particle_tex;

		p->bounce			= 0;
		p->type				= pt_snow;
		p->glow				= true;//false;

		
		p->colorred			= 250 ;
		p->colorgreen		= 250;
		p->colorblue		= 250;		


		//p->colorred		= 227;
		//p->colorgreen	= 151;
		//p->colorblue	= 79;

		p->origin[0]		= difference[0] * (rand () & 2047) * 0.00048828125 + min[0];	// Tomaz - Speed
		p->origin[1]		= difference[1] * (rand () & 2047) * 0.00048828125 + min[1];	// Tomaz - Speed
		p->origin[2]		= max[2] - 10;

		/*
		p->velocity[0]		= 0;
		p->velocity[1]		= 0;
		p->velocity[2]		= -50;
		*/
		p->velocity[0]		= (50 - rand()&50) * 90;
		p->velocity[1]		= (50 - rand()&50) * 90;
		p->velocity[2]		= 25 - rand()&75;
	}
}

// Tei smoketemps


void R_TempusDarkSmoke (vec3_t min, vec3_t max, int flakes)
{
	int			i;
	vec3_t		difference;
	particle_t	*p;

	for (i=0 ; i<flakes ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		VectorSubtract(max, min, difference);

		p->die				= cl.time + 10 * (rand() & 3);

		p->scale			= 40 + (rand() & 43) +1;
		p->alpha			= 200 + (rand() & 8) +1;
		
		p->texnum			= smoke1_tex;
		if (rand()&1)
			p->texnum			= smoke2_tex;
		if (rand()&1)
			p->texnum			= smoke3_tex;
		if (rand()&1)
			p->texnum			= particle_tex;

		p->bounce			= 0;
		p->type				= pt_snow;
		p->glow				= false;

		
		p->colorred			= 0 ;
		p->colorgreen		= 0;
		p->colorblue		= 0;		

		p->origin[0]		= difference[0] * (rand () & 2047) * 0.00048828125 + min[0];	// Tomaz - Speed
		p->origin[1]		= difference[1] * (rand () & 2047) * 0.00048828125 + min[1];	// Tomaz - Speed
		p->origin[2]		= max[2] - 10;

		p->velocity[0]		= (50 - rand()&50) * 90 - 1000;
		p->velocity[1]		= (50 - rand()&50) * 90 - 1000;
		p->velocity[2]		= 25 - rand()&75;
	}
}

// Tei dark smoketemps


/*
===============
R_Rain
===============
*/
void R_Rain (vec3_t min, vec3_t max, int drops)
{
	int			i;
	vec3_t		difference;
	particle_t	*p;

	for (i=0 ; i<drops ; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		VectorSubtract(max, min, difference);

		p->die				= cl.time + 10;

		p->scale			= (rand() & 3) +1;
		p->alpha			= 200;

		p->texnum			= rain_tex;
		p->bounce			= 0;
		p->type				= pt_rain;
		p->glow				= false;

		p->colorred			= 255;
		p->colorgreen		= 255;
		p->colorblue		= 255;

		p->origin[0]		= difference[0] * (rand () & 2047) * 0.00048828125 + min[0];	// Tomaz - Speed
		p->origin[1]		= difference[1] * (rand () & 2047) * 0.00048828125 + min[1];	// Tomaz - Speed
		p->origin[2]		= max[2] - 10;

		p->velocity[0]		= 0;
		p->velocity[1]		= 0;
		p->velocity[2]		= -400;
	}
}

//////////////////////////////////////////////////////////////////
// Tei fog plash

void R_FogSplashLite (vec3_t origin)
{
	int			i, j;
	particle_t	*p;

	for (i=-2 ; i<2 ; i++)
	{	
		for (j=-2 ; j<2 ; j++)
		{

			p	= addParticle();
			if(!p)
			{
				return;
			}
		
			if (rand()&1)
				return;

			p->texnum			= smoke3_tex;
			p->bounce			= 1;
			p->scale			= 6;
			p->alpha			= 221;
			p->die				= cl.time + 35;

			p->colorred			= 255;
			p->colorgreen		= 222;
			p->colorblue		= 222;			

			if (rand()&1)
				p->type				= pt_smoke;
			else
				p->type				= pt_fade;


			p->glow				= true;

			p->velocity[0]		= (rand() & 63 + 50) * (j*8 + (rand()&7)) * 0.003;
			p->velocity[1]		= (rand() & 63 + 50) * (i*8 + (rand()&7)) * 0.003;
			p->velocity[2]		= (rand() & 63 + 50) * ((i+j)*8 + (rand()&7)) * 0.02 + 120 + (120 * rand()&1);//((rand() & 63 + 50) * 256 + 50) * 0.01;
	
			p->origin[0]		= origin[0] + i * 10 + (rand() & 17);
			p->origin[1]		= origin[1] + j * 10 + (rand() & 17);
			p->origin[2]		= origin[2] + (i+j)*10 + (rand() & 7);


			/*
			p->velocity[0]		= (rand() & 3 + 2) * (j *2 + (rand()&7)) * 0.1;
			p->velocity[1]		= (rand() & 3 + 2) * (i *2 + (rand()&7)) * 0.1;
			p->velocity[2]		= (rand() & 3 + 2) * 25 + 10;
	
			p->origin[0]		= origin[0] + (rand() & 7) + (j * 8);
			p->origin[1]		= origin[1] + (rand() & 7) + (i * 8);
			p->origin[2]		= origin[2] + (rand() & 63);
				*/
		}
	}
}

// Tei fog plash

//////////////////////////////////////////////////////////////////
// Tei fog plash

void R_FogSplash (vec3_t origin)
{
	int			i, j;
	particle_t	*p;

	for (i=-2 ; i<2 ; i++)
	{	
		for (j=-2 ; j<2 ; j++)
		{

			p	= addParticle();
			if(!p)
			{
				return;
			}
		
			p->texnum			= smoke3_tex;
			p->bounce			= 1;
			p->scale			= 45;
			p->alpha			= 200;
			p->die				= cl.time + 1345;

			if (rand()&1) {
				p->colorred			= 222;
				p->colorgreen		= 222;
				p->colorblue		= 222;			
			} else {
				p->colorred		= 79;
				p->colorgreen	= 151;
				p->colorblue	= 227;
			}

			if (rand()&1)
				p->type				= pt_smoke;
			else
				p->type				= pt_fade;



			p->glow				= true;

			p->velocity[0]		= (rand() & 63 + 50) * (j*8 + (rand()&7)) * 0.05;
			p->velocity[1]		= (rand() & 63 + 50) * (i*8 + (rand()&7)) * 0.05;
			p->velocity[2]		= (rand() & 63 + 50) * ((i+j)*8 + (rand()&7)) * 0.02 + 220 + (220 * rand()&1);//((rand() & 63 + 50) * 256 + 50) * 0.01;
	
			p->origin[0]		= origin[0] + i * 10 + (rand() & 27);
			p->origin[1]		= origin[1] + j * 10 + (rand() & 27);
			p->origin[2]		= origin[2] + (i+j)*10 + (rand() & 7);


			/*
			p->velocity[0]		= (rand() & 3 + 2) * (j *2 + (rand()&7)) * 0.1;
			p->velocity[1]		= (rand() & 3 + 2) * (i *2 + (rand()&7)) * 0.1;
			p->velocity[2]		= (rand() & 3 + 2) * 25 + 10;
	
			p->origin[0]		= origin[0] + (rand() & 7) + (j * 8);
			p->origin[1]		= origin[1] + (rand() & 7) + (i * 8);
			p->origin[2]		= origin[2] + (rand() & 63);
				*/
		}
	}
}

// Tei fog plash

// Tei chof
void R_FogChof (vec3_t origin)
{
	int			i, j;
	particle_t	*p;

	for (i=-16 ; i<16 ; i++)
	{	
		for (j=-16 ; j<16 ; j++)
		{
			p	= addParticle();
			if(!p)
			{
				return;
			}
		
			p->texnum			= smoke3_tex;
			p->bounce			= 1;
			p->scale			= 28;
			p->alpha			= 200;
			p->die				= cl.time + 45;

			p->colorred			= 222;
			p->colorgreen		= 222;
			p->colorblue		= 222;			

			p->type				= pt_smoke;
			p->glow				= true;
				
			p->velocity[0]		= (rand() & 63 + 50) * (j*8 + (rand()&7));
			p->velocity[1]		= (rand() & 63 + 50) * (i*8 + (rand()&7));
			p->velocity[2]		= (rand() & 63 + 50) * 256 + 50;
	
			p->origin[0]		= origin[0] + (rand() & 7) + (j * 8);
			p->origin[1]		= origin[1] + (rand() & 7) + (i * 8);
			p->origin[2]		= origin[2] + (rand() & 63);
		}
	}
}

// Tei chof



/*
===============
R_LavaSplash
===============
*/
void R_LavaSplash (vec3_t origin)
{
	int			i, j;
	particle_t	*p;

	for (i=-16 ; i<16 ; i++)
	{	
		for (j=-16 ; j<16 ; j++)
		{
			p	= addParticle();
			if(!p)
			{
				return;
			}
		
			p->texnum			= particle_tex;
			p->bounce			= 0;
			p->scale			= 2;
			p->alpha			= 200;
			p->die				= cl.time + 5;

			p->colorred			= 163;
			p->colorgreen		= 39;
			p->colorblue		= 11;			

			p->type				= pt_grav;
			p->glow				= true;
				
			p->velocity[0]		= (rand() & 63 + 50) * (j*8 + (rand()&7));
			p->velocity[1]		= (rand() & 63 + 50) * (i*8 + (rand()&7));
			p->velocity[2]		= (rand() & 63 + 50) * 256;
	
			p->origin[0]		= origin[0] + (rand() & 7) + (j * 8);
			p->origin[1]		= origin[1] + (rand() & 7) + (i * 8);
			p->origin[2]		= origin[2] + (rand() & 63);

		}
	}
}

/*
===============
R_TeleportSplash

===============
*/
void R_TeleportSplash (vec3_t origin)
{
	int			i, j, k;
	particle_t	*p;

	for (i=-16 ; i<16 ; i+=4)
	{	
		for (j=-16 ; j<16 ; j+=4)
		{
			for (k=-24 ; k<32 ; k+=4)
			{
				p	= addParticle();
				if(!p)
				{
					return;
				}
		
				p->texnum			= particle_tex;
				p->bounce			= 0;
				p->scale			= 2;
				p->alpha			= 200;
				p->die				= cl.time + 1;

				p->colorred			= 255;
				p->colorgreen		= 255;
				p->colorblue		= 255;				

				p->type				= pt_fade;
				p->glow				= true;
	
				p->origin[0]		= origin[0] + i + (rand() & 7);
				p->origin[1]		= origin[1] + j + (rand() & 7);
				p->origin[2]		= origin[2] + k + (rand() & 7);
	
				p->velocity[0]		= i*2 + (rand() & 31) - 16;
				p->velocity[1]		= j*2 + (rand() & 31) - 16;
				p->velocity[2]		= k*2 + (rand() & 31) + 24;
			}
		}
	}
}

// Tei custom fx
void R_CustomFX (vec3_t origin,vec3_t color,vec3_t veloc , int num, int particle, int bounce, int scale, int die, int type )
{
	int			i;
	particle_t	*p;

	for (i= 0  ; i<num ; i++){	
				p	= addParticle();
				if(!p)
				{
					return;
				}
		
				p->texnum			= particle;
				p->bounce			= bounce;
				p->scale			= scale;
				p->alpha			= 200;
				p->die				= cl.time + die;

				p->colorred			= color[0];
				p->colorgreen		= color[1];
				p->colorblue		= color[2];				

				p->type				= type;
				p->glow				= true;
	
				p->origin[0]		= origin[0];
				p->origin[1]		= origin[1];
				p->origin[2]		= origin[2];
	
				p->velocity[0]		= veloc[0];
				p->velocity[1]		= veloc[1];
				p->velocity[2]		= veloc[2];
	}
}
// Tei custom fx

void R_RailTrail (vec3_t start, vec3_t end, vec3_t angle)
{
	vec3_t		vec;
	float		len;
	vec3_t		forward, right, up;
	particle_t	*p;
	byte		*color;

	VectorSubtract (end, start, vec);

	len = VectorNormalize(vec);

	while (len > 0)
	{
		{  
			p	= addParticle();
			if(!p)
			{
				return;
			}

			p->alpha			= 200;
			p->scale			= 3;
			p->die				= cl.time + 1;
			p->glow				= true;

			p->colorred			= 255;
			p->colorgreen		= 255;
			p->colorblue		= 255;

			p->type				= pt_rail;
			//Tei new rail
			p->texnum			= circle_tex;//particle_tex;
			//Tei new rail
			p->bounce			= 0;

			p->origin[0]		= start[0];
			p->origin[1]		= start[1];
			p->origin[2]		= start[2];

			p->velocity[0]		= 0;
			p->velocity[1]		= 0;
			p->velocity[2]		= 0;
		}

		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->alpha			= 200;
		p->scale			= 4;
		p->die				= cl.time + 1;
		p->glow				= true;

		color				= (byte *) &d_8to24table[(int)(rand() & 7) + 208];

		p->colorred			= color[0];
		p->colorgreen		= color[1];
		p->colorblue		= color[2];

		p->type				= pt_rail;
		p->texnum			= particle_tex;
		p->bounce			= 0;

		AngleVectors (angle, forward, right, up);

		p->origin[0]		= start[0] + right[0] * 3;
		p->origin[1]		= start[1] + right[1] * 3;
		p->origin[2]		= start[2] + right[2] * 3;
		
		p->velocity[0]		= right[0] * 10;
		p->velocity[1]		= right[1] * 10;
		p->velocity[2]		= right[2] * 10;

		angle[2] += 5;

		len--;
		VectorAdd (start, vec, start);
	}                                     
}

// Tei custom fx

// Tei hipertrail

void R_ZTrail (vec3_t start, vec3_t end, vec3_t angle)
{
	vec3_t		vec;
	float		len;
	vec3_t		forward, right, up;
	particle_t	*p;
	byte		*color;

	VectorSubtract (end, start, vec);

	len = VectorNormalize(vec);

	while (len > 0)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->alpha			= 250;
		p->scale			= 4;
		p->die				= cl.time + 55;
		p->glow				= true;

		color				= (byte *) &d_8to24table[(int)(rand() & 7) + 208];

		p->colorred			= color[0];
		p->colorgreen		= color[1];
		p->colorblue		= color[2];

		p->type				= pt_rail;
		p->texnum			= flama_tex;
		p->bounce			= 0;

		AngleVectors (angle, forward, right, up);

		p->origin[0]		= start[0] + right[0];// * 3;
		p->origin[1]		= start[1] + right[1];// * 3;
		p->origin[2]		= start[2] + right[2];// * 3;
		
		p->velocity[0]		= right[0] * 80;
		p->velocity[1]		= right[1] * 80;
		p->velocity[2]		= right[2] * 80;

		angle[2] += 5;//5

		len--;
		VectorAdd (start, vec, start);
	}                                     
}

// Tei hipertrail

void R_RocketTrail (vec3_t start, vec3_t end, entity_t *ent)
{
	int			contents;
	particle_t	*p;

	if (ent->debris_smoke <= 0)
		return;

	contents = Mod_PointInLeaf(start, cl.worldmodel)->contents;

	if (contents == CONTENTS_SKY || contents == CONTENTS_LAVA)
		return;

	if (cl.time > ent->time_left)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		VectorCopy(start, p->origin);

		if (contents == CONTENTS_EMPTY || contents == CONTENTS_SOLID)
		{
			p->die			= cl.time + 10;

			p->colorred		= 187;
			p->colorgreen	= 187;
			p->colorblue	= 187;			

			p->alpha		= ent->debris_smoke * 28;
			p->scale		= 2;
			p->texnum		= smoke1_tex + (rand() & 3);
			p->type			= pt_smoke;
			p->bounce		= 0;

			p->velocity[0]	= (rand() & 15) - 8;
			p->velocity[1]	= (rand() & 15) - 8;
			p->velocity[2]	= (rand() & 31) + 15;
			
		}
		else
		{
			p->die			= cl.time + 10;

			p->colorred		= 127;
			p->colorgreen	= 127;
			p->colorblue	= 255;

			p->alpha		= 200;
			p->scale		= (rand() & 3) +1;
			p->texnum		= bubble_tex;
			p->bounce		= 0;
			p->type			= pt_bubble;

			p->velocity[0]	= 0;
			p->velocity[1]	= 0;
			p->velocity[2]	= 20;
		}
		p->glow				= false;
		ent->time_left		= cl.time + 0.01;
		ent->debris_smoke	-= 0.05f;
	}
}

// Tei fx
void R_TrailGray (entity_t * e)
{
	int			contents;
	particle_t	*p;

	p	= addParticle();
	if(!p)
	{
		return;
	}

	VectorCopy(e->origin, p->origin);

	p->die			= cl.time + 10;//e->frame;

	p->colorred		= 127;
	p->colorgreen	= 127;
	p->colorblue	= 127;			

	//p->alpha		= rand()&127;
	p->alpha		= rand()&63;
	
	//p->scale		= 32 + rand()&31;
    p->scale		= 16 + rand()&31;

	p->texnum		= smoke1_tex + (rand() & 3);
	p->type			= pt_slowmoke2;
	p->bounce		= 0;
	p->glow			= 0;
	p->velocity[0]	= ((rand() & 15) - 8)*2;
	p->velocity[1]	= ((rand() & 15) - 8)*2;
	p->velocity[2]	= (rand() & 15);
}

void R_TrailGray3 (entity_t * e)
{
	int			contents;
	particle_t	*p;

	p	= addParticle();
	if(!p)
	{
		return;
	}

	VectorCopy(e->origin, p->origin);

	p->die			= cl.time + 10;//e->frame;

	p->colorred		= 127;
	p->colorgreen	= 127;
	p->colorblue	= 127;			

	p->alpha		= rand()&63;
	
    p->scale		= 1 + rand()&7;
	p->scalex		= 12 + rand()&3;
	p->scaley		= 12 + rand()&3;
	p->scalez		= 1;


	p->texnum		= smoke1_tex + (rand() & 3);
	p->type			= pt_slowmoke2;
	p->bounce		= 0;
	p->glow			= 0;
	p->velocity[0]	= ((rand() & 15) - 8)*2;
	p->velocity[1]	= ((rand() & 15) - 8)*2;
	p->velocity[2]	= (rand() & 15);
}


void R_TrailGray2 (entity_t * e)
{
	int			contents;
	particle_t	*p;

	p	= addParticle();
	if(!p)
	{
		return;
	}

	VectorCopy(e->origin, p->origin);

	p->die			= cl.time + 10;//e->frame;

	p->colorred		= 127;
	p->colorgreen	= 127;
	p->colorblue	= 127;			

	p->alpha		= rand()&127;
	
	p->scale		= 32 + rand()&31;

	p->texnum		= smoke1_tex + (rand() & 3);
	p->type			= pt_slowmoke2;
	p->bounce		= 0;
	p->glow			= 0;
	p->velocity[0]	= ((rand() & 15) - 8)*2;
	p->velocity[1]	= ((rand() & 15) - 8)*2;
	p->velocity[2]	= (rand() & 15);
}

// Tei fx


// Tei circles trail
void R_CircleRocketTrail (vec3_t start, vec3_t end, entity_t *ent)
{
	int			contents;
	particle_t	*p;

	if (ent->debris_smoke <= 0)
		return;

	contents = Mod_PointInLeaf(start, cl.worldmodel)->contents;

	if (contents == CONTENTS_SKY || contents == CONTENTS_LAVA)
		return;

	if (cl.time > ent->time_left)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		VectorCopy(start, p->origin);

		if (contents == CONTENTS_EMPTY || contents == CONTENTS_SOLID)
		{
			p->die			= cl.time + 10;

			p->colorred		= 187;
			p->colorgreen	= 187;
			p->colorblue	= 187;			

			p->alpha		= ent->debris_smoke * 28;
			p->scale		= 2;
			p->texnum		= circle_tex;
			p->type			= 	pt_expandfade;//pt_slowmoke;//pt_fade	;//pt_static;
			p->bounce		= 0;
			p->glow				= false;
			p->velocity[0]	= 0;
			p->velocity[1]	= 0;
			p->velocity[2]	= 0;
			
		}
		else
		{
			p->die			= cl.time + 10;

			p->colorred		= 127;
			p->colorgreen	= 127;
			p->colorblue	= 255;

			p->alpha		= 200;
			p->scale		= (rand() & 3) +1;
			p->texnum		= bubble_tex;
			p->bounce		= 0;
			p->type			= pt_bubble;

			p->velocity[0]	= 0;
			p->velocity[1]	= 0;
			p->velocity[2]	= 20;
		}
		p->glow				= false;
		ent->time_left		= cl.time + 0.01;
		ent->debris_smoke	-= 0.05f;
	}
}


// Tei circles trail


// Tei Black estela begin

void R_DarkRocketTrail (vec3_t start, vec3_t end, entity_t *ent, qboolean subtype)
{
	int			contents;
	particle_t	*p;

	if (ent->debris_smoke <= 0)
		return;

	contents = Mod_PointInLeaf(start, cl.worldmodel)->contents;

	if (contents == CONTENTS_SKY || contents == CONTENTS_LAVA)
		return;

	if (cl.time > ent->time_left)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		VectorCopy(start, p->origin);

		if (contents == CONTENTS_EMPTY || contents == CONTENTS_SOLID)
		{
			p->die			= cl.time + 10;

			p->colorred		= 0;
			p->colorgreen	= 0;
			p->colorblue	= 0;			

			p->alpha		= ent->debris_smoke * 28;
			p->scale		= 12;
			p->texnum		= smoke1_tex + (rand() & 3);
			if (subtype == true)
				p->type			= pt_fade			;//pt_snow;//pt_smoke;
			else
				// Smoke that not die
				p->type			= pt_snow			;//pt_snow;//pt_smoke;

			p->bounce		= 0;

			p->velocity[0]	= (rand() & 15) - 8;
			p->velocity[1]	= (rand() & 15) - 8;
			p->velocity[2]	= (rand() & 31) + 15;
			
		}
		else
		{
			p->die			= cl.time + 10;

			p->colorred		= 127;
			p->colorgreen	= 127;
			p->colorblue	= 255;

			p->alpha		= 200;
			p->scale		= (rand() & 3) +1;
			p->texnum		= bubble_tex;
			p->bounce		= 0;
			p->type			= pt_bubble;

			p->velocity[0]	= 0;
			p->velocity[1]	= 0;
			p->velocity[2]	= 20;
		}
		p->glow				= false;
		ent->time_left		= cl.time + 0.01;
		ent->debris_smoke	-= 0.05f;
	}
}

// Tei Black estela end


void R_BloodTrail (vec3_t start, vec3_t end, entity_t *ent)
{
	particle_t	*p;
	byte		*color;

	if (cl.time > ent->time_left)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->die				= cl.time + 10;

		color				= (byte *) &d_8to24table[(int)(rand() & 3) + 68];

		p->colorred			= color[0];
		p->colorgreen		= color[1];
		p->colorblue		= color[2];

		p->alpha			= 200;
		p->scale			= 4;
		p->texnum			= blood_tex;
		p->bounce			= 0;
		p->type				= pt_blood2;
		p->glow				= false;

		p->velocity[0]		= (rand() & 15) - 8;
		p->velocity[1]		= (rand() & 15) - 8;
		p->velocity[2]		= (rand() & 15) - 8;

		p->origin[0]		= start[0] + ((rand() & 3) - 2);
		p->origin[1]		= start[1] + ((rand() & 3) - 2);
		p->origin[2]		= start[2] + ((rand() & 3) - 2);

		ent->time_left		= cl.time + 0.01;
	}
}

void R_TracerTrail (vec3_t start, vec3_t end, entity_t *ent, byte color)
{
	vec3_t		vec;
	static int	tracercount;
	particle_t	*p;
	byte		*color24;
	
	VectorSubtract (end, start, vec);

	if (cl.time > ent->time_left)
	{
		{
			p	= addParticle();
			if(!p)
			{
				return;
			}

			VectorCopy (start, p->origin);

			p->die				= cl.time + 0.3;

			color24				= (byte *) &d_8to24table[(int)color];

			p->colorred			= color24[0];
			p->colorgreen		= color24[1];
			p->colorblue		= color24[2];

			p->alpha			= 200;
			p->scale			= 3;
			p->texnum			= particle_tex;
			p->bounce			= 0;
			p->type				= pt_static;
			p->glow				= true;

			p->velocity[0]		= 5 * -vec[1];
			p->velocity[1]		= 5 *  vec[0];
			p->velocity[2]		= 0;
		}

		{
			p	= addParticle();
			if(!p)
			{
				return;
			}

			VectorCopy (start, p->origin);

			p->die				= cl.time + 0.3;

			color24				= (byte *) &d_8to24table[(int)color];

			p->colorred			= color24[0];
			p->colorgreen		= color24[1];
			p->colorblue		= color24[2];

			p->alpha			= 200;
			p->scale			= 3;
			p->texnum			= particle_tex;
			p->bounce			= 0;
			p->type				= pt_static;
			p->glow				= true;

			p->velocity[0]		= 5 *  vec[1];
			p->velocity[1]		= 5 * -vec[0];
			p->velocity[2]		= 0;
		}
		ent->time_left			= cl.time + 0.01;
	}
}

void R_VoorTrail (vec3_t start, vec3_t end, entity_t *ent)
{
	particle_t	*p;

	if (cl.time > ent->time_left)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->die				= cl.time + 2;

		p->colorred			= 187;
		p->colorgreen		= 115;
		p->colorblue		= 159;		

		p->alpha			= 200;
		p->scale			= 3;
		p->texnum			= particle_tex;
		p->bounce			= 0;
		p->type				= pt_fade;
		p->glow				= true;

		p->velocity[0]		= (rand() & 15) - 8;
		p->velocity[1]		= (rand() & 15) - 8;
		p->velocity[2]		= (rand() & 15) - 8;

		p->origin[0]		= start[0] + ((rand() & 3) - 2);
		p->origin[1]		= start[1] + ((rand() & 3) - 2);
		p->origin[2]		= start[2] + ((rand() & 3) - 2);

		ent->time_left		= cl.time + 0.01;
	}
}

/*
==========
R_Fire
==========
*/
void R_Fire (entity_t *ent, qboolean fire2)
{
	particle_t	*p;
	
	if( cl.time + 1 < ent->time_left )
	{
		ent->time_left = cl.time + 0.01;
	}
	
	if (cl.time > ent->time_left)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->die			= cl.time + 5;

		p->colorred		= 227;
		p->colorgreen	= 151;
		p->colorblue	= 79;

		p->alpha		= 128;
		p->scale		= 10;
		p->texnum		= particle_tex;
		p->bounce		= 0;
		p->type			= pt_fire;
		p->glow			= true;

		p->velocity[0]	= (rand() & 3) - 2;
		p->velocity[1]	= (rand() & 3) - 2;
		p->velocity[2]	= 0;

		p->origin[0]	= ent->origin[0];
		p->origin[1]	= ent->origin[1];
		p->origin[2]	= ent->origin[2] + 4;

		if (fire2)
		{
			p->origin[2]	= ent->origin[2] - 2;
			if (ent->frame)
			{
				p->scale		= 30;
				p->velocity[0]	= (rand() & 7) - 4;
				p->velocity[1]	= (rand() & 7) - 4;
				p->velocity[2]	= 0;
				p->type			= pt_fire2;
			}
		}
		ent->time_left	= cl.time + 0.01;
	}
}


// Tei big fire

void R_BigFire (entity_t *ent, qboolean fire2)
{
	particle_t	*p;
	
	if( cl.time + 1 < ent->time_left )
	{
		ent->time_left = cl.time + 0.01;
	}
	
	if (cl.time > ent->time_left)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->die			= cl.time + 10;

		p->colorred		= 227;
		p->colorgreen	= 151;
		p->colorblue	= 79;

		p->alpha		= 128;
		p->scale		= 90;
		p->texnum		= particle_tex;
		p->bounce		= 0;
		p->type			= pt_fire;
		p->glow			= true;

		p->velocity[0]	= (rand() & 3) - 2;
		p->velocity[1]	= (rand() & 3) - 2;
		p->velocity[2]	= 0;//(rand() & 3) - 2;

		p->origin[0]	= ent->origin[0];
		p->origin[1]	= ent->origin[1];
		p->origin[2]	= ent->origin[2] + 4;

		if (fire2)
		{
			p->origin[2]	= ent->origin[2] - 2;
			if (ent->frame)
			{
				p->scale		= 30;
				p->velocity[0]	= (rand() & 7) - 4;
				p->velocity[1]	= (rand() & 7) - 4;
				p->velocity[2]	= 0;
				p->type			= pt_fire2;
			}
		}
		ent->time_left	= cl.time + 0.01;
	}
}
// Tei big fire


// Tei big fire down
/*
==========
R_DowFire
==========
*/
void R_DowFire (entity_t *ent, qboolean fire2)
{
	particle_t	*p;
	//vec3_t * vfor;
	float		sr, sp, sy, cr, cp, cy;
	float		angle;

	if( cl.time + 1 < ent->time_left )
	{
		ent->time_left = cl.time + 0.01;
	}
	
	if (cl.time > ent->time_left)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->die			= cl.time + 20;

		if (rand()&1) {
			// fire1
			p->colorred		= 227;
			p->colorgreen	= 151;
			p->colorblue	= 79;
		}
		else{
			if (rand()&1) {
				if (rand()&1) {
					// gas
					p->colorred		= 79;
					p->colorgreen	= 151;
					p->colorblue	= 227;
				}
				else {
					// smoke
					p->colorred		= -79;
					p->colorgreen	= -151;
					p->colorblue	= -227;
				}
			} else {
				// fire2
				p->colorred		= -79;
				p->colorgreen	= -151;
				p->colorblue	= -227;
			}

		}
		/*
			// smoke
			p->colorred		= 10;
			p->colorgreen	= 10;
			p->colorblue	= 10;
		*/


		p->alpha		= 128;

		if (rand()&1){

			p->scale		= 40;
			if ( rand()&1 ) 
				p->scale		= 60;
		}
		else
			p->scale		= 25;

		if (rand()&1)
			p->texnum		= fire_tex;//snow_tex;//particle_tex;rain_tex;
		else 
			p->texnum		= smoke1_tex;//snow_tex;//particle_tex;rain_tex;

		//p->texnum = flama_tex;

		p->bounce		= 1;
		
		if (rand()&1)
			p->type			= pt_fire;
		else
			p->type			= pt_fire2;

		p->glow			= true;

		/*
		p->velocity[0]	= (rand() & 3) - 2;
		p->velocity[1]	= (rand() & 3) - 2;
		p->velocity[2]	= -200 - ((rand() & 8) );
		*/

	//AngleVectors

	angle	= DEG2RAD(ent->angles[YAW]);	// Tomaz Speed
	sy		= sin(angle);
	cy		= cos(angle);
	angle	= DEG2RAD(ent->angles[PITCH]);	// Tomaz Speed
	sp		= sin(angle);
	cp		= cos(angle);
	angle	= DEG2RAD(ent->angles[ROLL]);	// Tomaz Speed
	sr		= sin(angle);
	cr		= cos(angle);

		p->velocity[0]	= cp*cy * 160;
		p->velocity[1]	= cp*sy * 160;
		p->velocity[2]	=  -sp * 160;
	

		p->origin[0]	= ent->origin[0] ;
		p->origin[1]	= ent->origin[1] ;
		p->origin[2]	= ent->origin[2] ;

		ent->time_left	= cl.time + 0.01;
	}
}
// Tei big fire down

// Tei - small enginefire begin
void R_SmallDowFire (entity_t *ent, qboolean fire2)
{
	particle_t	*p;
	//vec3_t * vfor;
	float		sr, sp, sy, cr, cp, cy;
	float		angle;

	if( cl.time + 1 < ent->time_left )
	{
		ent->time_left = cl.time + 0.01;
	}
	
	if (cl.time > ent->time_left)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->die			= cl.time + 20;

		if (rand()&1) {
			// fire1
			p->colorred		= 227;
			p->colorgreen	= 151;
			p->colorblue	= 79;
		}
		else{
			if (rand()&1) {
				if (rand()&1) {
					// gas
					p->colorred		= 79;
					p->colorgreen	= 151;
					p->colorblue	= 227;
				}
				else {
					// smoke
					p->colorred		= -79;
					p->colorgreen	= -151;
					p->colorblue	= -227;
				}
			} else {
				// fire2
				p->colorred		= -79;
				p->colorgreen	= -151;
				p->colorblue	= -227;
			}

		}
		/*
			// smoke
			p->colorred		= 10;
			p->colorgreen	= 10;
			p->colorblue	= 10;
		*/


		p->alpha		= 128;

		if (rand()&1){

			p->scale		= 6;
			if ( rand()&1 ) 
				p->scale		= 8;
		}
		else
			p->scale		= 5;

		if (rand()&1)
			p->texnum		= fire_tex;//snow_tex;//particle_tex;rain_tex;
		else 
			p->texnum		= smoke1_tex;//snow_tex;//particle_tex;rain_tex;

		//p->texnum = flama_tex;

		p->bounce		= 1;
		
		if (rand()&1)
			p->type			= pt_fire;
		else
			p->type			= pt_fire2;

		p->glow			= true;

		/*
		p->velocity[0]	= (rand() & 3) - 2;
		p->velocity[1]	= (rand() & 3) - 2;
		p->velocity[2]	= -200 - ((rand() & 8) );
		*/

	//AngleVectors

	angle	= DEG2RAD(ent->angles[YAW]);	// Tomaz Speed
	sy		= sin(angle);
	cy		= cos(angle);
	angle	= DEG2RAD(ent->angles[PITCH]);	// Tomaz Speed
	sp		= sin(angle);
	cp		= cos(angle);
	angle	= DEG2RAD(ent->angles[ROLL]);	// Tomaz Speed
	sr		= sin(angle);
	cr		= cos(angle);

		p->velocity[0]	= cp*cy * 16;
		p->velocity[1]	= cp*sy * 16;
		p->velocity[2]	=  -sp * 16;
	

		p->origin[0]	= ent->origin[0] ;
		p->origin[1]	= ent->origin[1] ;
		p->origin[2]	= ent->origin[2] ;

		ent->time_left	= cl.time + 0.01;
	}
}
// Tei small enginefire end


// Tei magic fire down
/*
==========
R_DowFire
==========
*/
void R_MagicFire (entity_t *ent, qboolean fire2)
{
	particle_t	*p;
	//vec3_t * vfor;
	float		sr, sp, sy, cr, cp, cy;
	float		angle;

	if( cl.time + 1 < ent->time_left )
	{
		ent->time_left = cl.time + 0.01;
	}
	
	if (cl.time > ent->time_left)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->die			= cl.time + 20;

		if (rand()&1) {
			// fire1
			p->colorred		= 227;
			p->colorgreen	= 151;
			p->colorblue	= 79;
		}
		else{
			if (rand()&1) {
				if (rand()&1) {
					// gas
					p->colorred		= 79;
					p->colorgreen	= 151;
					p->colorblue	= 227;
				}
				else {
					// smoke
					p->colorred		= -79;
					p->colorgreen	= -151;
					p->colorblue	= -227;
				}
			} else {
				// fire2
				p->colorred		= -79;
				p->colorgreen	= -151;
				p->colorblue	= -227;
			}

		}
			// smoke
		if (rand()&1) 
		{
			p->colorred		= 10 + rand()&129;
			p->colorgreen	= 10+ rand()&129;
			p->colorblue	= 10+ rand()&129;
		}


		p->alpha		= 128;

		if (rand()&1){

			p->scale		= 40;
			if ( rand()&1 ) 
				p->scale		= 60;
		}
		else
			p->scale		= 25;

		p->texnum		= rain_tex;

		p->bounce		= 0;
		

		//if (rand()&1)
			p->type			= pt_smokeexp;//pt_blob2;//pt_explode;//pt_snow;
		//else
		//	p->type			= pt_fire2;

		p->glow			= true;


	angle	= DEG2RAD(ent->angles[YAW]) + sin( anglemod(100*cl.time)/90*M_PI) * 5;	// Tomaz Speed
	sy		= sin(angle);
	cy		= cos(angle);
	angle	= DEG2RAD(ent->angles[PITCH]);	// Tomaz Speed
	sp		= sin(angle);
	cp		= cos(angle);
	angle	= DEG2RAD(ent->angles[ROLL]);	// Tomaz Speed
	sr		= sin(angle);
	cr		= cos(angle);

		p->velocity[0]	= cp*cy * 160  ;
		p->velocity[1]	= cp*sy * 160 ;
		p->velocity[2]	=  -sp * 160 ;

	

		p->origin[0]	= ent->origin[0] ;
		p->origin[1]	= ent->origin[1] ;
		p->origin[2]	= ent->origin[2] ;

		ent->time_left	= cl.time + 0.01;
	}
}
// Tei magic fire down



// Tei big fire down
/*
==========
R_DowFire
==========
*/
void R_FireClassic (entity_t *ent, qboolean fire2)
{
	particle_t	*p;
	//vec3_t * vfor;

	if( cl.time + 1 < ent->time_left )
	{
		ent->time_left = cl.time + 0.01;
	}
	
	if (cl.time > ent->time_left)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->die			= cl.time + 20;

		if (rand()&1) {
			// fire1
			p->colorred		= 227;
			p->colorgreen	= 151;
			p->colorblue	= 79;
		}
		else{
			if (rand()&1) {
				if (rand()&1) {
					// gas
					p->colorred		= 79;
					p->colorgreen	= 151;
					p->colorblue	= 227;
				}
				else {
					// smoke
					p->colorred		= -79;
					p->colorgreen	= -151;
					p->colorblue	= -227;
				}
			} else {
				// fire2
				p->colorred		= -79;
				p->colorgreen	= -151;
				p->colorblue	= -227;
			}

		}

		p->alpha		= 128;

		if (rand()&1){

			p->scale		= 40;
			if ( rand()&1 ) 
				p->scale		= 60;
		}
		else
			p->scale		= 25;

		if (rand()&1)
			if (rand()&1)
				p->texnum		= fire_tex;//snow_tex;//particle_tex;rain_tex;
			else
				p->texnum		= smoke2_tex;//snow_tex;//particle_tex;rain_tex;
		else 
			p->texnum		= smoke1_tex;//snow_tex;//particle_tex;rain_tex;

		//p->texnum = swdf.value;

		p->bounce		= 1;
		
		if (rand()&1)
			p->type			= pt_fire;
		else
			p->type			= pt_fire2;

		p->glow			= true;

		p->velocity[0]	= (rand() & 3) - 2;
		p->velocity[1]	= (rand() & 3) - 2;
		p->velocity[2]	= -200 - ((rand() & 8) );
	

		p->origin[0]	= ent->origin[0] ;
		p->origin[1]	= ent->origin[1] ;
		p->origin[2]	= ent->origin[2] ;

		ent->time_left	= cl.time + 0.01;
	}
}
// Tei big fire down


// Tei - Fire explosion











// Tei waterfall
/*
==========
R_WaterFall
==========
*/
void R_WaterFall (entity_t *ent, qboolean fire2)
{
	particle_t	*p;
	//vec3_t * vfor;

	if( cl.time + 1 < ent->time_left )
	{
		ent->time_left = cl.time + 0.01;
	}
	
	if (cl.time > ent->time_left)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->die			= cl.time + 80;

		if (rand()&1) {
			// fire1
			p->colorred		= 250;
			p->colorgreen	= 250;
			p->colorblue	= 250;
		}
		else
			p->colorred		= 79;
			p->colorgreen	= 151;
			p->colorblue	= 227;

		/*
		else{
			if (rand()&1) {
				if (rand()&1) {
					// gas
					p->colorred		= 119;
					p->colorgreen	= 121;
					p->colorblue	= 127;
				}
				else {
					// smoke
					p->colorred		= 119;
					p->colorgreen	= 111;
					p->colorblue	= 257;
				}
			} else {
				// fire2
				p->colorred		= 39;
				p->colorgreen	= 211;
				p->colorblue	= 257;
			}

		}
		*/
		if (rand()&1)
			p->alpha		= 128;
		else
			p->alpha		= 250;


		if (rand()&1){

			p->scale		= 40;
			if ( rand()&1 ) 
				p->scale		= 60;
		}
		else
			p->scale		= 32;

		if (rand()&1)
			if (rand()&1)
				p->texnum		= smoke1_tex;//snow_tex;//particle_tex;rain_tex;
			else
				p->texnum		= smoke2_tex;//snow_tex;//particle_tex;rain_tex;
		else 
			p->texnum		= smoke3_tex;//snow_tex;//particle_tex;rain_tex;
		





		p->bounce		= 1;
		
		if (rand()&1)
			p->type			= pt_fire;
		else
			p->type			= pt_fire2;

		p->glow			= true;

		p->velocity[0]	= (rand() & 3) - 2;
		p->velocity[1]	= (rand() & 3) - 2;
		p->velocity[2]	= -200 - ((rand() & 8) );
	

		p->origin[0]	= ent->origin[0] ;
		p->origin[1]	= ent->origin[1] ;
		p->origin[2]	= ent->origin[2] ;

		ent->time_left	= cl.time + 0.01;
	}
}
// Tei waterfall end




// Tei Blue fire

/*
==========
R_FireBlue
==========
*/
void R_FireBlue (entity_t *ent, qboolean fire2)
{
	particle_t	*p;
	
	if( cl.time + 1 < ent->time_left )
	{
		ent->time_left = cl.time + 0.01;
	}
	
	if (cl.time > ent->time_left)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->die			= cl.time + 5;

		p->colorred		= 79;
		p->colorgreen	= 151;
		p->colorblue	= 227;

		p->alpha		= 128;
		p->scale		= 10;
		p->texnum		= particle_tex;
		p->bounce		= 0;
		p->type			= pt_fire;
		p->glow			= true;

		p->velocity[0]	= (rand() & 3) - 2;
		p->velocity[1]	= (rand() & 3) - 2;
		p->velocity[2]	= 0;//(rand() & 3) - 2;

		p->origin[0]	= ent->origin[0];
		p->origin[1]	= ent->origin[1];
		p->origin[2]	= ent->origin[2] + 4;

		if (fire2)
		{
			p->origin[2]	= ent->origin[2] - 2;
			if (ent->frame)
			{
				p->scale		= 30;
				p->velocity[0]	= (rand() & 7) - 4;
				p->velocity[1]	= (rand() & 7) - 4;
				p->velocity[2]	= 0;
				p->type			= pt_fire2;
			}
		}
		ent->time_left	= cl.time + 0.01;
	}
}

// Tei Blue fire


#define	DIST_EPSILON	(0.03125)

int SV_HullPointContents (hull_t *hull, int num, vec3_t p);

qboolean detectCollision( int num, vec3_t start, vec3_t end, vec3_t impact, vec3_t normal )
{
	dclipnode_t	*node, *nodes = cl.worldmodel->hulls->clipnodes;
	mplane_t	*plane, *planes = cl.worldmodel->hulls->planes;
	float		t1, t2;
	float		frac;
	vec3_t		mid;
	int			side;

	qboolean	t1neg, t2neg;

	while( num >= 0 )
	{
		t1neg = false;
		t2neg = false;
	//
	// find the point distances
	//
		node	= nodes + num;
		plane	= planes + node->planenum;

		t1		= start[plane->type] - plane->dist;
		t2		= end[plane->type] - plane->dist;

		if( plane->type >= 3 )
		{
			t1	= DotProduct (plane->normal, start) - plane->dist;
			t2	= DotProduct (plane->normal, end) - plane->dist;
		}

		if( t1 < 0 )
		{
			t1neg	= true;
		}
		if( t2 < 0 )
		{
			t2neg	= true;
		}
		
		if( !t1neg && !t2neg )
		{
			num	= node->children[0];
			continue;
		}

		if( t1neg && t2neg )
		{
			num	= node->children[1];
			continue;
		}

	// put the crosspoint DIST_EPSILON pixels on the near side
		if( t1neg )
		{
			frac	= (t1 + DIST_EPSILON)/(t1-t2);
		}
		else
		{
			frac	= (t1 - DIST_EPSILON)/(t1-t2);
		}

		//
		//	clamp to [0,1]
		if(frac < 0)
		{
			frac	= 0;
		}

		if(frac > 1)
		{
			frac	= 1;
		}
			
		mid[0]	= start[0] + frac*(end[0] - start[0]);
		mid[1]	= start[1] + frac*(end[1] - start[1]);
		mid[2]	= start[2] + frac*(end[2] - start[2]);

		side = ( t1 < 0 );

		// move up to the node
		if( detectCollision( node->children[side], start, mid, impact, normal ) )
		{
			return true;
		}

		if( SV_HullPointContents( cl.worldmodel->hulls, node->children[side^1], mid ) != CONTENTS_SOLID )
		{
			// go past the node
			num		= node->children[ side^1 ];

			//	NOTE: this is ok, because we won't need start any more! ONLY because of that!
			//			IE: CHANGE IT if you use it elsewhere, and keep using start
			VectorCopy( mid, start );

			continue;
		}
		
	//==================
	// the other side of the node is solid, this is the impact point
	//==================
		if( !side )
		{
			VectorCopy( plane->normal, normal );
		}
		else
		{
			VectorNegate( plane->normal, normal );
		}

		VectorCopy( mid, impact );
		
		return true;
	}

	//	empty
	return false;
}

extern	qboolean	mirror_render;
extern	cvar_t		sv_gravity;

//Tei volumetric 
float CalcVolLevel ( particle_t * pe , float maxdx)
{
	particle_t	*p				= active_particles;
	float sal = 0;

	while( p )
	{
		if ( (fabs( p->origin[0] - pe->origin[0] ) + fabs( p->origin[1] - pe->origin[1] ) +fabs( p->origin[2] - pe->origin[2] )) < maxdx )
				sal++;
		p	= p->next;
	}
	return sal;
};
// Tei volumetric


extern cvar_t sv_stepsize;//Tei

//
//	R_MoveParticles
//

void R_MoveParticles( void )
{
	particle_t	*p				= active_particles;

	
	//
	//	time vars
	//
	
	float		frametime		= cl.time - cl.oldtime;
	float		time			= frametime * 10;
	float		fastgrav		= frametime * sv_gravity.value * 0.5f;
	float		slowgrav		= frametime * sv_gravity.value * 0.05f;
	float		evenslowergrav	= frametime * sv_gravity.value * 0.02f;
	
	float		ft2				= frametime * 2.0f;
	float		ft4				= frametime * 4.0f;
	float		ft8				= frametime * 8.0f;
	float		ft16			= frametime * 16.0f;
	float		ft32			= frametime * 32.0f;
	float		ft64			= frametime * 64.0f;
	float		ft128			= frametime * 128.0f;
	float		ft256			= frametime * 256.0f;
	
	float dx;	//Tei
	
	//
	//	bounce  vars
	//

	vec3_t		impact, normal, oldorigin;
	float		dist;

	float		vl;// Tei volumetric

	//
	//	loop through all the particles, doing physics for each
	//
	
	while( p )
	{

		//Tei volumetric
		/*
		if (p->volumetric)
		{	
			//if (rand()&1)
			vl = CalcVolLevel(p,8);
			if (vl <2)
			{
				p->type = pt_fadeout;
				p->texnum = particle_tex;
			}
			else
			if (vl <3)
			{
				p->texnum = particle_tex;
			}
		}
		*/
		//Tei volumetric				

		//	if its dead, kill it...
		if (p->type == pt_static )
		if( p->die < cl.time )
		{
			// Tei polite particle deletion
			p->type = pt_fadeout;
			/*
			p	= remParticle( p );
			continue;
			*/
			p->alpha	   -= ft8;

			p->die = cl.time + 0.3;

			if (p->texnum == smoke1_tex)
				p->texnum = smoke2_tex;
			else
			if (p->texnum == smoke2_tex)
				p->texnum = smoke1_tex;
			// Tei polite particle deletion
		}
		

			
		
		//
		//	move the particle
		//
		
		VectorCopy(p->origin, oldorigin);
		
		p->origin[0] += p->velocity[0] * frametime;
		p->origin[1] += p->velocity[1] * frametime;
		p->origin[2] += p->velocity[2] * frametime;

		//Tei wind
		/*
		p->origin[0] += 1 / (fabs(p->velocity[0]));
		p->origin[1] += 1 / (fabs(p->velocity[1]));
		p->alpha	   -= ft8;
		p->scale	   += ft8;
		*/
		//Tei wind

		//
		//	handle all the velocity/alpha/scale physics and particle-specific stuff
		//	do this here so we can kill as many alpha and scale out particles as possible before bouncing
		//

		// Tei fxcolor
		switch( p->fxcolor)
		{
			case FXC_AUTOGRAY:
				if(p->colorblue)
					p->colorblue--;
				if(p->colorred)
					p->colorred--;
				if(p->colorgreen)
					p->colorgreen--;
				break;
			case FXC_AUTOGRAY2:
				//p->glow = false;
				if (rand()&1)
					break;
				if(p->colorblue)
					p->colorblue  = p->colorblue * 0.999;
				if(p->colorred)
					p->colorred   = p->colorred * 0.999;
				if(p->colorgreen)
					p->colorgreen = p->colorgreen * 0.999;
				break;

			default:
				break;
		}
		// Tei fxcolor
			
		if( p->type & ( pt_grav | pt_fade | pt_blood ) )
		{
			p->velocity[2]	-= slowgrav;
		}
		
		if( p->type & ( pt_blood2 | pt_explode ) )
		{
			p->velocity[2]	-= fastgrav;
		}
		
		if( p->type & ( pt_smoke | pt_bulletpuff | pt_smokeexp | pt_fade | pt_rail ) )
		{
			p->alpha		-= ft256;
		}
		
		if( p->type & ( pt_blood2 | pt_explode ) )
		{
			p->alpha		-= ft128;
		}
		
		if( p->type & ( pt_fire | pt_fire2 ) )
		{
			p->alpha		-= ft64;
		}
		
		if( p->type & ( pt_smoke | pt_bulletpuff | pt_smokeexp ) )
		{
			p->scale		+= ft16;
		}
		
		switch( p->type )
		{
			// Tei static fix
			case pt_static:
			{
				p->time = cl.time + 3;
				break;
			}
			// Tei static fix

			
			case pt_rain:
			{
				p->velocity[2] = -fabs(p->velocity[2]) - 10 ;
					//p->type = pt_fadeout;
				
				break;
			}


			case pt_bubble:
			{
				p->velocity[0] = (rand() & 15) - 8;
				p->velocity[1] = (rand() & 15) - 8;
				p->velocity[2] = (rand() & 31) + 64;
				
				break;
			}
			
			case pt_explode:
			{
				p->scale		-= ft2;
				
				break;
			}
			
			case pt_snow:
			{
				if (cl.time > p->time)
				{
					p->time = cl.time + (rand() & 3) * 0.1;
					p->velocity[0] = (rand() & 31) - 16;
					p->velocity[1] = (rand() & 31) - 16;
					//if (p->velocity[2]> -10)	//Tei
					//		p->velocity[2] -= 10; //Tei
				}	
				break;
			}

			case pt_snowfade:
			{
				if (cl.time > p->time)
				{
					p->time = cl.time + (rand() & 3) * 0.1;
					p->velocity[0] = (rand() & 31) - 16;
					p->velocity[1] = (rand() & 31) - 16;
					p->scale	   += ft16;
					if (p->alpha > ft32)
						p->alpha	   -= ft32;
					else
						p->alpha = 0;
					p->velocity[1] = p->velocity[1] + (rand() & 7);
				}	
				break;
			}


			case pt_fire:
			{
				p->velocity[2]	+= evenslowergrav;
				p->scale		-= ft2;
				
				break;
			}
			
			case pt_fire2:
			{
				p->velocity[2]	+= slowgrav;
				p->scale		-= ft4;
				
				break;
			}

			case pt_slowmoke:
			{
				if (cl.time > p->time)
				{
					p->time = cl.time + (rand() & 3) * 0.1;
					p->velocity[0] = (rand() & 31) - 16;
					p->velocity[1] = (rand() & 31) - 16;
					p->velocity[2] += slowgrav;
					p->alpha	   -= ft256;
				}
				
				break;
			}
			/*
			case pt_slowmoke2:
			{
				if (cl.time > p->time)
				{
					p->time = cl.time + (rand() & 3) * 0.1;
					p->velocity[0] = p->velocity[0] * 0.5 + (rand() & 7) - 3;
					p->velocity[1] = p->velocity[1] * 0.5 + (rand() & 7) - 3;
					p->velocity[2] += slowgrav * 0.1;
					p->alpha	   -= ft128;
					p->scale	   += ft64;
				}
				
				break;
			}
			*/
			case pt_slowmoke2:
			{
				if (cl.time > p->time)
				{
					p->time = cl.time + (rand() & 3) * 0.1;
					p->velocity[0] = p->velocity[0] * 0.5 + (rand() & 7) - 3;
					p->velocity[1] = p->velocity[1] * 0.5 + (rand() & 7) - 3;
					p->velocity[2] += slowgrav * 0.1;
					p->alpha	   -= ft128;
					p->scale	   += ft128;
				}
				
				break;
			}


			case pt_expandfade:
			{
				p->alpha	   -= ft128;//ft256;
				p->scale	   += ft4;
				break;

			}

			case pt_expand:
			{
				p->alpha	   -= ft64;//ft256;
				p->scale	   += ft128;
				break;
			}

			case pt_fadeout:
			{
				p->alpha = p->alpha * 0.4;
				break;
			}

			case pt_fog:
			{
				p->alpha +=  ft4;
				p->scale += ft4;
				if (p->die < (cl.time + 3)) {
					if (rand()&1)
						p->type = pt_expandfade;
					
				}
				break;
			}

			case pt_gorigin:
			{
				//p->alpha	-= ft8;
				//p->scale	+= ft16;

				p->alpha	-= ft16;
				//p->scale	+= ft8;

				dx = fabs( p->origin[0] - p->gorigin[0] ) + fabs( p->origin[1] - p->gorigin[1] ) +fabs( p->origin[2] - p->gorigin[2] );
				if ( dx < 5)
					p->type = pt_fadeout;
				break;
			}
		
			default:
				break;

		}
		
		
		//
		//	if alpha is <= 0, its invisible, loose it; if scale is <= 0, its invisible, loose it
		//
		
		if( p->alpha <= 0.0f || p->scale <= 0.0f )
		{
			p	= remParticle( p );
			continue;
		}		
		
		
		//
		//	this is a big CPU eater... but oh well, its needed. =] we check other break out situations first
		//	then run this check
		//	
		//	also, we're doing this stuff before the bounce is thought of because... well... never seen stuff bounce all that much off the sky. ;]
		//
		
		p->contents = Mod_PointInLeaf(p->origin, cl.worldmodel)->contents;
		
		
		//
		//	check for sky impact - no ammount of bouncing matters here
		//
		
		if( p->contents == CONTENTS_SKY )
		{
			p = remParticle(p);
			continue;
		}
		
		
		//
		//	handle bounce - only do this if its in solid... ;] no need to bust our balls for nothing...
		//
		
		if( p->bounce )
		{
			if( detectCollision( 0, oldorigin, p->origin, impact, normal ) )
			{
				VectorCopy(impact, p->origin);
				
				dist = DotProduct(p->velocity, normal) * -p->bounce;
				
				VectorMA(p->velocity, dist, normal, p->velocity);
				
				if( DotProduct(p->velocity, p->velocity) < 0.03 )
				{
					VectorClear(p->velocity);
					p->bounce = 0;
				}
			}
		}
		
		//
		//	now we check for being inside a solid, and get rid of it if it is - note, not bouncing stuff inside of a solid - it bounces back out
		//
		
		if( p->contents == CONTENTS_SOLID && !p->bounce )
		{
			p	= remParticle( p );
			continue;
		}
		
		
		//
		//	lastly, we have a bunch more CONTENTS checks, but only on certain particle type combos...
		//
		
		//	check for bubbles outa the water
		if( ( p->type & pt_bubble ) && ( p->contents == CONTENTS_EMPTY ) )
		{
			p	= remParticle( p );
			continue;
		}
		
		//	check for stuff in the water...
		if( ( p->type & ( pt_explode | pt_bulletpuff | pt_smokeexp | pt_slowmoke ) ) && ( p->contents != CONTENTS_EMPTY ) && ( p->contents != CONTENTS_SOLID ) )
		{
			p	= remParticle( p );
			continue;
		}
		
		
		//
		//	move pointer up one
		//
		
		p	= p->next;
	}
}


//
//	R_DrawParticles
//



void R_DrawParticles( qboolean waterpart )
{
	particle_t	*p			 	= active_particles;
	
	int			texnum;
	
	byte		alpha;
	
	vec3_t		up				= { vup[0] * 0.75f, vup[1] * 0.75f, vup[2] * 0.75f };
	vec3_t		right			= { vright[0] * 0.75f, vright[1] * 0.75f, vright[2] * 0.75f };
	
	vec3_t		coord[4];
	
	//
	//	if there aren't any particles active, don't try to draw particles!! =]
	//
	
	if( !p )
	{
		return;
	}
	
	//
	//	create the coordinates along the plane parallel to our view
	//
	
	VectorAdd( up, right, coord[0] );
	VectorSubtract( right, up, coord[1] );
	VectorNegate( coord[0], coord[2] );
	VectorNegate( coord[1], coord[3] );
	
	//
	//	setup for the loop
	//

	//	fix up texnum
	texnum		= p->texnum;
	glBindTexture( GL_TEXTURE_2D, texnum );
	
	//	get blending setup
	glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE );
	
	//	remove write to depth buffer
	glDepthMask(false);
	
	//
	//	loop
	//
	
	while( p )
	{
		//	if the texnums don't match, end primitives, and bind a new texture, then restart primitives
		if( p->texnum != texnum )
		{
			texnum	= p->texnum;
			glBindTexture( GL_TEXTURE_2D, texnum );
		}
		
		if (p->glow)
			glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		else
			glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

		//
		//	ensure that we draw only those particles on the 'right' side of the water as det. by waterpart
		//
		
		if(!waterpart && p->contents != CONTENTS_EMPTY)
		{
			p = p->next;
			continue;
		}
		
		if(waterpart && p->contents == CONTENTS_EMPTY)
		{
			p = p->next;
			continue;
		}
		
		alpha	= p->alpha;
	
		glColor4ub(p->colorred, p->colorgreen, p->colorblue, alpha);
		
		
		//
		//	push a matrix onto the stack for this particle
		//
		
		glPushMatrix();
		{	
			//
			//	translate and scale it
			//
			
			glTranslatef( p->origin[0], p->origin[1], p->origin[2] );
			glScalef( p->scale * p->scalex, p->scale * p->scaley, p->scale * p->scalez);//Tei
			
			glBegin( GL_QUADS );
			{
				//
				//	pass the vertex data to OpenGL
				//
				
				glTexCoord2f(	0,		1	);
				glVertex3fv(	coord[0]	);
				
				glTexCoord2f(	0,		0	);
				glVertex3fv(	coord[1]	);
				
				glTexCoord2f(	1,		0	); 
				glVertex3fv(	coord[2]	);
				
				glTexCoord2f(	1,		1	);
				glVertex3fv(	coord[3]	);
				
			}
			glEnd();
			
		}
		glPopMatrix();
		
		
		//
		//	move on to the next particle
		//
		
		p = p->next;
	}

	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
	glDepthMask(true);
	glColor4f(1,1,1,1);
}





///////////////////////////
// FH CODE



/* === Shockwaves === */

/*
void R_Shock1 (vec3_t org, int type)
{
	int			i, j, count;
	particle_t	*p;
	byte		*colorRGB;

	p	= addParticle();
	if(!p)
	{
		return;
	}

	p->die = cl.time + 1;
	
	p->drawtype = PFX_GLOW;

	
	if (type == 1)
		p->fxtype = TE_SHOCKWAVE;
	else if (type == 2)
	{
		p->fxtype = TE_BIGSHOCKWAVE;
		p->die = cl.time + 0.125;
	}
	else
		p->fxtype = TE_SPARKWAVE;
	//			p->die = cl.time + 0.2 + (rand()&7) * 0.02;
	p->texnum			= circle_tex;

	p->colorred			= 150 + rand()%6;
	p->colorgreen		= 150 + rand()%6;
	p->colorblue		= 150 + rand()%6;

	p->scale			= 1;
	p->alpha			= 200;
	p->bounce			= 0;
	p->type = pt_grav;
	p->time = cl.time;
	p->glow				= false;

	//colorRGB				= (byte *) &d_8to24table[(int)(rand() & 7) + 105];
	//p->colorred = colorRGB[0];
	//p->colorgreen = colorRGB[1];
	//p->colorblue = colorRGB[2];

		p->origin[0]		= org[0];
		p->origin[1]		= org[1];
		p->origin[2]		= org[2];

		p->velocity[0]		= 0;
		p->velocity[1]		= 0;
		p->velocity[2]		= 0;
}

*/

void R_FireExplo (vec3_t  origin, float scale)
{
	particle_t	*p;
	int i;
	int ext = 7 * scale;
	int pos = 32 * scale;

	for (i =0; i < 6; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		//ext = ext + rand()&1;
		pos = pos + rand()&63  ;

		p->die			= cl.time + 20;

		p->fxcolor = FXC_AUTOGRAY2;
		//p->volumetric = true;

		if (rand()&1) {
			// fire1
			p->colorred		= 227;
			p->colorgreen	= 151;
			p->colorblue	= 79;
		}
		else{
			if (rand()&1) {
				if (rand()&1) {
					// gas
					p->colorred		= 79;
					p->colorgreen	= 151;
					p->colorblue	= 227;
				}
				else {
					// smoke
					p->colorred		= -79;
					p->colorgreen	= -151;
					p->colorblue	= -227;
				}
			} else {
				// fire2
				p->colorred		= -79;
				p->colorgreen	= -151;
				p->colorblue	= -227;
			}

		}

		p->alpha		= 128;

		if (rand()&1){

			p->scale		= 10 * scale;
			if ( rand()&1 ) 
				p->scale		= 15 * scale;
		}
		else
			p->scale		= 7 * scale;

		if (p->scale < 255)
			p->scale = p->scale + 5;

		if (rand()&1)
			if (rand()&1)
				p->texnum		= fire_tex;//snow_tex;//particle_tex;rain_tex;
			else
				p->texnum		= smoke2_tex;//snow_tex;//particle_tex;rain_tex;
		else 
			p->texnum		= smoke1_tex;//snow_tex;//particle_tex;rain_tex;

		//if (rand()&1)
		//		p->texnum		= flama_tex;//snow_tex;//particle_tex;rain_tex;


		p->bounce		= 1;
		
		if (rand()&1)
			p->type			= pt_fire;
		else
			p->type			= pt_fire2;

		p->glow			= true;

		p->velocity[0]	= (rand() & (ext *2+1)) - ext;
		p->velocity[1]	= (rand() & (ext *2+1)) - ext;
		p->velocity[2]	= 100 - ((rand() & 8) );
	

		p->origin[0]	= origin[0] +(rand() & (pos*2+1)) - pos; 
		p->origin[1]	= origin[1] +(rand() & (pos*2+1)) - pos;
		p->origin[2]	= origin[2] ;
	}
}

void R_FireExploLava (vec3_t  origin, float scale)
{
	particle_t	*p;
	int i;
	int ext = 7 * scale;
	int pos = 32 * scale;

	p	= addParticle();
	if(!p)
	{
		return;
	}

	pos = pos + rand()&63  ;

	p->die			= cl.time + 20;

	if (rand()&1) {
		// fire1
		p->colorred		= 227;
		p->colorgreen	= 151;
		p->colorblue	= 79;
	}
	else{
		if (rand()&1) {
			if (rand()&1) {
				// gas
				p->colorred		= 79;
				p->colorgreen	= 151;
				p->colorblue	= 227;
			}
			else {
				// smoke
				p->colorred		= -79;
				p->colorgreen	= -151;
				p->colorblue	= -227;
			}
		} else {
			// fire2
			p->colorred		= -79;
			p->colorgreen	= -151;
			p->colorblue	= -227;
		}

	}

	p->alpha		= rand()&63;

	if (rand()&1){

		p->scale		= 10 * scale;
		if ( rand()&1 ) 
			p->scale		= 15 * scale;
	}
	else
		p->scale		= 7 * scale;

	if (p->scale < 255)
		p->scale = p->scale + 5;

	/*
	if (rand()&1)
		if (rand()&1)
			p->texnum		= fire_tex;//snow_tex;//particle_tex;rain_tex;
		else
			p->texnum		= smoke2_tex;//snow_tex;//particle_tex;rain_tex;
	else 
		p->texnum		= smoke1_tex;//snow_tex;//particle_tex;rain_tex;
	*/
	if (rand()&1)
			p->texnum = particle_tex;
	else
		if (rand()&1)
			p->texnum = smoke1_tex;
		else
			p->texnum = smoke2_tex;

	if (rand()&1)
		p->type			= pt_fire;
	else
		p->type			= pt_fire2;


	if ( rand()&7 == 7 )
	{
		p->bounce		= 1;
		p->texnum = bubble_tex;
		p->scale = 3;
		p->alpha = 3;
		p->type =	pt_bubble;
	}
	else
		p->bounce		=  0;
	

	//if(rand()&1)
	//if (rand()&1)
	//	p->type			= pt_slowmoke2;
	//else
	//	p->type			= pt_snowfade;



	p->glow			= true;

	p->velocity[0]	= (rand() & (ext *2+1)) - ext;
	p->velocity[1]	= (rand() & (ext *2+1)) - ext;
	p->velocity[2]	= 100 - ((rand() & 8) );


	p->origin[0]	= origin[0] +(rand() & (pos*2+1)) - pos; 
	p->origin[1]	= origin[1] +(rand() & (pos*2+1)) - pos;
	p->origin[2]	= origin[2] ;
}


void R_FireExploBlack (vec3_t  origin, float scale)
{
	particle_t	*p;
	int i;
	int ext = 2 * scale;
	int pos = 7 * scale;

		p	= addParticle();
		if(!p)
		{
			return;
		}

		//ext = ext + rand()&1;
		pos = pos + rand()&63  ;

		p->die			= cl.time + 20;

		p->colorred		= 0;
		p->colorgreen	= 0;
		p->colorblue	= 0;
		p->alpha		= rand()&127;


		if (rand()&1){

			p->scale		= 10 * scale;
			if ( rand()&1 ) 
				p->scale		= 15 * scale;
		}
		else
			p->scale		= 7 * scale;

		if (p->scale < 255)
			p->scale = p->scale + 5;

		p->texnum		= smoke1_tex + (rand()&3);//snow_tex;//particle_tex;rain_tex;

		p->bounce		= 0;
		
		if (rand()&1)
			p->type			= pt_snowfade;
		//else
		//	p->type			= pt_slowmoke;

		p->glow			= false;

		p->velocity[0]	= (rand() & (ext *2+1)) - ext;
		p->velocity[1]	= (rand() & (ext *2+1)) - ext;
		p->velocity[2]	= 30 - ((rand() & 8) );
	

		p->origin[0]	= origin[0] +(rand() & (pos*2+1)) - pos; 
		p->origin[1]	= origin[1] +(rand() & (pos*2+1)) - pos;
		p->origin[2]	= origin[2] + pos * 2 + (rand()& pos);
}


void R_FireFlama (vec3_t  origin, float scale)
{
	particle_t	*p;
	int i;
	int ext = 7 * scale;
	int pos = 31 * scale;

	for (i =0; i < 6; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}
		ext = ext + rand()&1;
		pos = pos + rand()&1;

		p->die			= cl.time + 20;

		if (rand()&1) {
			// fire1
			p->colorred		= 227;
			p->colorgreen	= 151;
			p->colorblue	= 79;
		}
		else{
			if (rand()&1) {
				if (rand()&1) {
					// gas
					p->colorred		= 79;
					p->colorgreen	= 151;
					p->colorblue	= 227;
				}
				else {
					// smoke
					p->colorred		= -79;
					p->colorgreen	= -151;
					p->colorblue	= -227;
				}
			} else {
				// fire2
				p->colorred		= -79;
				p->colorgreen	= -151;
				p->colorblue	= -227;
			}

		}

		//p->alpha		= 128;

		p->alpha		= rand()&127;

		if (rand()&1){

			p->scale		= 20 * scale;
			if ( rand()&1 ) 
				p->scale		= 30 * scale;
		}
		else
			p->scale		= 15 * scale;

		if (rand()&1)
			if (rand()&1)
				p->texnum		= fire_tex;//snow_tex;//particle_tex;rain_tex;
			else
				p->texnum		= smoke2_tex;//snow_tex;//particle_tex;rain_tex;
		else 
			p->texnum		= smoke1_tex;//snow_tex;//particle_tex;rain_tex;

		if (rand()&1)
				p->texnum		= flama_tex;//snow_tex;//particle_tex;rain_tex;


		p->bounce		= 1;
		
		if (rand()&1)
			p->type			= pt_fire;
		else
			p->type			= pt_fire2;

		p->glow			= true;

		p->velocity[0]	= (rand() & (ext *2+1)) - ext;
		p->velocity[1]	= (rand() & (ext *2+1)) - ext;
		p->velocity[2]	= 100 - ((rand() & 8) );
	

		p->origin[0]	= origin[0] +(rand() & (pos*2+1)) - pos; 
		p->origin[1]	= origin[1] +(rand() & (pos*2+1)) - pos;
		p->origin[2]	= origin[2] ;
	}
}


void R_ExploRing (vec3_t  origin, float scale)
{
	particle_t	*p;
	int i;
	int ext = 127 * scale;
	int pos = 32 * scale;


	for (i =0; i < 6; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}
		ext = ext + rand()&1;
		pos = pos + rand()&1;

		p->die			= cl.time + 20 ;

		if (rand()&1) {
			p->colorred		= 227;
			p->colorgreen	= 151;
			p->colorblue	= 79;
		}

		p->alpha		= 60;
		p->scale		= 2 * scale;
		p->texnum		= circle_tex;
		p->bounce		= 0;
		p->type			= pt_expand;
		p->glow			= true;

		p->velocity[0]	= ((rand() & (ext *2+1)) - ext) * 50;
		p->velocity[1]	= ((rand() & (ext *2+1)) - ext) * 50;
		p->velocity[2]	= 0;
	

		p->origin[0]	= origin[0] ; 
		p->origin[1]	= origin[1] ;
		p->origin[2]	= origin[2] ;
	}
}

void R_ZRing (vec3_t  origin, float scale)
{
	particle_t	*p;
	int i;
	int ext = 127 * scale;
	int pos = 32 * scale;


	//for (i =0; i < 3; i++)
	//{
		p	= addParticle();
		if(!p)
		{
			return;
		}
		ext = ext + rand()&1;
		pos = pos + rand()&1;

		p->die			= cl.time + 20 ;

		if (rand()&1) {
			p->colorred		= 227;
			p->colorgreen	= 251;
			p->colorblue	= 252;
		}

		p->alpha		= 60;
		p->scale		= scale;
		p->texnum		= circle_tex;
		p->bounce		= 0;
		p->type			= pt_expand;
		p->glow			= true;

		p->velocity[0]	= 0;
		p->velocity[1]	= 0;
		p->velocity[2]	= 0;
	

		p->origin[0]	= origin[0] ; 
		p->origin[1]	= origin[1] ;
		p->origin[2]	= origin[2] ;
	//}
}

void R_ParticleSnow (vec3_t origin)
{
	int			i, contents;
	particle_t	*p;
	vec3_t		vel;
	byte		*color;

	p	= addParticle();
	if(!p)
	{
		return;
	}

	p->scale			= 2 +rand()&3 ;
	p->alpha			= 80;
	p->texnum			= snow_tex;
	p->bounce			= 0;
	p->type				= pt_snow;

	p->colorred			= 255;
	p->colorgreen		= 255;
	p->colorblue		= 255;

	p->die				= cl.time + 15;
	p->glow				= true;

	p->origin[0]		= origin[0] + (rand() &127) - 63;
	p->origin[1]		= origin[1] + (rand() &127) - 63;
	p->origin[2]		= origin[2] + (rand() &127) - 63;

	p->velocity[2]		= -( 20 + rand()&63);
}


void R_ParticleRain (vec3_t origin)
{
	int			i, contents;
	particle_t	*p;
	vec3_t		vel;
	byte		*color;

	p	= addParticle();
	if(!p)
	{
		return;
	}

	p->scale			= 1 +rand()&1 ;
	p->scalez			= 1 +rand()&63;

	p->alpha			= 70;
	p->texnum			= particle_tex;
	p->bounce			= 0;
	p->type				= pt_rain;

	p->colorred			= 255;
	p->colorgreen		= 255;
	p->colorblue		= 255;

	p->die				= cl.time + 2;
	p->glow				= true;

	p->origin[0]		= origin[0] + (rand() &127) - 63;
	p->origin[1]		= origin[1] + (rand() &127) - 63;
	p->origin[2]		= origin[2] + (rand() &127) - 63;

	p->velocity[2]		= -( 1920 + rand()&511 );
}


void R_FireStaticFog (vec3_t  origin)
{
	particle_t	*p;
	int i;
	int pos = 32 ;

	for (i =0; i < 6; i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->die			= cl.time + 20;

		p->scale  = rand()&7;
		p->scalex = rand()&127;
		p->scaley = rand()&127;

		p->colorred		= 255;
		p->colorgreen	= 255;
		p->colorblue	= 255;
		p->alpha		= rand()&31;
		p->bounce		= 0;
		p->texnum		= smoke1_tex + (rand() & 3);

		p->type			= pt_static;
		p->glow			= true;

		p->origin[0]	= origin[0] +(rand() & (pos*2-1)) - pos; 
		p->origin[1]	= origin[1] +(rand() & (pos*2-1)) - pos;
		p->origin[2]	= origin[2] ;

		p->velocity[0] = 0;
		p->velocity[1] = 0;
		p->velocity[2] = 0;

	}
}


void R_ParticleBlast (vec3_t origin, vec3_t dir, int num,vec3_t color, byte scale)
{
	int			i, contents;
	particle_t	*p;
	vec3_t		vel;

	for( i=0; i<num;i++)
	{
		p	= addParticle();
		if(!p)
		{
			return;
		}

		p->scale			= 1 ;
		p->scalex			= 1+ rand()&31;
		p->scaley			= 1+ rand()&31;
		p->scalez			= 1+ rand()&31;

		p->alpha			= 80;
		p->texnum			= particle_tex;
		p->bounce			= 0;
		p->type				= pt_static;

		p->colorred			= color[0];
		p->colorgreen		= color[1];
		p->colorblue		= color[2];

		p->die				= cl.time + 15;
		p->glow				= true;

		if( scale)
		{
			p->origin[0]		= origin[0] + ((rand()&(scale*2-1)) - scale) ;
			p->origin[1]		= origin[1] + ((rand()&(scale*2-1)) - scale);
			p->origin[2]		= origin[2] + ((rand()&(scale*2-1)) - scale);
		}
		else
		{
			p->origin[0]		= origin[0];
			p->origin[1]		= origin[1];
			p->origin[2]		= origin[2];
		}

		p->velocity[0]		= dir[0];
		p->velocity[1]		= dir[1];
		p->velocity[2]		= dir[2];
	}
}