#include "quakedef.h"
#include "drquake.h"
#ifdef Q2_BSP38
extern model_t *loadmodel;
extern char    loadname[32];
extern byte	*mod_base;
extern int bspversion;
#ifdef XBSP
extern bspheader_t *loadheader;
#define loadmodel loadheader
#endif

void Mod_LoadNodes_BSP38 (lump_t *l)
{
	int			i, j, count, p;
	dnodeBSP38_t	*in;
	mnode_t 	*out;

	in = (void *)(mod_base + l->fileofs);
	if (l->filelen % sizeof(*in))
		Sys_Error ("MOD_LoadBmodel: funny nodelump size in %s",loadname);
	count = l->filelen / sizeof(*in);
	out = Hunk_AllocName ( count*sizeof(*out), loadname);	

	loadmodel->nodes = out;
	loadmodel->numnodes = count;

	for ( i=0 ; i<count ; i++, in++, out++)
	{
		for (j=0 ; j<3 ; j++)
		{
			out->minmaxs[j] = LittleShort (in->mins[j]);
			out->minmaxs[3+j] = LittleShort (in->maxs[j]);
		}
	
		p = LittleLong(in->planenum);
		out->plane = loadmodel->planes + p;

		out->firstsurface = LittleShort (in->firstface);
		out->numsurfaces = LittleShort (in->numfaces);
		
		for (j=0 ; j<2 ; j++)
		{
			p = LittleLong (in->children[j]);
			if (p >= 0)
				out->children[j] = loadmodel->nodes + p;
			else
				out->children[j] = (mnode_t *)(loadmodel->leafs + (-1 - p));
		}
	}
	
	Mod_SetParent (loadmodel->nodes, NULL);	// sets nodes and leafs
}

void Mod_LoadLeafs_BSP38 (lump_t *l)
{
	dleafBSP38_t 	*in;
	mleaf_t 	*out;
	int			i, j, count, p;

	in = (void *)(mod_base + l->fileofs);
	if (l->filelen % sizeof(*in))
		Sys_Error ("MOD_LoadBmodel: funny lump size in %s",loadname);
	count = l->filelen / sizeof(*in);
	out = Hunk_AllocName ( count*sizeof(*out), loadname);	

	loadmodel->leafs = out;
	loadmodel->numleafs = count;

	for ( i=0 ; i<count ; i++, in++, out++)
	{
		for (j=0 ; j<3 ; j++)
		{
			out->minmaxs[j] = LittleShort (in->mins[j]);
			out->minmaxs[3+j] = LittleShort (in->maxs[j]);
		}

		p = LittleLong(in->contents);
		out->contents = p;

		out->firstmarksurface = loadmodel->marksurfaces +
			LittleShort(in->firstmarksurface);
		out->nummarksurfaces = LittleShort(in->nummarksurfaces);
		
		p = LittleLong(in->visofs);
		if (p == -1)
			out->compressed_vis = NULL;
		else
			out->compressed_vis = loadmodel->visdata + p;
		out->efrags = NULL;
		
		for (j=0 ; j<4 ; j++)
			out->ambient_sound_level[j] = 0;//in->ambient_level[j];

		// gl underwater warp
		if (out->contents != CONTENTS_EMPTY)
		{
			for (j=0 ; j<out->nummarksurfaces ; j++)
				out->firstmarksurface[j]->flags |= SURF_UNDERWATER;
		}
	}	
}

void Mod_LoadTexinfo_BSP38 (lump_t *l)
{
	texinfoBSP38_t *in;
	mtexinfo_t *out;
	int 	i, j, count;
	int		miptex;
	float	len1, len2;

	in = (void *)(mod_base + l->fileofs);
	if (l->filelen % sizeof(*in))
		Sys_Error ("MOD_LoadBmodel: funny texinfolump size in %s",loadname);
	count = l->filelen / sizeof(*in);
	out = Hunk_AllocName ( count*sizeof(*out), loadname);	

	loadmodel->texinfo = out;
	loadmodel->numtexinfo = count;

	for ( i=0 ; i<count ; i++, in++, out++)
	{
		for (j=0 ; j<8 ; j++)
			out->vecs[0][j] = LittleFloat (in->vecs[0][j]);
		len1 = Length (out->vecs[0]);
		len2 = Length (out->vecs[1]);
		len1 = (len1 + len2)/2;
		if (len1 < 0.32)
			out->mipadjust = 4;
		else if (len1 < 0.49)
			out->mipadjust = 3;
		else if (len1 < 0.99)
			out->mipadjust = 2;
		else
			out->mipadjust = 1;
#if 0
		if (len1 + len2 < 0.001)
			out->mipadjust = 1;		// don't crash
		else
			out->mipadjust = 1 / floor( (len1+len2)/2 + 0.1 );
#endif

//		miptex = LittleLong (in->miptex);
		out->flags = LittleLong (in->flags);
	
//		if (!loadmodel->textures)
		{
			out->texture = r_notexture_mip;	// checkerboard texture
			out->flags = 0;
		}
/*		else
		{
			if (miptex >= loadmodel->numtextures)
				Sys_Error ("miptex >= loadmodel->numtextures");
			out->texture = loadmodel->textures[miptex];
			if (!out->texture)
			{
				out->texture = r_notexture_mip; // texture not found
				out->flags = 0;
			}
		}
*/	}
/*
	int         i, j, num, max, altmax;
	miptex_t	*mt;
	texture_t	*tx, *tx2;
	texture_t	*anims[10];
	texture_t	*altanims[10];
	texinfoBSP38_t *texinfo;

	if (!l->filelen)
	{
		loadmodel->textures = NULL;
		return;
	}

	texinfo = (texinfoBSP38_t *)(mod_base + l->fileofs);
	m->nummiptex = LittleLong (m->nummiptex);
	loadmodel->numtextures = m->nummiptex;
	loadmodel->textures = Hunk_AllocName (m->nummiptex * sizeof(*loadmodel->textures) , loadname);

	for (i=0 ; i<m->nummiptex ; i++)
	{
		m->dataofs[i] = LittleLong(m->dataofs[i]);
		if (m->dataofs[i] == -1)
			continue;
		mt = (miptex_t *)((byte *)m + m->dataofs[i]);

		// JTR: rewriting the map texture loader for the DRQuake TX_loader
		tx = Hunk_AllocName (sizeof(texture_t), loadname );
		loadmodel->textures[i] = tx;

		memcpy (tx->name, mt->name, sizeof(tx->name));

		tx->width = LittleLong (mt->width);
		tx->height = LittleLong (mt->height);
		for (j=0 ; j<MIPLEVELS ; j++)
			tx->offsets[j] = LittleLong (mt->offsets[j]);

		if ( (tx->width & 15) || (tx->height & 15) )
			Sys_Error ("Texture %s is not 16 aligned", mt->name);

		if (!strncmp(mt->name,"{",1))
			tx->transparent = true;
		else
			tx->transparent = false;

		tx->gl_texturenum = TX_LoadTexture(-1, tx->name, 0, 0, 0);
	}
//
// sequence the animations
//
	for (i=0 ; i<m->nummiptex ; i++)
	{
		tx = loadmodel->textures[i];
		if (!tx || tx->name[0] != '+')
			continue;
		if (tx->anim_next)
			continue;	// allready sequenced

	// find the number of frames in the animation
		memset (anims, 0, sizeof(anims));
		memset (altanims, 0, sizeof(altanims));

		max = tx->name[1];
		altmax = 0;
		if (max >= 'a' && max <= 'z')
			max -= 'a' - 'A';
		if (max >= '0' && max <= '9')
		{
			max -= '0';
			altmax = 0;
			anims[max] = tx;
			max++;
		}
		else if (max >= 'A' && max <= 'J')
		{
			altmax = max - 'A';
			max = 0;
			altanims[altmax] = tx;
			altmax++;
		}
		else
			Sys_Error ("Bad animating texture %s", tx->name);

		for (j=i+1 ; j<m->nummiptex ; j++)
		{
			tx2 = loadmodel->textures[j];
			if (!tx2 || tx2->name[0] != '+')
				continue;
			if (strcmp (tx2->name+2, tx->name+2))
				continue;

			num = tx2->name[1];
			if (num >= 'a' && num <= 'z')
				num -= 'a' - 'A';
			if (num >= '0' && num <= '9')
			{
				num -= '0';
				anims[num] = tx2;
				if (num+1 > max)
					max = num + 1;
			}
			else if (num >= 'A' && num <= 'J')
			{
				num = num - 'A';
				altanims[num] = tx2;
				if (num+1 > altmax)
					altmax = num+1;
			}
			else
				Sys_Error ("Bad animating texture %s", tx->name);
		}
		
#define	ANIM_CYCLE	2
	// link them all together
		for (j=0 ; j<max ; j++)
		{
			tx2 = anims[j];
			if (!tx2)
				Sys_Error ("Missing frame %i of %s",j, tx->name);
			tx2->anim_total = max * ANIM_CYCLE;
			tx2->anim_min = j * ANIM_CYCLE;
			tx2->anim_max = (j+1) * ANIM_CYCLE;
			tx2->anim_next = anims[ (j+1)%max ];
			if (altmax)
				tx2->alternate_anims = altanims[0];
		}
		for (j=0 ; j<altmax ; j++)
		{
			tx2 = altanims[j];
			if (!tx2)
				Sys_Error ("Missing frame %i of %s",j, tx->name);
			tx2->anim_total = altmax * ANIM_CYCLE;
			tx2->anim_min = j * ANIM_CYCLE;
			tx2->anim_max = (j+1) * ANIM_CYCLE;
			tx2->anim_next = altanims[ (j+1)%altmax ];
			if (max)
				tx2->alternate_anims = anims[0];
		}
	}
*/
}

void Mod_LoadBrushModel_BSP38 (model_t *mod, void *buffer)
{
	int			i;
	dheader_t	*header;
	
#ifdef XBSP
#undef loadmodel
#endif
	loadmodel->type = mod_brush;
	
	mod_base = buffer;
	header = (dheader_t *)buffer;

	i = LittleLong (header->version);

	bspversion = i;

// swap all the lumps
	for (i=0 ; i<HEADER_BSP38LUMPS ; i++)
		((int *)header)[i] = LittleLong ( ((int *)header)[i]);

	Mod_LoadEntities (&header->lumps[LUMP_BSP38_ENTITIES]);//Pretty self-explanatory.
	Mod_LoadVertexes (&header->lumps[LUMP_BSP38_VERTEXES]);//load vec3_t's.. identical to Q1
	Mod_LoadEdges (&header->lumps[LUMP_BSP38_EDGES]);//load 2 shorts.. identical to Q1
	Mod_LoadSurfedges (&header->lumps[LUMP_BSP38_FACE_EDGES_TABLE]);//Not sure it's this 1..

//		Mod_LoadTextures (&header->lumps[LUMP_BSP38_TEXTURES]);//Q2 doesn't have textures inside the BSP
//		Mod_LoadLighting (&header->lumps[LUMP_BSP38_LIGHTING]);//Should be identical to Q1

	Mod_LoadPlanes (&header->lumps[LUMP_BSP38_PLANES]);//load mplane_t's.. identical to Q1
	Mod_LoadTexinfo_BSP38 (&header->lumps[LUMP_BSP38_TEXINFO]);
Sys_Error("..6.");
	Mod_LoadFaces (&header->lumps[LUMP_BSP38_FACES]);
Sys_Error("..7.");
//		Mod_LoadMarksurfaces (&header->lumps[LUMP_BSP38_LEAF_FACE_TABLE]);//Not sure it's this 1..
Sys_Error("..8.");
	Mod_LoadVisibility (&header->lumps[LUMP_BSP38_VISIBILITY]);//Should be identical to Q1
Sys_Error("..9.");
	Mod_LoadLeafs_BSP38 (&header->lumps[LUMP_BSP38_LEAFS]);
Sys_Error("..10.");
	Mod_LoadNodes_BSP38 (&header->lumps[LUMP_BSP38_NODES]);//Q2 uses ints instead of shorts for children pointers.
Sys_Error("..11.");
//		Mod_LoadClipnodes (&header->lumps[LUMP_BSP38_CLIPNODES]);
	Mod_LoadSubmodels (&header->lumps[LUMP_BSP38_MODELS]);
Sys_Error("..12.");
	//LUMP_BSP38_BRUSHES, LUMP_BSP38_BRUSH_SIDES, LUMP_BSP38_POP, LUMP_BSP38_AREAS, LUMP_BSP38_AREA_PORTALS

	Mod_MakeHull0 ();
	
	mod->numframes = 2;		// regular and alternate animation
	
#ifdef ENVLEVEL
	ENV_Load(mod, COM_LoadTempFile(va("env/%s.env", loadname)));//Load the env
#endif
	Mod_SetupSubmodels(mod);
}

#endif
