/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// protocol.h -- communications protocols

//q3q probably should change this...
#define	PROTOCOL_VERSION	15

// if the high bit of the servercmd is set, the low bits are fast update flags:
#define	U_MOREBITS		(1<<0)
#define	U_ORIGIN1		(1<<1)
#define	U_ORIGIN2		(1<<2)
#define	U_ORIGIN3		(1<<3)
#define	U_ANGLE2		(1<<4)
#define	U_NOLERP		(1<<5)		// don't interpolate movement
#define	U_FRAME			(1<<6)
#define U_SIGNAL		(1<<7)		// just differentiates from other updates

// svc_update can pass all of the fast update bits, plus more
#define	U_ANGLE1		(1<<8)
#define	U_ANGLE3		(1<<9)
#define	U_MODEL			(1<<10)
#define	U_COLORMAP		(1<<11)
#define	U_SKIN			(1<<12)
#define	U_EFFECTS		(1<<13)
#define	U_LONGENTITY	(1<<14)


//qbism//jf 01-10-30 a branching approach to minimize number of bytes sent
#define	U_EXTEND1		(1<<15)//extend to next byte

//jft future tests:  	A.  Always set baseline to previous frame, then EVERYTHING is delta.
//						B.  If entity remains constant for several frames, reset the baseline.
//#define	U_DELTA		(1<<16) //qbism//jf 01-10-30 DP no data, while this is set the entity is delta compressed
// (uses previous frame as a baseline, meaning only things that have changed from the previous
// frame are sent, except for the forced full update every half second)

#define U_EFFECTSTRAIL	(1<<16)
#define U_LEGSFRAME		(1<<17)
#define U_VWEPFRAME		(1<<18)
#define U_TORSOFRAME	(1<<19)
#define U_LEGSX			(1<<20)	//Xtended update info
#define U_TORSOX		(1<<21)
#define U_VWEPX			(1<<22)
#define U_EXTEND2		(1<<23)

#define U_ALPHA			(1<<24)
#define U_LEGSALPHA		(1<<25)
#define U_TORSOALPHA	(1<<26)
#define U_VWEPALPHA		(1<<27)
#define U_EFFECTSX		(1<<28) //qbism//jf 01-10-30 maybe
#define U_EFFECTSX2		(1<<29) //jft
//not used- 30,31


#define X_MODEL			(1<<0)
#define X_SKIN			(1<<1)
#define X_ANGLES1		(1<<2)
#define X_ANGLES2		(1<<3)
#define X_ANGLES3		(1<<4)
#define X_ORIGIN1		(1<<5)
#define X_ORIGIN2		(1<<6)
#define X_ORIGIN3		(1<<7)

//qbism//jf 01-10-30 DP effects- branched off as Xtensions.
#define	X_EFFECTS2	(1<<24) // 1 byte, this is .effects & 0xFF00 (second byte)
#define X_GLOWSIZE	(1<<25) // 1 byte, encoding is float/8.0, signed (negative is darklight), not sent if 0
#define	X_GLOWCOLOR	(1<<26) // 1 byte, palette index, default is 254 (white), this IS used for darklight (allowing colored darklight), however the particles from a darklight are always black, not sent if default value (even if glowsize or glowtrail is set)
#define X_COLORMOD	(1<<27) // 1 byte, 3 bit red, 3 bit green, 2 bit blue, this lets you tint an object artifically, so you could make a red rocket, or a blue fiend...
#define X_GLOWTRAIL	(1<<28) // leaves a trail of particles (of color .glowcolor, or black if it is a negative glowsize)
#define X_VIEWMODEL	(1<<29) // attachs the model to the view (origin and angles become relative to it), only shown to owner, a more powerful alternative to .weaponmodel and such
//qbism//jf 01-10-30 30, 31 unused


#define	SU_VIEWHEIGHT	(1<<0)
#define	SU_IDEALPITCH	(1<<1)
#define	SU_PUNCH1		(1<<2)
#define	SU_PUNCH2		(1<<3)
#define	SU_PUNCH3		(1<<4)
#define	SU_VELOCITY1	(1<<5)
#define	SU_VELOCITY2	(1<<6)
#define	SU_VELOCITY3	(1<<7)
//define	SU_AIMENT		(1<<8)  AVAILABLE BIT
#define	SU_ITEMS		(1<<9)
#define	SU_ONGROUND		(1<<10)		// no data follows, the bit is it
#define	SU_INWATER		(1<<11)		// no data follows, the bit is it
#define	SU_WEAPONFRAME	(1<<12)
#define	SU_ARMOR		(1<<13)
#define	SU_WEAPON		(1<<14)
//jft (1<<15) AVAILABLE BIT

// a sound with no channel is a local only sound
#define	SND_VOLUME		(1<<0)		// a byte
#define	SND_ATTENUATION	(1<<1)		// a byte
#define	SND_LOOPING		(1<<2)		// a long
//qbism//jf 01-10-30 Increase max cached sounds. Make some use of these wasted bits.
#define	SND_MORE1		(1<<3)		// flag
#define	SND_MORE2		(1<<4)
//qbism//jf 01-10-30 5,6,7 unused


// defaults for clientinfo messages
#define	DEFAULT_VIEWHEIGHT	22


// game types sent by serverinfo
// these determine which intermission screen plays
#define	GAME_COOP			0
#define	GAME_DEATHMATCH		1

//==================
// note that there are some defs.qc that mirror to these numbers
// also related to svc_strings[] in cl_parse
//==================

//
// server to client
//
#define	svc_bad				0
#define	svc_nop				1
#define	svc_disconnect		2
#define	svc_updatestat		3	// [byte] [long]
#define	svc_version			4	// [long] server version
#define	svc_setview			5	// [short] entity number
#define	svc_sound			6	// <see code>
#define	svc_time			7	// [float] server time
#define	svc_print			8	// [string] null terminated string
#define	svc_stufftext		9	// [string] stuffed into client's console buffer
								// the string should be \n terminated
#define	svc_setangle		10	// [angle3] set the view angle to this absolute value

#define	svc_serverinfo		11	// [long] version
						// [string] signon string
						// [string]..[0]model cache
						// [string]...[0]sounds cache
#define	svc_lightstyle		12	// [byte] [string]
#define	svc_updatename		13	// [byte] [string]
#define	svc_updatefrags		14	// [byte] [short]
#define	svc_clientdata		15	// <shortbits + data>
#define	svc_stopsound		16	// <see code>
#define	svc_updateskins		17
//#define	svc_updatebodies	21	//jgf not implemented
#define	svc_particle		18	// [vec3] <variable>
#define	svc_damage			19

#define	svc_spawnstatic		20
//	svc_spawnbinary		21
#define	svc_spawnbaseline	22

#define	svc_temp_entity		23

#define	svc_setpause		24	// [byte] on / off
#define	svc_signonnum		25	// [byte]  used for the signon sequence

#define	svc_centerprint		26	// [string] to put in center of the screen

#define	svc_killedmonster	27
#define	svc_foundsecret		28

#define	svc_spawnstaticsound	29	// [coord3] [byte] samp [byte] vol [byte] aten

#define	svc_intermission	30		// [string] music
#define	svc_finale			31		// [string] music [string] text

#define	svc_cdtrack			32		// [byte] track [byte] looptrack
#define svc_sellscreen		33

#define svc_cutscene		34
#define	svc_localsound		35	//jft <see code>

#define	svc_skybox			37		//jft Tomaz - Skybox


//
// client to server
//
#define	clc_bad			0
#define	clc_nop 		1
#define	clc_disconnect	2
#define	clc_move		3			// [usercmd_t]
#define	clc_stringcmd	4		// [string] message


//qbism// 2000-03-01 JPG - added ProQuake commands
#define pqc_nop			1
#define pqc_new_team	2
#define pqc_erase_team	3
#define pqc_team_frags	4
#define	pqc_match_time	5
#define pqc_match_reset	6
#define pqc_ping_times	7
//qbism// 2000-03-01 JPG - end mod


//
// temp entity events
//
#define	TE_SPIKE			0
#define	TE_SUPERSPIKE		1
#define	TE_GUNSHOT			2
#define	TE_EXPLOSION		3
#define	TE_TAREXPLOSION		4
#define	TE_LIGHTNING1		5
#define	TE_LIGHTNING2		6
#define	TE_WIZSPIKE			7
#define	TE_KNIGHTSPIKE		8
#define	TE_LIGHTNING3		9
#define	TE_LAVASPLASH		10
#define	TE_TELEPORT			11
#define TE_EXPLOSION2		12

// PGM 01/21/97
#define TE_BEAM				13
// PGM 01/21/97


#define TE_SNOW				14	//jft Tomaz - Snow
#define TE_RAIN				15	// Tomaz - Rain
#define	TE_PLASMA			16	// Tomaz - Plasma Gun
#define TE_RAILTRAIL		17	// Tomaz - RailGun
