/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

// draw.c -- this is the only file outside the refresh that touches the
// vid buffer

#include "quakedef.h"
//qbism//jf 01-10-30 jpeg
#include "jpeglib.h"

unsigned char col_white[4] = {
	255, 255, 255, 255 };

#define GL_COLOR_INDEX8_EXT     0x80E5

byte* loadimagepixels (char* filename, char* directory, qboolean complain, int matchwidth, int matchheight);

extern unsigned char d_15to8table[65536];


//qbism//jf 00-09-21 scrap gl_nobind
//cvar_t		gl_nobind = {
//	"gl_nobind", "0"};
cvar_t		gl_max_size = {
	"gl_max_size", "1024","Maximum height and width of textures sent to graphics card."};
cvar_t		gl_picmip = {
	"gl_picmip", "0","Scale shift of graphics to graphics card to save video memory. 1 = 1/2, 2 = 1/4, etc."};
//qbism//jf 2000-04-09 console alpha changed from 1.0 to 0.7 default value.
cvar_t		con_alpha = {
	"con_alpha", "0.7","Transparency of drop-down console.", false, false, false, 1, 0, 1};	// 2000-01-11 Transparent console by Radix


cvar_t		gl_lerpimages = {
	"gl_lerpimages", "1","Resample textures that must be resized."}; // qbism//00-10-15


byte		*draw_chars;				// FONTSIZE*FONTSIZE graphic characters


qpic_t		*draw_disc;
qpic_t		*draw_backtile;

int			translate_texture;
int			char_texture;
int			number_texture[11];			//qbism//00-10-15 muff


int            cs_texture;

static byte cs_data[64] = {
	0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
	0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff,
	0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};//qbism//00-06-28 shelob


extern cvar_t crosshair, cl_crossx, cl_crossy, crosshaircolor;//qbism//00-06-28 shelob

typedef struct
{
	int		texnum;
	float	sl, tl, sh, th;
}
glpic_t;

byte		conback_buffer[sizeof(qpic_t) + sizeof(glpic_t)];
qpic_t		*conback = (qpic_t *)&conback_buffer;

int		gl_lightmap_format = 4;
int		gl_solid_format = 3;
int		gl_alpha_format = 4;

int		gl_filter_min = GL_LINEAR_MIPMAP_NEAREST;
int		gl_filter_max = GL_LINEAR;


int		texels;

//qbism//00-10-15 32T and MD2 from DarkPlaces




typedef struct
{
	int		texnum;
	char	identifier[64];
	int		width, height;
	qboolean	mipmap;
	// LordHavoc: 32bit textures
	int		bytesperpixel;
	// LordHavoc: CRC to identify cache mismatchs
	int		lhcsum;
	int		lerped; // whether this texture was uploaded with or without interpolation

}
gltexture_t;

#define	MAX_GLTEXTURES	4096 //qbism//jf 00-10-15 DarkPlaces upped from 1024


extern byte			*targa_rgba; //qbism//00-10-15 tQER from muff source

gltexture_t	gltextures[MAX_GLTEXTURES];
int			numgltextures;

//qbism//jf scrap GL_Bind in lieu of glbindtexture ala DarkPlaces
/*
void GL_Bind (int texnum)
{
if (gl_nobind.value)
texnum = char_texture;
if (currenttexture == texnum)
return;
currenttexture = texnum;
#ifdef _WIN32
bindTexFunc (GL_TEXTURE_2D, texnum);
#else
glBindTexture(GL_TEXTURE_2D, texnum);
#endif
}
*/

/*
=============================================================================

scrap allocation

Allocate all the little status bar obejcts into a single texture
to crutch up stupid hardware / drivers

=============================================================================
*/

#define	MAX_SCRAPS		2
#define	BLOCK_WIDTH		256
#define	BLOCK_HEIGHT	256

int			scrap_allocated[MAX_SCRAPS][BLOCK_WIDTH];
byte		scrap_texels[MAX_SCRAPS][BLOCK_WIDTH*BLOCK_HEIGHT*4];
qboolean	scrap_dirty;
int			scrap_texnum;

// returns a texture number and the position inside it
int Scrap_AllocBlock (int w, int h, int *x, int *y)
{
	int		i, j;
	int		best, best2;
	int		bestx;
	int		texnum;

	for (texnum=0 ; texnum<MAX_SCRAPS ; texnum++)
	{
		best = BLOCK_HEIGHT;

		for (i=0 ; i<BLOCK_WIDTH-w ; i++)
		{
			best2 = 0;

			for (j=0 ; j<w ; j++)
			{
				if (scrap_allocated[texnum][i+j] >= best)
					break;
				if (scrap_allocated[texnum][i+j] > best2)
					best2 = scrap_allocated[texnum][i+j];
			}
			if (j == w)
			{	// this is a valid spot


				*x = i;
				*y = best = best2;
			}
		}

		if (best + h > BLOCK_HEIGHT)
			continue;

		for (i=0 ; i<w ; i++)
			scrap_allocated[texnum][*x + i] = best + h;

		return texnum;
	}

	Sys_Error ("Scrap_AllocBlock: full");
	return (0); //qbism//jf  2000-01-14 Dummy return to appease compiler warning.

}

int	scrap_uploads;

void Scrap_Upload (void)
{
	int		texnum;

	scrap_uploads++;

	for (texnum=0 ; texnum<MAX_SCRAPS ; texnum++) {
		glBindTexture(GL_TEXTURE_2D,scrap_texnum + texnum);
		GL_Upload8 (scrap_texels[texnum], BLOCK_WIDTH, BLOCK_HEIGHT, false, true);
	}
	scrap_dirty = false;
}

//=============================================================================
/* Support Routines */

typedef struct cachepic_s
{
	char		name[MAX_QPATH];
	qpic_t		pic;
	byte		padding[32];	// for appended glpic

}
cachepic_t;

#define	MAX_CACHED_PICS		128
cachepic_t	menu_cachepics[MAX_CACHED_PICS];
int			menu_numcachepics;

byte		menuplyr_pixels[4096];

int		pic_texels;
int		pic_count;

qpic_t *Draw_PicFromWad (char *name)
{
	qpic_t	*p;
	glpic_t	*gl;

	p = W_GetLumpName (name);
	gl = (glpic_t *)p->data;

	// load little ones into the scrap
	if (p->width < 64 && p->height < 64)
	{
		int		x, y;
		int		i, j, k;
		int		texnum;

		//qbism//00-10-15 LordHavoc: LINEAR interpolation
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR); //NEAREST);

		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR); //NEAREST);

		texnum = Scrap_AllocBlock (p->width, p->height, &x, &y);
		scrap_dirty = true;
		k = 0;
		for (i=0 ; i<p->height ; i++)
			for (j=0 ; j<p->width ; j++, k++)
				scrap_texels[texnum][(y+i)*BLOCK_WIDTH + x + j] = p->data[k];
		texnum += scrap_texnum;
		gl->texnum = texnum;
		gl->sl = (x+0.01)/(float)BLOCK_WIDTH;
		gl->sh = (x+p->width-0.01)/(float)BLOCK_WIDTH;
		gl->tl = (y+0.01)/(float)BLOCK_WIDTH;
		gl->th = (y+p->height-0.01)/(float)BLOCK_WIDTH;

		pic_count++;
		pic_texels += p->width*p->height;
	}
	else
	    {
		//qbism//00-10-15 LordHavoc: LINEAR interpolation
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR); //NEAREST);

		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR); //NEAREST);

		gl->texnum = GL_LoadPicTexture (p);
		gl->sl = 0;
		gl->sh = 1;
		gl->tl = 0;
		gl->th = 1;
	}
	return p;
}

//start of tQER - scaled fonts
/*
================
Draw_CacheTGAPic
================
*/
qpic_t	*Draw_CacheTGAPic (char *path, int x, int y)
{
	cachepic_t	*pic;
	int			i;
	qpic_t		*dat;
	glpic_t		*gl;
	FILE	*fd;

	for (pic=menu_cachepics, i=0 ; i<menu_numcachepics ; pic++, i++)
		if (!strcmp (path, pic->name))
			return &pic->pic;

	if (menu_numcachepics == MAX_CACHED_PICS)
		Sys_Error ("menu_numcachepics == MAX_CACHED_PICS");
	menu_numcachepics++;
	strcpy (pic->name, path);

	//
	// load the pic from disk
	//
	/*
	dat = (qpic_t *)COM_LoadTempFile (path);
	if (!dat)
	Sys_Error ("Draw_CachePic: failed to load %s", path);
	SwapPic (dat);

	// HACK HACK HACK --- we need to keep the bytes for
	// the translatable player picture just for the menu
	// configuration dialog
	if (!strcmp (path, "gfx/menuplyr.lmp"))
	memcpy (menuplyr_pixels, dat->data, dat->width*dat->height);
	*/
	pic->pic.width = x;
	pic->pic.height = y;

	gl = (glpic_t *)pic->pic.data;
	COM_FOpenFile ("sprites/console.tga", &fd);
	if (!fd)
	{
		Sys_Error ("Couldn't load %s\n", "sprites/console.tga");
		return NULL;
	}
	LoadTGA (fd);
	gl->texnum = texture_extension_number++;
	glBindTexture(GL_TEXTURE_2D,gl->texnum);
	glTexImage2D (GL_TEXTURE_2D, 0, gl_alpha_format, 128, 128, 0, GL_RGBA, GL_UNSIGNED_BYTE, targa_rgba);
	free (targa_rgba);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	//gl->texnum = GL_LoadPicTexture (dat);
	gl->sl = 0;
	gl->sh = 1;
	gl->tl = 0;
	gl->th = 1;

	return &pic->pic;
}
//end of tQER

/*
================
Draw_CachePic
================
*/
qpic_t	*Draw_CachePic (char *path)
{
	cachepic_t	*pic;
	int			i;
	qpic_t		*dat;
	glpic_t		*gl;

	for (pic=menu_cachepics, i=0 ; i<menu_numcachepics ; pic++, i++)
		if (!strcmp (path, pic->name))
			return &pic->pic;

	if (menu_numcachepics == MAX_CACHED_PICS)
		Sys_Error ("menu_numcachepics == MAX_CACHED_PICS");
	menu_numcachepics++;
	strcpy (pic->name, path);

	//
	// load the pic from disk
	//
	dat = (qpic_t *)COM_LoadTempFile (path);
	if (!dat)
		Sys_Error ("Draw_CachePic: failed to load %s", path);
	SwapPic (dat);

	// HACK HACK HACK --- we need to keep the bytes for
	// the translatable player picture just for the menu
	// configuration dialog
	if (!strcmp (path, "gfx/menuplyr.lmp"))
		memcpy (menuplyr_pixels, dat->data, dat->width*dat->height);

	pic->pic.width = dat->width;
	pic->pic.height = dat->height;

	gl = (glpic_t *)pic->pic.data;
	gl->texnum = GL_LoadPicTexture (dat);
	gl->sl = 0;
	gl->sh = 1;
	gl->tl = 0;
	gl->th = 1;

	return &pic->pic;
}


void Draw_CharToConback (int num, byte *dest)
{
	int		row, col;
	byte	*source;
	int		drawline;
	int		x;

	row = num>>4;
	col = num&15;
	source = draw_chars + (row<<10) + (col<<3);

	drawline = 8;

	while (drawline--)
	{
		for (x=0 ; x<8 ; x++)
			if (source[x] != 255)
				dest[x] = 0x60 + source[x];
		source += 128;
		dest += 320;
	}

}

typedef struct
{
	char *name;
	int	minimize, maximize;
}
glmode_t;

glmode_t modes[] = {
	{
		"GL_NEAREST", GL_NEAREST, GL_NEAREST				}
	,
	{
		"GL_LINEAR", GL_LINEAR, GL_LINEAR				}
	,
	{
		"GL_NEAREST_MIPMAP_NEAREST", GL_NEAREST_MIPMAP_NEAREST, GL_NEAREST				}
	,
	{
		"GL_LINEAR_MIPMAP_NEAREST", GL_LINEAR_MIPMAP_NEAREST, GL_LINEAR				}
	,
	{
		"GL_NEAREST_MIPMAP_LINEAR", GL_NEAREST_MIPMAP_LINEAR, GL_NEAREST				}
	,
	{
		"GL_LINEAR_MIPMAP_LINEAR", GL_LINEAR_MIPMAP_LINEAR, GL_LINEAR				}
};

/*
===============
Draw_TextureMode_f
===============
*/
void Draw_TextureMode_f (void)
{
	int		i;
	gltexture_t	*glt;

	if (Cmd_Argc() == 1)
	{
		for (i=0 ; i< 6 ; i++)
			if (gl_filter_min == modes[i].minimize)
			{
				Con_Printf ("%s\n", modes[i].name);
				return;
			}
		Con_Printf ("current filter is unknown???\n");
		return;
	}

	for (i=0 ; i< 6 ; i++)
	{
		if (!Q_strcasecmp (modes[i].name, Cmd_Argv(1) ) )
			break;
	}
	if (i == 6)
	{
		Con_Printf ("bad filter name\n");
		return;
	}

	gl_filter_min = modes[i].minimize;
	gl_filter_max = modes[i].maximize;

	// change all the existing mipmap texture objects
	for (i=0, glt=gltextures ;
	i<numgltextures ;
	i++, glt++)
	    {
		if (glt->mipmap)
		{
			glBindTexture(GL_TEXTURE_2D,glt->texnum);
			glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, gl_filter_min);
			glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, gl_filter_max);
		}
	}
}

/*
===============
Draw_Init
===============
*/
void Draw_Init (void)
{
	int		i;
	qpic_t	*cb;
	byte	*dest, *src;
	int		x, y;
	char	ver[40];
	glpic_t	*gl;
	int		start;
	byte	*ncdata;
	int		f, fstep;
	//jfmuff
	FILE	*fd; //tQER

	char	*ia; // muff

	//qbism//jf 00-09-21 scrap gl_nobind
	//Cvar_RegisterVariable (&gl_nobind);
	Cvar_RegisterVariable (&gl_max_size);
	Cvar_RegisterVariable (&gl_picmip);
	Cvar_RegisterVariable (&con_alpha);	//qbism// 2000-01-11 Transparent console by Radix

	Cvar_RegisterVariable (&gl_lerpimages); //qbism//00-10-15

	// 3dfx can only handle 256 wide textures
	if (!Q_strncasecmp ((char *)gl_renderer, "3dfx",4) ||
		    strstr((char *)gl_renderer, "Glide"))
		Cvar_Set ("gl_max_size", "256");

	Cmd_AddCommand ("gl_texturemode", &Draw_TextureMode_f);

	// load the console background and the charset
	// by hand, because we need to write the version
	// string into the background before turning
	// it into a texture
	draw_chars = W_GetLumpName ("conchars");
	for (i=0 ; i<256*64 ; i++)
		if (draw_chars[i] == 0)
			draw_chars[i] = 255;	// proper transparent color

	// start tQER fonts
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

	// now turn them into textures
	gl = (glpic_t *)conback->data;
	COM_FOpenFile ("sprites/conchars.tga", &fd);
	if (!fd)
	{
		Sys_Error ("Couldn't load %s\n", "sprites/conchars.tga");
		return;
	}
	LoadTGA (fd);
	char_texture = texture_extension_number++;
	glBindTexture(GL_TEXTURE_2D, char_texture); //qbism//jf 00-10-15 lose GL_Bind

	//GL_Bind (char_texture);
	glTexImage2D (GL_TEXTURE_2D, 0, gl_alpha_format, 256, 256, 0, GL_RGBA, GL_UNSIGNED_BYTE, targa_rgba);
	free (targa_rgba);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	//end of tQER - fonts

	//muff - 12th may 2000 - load status bar number tga's
	// there is likely to be an easier way to load all these, but this is understandable at least

	//qbism//jf 00-10-15 one two many sets of this?
	//glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	//glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

	// zero
	COM_FOpenFile ("sprites/numbers/zero.tga", &fd);
	if (!fd)
	{
		Sys_Error ("Couldn't load %s\n", "sprites/numbers/zero.tga");
		return;
	}

	LoadTGA (fd);
	number_texture[0] = texture_extension_number++;
	glBindTexture(GL_TEXTURE_2D,number_texture[0]);
	glTexImage2D (GL_TEXTURE_2D, 0,  gl_alpha_format, 32, 32, 0, GL_RGBA, GL_UNSIGNED_BYTE, targa_rgba);
	free (targa_rgba);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	// zero END

	// one
	COM_FOpenFile ("sprites/numbers/one.tga", &fd);
	if (!fd)
	{
		Sys_Error ("Couldn't load %s\n", "sprites/numbers/one.tga");
		return;
	}

	LoadTGA (fd);
	number_texture[1] = texture_extension_number++;
	glBindTexture(GL_TEXTURE_2D,number_texture[1]);
	glTexImage2D (GL_TEXTURE_2D, 0, gl_alpha_format, 32, 32, 0, GL_RGBA, GL_UNSIGNED_BYTE, targa_rgba); //GL_RGBA

	free (targa_rgba);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	// one END

	// two
	COM_FOpenFile ("sprites/numbers/two.tga", &fd);
	if (!fd)
	{
		Sys_Error ("Couldn't load %s\n", "sprites/numbers/two.tga");
		return;
	}

	LoadTGA (fd);
	number_texture[2] = texture_extension_number++;
	glBindTexture(GL_TEXTURE_2D,number_texture[2]);
	glTexImage2D (GL_TEXTURE_2D, 0, gl_alpha_format, 32, 32, 0, GL_RGBA, GL_UNSIGNED_BYTE, targa_rgba);
	free (targa_rgba);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	// two END

	// three
	COM_FOpenFile ("sprites/numbers/three.tga", &fd);
	if (!fd)
	{
		Sys_Error ("Couldn't load %s\n", "sprites/numbers/three.tga");
		return;
	}

	LoadTGA (fd);
	number_texture[3] = texture_extension_number++;
	glBindTexture(GL_TEXTURE_2D,number_texture[3]);
	glTexImage2D (GL_TEXTURE_2D, 0, gl_alpha_format, 32, 32, 0, GL_RGBA, GL_UNSIGNED_BYTE, targa_rgba);
	free (targa_rgba);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	// three END

	// four
	COM_FOpenFile ("sprites/numbers/four.tga", &fd);
	if (!fd)
	{
		Sys_Error ("Couldn't load %s\n", "sprites/numbers/four.tga");
		return;
	}

	LoadTGA (fd);
	number_texture[4] = texture_extension_number++;
	glBindTexture(GL_TEXTURE_2D,number_texture[4]);
	glTexImage2D (GL_TEXTURE_2D, 0, gl_alpha_format, 32, 32, 0, GL_RGBA, GL_UNSIGNED_BYTE, targa_rgba);
	free (targa_rgba);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	// four END

	// five
	COM_FOpenFile ("sprites/numbers/five.tga", &fd);
	if (!fd)
	{
		Sys_Error ("Couldn't load %s\n", "sprites/numbers/five.tga");
		return;
	}

	LoadTGA (fd);
	number_texture[5] = texture_extension_number++;
	glBindTexture(GL_TEXTURE_2D,number_texture[5]);
	glTexImage2D (GL_TEXTURE_2D, 0, gl_alpha_format, 32, 32, 0, GL_RGBA, GL_UNSIGNED_BYTE, targa_rgba);
	free (targa_rgba);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	//five END

	// six
	COM_FOpenFile ("sprites/numbers/six.tga", &fd);
	if (!fd)
	{
		Sys_Error ("Couldn't load %s\n", "sprites/numbers/six.tga");
		return;
	}

	LoadTGA (fd);
	number_texture[6] = texture_extension_number++;
	glBindTexture(GL_TEXTURE_2D,number_texture[6]);
	glTexImage2D (GL_TEXTURE_2D, 0, gl_alpha_format, 32, 32, 0, GL_RGBA, GL_UNSIGNED_BYTE, targa_rgba);
	free (targa_rgba);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	//six END


	// seven
	COM_FOpenFile ("sprites/numbers/seven.tga", &fd);
	if (!fd)
	{
		Sys_Error ("Couldn't load %s\n", "sprites/numbers/seven.tga");
		return;
	}

	LoadTGA (fd);
	number_texture[7] = texture_extension_number++;
	glBindTexture(GL_TEXTURE_2D,number_texture[7]);
	glTexImage2D (GL_TEXTURE_2D, 0, gl_alpha_format, 32, 32, 0, GL_RGBA, GL_UNSIGNED_BYTE, targa_rgba);
	free (targa_rgba);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	// seven END

	// eight
	COM_FOpenFile ("sprites/numbers/eight.tga", &fd);
	if (!fd)
	{
		Sys_Error ("Couldn't load %s\n", "sprites/numbers/eight.tga");
		return;
	}

	LoadTGA (fd);
	number_texture[8] = texture_extension_number++;
	glBindTexture(GL_TEXTURE_2D,number_texture[8]);
	glTexImage2D (GL_TEXTURE_2D, 0, gl_alpha_format, 32, 32, 0, GL_RGBA, GL_UNSIGNED_BYTE, targa_rgba);
	free (targa_rgba);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	// eight END

	// nine
	COM_FOpenFile ("sprites/numbers/nine.tga", &fd);
	if (!fd)
	{
		Sys_Error ("Couldn't load %s\n", "sprites/numbers/nine.tga");
		return;
	}

	LoadTGA (fd);
	number_texture[9] = texture_extension_number++;
	glBindTexture(GL_TEXTURE_2D,number_texture[9]);
	glTexImage2D (GL_TEXTURE_2D, 0, gl_alpha_format, 32, 32, 0, GL_RGBA, GL_UNSIGNED_BYTE, targa_rgba);
	free (targa_rgba);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	// nine END

	//loading the minus smooths the previous image better - don't ask me why...not a clue
	// minus
	COM_FOpenFile ("sprites/numbers/minus.tga", &fd);
	if (!fd)
	{
		Sys_Error ("Couldn't load %s\n", "sprites/numbers/minus.tga");
		return;
	}

	LoadTGA (fd);
	number_texture[10] = texture_extension_number++;
	glBindTexture(GL_TEXTURE_2D,number_texture[10]);
	glTexImage2D (GL_TEXTURE_2D, 0, gl_alpha_format, 32, 32, 0, GL_RGBA, GL_UNSIGNED_BYTE, targa_rgba);
	free (targa_rgba);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	// minus END

	/*	// LordHavoc: LINEAR texturing on text
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR); //NEAREST);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR); //NEAREST);

	// now turn them into textures
	char_texture = GL_LoadTexture ("charset", 128, 128, draw_chars, false, true,1);
	*/
	//qbism//00-06-28 shelob
	cs_texture = GL_LoadTexture ("crosshair", 8, 8, cs_data, false, true,1);

	start = Hunk_LowMark();

	cb = (qpic_t *)COM_LoadTempFile ("gfx/conback.lmp");
	if (!cb)
		Sys_Error ("Couldn't load gfx/conback.lmp");
	SwapPic (cb);

	// hack the version number directly into the pic
#if defined(__linux__)
	sprintf (ver, "(Linux %2.2f, gl %4.2f) %4.2f", (float)LINUX_VERSION, (float)GLQUAKE_VERSION, (float)VERSION);
#else
	//	sprintf (ver, "(gl %4.2f) %4.2f", (float)GLQUAKE_VERSION, (float)VERSION);
	sprintf(ver, "qbism 01 10-30"); //qbism//jf 2000-03-01


#endif
	//qbism//00-10-15 LordHavoc: changed to LINEAR filtering from NEAREST, looks better
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR); //NEAREST);

	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR); //NEAREST);

	dest = cb->data + 320*186 + 320 - 11 - 8*strlen(ver);
	y = strlen(ver);
	for (x=0 ; x<y ; x++)
		Draw_CharToConback (ver[x], dest+(x<<3));

#if 0
	conback->width = vid.conwidth;
	conback->height = vid.conheight;

	// scale console to vid size
	dest = ncdata = Hunk_AllocName(vid.conwidth * vid.conheight, "conback");

	for (y=0 ; y<vid.conheight ; y++, dest += vid.conwidth)
	{
		src = cb->data + cb->width * (y*cb->height/vid.conheight);
		if (vid.conwidth == cb->width)
			memcpy (dest, src, vid.conwidth);
		else
		    {
			f = 0;
			fstep = cb->width*0x10000/vid.conwidth;
			for (x=0 ; x<vid.conwidth ; x+=4)
			{
				dest[x] = src[f>>16];
				f += fstep;
				dest[x+1] = src[f>>16];
				f += fstep;
				dest[x+2] = src[f>>16];
				f += fstep;
				dest[x+3] = src[f>>16];
				f += fstep;
			}
		}
	}
#else
	conback->width = cb->width;
	conback->height = cb->height;
	ncdata = cb->data;
#endif

	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);

	gl = (glpic_t *)conback->data;
	gl->texnum = GL_LoadTexture ("conback", conback->width, conback->height, ncdata, false, false,1);
	gl->sl = 0;
	gl->sh = 1;
	gl->tl = 0;
	gl->th = 1;
	conback->width = vid.width;
	conback->height = vid.height;

	// free loaded console
	Hunk_FreeToLowMark(start);

	// save a texture slot for translated picture
	translate_texture = texture_extension_number++;

	// save slots for scraps
	scrap_texnum = texture_extension_number;
	texture_extension_number += MAX_SCRAPS;

	//
	// get the other pics we need
	//
	draw_disc = Draw_PicFromWad ("disc");
	draw_backtile = Draw_PicFromWad ("backtile");
}

//qbism//00-10-15 muff
void Draw_Number (int x, int y, int num, int col_flag)
{
	byte			*dest;
	byte			*source;
	unsigned short	*pusdest;
	int				drawline;
	int				row, col;
	int				width,height;
	float			texture_width,texture_height;
	float			frow, fcol, size;
	float			r,g,b,a;
	//
	float		rotate,rotate2;

	if ((num>9) || (num <0))
		return;		// space

	//now we calculate the scaled x position
	x = x*(vid.width*(0.6/320.0)) + (vid.width*0.05);//qbism//jf 00-10-15 scale+offset

	y = y*(vid.height * (1/200.0)) ;//qbism//jf 00-10-15 scale before calling func

	width  = 12*(vid.width/320); //qbism//00-10-15 muff- was 20*

	height = 12*(vid.height/200);

	texture_width  = 1;
	texture_height = 1;

	frow = 0;
	fcol = 0;

	//this is probably overkill - but it works

	if(col_flag==1)
	{
		//red
		r = 1.0;
		g = 0.0;
		b = 0.0;
		a = 1.0;
	}
	else if(col_flag==2)
	{
		//white
		r = 1.0;
		g = 1.0;
		b = 1.0;
		a = 0.4;
	}
	else
	    {
		//yellow
		r = 1.0;
		g = 0.8;
		b = 0.0;
		a = 0.6;
	}

	//	rotate = sin(cl.time-45);
	//	rotate2 = sin(cl.time+45);

	glDisable(GL_ALPHA_TEST);
	glEnable (GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	glDepthMask (0);
	glColor4f(r,g,b,a);

	glBindTexture(GL_TEXTURE_2D,number_texture[num]);
	/*
	glBegin (GL_QUADS);
	glTexCoord2f (fcol, frow);
	glVertex2f (x - (rotate2 * (width/2) ), y);
	glTexCoord2f (fcol + texture_width, frow);
	glVertex2f (x + (rotate * (width/2)), y);
	glTexCoord2f (fcol + texture_width, frow + texture_height);
	glVertex2f (x + (rotate * (width/2)), y + height);
	glTexCoord2f (fcol, frow + texture_height);
	glVertex2f (x - (rotate2 * (width/2)), y + height);
	glEnd ();
	*/
	glBegin (GL_QUADS);
	glTexCoord2f (fcol, frow);
	glVertex2f (x, y);
	glTexCoord2f (fcol + texture_width, frow);
	glVertex2f (x + width, y);
	glTexCoord2f (fcol + texture_width, frow + texture_height);
	glVertex2f (x + width, y + height);
	glTexCoord2f (fcol, frow + texture_height);
	glVertex2f (x, y + height);
	glEnd ();

	glColor4f (1,1,1,1);
	glEnable(GL_ALPHA_TEST);
	glDisable (GL_BLEND);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
	glDepthMask (1);

}



/* qbism//00-10-15 Draw_Character and Draw_String from DP
================
Draw_Character

Draws one FONTSIZE graphics character with 0 being transparent.
It can be clipped to the top of the screen to allow the console to be
smoothly scrolled off.
================
*/

void Draw_Character (int x, int y, int num)
{
	float			frow, fcol;

	if (num == 32 || num == 160)
		return;		// space

	num &= 255;

	if (y <= -FONTSIZE)
		return;			// totally off screen


	glBindTexture(GL_TEXTURE_2D, char_texture);
	// LordHavoc: NEAREST mode on text if not scaling up
	if (glwidth <= (int) vid.width)
	{
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	}
	else
	{
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	}


	glColor3f(1,1,1);
	glEnable (GL_BLEND);
	glBegin (GL_QUADS);
	frow = (float) ((int) num >> 4)*0.0625;
	fcol = (float) ((int) num & 15)*0.0625;
	glTexCoord2f (fcol, frow);
	glVertex2f (x, y);
	glTexCoord2f (fcol + 0.0625, frow);
	glVertex2f (x+FONTSIZE, y);
	glTexCoord2f (fcol + 0.0625, frow + 0.0625);
	glVertex2f (x+FONTSIZE, y+FONTSIZE);
	glTexCoord2f (fcol, frow + 0.0625);
	glVertex2f (x, y+FONTSIZE);
	glEnd ();
}


/*
================
Draw_String
================
*/
// LordHavoc: sped this up a lot, and added maxlen
void Draw_String (int x, int y, char *str, int maxlen)
{

	int num;
	float frow, fcol;
	if (y <= -FONTSIZE || y >= (int) vid.height || x >= (int) vid.width || *str == 0) // completely offscreen or no text to print

		return;
	if (maxlen < 1)
		maxlen = strlen(str);
	else if (maxlen > (int) strlen(str))
		maxlen = strlen(str);
	glBindTexture(GL_TEXTURE_2D, char_texture);

	// LordHavoc: NEAREST mode on text if not scaling up
	if (glwidth <= (int) vid.width)
	{
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
	}
	else
	{
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	}

	glColor3f(1,1,1);
	glBegin (GL_QUADS);
	while (maxlen-- && x < (int) vid.width) // stop rendering when out of characters or room

	{
		if ((num = *str++) != 32 && num != 160) // skip spaces

		{
			frow = (float) ((int) num >> 4)*0.0625;
			fcol = (float) ((int) num & 15)*0.0625;
			glTexCoord2f (fcol, frow);
			glVertex2f (x, y);
			glTexCoord2f (fcol + 0.0625, frow);
			glVertex2f (x+FONTSIZE, y);
			glTexCoord2f (fcol + 0.0625, frow + 0.0625);
			glVertex2f (x+FONTSIZE, y+FONTSIZE);
			glTexCoord2f (fcol, frow + 0.0625);
			glVertex2f (x, y+FONTSIZE);
		}
		x += FONTSIZE;
	}
	glEnd ();
}


/*
================
Draw_DebugChar

Draws a single character directly to the upper right corner of the screen.
This is for debugging lockups by drawing different chars in different parts
of the code.
================
*/
void Draw_DebugChar (char num)
{
}


//qbism//00-06-28 shelob
void Draw_Crosshair(void)
{
	int x, y;
	extern vrect_t        scr_vrect;
	unsigned char *pColor;

	if (crosshair.value == 2) {
		x = scr_vrect.x + scr_vrect.width/2 + 1  + cl_crossx.value;
		y = scr_vrect.y + scr_vrect.height/2  + cl_crossy.value;

		glTexEnvf ( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE );
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glDepthMask (0);
		pColor = (unsigned char *) &d_8to24table[(byte) crosshaircolor.value];
		glColor4ubv ( pColor );
		glBindTexture(GL_TEXTURE_2D,cs_texture);

		glBegin (GL_QUADS);
		glTexCoord2f (0, 0);
		glVertex2f (x - 4, y - 4);
		glTexCoord2f (1, 0);
		glVertex2f (x+12, y-4);
		glTexCoord2f (1, 1);
		glVertex2f (x+12, y+12);
		glTexCoord2f (0, 1);
		glVertex2f (x - 4, y+12);
		glEnd ();

		glTexEnvf ( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE );
		glDepthMask (1);
	}
	else if (crosshair.value)
		//Draw_Character (scr_vrect.x + scr_vrect.width/2-4 + cl_crossx.value, scr_vrect.y + scr_vrect.height/2-4 + cl_crossy.value, '+');
		Draw_Character (scr_vrect.x + scr_vrect.width/2 + cl_crossx.value, scr_vrect.y + scr_vrect.height/2 + cl_crossy.value, '+');
}


/*
=============
Draw_AlphaPic
=============
*/
void Draw_AlphaPic (int x, int y, qpic_t *pic, float alpha)
{
	byte			*dest, *source;
	unsigned short	*pusdest;
	int				v, u;
	glpic_t			*gl;

	if (scrap_dirty)
		Scrap_Upload ();
	gl = (glpic_t *)pic->data;
	glDisable(GL_ALPHA_TEST);
	glEnable (GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	//	glCullFace(GL_FRONT);
	glColor4f (1,1,1,alpha);
	glBindTexture(GL_TEXTURE_2D,gl->texnum);
	glBegin (GL_QUADS);
	glTexCoord2f (gl->sl, gl->tl);
	glVertex2f (x, y);
	glTexCoord2f (gl->sh, gl->tl);
	glVertex2f (x+pic->width, y);
	glTexCoord2f (gl->sh, gl->th);
	glVertex2f (x+pic->width, y+pic->height);
	glTexCoord2f (gl->sl, gl->th);
	glVertex2f (x, y+pic->height);
	glEnd ();
	glColor4f (1,1,1,1);
	glEnable(GL_ALPHA_TEST);
	glDisable (GL_BLEND);
}


/*
=============
Draw_Pic
=============
*/
void Draw_Pic (int x, int y, qpic_t *pic)
{
	byte			*dest, *source;
	unsigned short	*pusdest;
	int				v, u;
	glpic_t			*gl;

	if (scrap_dirty)
		Scrap_Upload ();
	gl = (glpic_t *)pic->data;
	glColor4f (1,1,1,1);
	glBindTexture(GL_TEXTURE_2D,gl->texnum);
	glBegin (GL_QUADS);
	glTexCoord2f (gl->sl, gl->tl);
	glVertex2f (x, y);
	glTexCoord2f (gl->sh, gl->tl);
	glVertex2f (x+pic->width, y);
	glTexCoord2f (gl->sh, gl->th);
	glVertex2f (x+pic->width, y+pic->height);
	glTexCoord2f (gl->sl, gl->th);
	glVertex2f (x, y+pic->height);
	glEnd ();
}


/*
//qbism//00-04-28 muff's Draw_Pic2
=============
Draw_Pic2 - muff for scaling status bar
added 20 april 2000
=============
*/
void Draw_Pic2 (int x, int y, qpic_t *pic)
{
	byte            *dest, *source;
	unsigned short    *pusdest;
	int                v, u;
	glpic_t            *gl;
	int pw,ph;


	if (x < 0 || (unsigned)(x + pic->width) > vid.width || y < 0 ||
		    (unsigned)(y + pic->height) > vid.height)
	{
		Sys_Error ("Draw_Pic2: bad coordinates"); //qbism//jf 2000-04-29 Draw_Pic2, not Trans_Pic

	}


	if (scrap_dirty)
		Scrap_Upload ();
	gl = (glpic_t *)pic->data;


	// first we calculate the scaling factor of the picture
	pw = (pic->width)  * (vid.width * (0.6/320.0)) ;//qbism//jf 00-05-01 *0.6

	ph = (pic->height) * (vid.height* (0.6/200.0)) ;//qbism//jf 00-05-01 *0.6

	//now we calculate the scaled x position
	x = x*(vid.width*(0.6/320.0)) + (vid.width*0.05);//qbism//jf 00-05-01 scale+offset

	y = y*(vid.height * (1/200.0)) ;//qbism//jf 00-05-21 *1 (no scaling).  scale before calling func

	glColor3f (1,1,1);
	glBindTexture(GL_TEXTURE_2D,gl->texnum);
	glBegin (GL_QUADS);
	glTexCoord2f (gl->sl, gl->tl);
	glVertex2f (x, y);
	glTexCoord2f (gl->sh, gl->tl);
	glVertex2f (x+pw, y);
	glTexCoord2f (gl->sh, gl->th);
	glVertex2f (x+pw, y+ph );
	glTexCoord2f (gl->sl, gl->th);
	glVertex2f (x, y+ph);
	glEnd ();
}

/*
//qbism//00-05-23 Draw_AlphaPic2 based on muff's Draw_Pic2
=============
Draw_AlphaPic2 - qbism for scaling status bar
=============
*/
void Draw_AlphaPic2 (int x, int y, qpic_t *pic, float alpha)
{
	byte            *dest, *source;
	unsigned short    *pusdest;
	int                v, u;
	glpic_t            *gl;
	int pw,ph;

	if (x < 0 || (unsigned)(x + pic->width) > vid.width || y < 0 ||
		    (unsigned)(y + pic->height) > vid.height)
	{
		Sys_Error ("Draw_AlphaPic2: bad coordinates"); //qbism//jf 2000-04-29 Draw_Pic2, not Trans_Pic

	}


	if (scrap_dirty)
		Scrap_Upload ();
	gl = (glpic_t *)pic->data;
	//	glDisable(GL_ALPHA_TEST);
	//	glEnable (GL_BLEND);
	//	glColor4f (0.9,0.9,0.9,alpha);



	// first we calculate the scaling factor of the picture
	pw = (pic->width)  * (vid.width * (0.6/320.0)) ;//qbism//jf 00-05-01 *0.6

	ph = (pic->height) * (vid.height* (0.6/200.0)) ;//qbism//jf 00-05-01 *0.6

	//now we calculate the scaled x position
	x = x*(vid.width*(0.6/320.0)) + (vid.width*0.05);//qbism//jf 00-05-01 scale+offset

	y = y*(vid.height * (1/200.0)) ;//qbism//jf 00-05-21 *1 (no scaling).  scale before calling func

	glDisable(GL_ALPHA_TEST);
	glEnable (GL_BLEND);
	glColor4f (1,1,1,alpha);
	//  	glBindTexture(GL_TEXTURE_2D, gl->texnum); //jpd
	glBindTexture(GL_TEXTURE_2D,gl->texnum);
	glBegin (GL_QUADS);
	glTexCoord2f (gl->sl, gl->tl);
	glVertex2f (x, y);
	glTexCoord2f (gl->sh, gl->tl);
	glVertex2f (x+pw, y);
	glTexCoord2f (gl->sh, gl->th);
	glVertex2f (x+pw, y+ph );
	glTexCoord2f (gl->sl, gl->th);
	glVertex2f (x, y+ph);
	glEnd ();
	glColor3f (1,1,1);
	glEnable(GL_ALPHA_TEST);
	glDisable (GL_BLEND);

}


/*
=============
Draw_TransPic
=============
*/
void Draw_TransPic (int x, int y, qpic_t *pic)
{
	byte	*dest, *source, tbyte;
	unsigned short	*pusdest;
	int				v, u;

	if (x < 0 || (unsigned)(x + pic->width) > vid.width || y < 0 ||
		    (unsigned)(y + pic->height) > vid.height)
	{
		Sys_Error ("Draw_TransPic: bad coordinates");
	}

	Draw_Pic (x, y, pic);
}


/*
=============
Draw_TransPicTranslate

Only used for the player color selection menu
=============
*/
void Draw_TransPicTranslate (int x, int y, qpic_t *pic, byte *translation)
{
	int				v, u; //qbism//jf 00-10-15 not used , c;

	unsigned		trans[64*64], *dest;
	byte			*src;
	int				p;

	glBindTexture(GL_TEXTURE_2D,translate_texture);

	//qbism//jf 00-10-15 not used   c = pic->width * pic->height;

	dest = trans;
	for (v=0 ; v<64 ; v++, dest += 64)
	{
		src = &menuplyr_pixels[ ((v*pic->height)>>6) *pic->width];
		for (u=0 ; u<64 ; u++)
		{
			p = src[(u*pic->width)>>6];
			if (p == 255)
				dest[u] = p;
			else
				dest[u] =  d_8to24table[translation[p]];
		}
	}

	glTexImage2D (GL_TEXTURE_2D, 0, gl_alpha_format, 64, 64, 0, GL_RGBA, GL_UNSIGNED_BYTE, trans);

	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

	glColor3f (1,1,1);
	glBegin (GL_QUADS);
	glTexCoord2f (0, 0);
	glVertex2f (x, y);
	glTexCoord2f (1, 0);
	glVertex2f (x+pic->width, y);
	glTexCoord2f (1, 1);
	glVertex2f (x+pic->width, y+pic->height);
	glTexCoord2f (0, 1);
	glVertex2f (x, y+pic->height);
	glEnd ();
}


/*
================
Draw_ConsoleBackground

================
*/
void Draw_ConsoleBackground (int lines)
{
	//qbism// 2000-01-12 Variable console height by Fett/Maddes  start
	//	int y = (vid.height * 3) >> 2;
	int y;

	//	if (lines > y)
	if (con_forcedup)
		//qbism// 2000-01-12 Variable console height by Fett/Maddes  end
		Draw_Pic(0, lines - vid.height, conback);
	else
	    //qbism// 2000-01-11 Transparent console by Radix  start
	{
		//		Draw_AlphaPic (0, lines - vid.height, conback, (float)(1.2 * lines)/y);
		// 2000-01-12 Variable console height by Fett/Maddes  start
		//		Draw_AlphaPic (0, lines - vid.height, conback, (float)(2 * con_alpha.value * lines)/y);
		if (scr_conlines > 0)	// moving down

		{
			y = scr_conlines;
		}
		else			// moving up
		{
			y = vid.height*scr_conheight.value;	// in-game console

			if (y < 32)
			{
				y = 32;		// always leave two lines visible

			}
			if (y >= vid.height)
			{
				y = vid.height - 1;	// maximum is full screen

			}
		}

		Draw_AlphaPic (0, lines - vid.height, conback, (float)(con_alpha.value*lines)/y);
		//qbism// 2000-01-12 Variable console height by Fett/Maddes  end
	}
	//qbism// 2000-01-11 Transparent console by Radix  end
}


/*
=============
Draw_TileClear

This repeats a 64*64 tile graphic to fill the screen around a sized down
refresh window.
=============
*/
void Draw_TileClear (int x, int y, int w, int h)
{
	glColor3f (1,1,1);
	glBindTexture(GL_TEXTURE_2D,*(int *)draw_backtile->data);
	glBegin (GL_QUADS);
	glTexCoord2f (x/64.0, y/64.0);
	glVertex2f (x, y);
	glTexCoord2f ( (x+w)/64.0, y/64.0);
	glVertex2f (x+w, y);
	glTexCoord2f ( (x+w)/64.0, (y+h)/64.0);
	glVertex2f (x+w, y+h);
	glTexCoord2f ( x/64.0, (y+h)/64.0 );
	glVertex2f (x, y+h);
	glEnd ();
}


/*
=============
Draw_Fill

Fills a box of pixels with a single color
=============
*/
void Draw_Fill (int x, int y, int w, int h, int c)
{
	glDisable (GL_TEXTURE_2D);
	glColor3f (host_basepal[c*3]/255.0,
		host_basepal[c*3+1]/255.0,
		host_basepal[c*3+2]/255.0);

	glBegin (GL_QUADS);

	glVertex2f (x,y);
	glVertex2f (x+w, y);
	glVertex2f (x+w, y+h);
	glVertex2f (x, y+h);

	glEnd ();
	glColor3f (1,1,1);
	glEnable (GL_TEXTURE_2D);
}
//=============================================================================

/*
================
//qbism//jf 00-09-21 ditch Draw_FadeScreen

================

void Draw_FadeScreen (void)
{
glEnable (GL_BLEND);
glDisable (GL_TEXTURE_2D);
glColor4f (0.0, 0.0, 0.0, 0.8);
glBegin (GL_QUADS);

glVertex2f (0,0);
glVertex2f (vid.width, 0);
glVertex2f (vid.width, vid.height);
glVertex2f (0, vid.height);

glEnd ();
glColor4f (1,1,1,1);
glEnable (GL_TEXTURE_2D);
glDisable (GL_BLEND);

Sbar_Changed();
}
*/
//=============================================================================

/*
================
Draw_BeginDisc

Draws the little blue disc in the corner of the screen.
Call before beginning any disc IO.
================
*/
void Draw_BeginDisc (void)
{
	if (!draw_disc)
		return;
	glDrawBuffer  (GL_FRONT);
	Draw_Pic (vid.width - 24, 0, draw_disc);
	glDrawBuffer  (GL_BACK);
}


/*
================
Draw_EndDisc

Erases the disc icon.
Call after completing any disc IO
================
*/
void Draw_EndDisc (void)
{
}

/* qbism//00-10-15 GL_Set2D from DP
================
GL_Set2D

Setup as if the screen was 320*200
================
*/
void GL_Set2D (void)
{
	glViewport (glx, gly, glwidth, glheight);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity ();
	glOrtho  (0, vid.width, vid.height, 0, -99999, 99999);

	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity ();

	glDisable (GL_DEPTH_TEST);
	glDisable (GL_CULL_FACE);
	glEnable (GL_BLEND); // was Disable

	//	glEnable (GL_ALPHA_TEST);
	glDisable (GL_ALPHA_TEST);
	glEnable(GL_TEXTURE_2D);

	// LordHavoc: added this
	//	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	//	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	glColor3f(1,1,1);
}

//====================================================================

/* qbism//00-10-15 GL_FindTexture, GL_ResampleTexture, GL_Resample8BitTexture from DP
================
GL_FindTexture
================
*/
int GL_FindTexture (char *identifier)
{
	int		i;
	gltexture_t	*glt;

	for (i=0, glt=gltextures ; i<numgltextures ; i++, glt++)
	{
		if (!strcmp (identifier, glt->identifier))
			return gltextures[i].texnum;
	}

	return -1;
}

extern byte qgamma[];

// LordHavoc: gamma correction and improved resampling
void GL_ResampleTextureLerpLine (byte *in, byte *out, int inwidth, int outwidth)
{
	int		j, xi, oldx = 0;
	float	f, fstep, l1, l2;
	fstep = (float) inwidth/outwidth;
	for (j = 0,f = 0;j < outwidth;j++, f += fstep)
	{
		xi = (int) f;
		if (xi != oldx)
		{
			in += (xi - oldx) * 4;
			oldx = xi;
		}
		if (xi < (inwidth-1))
		{
			l2 = f - xi;
			l1 = 1 - l2;

			*out++ = qgamma[(byte) (in[0]*l1 + in[4]*l2)];
			*out++ = qgamma[(byte) (in[1]*l1 + in[5]*l2)];
			*out++ = qgamma[(byte) (in[2]*l1 + in[6]*l2)];
			*out++ =        (byte) (in[3]*l1 + in[7]*l2) ;
		}
		else // last pixel of the line has no pixel to lerp to
		{
			*out++ = qgamma[in[0]];
			*out++ = qgamma[in[1]];
			*out++ = qgamma[in[2]];
			*out++ =        in[3] ;
		}
	}
}

/*
================
GL_ResampleTexture
================
*/
void GL_ResampleTexture (void *indata, int inwidth, int inheight, void *outdata,  int outwidth, int outheight)
{
	// LordHavoc: gamma correction and greatly improved resampling
	if (gl_lerpimages.value)
	{
		int		i, j, yi, oldy;
		byte	*inrow, *out, *row1, *row2;
		float	f, fstep, l1, l2;
		out = outdata;
		fstep = (float) inheight/outheight;

		row1 = malloc(outwidth*4);
		row2 = malloc(outwidth*4);
		inrow = indata;
		oldy = 0;
		GL_ResampleTextureLerpLine (inrow, row1, inwidth, outwidth);
		GL_ResampleTextureLerpLine (inrow + inwidth*4, row2, inwidth, outwidth);
		for (i = 0, f = 0;i < outheight;i++,f += fstep)
		{
			yi = (int) f;
			if (yi != oldy)
			{
				inrow = (byte *)((int)indata + inwidth*4*yi);
				if (yi == oldy+1)
					memcpy(row1, row2, outwidth*4);
				else
				    GL_ResampleTextureLerpLine (inrow, row1, inwidth, outwidth);
				if (yi < (inheight-1))
					GL_ResampleTextureLerpLine (inrow + inwidth*4, row2, inwidth, outwidth);
				else
				    memcpy(row2, row1, outwidth*4);
				oldy = yi;
			}
			if (yi < (inheight-1))
			{
				//l2 = (f - yi);
				l2 = 0.5-(f - yi);
				l2 = 0.5-(l2*l2*l2*4);
				l1 = (1 - l2);

				for (j = 0;j < outwidth;j++)
				{
					*out++ = (byte) (*row1++ * l1 + *row2++ * l2);
					*out++ = (byte) (*row1++ * l1 + *row2++ * l2);
					*out++ = (byte) (*row1++ * l1 + *row2++ * l2);
					*out++ = (byte) (*row1++ * l1 + *row2++ * l2);
				}
				row1 -= outwidth*4;
				row2 -= outwidth*4;
			}
			else // last line has no pixels to lerp to
			{
				for (j = 0;j < outwidth;j++)
				{
					*out++ = *row1++;
					*out++ = *row1++;
					*out++ = *row1++;
					*out++ = *row1++;
				}
				row1 -= outwidth*4;
			}
		}
		free(row1);
		free(row2);
	}
	else
	{
		int		i, j;
		unsigned	frac, fracstep;
		byte	*inrow, *out, *inpix;
		out = outdata;

		fracstep = inwidth*0x10000/outwidth;
		for (i=0 ; i<outheight ; i++)
		{
			inrow = (byte *)indata + inwidth*(i*inheight/outheight)*4;
			frac = fracstep >> 1;
			for (j=0 ; j<outwidth ; j+=4)
			{
				inpix = inrow + ((frac >> 14) & ~3);
				*out++ = qgamma[*inpix++];
				*out++ = qgamma[*inpix++];
				*out++ = qgamma[*inpix++];
				*out++ =       *inpix++ ;
				frac += fracstep;
				inpix = inrow + ((frac >> 14) & ~3);
				*out++ = qgamma[*inpix++];
				*out++ = qgamma[*inpix++];
				*out++ = qgamma[*inpix++];
				*out++ =       *inpix++ ;
				frac += fracstep;
				inpix = inrow + ((frac >> 14) & ~3);
				*out++ = qgamma[*inpix++];
				*out++ = qgamma[*inpix++];
				*out++ = qgamma[*inpix++];
				*out++ =       *inpix++ ;
				frac += fracstep;
				inpix = inrow + ((frac >> 14) & ~3);
				*out++ = qgamma[*inpix++];
				*out++ = qgamma[*inpix++];
				*out++ = qgamma[*inpix++];
				*out++ =       *inpix++ ;
				frac += fracstep;
			}
		}
	}
}

/*
================
GL_Resample8BitTexture -- JACK
================
*/
void GL_Resample8BitTexture (unsigned char *in, int inwidth, int inheight, unsigned char *out,  int outwidth, int outheight)
{
	int		i, j;
	unsigned	char *inrow;
	unsigned	frac, fracstep;

	fracstep = inwidth*0x10000/outwidth;
	for (i=0 ; i<outheight ; i++, out += outwidth)
	{
		inrow = in + inwidth*(i*inheight/outheight);
		frac = fracstep >> 1;
		for (j=0 ; j<outwidth ; j+=4)
		{
			out[j] = inrow[frac>>16];
			frac += fracstep;
			out[j+1] = inrow[frac>>16];
			frac += fracstep;
			out[j+2] = inrow[frac>>16];
			frac += fracstep;
			out[j+3] = inrow[frac>>16];
			frac += fracstep;
		}
	}
}

/*
================
GL_MipMap

Operates in place, quartering the size of the texture
================
*/
void GL_MipMap (byte *in, int width, int height)
{
	int		i, j;
	byte	*out;

	width <<=2;
	height >>= 1;
	out = in;
	for (i=0 ; i<height ; i++, in+=width)
	{
		for (j=0 ; j<width ; j+=8, out+=4, in+=8)
		{
			out[0] = (in[0] + in[4] + in[width+0] + in[width+4])>>2;
			out[1] = (in[1] + in[5] + in[width+1] + in[width+5])>>2;
			out[2] = (in[2] + in[6] + in[width+2] + in[width+6])>>2;
			out[3] = (in[3] + in[7] + in[width+3] + in[width+7])>>2;
		}
	}
}

/*
================
GL_MipMap8Bit

Mipping for 8 bit textures
================
*/
void GL_MipMap8Bit (byte *in, int width, int height)
{
	int		i, j;
	unsigned short     r,g,b;
	byte	*out, *at1, *at2, *at3, *at4;

	//	width <<=2;
	height >>= 1;
	out = in;
	for (i=0 ; i<height ; i++, in+=width)
	{
		for (j=0 ; j<width ; j+=2, out+=1, in+=2)
		{
			at1 = (byte *) (d_8to24table + in[0]);
			at2 = (byte *) (d_8to24table + in[1]);
			at3 = (byte *) (d_8to24table + in[width+0]);
			at4 = (byte *) (d_8to24table + in[width+1]);

			r = (at1[0]+at2[0]+at3[0]+at4[0]);
			r>>=5;
			g = (at1[1]+at2[1]+at3[1]+at4[1]);
			g>>=5;
			b = (at1[2]+at2[2]+at3[2]+at4[2]);
			b>>=5;

			out[0] = d_15to8table[(r<<0) + (g<<5) + (b<<10)];
		}
	}
}

// qbism//00-10-15 get to work from dp:  GL_Upload32, GL_Upload8_EXT, GL_Upload8, GL_LoadTexture

/*
===============
GL_Upload32
===============
*/
void GL_Upload32 (unsigned *data, int width, int height,  qboolean mipmap, qboolean alpha)
{
	int			samples,i;
	static	unsigned	scaled[1024*512];	// [512*256];

	int			scaled_width, scaled_height;
	byte *in, *out;


	for (scaled_width = 1 ; scaled_width < width ; scaled_width<<=1)
		;
	for (scaled_height = 1 ; scaled_height < height ; scaled_height<<=1)
		;

	scaled_width >>= (int)gl_picmip.value;
	scaled_height >>= (int)gl_picmip.value;

	if (scaled_width > gl_max_size.value)
		scaled_width = gl_max_size.value;
	if (scaled_height > gl_max_size.value)
		scaled_height = gl_max_size.value;

	if (scaled_width * scaled_height > sizeof(scaled)/4)
		Sys_Error ("GL_LoadTexture: too big");

	samples = alpha ? gl_alpha_format : gl_solid_format;

#if 0
	if (mipmap)
		gluBuild2DMipmaps (GL_TEXTURE_2D, samples, width, height, GL_RGBA, GL_UNSIGNED_BYTE, trans);
	else if (scaled_width == width && scaled_height == height)
		glTexImage2D (GL_TEXTURE_2D, 0, samples, width, height, 0, GL_RGBA, GL_UNSIGNED_BYTE, trans);
	else
	    {
		gluScaleImage (GL_RGBA, width, height, GL_UNSIGNED_BYTE, trans,
			scaled_width, scaled_height, GL_UNSIGNED_BYTE, scaled);
		glTexImage2D (GL_TEXTURE_2D, 0, samples, scaled_width, scaled_height, 0, GL_RGBA, GL_UNSIGNED_BYTE, scaled);
	}
#else
	texels += scaled_width * scaled_height;

	if (scaled_width == width && scaled_height == height)
	{

		// qbism//00-10-15 LordHavoc: gamma correct while copying
		in = (byte *)data;
		out = (byte *)scaled;
		for (i = 0;i < width*height;i++)
		{
			*out++ = qgamma[*in++];
			*out++ = qgamma[*in++];
			*out++ = qgamma[*in++];
			*out++ = *in++;
		}
		//qbism//jf 00-10-15 why goto?!
		//goto done;

		/*	if (!mipmap)
		{
		glTexImage2D (GL_TEXTURE_2D, 0, samples, scaled_width, scaled_height, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);
		goto done;
		}
		memcpy (scaled, data, width*height*4);
		*/
	}
	else
	    GL_ResampleTexture (data, width, height, scaled, scaled_width, scaled_height);

	glTexImage2D (GL_TEXTURE_2D, 0, samples, scaled_width, scaled_height, 0, GL_RGBA, GL_UNSIGNED_BYTE, scaled);
	if (mipmap)
	{
		int		miplevel;

		miplevel = 0;
		while (scaled_width > 1 || scaled_height > 1)
		{
			GL_MipMap ((byte *)scaled, scaled_width, scaled_height);
			scaled_width >>= 1;
			scaled_height >>= 1;
			if (scaled_width < 1)
				scaled_width = 1;
			if (scaled_height < 1)
				scaled_height = 1;
			miplevel++;
			glTexImage2D (GL_TEXTURE_2D, miplevel, samples, scaled_width, scaled_height, 0, GL_RGBA, GL_UNSIGNED_BYTE, scaled);
		}
	}
done:
	;
#endif


	if (mipmap)
	{
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, gl_filter_min);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, gl_filter_max);
	}
	else
	    {
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, gl_filter_max);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, gl_filter_max);
	}
}

void GL_Upload8_EXT (byte *data, int width, int height,  qboolean mipmap, qboolean alpha)
{
	int			i, s;
	qboolean	noalpha;
	int			p;
	int			samples;
	static	unsigned char scaled[1024*512];	// [512*256];

	int			scaled_width, scaled_height;

	s = width*height;
	// if there are no transparent pixels, make it a 3 component
	// texture even if it was specified as otherwise
	if (alpha)
	{
		noalpha = true;
		for (i=0 ; i<s ; i++)
		{
			if (data[i] == 255)
				noalpha = false;
		}

		if (alpha && noalpha)
			alpha = false;
	}
	for (scaled_width = 1 ; scaled_width < width ; scaled_width<<=1)
		;
	for (scaled_height = 1 ; scaled_height < height ; scaled_height<<=1)
		;

	scaled_width >>= (int)gl_picmip.value;
	scaled_height >>= (int)gl_picmip.value;

	if (scaled_width > gl_max_size.value)
		scaled_width = gl_max_size.value;
	if (scaled_height > gl_max_size.value)
		scaled_height = gl_max_size.value;

	if (scaled_width * scaled_height > sizeof(scaled))
		Sys_Error ("GL_LoadTexture: too big");

	samples = 1; // alpha ? gl_alpha_format : gl_solid_format;

	texels += scaled_width * scaled_height;

	if (scaled_width == width && scaled_height == height)
	{
		if (!mipmap)
		{
			glTexImage2D (GL_TEXTURE_2D, 0, GL_COLOR_INDEX8_EXT, scaled_width, scaled_height, 0, GL_COLOR_INDEX , GL_UNSIGNED_BYTE, data);
			goto done;
		}
		memcpy (scaled, data, width*height);
	}
	else
	    GL_Resample8BitTexture (data, width, height, scaled, scaled_width, scaled_height);

	glTexImage2D (GL_TEXTURE_2D, 0, GL_COLOR_INDEX8_EXT, scaled_width, scaled_height, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, scaled);
	if (mipmap)
	{
		int		miplevel;

		miplevel = 0;
		while (scaled_width > 1 || scaled_height > 1)
		{
			GL_MipMap8Bit ((byte *)scaled, scaled_width, scaled_height);
			scaled_width >>= 1;
			scaled_height >>= 1;
			if (scaled_width < 1)
				scaled_width = 1;
			if (scaled_height < 1)
				scaled_height = 1;
			miplevel++;
			glTexImage2D (GL_TEXTURE_2D, miplevel, GL_COLOR_INDEX8_EXT, scaled_width, scaled_height, 0, GL_COLOR_INDEX, GL_UNSIGNED_BYTE, scaled);
		}
	}
done:
	;


	if (mipmap)
	{
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, gl_filter_min);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, gl_filter_max);
	}
	else
	    {
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, gl_filter_max);
		glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, gl_filter_max);
	}
}

/*
===============
GL_Upload8
===============
*/
void GL_Upload8 (byte *data, int width, int height,  qboolean mipmap, qboolean alpha)
{
	static	unsigned	trans[640*480];		// FIXME, temporary

	int			i, s;
	qboolean	noalpha;
	int			p;

	s = width*height;
	// if there are no transparent pixels, make it a 3 component
	// texture even if it was specified as otherwise
	if (alpha)
	{
		noalpha = true;
		for (i=0 ; i<s ; i++)
		{
			p = data[i];
			if (p == 255)
				noalpha = false;
			trans[i] = d_8to24table[p];
		}

		if (alpha && noalpha)
			alpha = false;
	}
	else
	    {
		if (s&3)
			Sys_Error ("GL_Upload8: s&3");
		for (i=0 ; i<s ; i+=4)
		{
			trans[i] = d_8to24table[data[i]];
			trans[i+1] = d_8to24table[data[i+1]];
			trans[i+2] = d_8to24table[data[i+2]];
			trans[i+3] = d_8to24table[data[i+3]];
		}
	}

	if (VID_Is8bit() && !alpha && (data!=scrap_texels[0])) {
		GL_Upload8_EXT (data, width, height, mipmap, alpha);
		return;
	}
	GL_Upload32 (trans, width, height, mipmap, alpha);
}

//qbism//00-10-15 GL_LoadTexture from LH
/*
================
GL_LoadTexture
================
*/

//qbism//jf 01-10-30 halflife
int lhcsumtable2[256];
int HL_LoadTexture (char *identifier, int width, int height, byte *data, qboolean mipmap, qboolean alpha)
{
	int			i, s, lhcsum;
	gltexture_t	*glt;

	// LordHavoc: do a checksum to confirm the data really is the same as previous
	// occurances. well this isn't exactly a checksum, it's better than that but
	// not following any standards.
	lhcsum = 0;
	s = width*height*4;
	for (i = 0;i < 256;i++) lhcsumtable2[i] = i + 1;
	for (i = 0;i < s;i++) lhcsum += (lhcsumtable2[data[i] & 255]++);

	// see if the texture is allready present
	if (identifier[0])
	{
		for (i=0, glt=gltextures ; i<numgltextures ; i++, glt++)
		{
			if (!strcmp (identifier, glt->identifier))
			{
				// LordHavoc: everyone hates cache mismatchs, so I fixed it
				if (lhcsum != glt->lhcsum || width != glt->width || height != glt->height)
				{
					Con_DPrintf("GL_LoadTexture: cache mismatch, replacing old texture\n");
					goto HL_LoadTexture_setup; // drop out with glt pointing to the texture to replace
				}
				return glt->texnum;
			}
		}
	}

	glt = &gltextures[numgltextures];
	numgltextures++;

	strcpy (glt->identifier, identifier);
	glt->texnum = texture_extension_number;
	texture_extension_number++;
	// LordHavoc: label to drop out of the loop into the setup code
HL_LoadTexture_setup:
	glt->lhcsum = lhcsum; // LordHavoc: used to verify textures are identical
	glt->width = width;
	glt->height = height;
	glt->mipmap = mipmap;

	glBindTexture(GL_TEXTURE_2D, glt->texnum);
	GL_Upload32 ((unsigned *) data, width, height, mipmap, true);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	return glt->texnum;
}



int lhcsumtable[256];
int GL_LoadTexture (char *identifier, int width, int height, byte *data, qboolean mipmap, qboolean alpha, int bytesperpixel)
{
	qboolean	noalpha;
	int			i, p, s, lhcsum;
	gltexture_t	*glt;

	// LordHavoc: do a checksum to confirm the data really is the same as previous
	// occurances. well this isn't exactly a checksum, it's better than that but
	// not following any standards.
	lhcsum = 0;
	s = width*height*bytesperpixel;
	for (i = 0;i < 256;i++) lhcsumtable[i] = i + 1;
	for (i = 0;i < s;i++) lhcsum += (lhcsumtable[data[i] & 255]++);

	// see if the texture is allready present
	if (identifier[0])
	{
		for (i=0, glt=gltextures ; i<numgltextures ; i++, glt++)
		{
			if (!strcmp (identifier, glt->identifier))
			{
				// LordHavoc: everyone hates cache mismatchs, so I fixed it
				if (lhcsum != glt->lhcsum || width != glt->width || height != glt->height)
				{
					Con_DPrintf("GL_LoadTexture: cache mismatch, replacing old texture\n");
					goto GL_LoadTexture_setup; // drop out with glt pointing to the texture to replace

					//Sys_Error ("GL_LoadTexture: cache mismatch");
				}
				return gltextures[i].texnum;
			}
		}
	}
	// LordHavoc: this was an else condition, causing disasterous results,
	// whoever at id or threewave must've been half asleep...
	glt = &gltextures[numgltextures];
	numgltextures++;

	strcpy (glt->identifier, identifier);
	glt->texnum = texture_extension_number;
	texture_extension_number++;
	// LordHavoc: label to drop out of the loop into the setup code
GL_LoadTexture_setup:
	glt->lhcsum = lhcsum; // LordHavoc: used to verify textures are identical

	glt->width = width;
	glt->height = height;
	glt->mipmap = mipmap;
	glt->bytesperpixel = bytesperpixel;


	//qbism//00-10-15 Dedicated server bug in GLQuake fix by Nathan Cline  start
	//	if (cls.state != ca_dedicated)
	//	{
	//qbism//00-10-15 Dedicated server bug in GLQuake fix by Nathan Cline  end
	//		GL_Bind(texture_extension_number );

	if (!isDedicated)
	{
		glBindTexture(GL_TEXTURE_2D,glt->texnum);

		// LordHavoc: 32bit textures
		if (bytesperpixel == 1)
			GL_Upload8 (data, width, height, mipmap, alpha);
		else if (bytesperpixel == 4)
			GL_Upload32 (data, width, height, mipmap, true);
		else
		    Sys_Error("GL_LoadTexture: unknown bytesperpixel\n");
	}

	//qbism//00-10-15 Dedicated server bug in GLQuake fix by Nathan Cline
	//	texture_extension_number++;
	//	return texture_extension_number-1;

	return glt->texnum;
}
/*
================
GL_LoadPicTexture
================
*/
int GL_LoadPicTexture (qpic_t *pic)
{
	return GL_LoadTexture ("", pic->width, pic->height, pic->data, false, true, 1);
}

/****************************************/

static GLenum oldtarget = TEXTURE0_SGIS;

void GL_SelectTexture (GLenum target)
{
	if (!gl_mtexable)
		return;
	qglSelectTextureSGIS(target);
	if (target == oldtarget)
		return;
	cnttextures[oldtarget-TEXTURE0_SGIS] = currenttexture;
	currenttexture = cnttextures[target-TEXTURE0_SGIS];
	oldtarget = target;
}

//qbism//00-10-15 MD2 to end of this file
int             image_width;
int             image_height;

/*
=================================================================

PCX Loading

=================================================================
*/

typedef struct
{
	char        manufacturer;
	char        version;
	char        encoding;
	char        bits_per_pixel;
	unsigned short      xmin,ymin,xmax,ymax;
	unsigned short      hres,vres;
	unsigned char       palette[48];
	char        reserved;
	char        color_planes;
	unsigned short      bytes_per_line;
	unsigned short      palette_type;
	char        filler[58];
	unsigned    data;                   // unbounded

}
pcx_t;

/* qbism//jf 00-10-15 yes, we have a different loadpcx function in gl_warp. sigh.
============
LoadPCX2 from muff tute
============
*/
byte* LoadPCX2 (FILE *f, int matchwidth, int matchheight)
{
	pcx_t   *pcx, pcxbuf;
	byte    palette[768];
	byte    *pix, *image_rgba;
	int             x, y;
	int             dataByte, runLength;
	int             count;

	//
	// parse the PCX file
	//
	fread (&pcxbuf, 1, sizeof(pcxbuf), f);

	pcx = &pcxbuf;

	if (pcx->manufacturer != 0x0a
		    || pcx->version != 5
		    || pcx->encoding != 1
		    || pcx->bits_per_pixel != 8
		    || pcx->xmax >= 320
		    || pcx->ymax >= 256)
	{
		Con_Printf ("Bad pcx file\n");
		return NULL;
	}

	if (matchwidth && (pcx->xmax+1) != matchwidth)
		return NULL;
	if (matchheight && (pcx->ymax+1) != matchheight)
		return NULL;

	// seek to palette
	fseek (f, -768, SEEK_END);
	fread (palette, 1, 768, f);

	fseek (f, sizeof(pcxbuf) - 4, SEEK_SET);

	count = (pcx->xmax+1) * (pcx->ymax+1);
	image_rgba = malloc( count * 4);

	for (y=0 ; y<=pcx->ymax ; y++)
	{
		pix = image_rgba + 4*y*(pcx->xmax+1);
		for (x=0 ; x<=pcx->xmax ; ) // muff - fixed - was referencing ymax
									{
			dataByte = fgetc(f);

			if((dataByte & 0xC0) == 0xC0)
			{
				runLength = dataByte & 0x3F;
				dataByte = fgetc(f);
			}
			else
			    runLength = 1;

			while(runLength-- > 0)
			{
				pix[0] = palette[dataByte*3];
				pix[1] = palette[dataByte*3+1];
				pix[2] = palette[dataByte*3+2];
				pix[3] = 255;
				pix += 4;
				x++;
			}
		}
	}
	image_width = pcx->xmax+1;
	image_height = pcx->ymax+1;
	return image_rgba;
}

/*
=========================================================

TARGA LOADING

=========================================================
*/

typedef struct _TargaHeader {
	unsigned char   id_length, colormap_type, image_type;
	unsigned short  colormap_index, colormap_length;
	unsigned char   colormap_size;
	unsigned short  x_origin, y_origin, width, height;
	unsigned char   pixel_size, attributes;
}
TargaHeader;


TargaHeader             targa_header;

/* //qbism//jf 00-10-15 already defined in gl_warp
int fgetLittleShort (FILE *f)
{
byte    b1, b2;

b1 = fgetc(f);
b2 = fgetc(f);

return (short)(b1 + b2*256);
}

int fgetLittleLong (FILE *f)
{
byte    b1, b2, b3, b4;

b1 = fgetc(f);
b2 = fgetc(f);
b3 = fgetc(f);
b4 = fgetc(f);

return b1 + (b2<<8) + (b3<<16) + (b4<<24);
}*/



//qbism//jf 01-10-30 from MH tute on QuakeSrc.
/*
============
LoadJPG
============
*/
byte *LoadJPG (FILE *f, int matchwidth, int matchheight)
{
	struct jpeg_decompress_struct cinfo;
	JDIMENSION num_scanlines;
	JSAMPARRAY in;
	struct jpeg_error_mgr jerr;
	int numPixels;
	int row_stride;
	byte *out;
	int count;
	int i;
	int r, g, b;
	byte *image_rgba;

	// set up the decompression.
	cinfo.err = jpeg_std_error(&jerr);
	jpeg_create_decompress (&cinfo);

	// inititalize the source
	jpeg_stdio_src (&cinfo, f);

	// initialize decompression
	(void) jpeg_read_header (&cinfo, TRUE);
	(void) jpeg_start_decompress (&cinfo);

	if (matchwidth && cinfo.image_width != matchwidth)
		goto error;

	if (matchheight && cinfo.image_height != matchheight)
		goto error;

	numPixels = cinfo.image_width * cinfo.image_height;

	// initialize the input buffer - we'll use the in-built memory management routines in the
	// JPEG library because it will automatically free the used memory for us when we destroy
	// the decompression structure.  cool.
	row_stride = cinfo.output_width * cinfo.output_components;
	in = (*cinfo.mem->alloc_sarray) ((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);

	// bit of error checking
	if (cinfo.output_components != 3)
		goto error;

	if ((numPixels * 4) != ((row_stride * cinfo.output_height) + numPixels))
		goto error;

	// initialize the return data
	image_rgba = malloc ((numPixels * 4));

	// read the jpeg
	count = 0;

	while (cinfo.output_scanline < cinfo.output_height)
	{
		num_scanlines = jpeg_read_scanlines(&cinfo, in, 1);
		out = in[0];

		for (i = 0; i < row_stride;)
		{
			r = image_rgba[count++] = out[i++];
			g = image_rgba[count++] = out[i++];
			b = image_rgba[count++] = out[i++];
			image_rgba[count++] = 255;
		}
	}

	// finish decompression and destroy the jpeg
	image_width = cinfo.image_width;
	image_height = cinfo.image_height;

	(void) jpeg_finish_decompress (&cinfo);
	jpeg_destroy_decompress (&cinfo);

	fclose (f);
	return image_rgba;

error:
	// this should rarely (if ever) happen, but just in case...
	Con_DPrintf ("Invalid JPEG Format\n");
	jpeg_destroy_decompress (&cinfo);

	fclose (f);
	return NULL;
}




//qbism//jf 00-10-15 MD2 changed name from muff tute, added "2" because of existing LoadTGA.
/*
=============
LoadTGA2
=============
*/
byte* LoadTGA2 (FILE *fin, int matchwidth, int matchheight)
{
	int                             columns, rows, numPixels;
	byte                    *pixbuf;
	int                             row, column;
	byte                    *image_rgba;

	targa_header.id_length = fgetc(fin);
	targa_header.colormap_type = fgetc(fin);
	targa_header.image_type = fgetc(fin);

	targa_header.colormap_index = fgetLittleShort(fin);
	targa_header.colormap_length = fgetLittleShort(fin);
	targa_header.colormap_size = fgetc(fin);
	targa_header.x_origin = fgetLittleShort(fin);
	targa_header.y_origin = fgetLittleShort(fin);
	targa_header.width = fgetLittleShort(fin);
	targa_header.height = fgetLittleShort(fin);
	if (matchwidth && targa_header.width != matchwidth)
		return NULL;
	if (matchheight && targa_header.height != matchheight)
		return NULL;
	targa_header.pixel_size = fgetc(fin);
	targa_header.attributes = fgetc(fin);

	if (targa_header.image_type!=2
		    && targa_header.image_type!=10)
		Sys_Error ("LoadTGA: Only type 2 and 10 targa RGB images supported\n");

	if (targa_header.colormap_type !=0
		    || (targa_header.pixel_size!=32 && targa_header.pixel_size!=24))
		Sys_Error ("Texture_LoadTGA: Only 32 or 24 bit images supported (no colormaps)\n");

	columns = targa_header.width;
	rows = targa_header.height;
	numPixels = columns * rows;

	image_rgba = malloc (numPixels*4);

	if (targa_header.id_length != 0)
		fseek(fin, targa_header.id_length, SEEK_CUR);  // skip TARGA image comment

	if (targa_header.image_type==2) {  // Uncompressed, RGB images


		for(row=rows-1; row>=0; row--) {
			pixbuf = image_rgba + row*columns*4;
			for(column=0; column < columns; column++) {
				unsigned char red,green,blue,alphabyte;
				switch (targa_header.pixel_size) {
				case 24:

					blue = getc(fin);
					green = getc(fin);
					red = getc(fin);
					*pixbuf++ = red;
					*pixbuf++ = green;
					*pixbuf++ = blue;
					*pixbuf++ = 255;
					break;
				case 32:
					blue = getc(fin);
					green = getc(fin);
					red = getc(fin);
					alphabyte = getc(fin);
					*pixbuf++ = red;
					*pixbuf++ = green;
					*pixbuf++ = blue;
					*pixbuf++ = alphabyte;
					break;
				}
			}
		}
	}
	else if (targa_header.image_type==10) {   // Runlength encoded RGB images


		unsigned char red,green,blue,alphabyte,packetHeader,packetSize,j;
		for(row=rows-1; row>=0; row--) {
			pixbuf = image_rgba + row*columns*4;
			for(column=0; column < columns; ) {
				packetHeader=getc(fin);
				packetSize = 1 + (packetHeader & 0x7f);
				if (packetHeader & 0x80) {        // run-length packet


					switch (targa_header.pixel_size) {
					case 24:
						blue = getc(fin);
						green = getc(fin);
						red = getc(fin);
						alphabyte = 255;
						break;
					case 32:
						blue = getc(fin);
						green = getc(fin);
						red = getc(fin);
						alphabyte = getc(fin);
						break;
					}

					for(j=0;j < packetSize;j++) {
						*pixbuf++=red;
						*pixbuf++=green;
						*pixbuf++=blue;
						*pixbuf++=alphabyte;
						column++;
						if (column==columns) { // run spans across rows


							column=0;
							if (row>0)
								row--;
							else
								goto breakOut;
							pixbuf = image_rgba + row*columns*4;
						}
					}
				}
				else {                            // non run-length packet


					for(j=0;j < packetSize;j++) {
						switch (targa_header.pixel_size) {
						case 24:
							blue = getc(fin);
							green = getc(fin);
							red = getc(fin);
							*pixbuf++ = red;
							*pixbuf++ = green;
							*pixbuf++ = blue;
							*pixbuf++ = 255;
							break;
						case 32:
							blue = getc(fin);
							green = getc(fin);
							red = getc(fin);
							alphabyte = getc(fin);
							*pixbuf++ = red;
							*pixbuf++ = green;
							*pixbuf++ = blue;
							*pixbuf++ = alphabyte;
							break;
						}
						column++;
						if (column==columns) { // pixel packet run spans across rows


							column=0;
							if (row>0)
								row--;
							else
								goto breakOut;
							pixbuf = image_rgba + row*columns*4;
						}
					}
				}
			}
breakOut:;
		}
	}

	fclose(fin);
	image_width = columns;
	image_height = rows;
	return image_rgba;
}

byte* loadimagepixels (char* filename, char* directory, qboolean complain, int matchwidth, int matchheight)
{
	FILE    *f;
	char    basename[MAX_QPATH], name[MAX_QPATH];
	byte    *image_rgba;
	COM_StripExtension(filename, basename); // strip the extension to allow TGA skins on Q2 models despite the .pcx in the skin name
	//qbism//jf 01-10-30 jpg, oh yeah.
	sprintf (name, "%s/%s.jpg", directory, basename);
	COM_FOpenFile (name, &f);
	if (f)
		return LoadJPG (f, matchwidth, matchheight);
	sprintf (name, "%s/%s.tga", directory, basename);
	COM_FOpenFile (name, &f);
	if (f)
		return LoadTGA2 (f, matchwidth, matchheight);
	sprintf (name, "%s/%s.pcx", directory, basename);
	COM_FOpenFile (name, &f);
	if (f)
		return LoadPCX2 (f, matchwidth, matchheight);
	//      if (image_rgba = W_GetTexture(basename, matchwidth, matchheight))
	//              return image_rgba;
	if (complain)
		Con_Printf ("Couldn't load textures/%s .jpg, tga or pcx\n", filename);
	return NULL;
}


//qbism MD2
int loadtextureimage (int texnum, char* filename, qboolean complain, int matchwidth, int matchheight)
{
	byte *data;
	if (!(data = loadimagepixels (filename, "skins", complain, matchwidth, matchheight)))
		return 0;
	if (texnum >= 0) // specific texnum, not cached

	{
		glBindTexture(GL_TEXTURE_2D,texnum);
		GL_Upload32 (data, image_width, image_height, true, true);
		free(data);
		return texnum;
	}
	else // any texnum, cached
	{
		texnum = GL_LoadTexture (filename, image_width, image_height, data, true, true, 4);
		free(data);
		return texnum;
	}
}

//qbism//jf 01-10-30 hl
void CL_ParseEntityLump(char *entdata)
{
	char *data;
	char key[128], value[1024];
	char wadname[128];
	char *skyname;
	int i, j, k;

	data = entdata;
	if (!data)
		return;

	data = COM_Parse(data);

	if (!data)
		return; // valid exit

	if (com_token[0] != '{')
		return; // error

	//doesn't seem to work here.... R_LoadSkys (NULL); //qbism//jf 01-10-30 load default sky in case no "sky" in worldspawn

	while (1)
	{
		data = COM_Parse(data);
		if (!data)
			return; // error
		if (com_token[0] == '}')
			return; // since we're just parsing the first ent (worldspawn), exit
		strcpy(key, com_token);
		while (key[strlen(key)-1] == ' ') // remove trailing spaces

			key[strlen(key)-1] = 0;
		data = COM_Parse(data);
		if (!data)
			return; // error
		strcpy(value, com_token);

		if (!strcmp("sky", key))
		{
			skyname = value;
			R_LoadSkys (skyname);
		}

		else if (!strcmp("fog", key))
		{
			scanf(value, "%f %f %f %f", &fog_density, &fog_red, &fog_green, &fog_blue);
			j = 0;
		}
		else if (!strcmp("fog_start", key))
			fog_start.value = atof(value);
		else if (!strcmp("fog_end", key))
			fog_end.value = atof(value);
		else if (!strcmp("fog_density", key))
			fog_density.value = atof(value);
		else if (!strcmp("fog_red", key))
			fog_red.value = atof(value);
		else if (!strcmp("fog_green", key))
			fog_green.value = atof(value);
		else if (!strcmp("fog_blue", key))
			fog_blue.value = atof(value);
		else if (!strcmp("fog_alpha", key))
			fog_alpha.value = atof(value);

		else if (!strcmp("wad", key)) // for HalfLife maps

		{
			j = 0;
			for (i = 0;i < 128;i++)
				if (value[i] != ';' && value[i] != '\\' && value[i] != '/' && value[i] != ':')
					break;
			if (value[i])
			{
				for (;i < 128;i++)
				{
					// ignore path - the \\ check is for HalfLife... stupid windoze 'programmers'...
					if (value[i] == '\\' || value[i] == '/' || value[i] == ':')
						j = i+1;
					else if (value[i] == ';' || value[i] == 0)
					{
						k = value[i];
						value[i] = 0;
						strcpy(wadname, "textures/");
						Con_DPrintf("Wad: %s\n", &value[j]);
						strcat(wadname, &value[j]);
						//						W_LoadTextureWadFile (wadname, false);
						j = i+1;
						if (!k)
							break;
					}
				}
			}
		}
	}
}
