/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
// cl_parse.c  -- parse a message received from the server

#include "quakedef.h"

char *svc_strings[] =
{
	"svc_bad",
	"svc_nop",
	"svc_disconnect",
	"svc_updatestat",
	"svc_version",		// [long] server version
	"svc_setview",		// [short] entity number
	"svc_localsound",	//qbism//jf 02-10-05 FIXME needs its own effect! <see code>
	"svc_sound",			//qbism//jf 02-10-05 <see code>
	"svc_time",			// [float] server time
	"svc_print",			// [string] null terminated string
	"svc_stufftext",		// [string] stuffed into client's console buffer
	// the string should be \n terminated
	"svc_setangle",		// [vec3] set the view angle to this absolute value

	"svc_serverinfo",		// [long] version
	// [string] signon string
	// [string]..[0]model cache [string]...[0]sounds cache
	// [string]..[0]item cache
	"svc_lightstyle",		// [byte] [string]
	"svc_updatename",		// [byte] [string]
	"svc_updatefrags",	// [byte] [short]
	"svc_clientdata",		// <shortbits + data>
	"svc_stopsound",		// <see code>
	"svc_updateskins",	// [byte] [byte]
	//	"svc_updatebodies",	// [byte] [byte]
	"svc_particle",		// [vec3] <variable>
	"svc_damage",			// [byte] impact [byte] blood [vec3] from

	"svc_spawnstatic",
	"svc_skybox"	// Tomaz - Skybox
	"svc_spawnbaseline",

	"svc_temp_entity",		// <variable>
	"svc_setpause",
	"svc_signonnum",
	"svc_centerprint",
	"svc_killedmonster",
	"svc_foundsecret",
	"svc_spawnstaticsound",
	"svc_intermission",
	"svc_finale",			// [string] music [string] text
	"svc_cdtrack",			// [byte] track [byte] looptrack
	"svc_sellscreen",
	"svc_cutscene",
	"svc_localsound", //qbism//jf 02-10-05

};

//=============================================================================

/*
===============
CL_EntityNum

This error checks and tracks the total number of entities
===============
*/
entity_t	*CL_EntityNum (int num)
{
	if (num >= cl.num_entities)
	{
		if (num >= MAX_EDICTS)
			Host_Error ("CL_EntityNum: %i is an invalid number",num);
		while (cl.num_entities<=num)
		{
			cl_entities[cl.num_entities].colormap = vid.colormap;
			cl.num_entities++;
		}
	}

	return &cl_entities[num];
}


/*
//qbism//jf 02-10-05
==================
CL_ParseLocalSoundPacket
==================
*/
void CL_ParseLocalSoundPacket(void)
{
	int 	volume;
	int 	field_mask;
	int 	sound_num;


	field_mask = MSG_ReadByte();

	if (field_mask & SND_VOLUME)
		volume = MSG_ReadByte ();
	else
	    volume = DEFAULT_SOUND_PACKET_VOLUME;

	sound_num = MSG_ReadByte ();

	//qbism//jf 01-10-30
	if (field_mask & SND_MORE1) sound_num += 256;
	if (field_mask & SND_MORE2) sound_num += 512;
	S_LocalSound (cl.sound_precache[sound_num]->name);
}





/*
==================
CL_ParseStartSoundPacket
==================
*/
void CL_ParseStartSoundPacket(void)
{
	vec3_t  pos;
	int 	channel, ent;
	int 	sound_num;
	int 	volume;
	int 	field_mask;
	float 	attenuation;
	int		i;

	field_mask = MSG_ReadByte();

	if (field_mask & SND_VOLUME)
		volume = MSG_ReadByte ();
	else
	    volume = DEFAULT_SOUND_PACKET_VOLUME;

	if (field_mask & SND_ATTENUATION)
		attenuation = MSG_ReadByte () * 0.015625;	//qbism//jf 02-10-05 was /64  Tomaz - Speed
	else
	    attenuation = DEFAULT_SOUND_PACKET_ATTENUATION;

	channel = MSG_ReadShort ();
	sound_num = MSG_ReadByte ();

	//qbism//jf 01-10-30
	if (field_mask & SND_MORE1) sound_num += 256;
	if (field_mask & SND_MORE2) sound_num += 512;

	ent = channel >> 3;
	channel &= 7;

	if (ent > MAX_EDICTS)
		Host_Error ("CL_ParseStartSoundPacket: ent = %i", ent);

	for (i=0 ; i<3 ; i++)
		pos[i] = MSG_ReadCoord ();

	S_StartSound (ent, channel, cl.sound_precache[sound_num], pos, volume/255.0, attenuation);
}

/*
==================
CL_KeepaliveMessage

When the client is taking a long time to load stuff, send keepalive messages
so the server doesn't disconnect.
==================
*/
void CL_KeepaliveMessage (void)
{
	float	time;
	static float lastmsg;
	int		ret;
	sizebuf_t	old;
	byte		olddata[8192];

	if (sv.active)
		return;		// no need if server is local

	if (cls.demoplayback)
		return;

	// read messages from server, should just be nops
	old = net_message;
	memcpy (olddata, net_message.data, net_message.cursize);

	do
	    {
		ret = CL_GetMessage ();
		switch (ret)
		{
		default:
			Host_Error ("CL_KeepaliveMessage: CL_GetMessage failed");
		case 0:
			break;	// nothing waiting

		case 1:
			Host_Error ("CL_KeepaliveMessage: received a message");
			break;
		case 2:
			if (MSG_ReadByte() != svc_nop)
				Host_Error ("CL_KeepaliveMessage: datagram wasn't a nop");
			break;
		}
	}
	while (ret);

	net_message = old;
	memcpy (net_message.data, olddata, net_message.cursize);

	// check time
	time = Sys_FloatTime ();
	if (time - lastmsg < 5)
		return;
	lastmsg = time;

	// write out a nop
	Con_Printf ("--> client to server keepalive\n");

	MSG_WriteByte (&cls.message, clc_nop);
	NET_SendMessage (cls.netcon, &cls.message);
	SZ_Clear (&cls.message);
}

//qbism//00-10-15 from DP

extern char skyname[];




/*
==================
CL_ParseServerInfo
==================
*/
void CL_ParseServerInfo (void)
{
	char	*str;
	int		i;
	int		nummodels, numsounds;
	char	model_precache[MAX_MODELS][MAX_QPATH];
	char	sound_precache[MAX_SOUNDS][MAX_QPATH];

	Con_DPrintf ("Serverinfo packet received.\n"); //qbism//00-10-15 typical for all Con_DPrintf

	//
	// wipe the client_state_t struct
	//
	CL_ClearState ();

	// parse protocol version number
	i = MSG_ReadLong ();
	if (i != PROTOCOL_VERSION)
	{
		Con_Printf ("Server returned version %i, not %i", i, PROTOCOL_VERSION);
		return;
	}

	// parse maxclients
	cl.maxclients = MSG_ReadByte ();
	if (cl.maxclients < 1 || cl.maxclients > MAX_SCOREBOARD)
	{
		Con_Printf("Bad maxclients (%u) from server\n", cl.maxclients);
		return;
	}
	cl.scores = Hunk_AllocName (cl.maxclients*sizeof(*cl.scores), "scores");
	cl.teamscores = Hunk_AllocName (14 * sizeof(*cl.teamscores), "teamscor"); //qbism// 2000-03-01 JPG - for teamscore status bar

	// parse gametype
	cl.gametype = MSG_ReadByte ();

	// parse signon message
	str = MSG_ReadString ();
	strncpy (cl.levelname, str, sizeof(cl.levelname)-1);

	// seperate the printfs so the server message can have a color
	Con_Printf("\n\n\35\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\36\37\n\n");
	Con_Printf ("%c%s\n", 2, str);

	//
	// first we go through and touch all of the precache data that still
	// happens to be in the cache, so precaching something else doesn't
	// needlessly purge it
	//

	// precache models
	memset (cl.model_precache, 0, sizeof(cl.model_precache));
	for (nummodels=1 ; ; nummodels++)
	{
		str = MSG_ReadString ();
		if (!str[0])
			break;
		if (nummodels==MAX_MODELS)
		{
			Con_Printf ("Server sent too many model precaches\n");
			return;
		}
		strcpy (model_precache[nummodels], str);
		Mod_TouchModel (str);
	}

	// precache sounds
	memset (cl.sound_precache, 0, sizeof(cl.sound_precache));
	for (numsounds=1 ; ; numsounds++)
	{
		str = MSG_ReadString ();
		if (!str[0])
			break;
		if (numsounds==MAX_SOUNDS)
		{
			Con_Printf ("Server sent too many sound precaches\n");
			return;
		}
		strcpy (sound_precache[numsounds], str);
		S_TouchSound (str);
	}

	//
	// now we try to load everything else until a cache allocation fails
	//

	for (i=1 ; i<nummodels ; i++)
	{
		//	isworldmodel = i == 1; // qbism//00-10-15 LordHavoc: first model is the world model

		cl.model_precache[i] = Mod_ForName (model_precache[i], false);
		if (cl.model_precache[i] == NULL)
		{
			Con_Printf("Model %s not found\n", model_precache[i]);
			return;
		}
		CL_KeepaliveMessage ();
	}

	S_BeginPrecaching ();
	for (i=1 ; i<numsounds ; i++)
	{
		cl.sound_precache[i] = S_PrecacheSound (sound_precache[i]);
		CL_KeepaliveMessage ();
	}
	S_EndPrecaching ();


	// local state
	cl_entities[0].model = cl.worldmodel = cl.model_precache[1];

	R_NewMap ();

	Hunk_Check ();		// make sure nothing is hurt

	noclip_anglehack = false;		// noclip is turned off at start

}


/*
==================
CL_ParseUpdate

Parse an entity update message from the server
If an entities model or origin changes from frame to frame, it must be
relinked.  Other attributes can change without relinking.
==================
*/
int	bitcounts[16];

void CL_ParseUpdate (int bits)
{
	int			i;
	int 		xtend=0; //qbism//jf 01-10-30

	model_t		*model;
	int			modnum;
	qboolean	forcelink;
	entity_t	*ent;
	int			num;
	int			skin;


	if (cls.signon == SIGNONS - 1)
	{	// first update is the final signon stage




		cls.signon = SIGNONS;
		CL_SignonReply ();
	}

	if (bits & U_MOREBITS)
		bits |= (MSG_ReadByte()<<8);
	if (bits & U_EXTEND1)
	{
		bits |= MSG_ReadByte() << 16;
		if (bits & U_EXTEND2)
			bits |= MSG_ReadByte() << 24;
	}

	if (bits & U_LONGENTITY)
		num = MSG_ReadShort ();
	else
		num = MSG_ReadByte ();

	ent = CL_EntityNum (num);


	if (ent->msgtime != cl.mtime[1])
	{
		forcelink			= true;	// no previous frame to lerp from
		ent->debris_smoke	= 9; //jft FIXME: must every entity have this?
		ent->time_left		= 0;

	}
	else
		forcelink = false;

	ent->msgtime = cl.mtime[0];
	// qbism//jf 00-10-15 end from Darkplaces

	//qbism//jf 02-10-05 delta baseline
	if (bits & U_MODEL)
	{
		modnum = MSG_ReadByte ();
		if (modnum >= MAX_MODELS) Host_Error ("CL_ParseModel: bad modnum");
		else ent->baseline.modelindex = modnum;
	}
	else modnum = ent->baseline.modelindex;

	model = cl.model_precache[modnum];
	if (model != ent->model)
	{
		ent->model = model;
		// automatic animation (torches, etc) can be either all together
		// or randomized
		if (model)
		{
			if (model->synctype == ST_RAND)
				ent->syncbase = (float)(rand()&0x7fff) / 0x7fff;
			else
			    ent->syncbase = 0.0;
		}
		else
			forcelink = true;	// hack to make null model players work
	}

	if (bits & U_FRAME)
	{
		ent->frame = MSG_ReadByte ();
		ent->baseline.frame = ent->frame;
	}
	else
		ent->frame = ent->baseline.frame;

	if (bits & U_COLORMAP)
	{
		i = MSG_ReadByte();
		ent->baseline.colormap = i;
	}
	else
		i = ent->baseline.colormap;
	if (!i)
		ent->colormap = vid.colormap;
	else
	{
		if (i > cl.maxclients)
			Sys_Error ("i >= cl.maxclients");
		ent->colormap = cl.scores[i-1].translations;
	}


	if (bits & U_SKIN)
	{
		skin = MSG_ReadByte();
		ent->baseline.skin = skin;
	}
	else
		skin = ent->baseline.skin;
	ent->skinnum = skin;


	//qbism//jf 01-10-30
	if (bits & U_LEGSFRAME)
	{
		ent->legsframe = MSG_ReadByte ();
		ent->baseline.legsframe = ent->legsframe;
	}
	else
		ent->legsframe = ent->baseline.legsframe;

	if (bits & U_LEGSX)	xtend = MSG_ReadByte ();
	else xtend = 0;

	if (xtend & X_MODEL)
	{
		modnum = MSG_ReadByte ();
		if (modnum >= MAX_MODELS) Host_Error ("CL_ParseModel: bad modnum");
		else ent->baseline.legsmodelindex = modnum;
	}
	else modnum = ent->baseline.legsmodelindex;
	if (modnum) model = cl.model_precache[modnum];
	else model= NULL;
	if (model != ent->legsmodel)
	{
		ent->legsmodel = model;
	}

	if (xtend & X_SKIN)
	{
		skin = MSG_ReadByte();
		ent->baseline.legsskin = skin;
	}
	else
		skin = ent->baseline.legsskin;
	ent->legsskinnum = skin;


	if (xtend & X_ANGLES1)
		ent->legsangles[0] = MSG_ReadAngle();
	else ent->legsangles[0]= ent->legsangles1[0]= ent->legsangles2[0]= 0;

	if (xtend & X_ANGLES2)
		ent->legsangles[1] = MSG_ReadAngle();
	else ent->legsangles[1]= ent->legsangles1[1]= ent->legsangles2[1]= 0;

	if (xtend & X_ANGLES3)
		ent->legsangles[2] = MSG_ReadAngle();
	else ent->legsangles[2]= ent->legsangles1[2]= ent->legsangles2[2]= 0;

	if (xtend & X_ALPHA)
	{
		ent->legsalpha = MSG_ReadByte();
		ent->baseline.legsalpha = ent->legsalpha;
	}
	else ent->legsalpha = ent->baseline.legsalpha;


	if (bits & U_TORSOFRAME)
	{
		ent->torsoframe = MSG_ReadByte ();
		ent->baseline.torsoframe = ent->torsoframe;
	}
	else
		ent->torsoframe = ent->baseline.torsoframe;

	if (bits & U_TORSOX) xtend = MSG_ReadByte ();
	else xtend = 0;

	if (xtend & X_MODEL)
	{
		modnum = MSG_ReadByte ();
		if (modnum >= MAX_MODELS) Host_Error ("CL_ParseModel: bad modnum");
		else ent->baseline.torsomodelindex = modnum;
	}
	else modnum = ent->baseline.torsomodelindex;
	if (modnum) model = cl.model_precache[modnum];
	else model= NULL;

	if (model != ent->torsomodel)
	{
		ent->torsomodel = model;
	}

	if (xtend & X_SKIN)
	{
		skin = MSG_ReadByte();
		ent->baseline.torsoskin = skin;
	}
	else
		skin = ent->baseline.torsoskin;
	ent->torsoskinnum = skin;


	if (xtend & X_ANGLES1)
		ent->torsoangles[0] = MSG_ReadAngle();
	else ent->torsoangles[0]= ent->torsoangles1[0]= ent->torsoangles2[0]= 0;

	if (xtend & X_ANGLES2)
		ent->torsoangles[1] = MSG_ReadAngle();
	else ent->torsoangles[1]= ent->torsoangles1[1]= ent->torsoangles2[1]= 0;

	if (xtend & X_ANGLES3)
		ent->torsoangles[2] = MSG_ReadAngle();
	else ent->torsoangles[2]= ent->torsoangles1[2]= ent->torsoangles2[2]= 0;

	if (xtend & X_ALPHA)
	{
		ent->torsoalpha = MSG_ReadByte();
		ent->baseline.torsoalpha = ent->torsoalpha;
	}
	else ent->torsoalpha = ent->baseline.torsoalpha;


	xtend = 0;

	if (bits & U_VWEPFRAME)
	{
		ent->vwepframe = MSG_ReadByte ();
		ent->baseline.vwepframe = ent->vwepframe;
	}
	else
		ent->vwepframe = ent->baseline.vwepframe;

	if (bits & U_VWEPX) xtend = MSG_ReadByte ();
	else xtend = 0;

	if (xtend & X_MODEL)
	{
		modnum = MSG_ReadByte ();
		if (modnum >= MAX_MODELS) Host_Error ("CL_ParseModel: bad modnum");
		else ent->baseline.vwepmodelindex = modnum;
	}
	else modnum = ent->baseline.vwepmodelindex;
	if (modnum) model = cl.model_precache[modnum];
	else model= NULL;

	if (model != ent->vwepmodel)
	{
		ent->vwepmodel = model;
	}

	if (xtend & X_SKIN)
	{
		skin = MSG_ReadByte();
		ent->baseline.vwepskin= skin;
	}
	else
		skin = ent->baseline.vwepskin;
	ent->vwepskinnum = skin;

	if (xtend & X_ANGLES1)
		ent->vwepangles[0] = MSG_ReadAngle();
	else ent->vwepangles[0]= ent->vwepangles1[0]= ent->vwepangles2[0]= 0;

	if (xtend & X_ANGLES2)
		ent->vwepangles[1] = MSG_ReadAngle();
	else ent->vwepangles[1]= ent->vwepangles1[1]= ent->vwepangles2[1]= 0;

	if (xtend & X_ANGLES3)
		ent->vwepangles[2] = MSG_ReadAngle();
	else ent->vwepangles[2]= ent->vwepangles1[2]= ent->vwepangles2[2]= 0;

	if (xtend & X_ALPHA) ent->vwepalpha = MSG_ReadByte();
	else ent->vwepalpha = ent->baseline.vwepalpha;



	//qbism//fj 02-10-05 face
	if (bits & U_MOUTHMODEL)
	{
		modnum = MSG_ReadByte ();
		if (modnum >= MAX_MODELS) Host_Error ("CL_ParseModel: bad modnum");
		else ent->baseline.mouthmodelindex = modnum;
	}
	else modnum = ent->baseline.mouthmodelindex;
	if (modnum) model = cl.model_precache[modnum];
	else model= NULL;
	if (model != ent->mouthmodel)
	{
		ent->mouthmodel = model;
	}


	if (bits & U_EYESMODEL)
	{
		modnum = MSG_ReadByte ();
		if (modnum >= MAX_MODELS) Host_Error ("CL_ParseModel: bad modnum");
		else ent->baseline.eyesmodelindex = modnum;
	}
	else modnum = ent->baseline.eyesmodelindex;
	if (modnum) model = cl.model_precache[modnum];
	else model= NULL;
	if (model != ent->eyesmodel)
	{
		ent->eyesmodel = model;
	}



	if (bits & U_ALPHA)
	{
		ent->alpha = MSG_ReadByte();
		ent->baseline.alpha =ent->alpha;
	}
	else ent->alpha = ent->baseline.alpha;


	if (bits & U_EFFECTS)
	{
		ent->effects = MSG_ReadByte();
		ent->baseline.effects = ent->effects;
	}
	else
		ent->effects = ent->baseline.effects;

	//qbism//jf 02-10-05 effectsx and effectstrail
	if (bits & U_EFFECTSX)
	{
		ent->effectsx = MSG_ReadByte();
		ent->baseline.effectsx = ent->effectsx;
	}
	else
		ent->effectsx = ent->baseline.effectsx;

	if (bits & U_EFFECTSTRAIL)
	{
		ent->effectstrail = MSG_ReadByte();
		ent->baseline.effectstrail =ent->effectstrail;
	}
	else
		ent->effectstrail = ent->baseline.effectstrail;

	// shift the known values for interpolation
	VectorCopy (ent->msg_origins[0], ent->msg_origins[1]);
	VectorCopy (ent->msg_angles[0], ent->msg_angles[1]);

	if (bits & U_ORIGIN1)
	{
		ent->msg_origins[0][0] = MSG_ReadCoord ();
		ent->baseline.origin[0] =ent->msg_origins[0][0];
	}
	else
		ent->msg_origins[0][0] = ent->baseline.origin[0];
	if (bits & U_ANGLE1)
	{
		ent->msg_angles[0][0] = MSG_ReadPreciseAngle();
		ent->baseline.angles[0] =ent->msg_angles[0][0];
	}
	else
		ent->msg_angles[0][0] = ent->baseline.angles[0];

	if (bits & U_ORIGIN2)
	{
		ent->msg_origins[0][1] = MSG_ReadCoord ();
		ent->baseline.origin[1] =ent->msg_origins[0][1];
	}
	else
		ent->msg_origins[0][1] = ent->baseline.origin[1];
	if (bits & U_ANGLE2)
	{
		//qbism//jf 02-10-05 changed angle to preciseangle.
		ent->msg_angles[0][1] = MSG_ReadPreciseAngle();
		ent->baseline.angles[1] =ent->msg_angles[0][1];
	}
	else
		ent->msg_angles[0][1] = ent->baseline.angles[1];

	if (bits & U_ORIGIN3)
	{
		ent->msg_origins[0][2] = MSG_ReadCoord ();
		ent->baseline.origin[2] =ent->msg_origins[0][2];
	}
	else
		ent->msg_origins[0][2] = ent->baseline.origin[2];
	if (bits & U_ANGLE3)
	{
		ent->msg_angles[0][2] = MSG_ReadPreciseAngle();
		ent->baseline.angles[2] =ent->msg_angles[0][2];
	}
	else
		ent->msg_                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               