/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef __RSCRIPT__
#define __RSCRIPT__

extern float turbsin[];

typedef struct
{
	char	type;			// effect types
	float	speed;			// speed of effect
	float	min, max;		// min & max values
} effect_t;

typedef struct
{
	char	typeX,typeY;	// scroll types
	float	speedX,speedY;	// speed of scroll
} scroll_t;

typedef struct anim_stage_s
{
	struct anim_stage_s		*next;
	char					texture[16];
	int						texnum;
} anim_stage_t;

typedef struct stage_s
{
	struct stage_s		*next;					// next stage (NULL if none)
	float				movx, movy;				// x/y speed
	float				blendsrc, blenddst;		// blendfuncs
	char				texture[32];			// texture name
	unsigned int		texnum;					// texnum

	qboolean			cullback;				// cull back face?
	qboolean			nolightmap;				// no lightmap?
	qboolean			alphafunc;				// use transparency?
	qboolean			spheremap;				// sphere mapping?

	effect_t			alpha;					// alpha shifting
	scroll_t			scroll;					// texture scrolling
	anim_stage_t		*anim;					// texture animation
	float				animwait,animtime;		// animation wait
	unsigned int		animcount,anim_current;	// number of anim frames
} stage_t;

typedef struct rscript_s
{
	char				name[48];		// script name
	stage_t				*stage;			// first stage
	unsigned char		stagecount;		// num stages
	struct rscript_s	*next;			// next script
	qboolean			ready;			// been readied?
} rscript_t;

extern rscript_t	*rootscript;
extern int	rs_num;

#endif