#include "quakedef.h"

/*
==================
R_BuildSRoom
laverick@bigfoot.com 880016
==================
*/
void R_BuildSkyRooms (void)
{
	vec3_t	sroom = {928, -704, 64};
	vec3_t	oldPos;
/*
1: set view location to skyroom location
2: glClear (clearing both the framebuffer and zbuffer)
3: R_RenderView (to render the skyroom)
4: glClear (just clearing the zbuffer, leaving framebuffer intact)
5 (optional): render sky polygons as depth only (using glColorMask(0,0,0,0); which is not supported by a lot of drivers)
6: set view location to player camera location
7: R_RenderView (to render the current room, but without rendering sky polygons)
8: display
*/
	VectorCopy	(r_refdef.vieworg , oldPos);
	VectorCopy (sroom, r_refdef.vieworg);
	glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);//2
	glDrawBuffer  (GL_AUX1);
	R_RenderView();//3
	glClear (GL_DEPTH_BUFFER_BIT);//4
	VectorCopy (oldPos, r_refdef.vieworg);//6
	glReadBuffer (GL_AUX1);
	GL_Bind(7000);
	glCopyTexImage2D(GL_TEXTURE_2D, 0, gl_alpha_format, 0, 0, 256, 256,0);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	R_RenderView();
	//	R_RenderView();

}