/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
//
// Cutscene playback
//

#include "quakedef.h"

#include <mmsystem.h>		
#include <digitalv.h>		
extern HWND		mainwindow;

HINSTANCE   ghInst;
MCIDEVICEID gwMCIDeviceID = 0;	/* MCI Device ID for the AVI file */
HWND        ghwndMovie;		/* window handle of the movie */
BOOL        gfPlaying = FALSE;	/* Play flag: TRUE == playing, FALSE == paused */
BOOL        gfMovieOpen = FALSE;/* Open flag: TRUE == movie open, FALSE = none */
HANDLE      ghAccel = NULL;	/* accelerator table */
HMENU       ghMenuBar = NULL;	/* menu bar handle */
char        gszBuffer[260];

#define AVI_VIDEO "avivideo"

static BOOL initAVI(
void)
{
	MCI_DGV_OPEN_PARMS	mciOpen;
		
	/* set up the open parameters */
	mciOpen.dwCallback 		= 0L;
	mciOpen.wDeviceID 		= 0;
	mciOpen.lpstrDeviceType 	= AVI_VIDEO;
	mciOpen.lpstrElementName 	= NULL;
	mciOpen.lpstrAlias 		= NULL;
	mciOpen.dwStyle 		= 0;
	mciOpen.hWndParent 		= NULL;
		
	/* try to open the driver */
	return (mciSendCommand(0, MCI_OPEN, (DWORD)(MCI_OPEN_TYPE),
                          (DWORD)(LPMCI_DGV_OPEN_PARMS)&mciOpen) == 0);
}

void termAVI(void)
{
	MCIDEVICEID        mciID;
	MCI_GENERIC_PARMS  mciClose;
	//
	// Get the device ID for the opened device type and then close
	// the device type.
	mciID = mciGetDeviceID(AVI_VIDEO);
	mciSendCommand(mciID, MCI_CLOSE, 0L,
                   (DWORD)(LPMCI_GENERIC_PARMS)&mciClose);
}

static VOID positionMovie(
HWND hWnd)
{
	RECT rcMovie;		/* the rect where the movie is positioned      */
				/* for QT/W this is the movie rect, for AVI    */
				/* this is the location of the playback window */
	RECT	rcClient, rcMovieBounds;
	MCI_DGV_RECT_PARMS	mciRect;

	/* if there is no movie yet then just get out of here */
	if (!gfMovieOpen)
		return;

	GetClientRect(hWnd, &rcClient);	/* get the parent windows rect */
	
	/* get the original size of the movie */
	mciSendCommand(gwMCIDeviceID, MCI_WHERE,
                  (DWORD)(MCI_DGV_WHERE_SOURCE),
                  (DWORD)(LPMCI_DGV_RECT_PARMS)&mciRect);
	CopyRect( &rcMovieBounds, &mciRect.rc );	/* get it in the movie bounds rect */

	rcMovie.left = (rcClient.right/2) - (rcMovieBounds.right / 2);
	rcMovie.top = (rcClient.bottom/2) - (rcMovieBounds.bottom / 2);
	rcMovie.right = rcMovie.left + rcMovieBounds.right;
	rcMovie.bottom = rcMovie.top + rcMovieBounds.bottom;

	/* reposition the playback (child) window */
	MoveWindow(ghwndMovie, rcMovie.left, rcMovie.top,
			rcMovieBounds.right, rcMovieBounds.bottom, TRUE);
}

static void fileCloseMovie(HWND hWnd)
{
	MCI_GENERIC_PARMS  mciGeneric;

	mciSendCommand(gwMCIDeviceID, MCI_CLOSE, 0L,
                 (DWORD)(LPMCI_GENERIC_PARMS)&mciGeneric);

	gfPlaying = FALSE;	// can't be playing any longer
	gfMovieOpen = FALSE;	// no more movies open
	
	/* cause a total repaint to occur */
	InvalidateRect(hWnd, NULL, TRUE);
	UpdateWindow(hWnd);
}

static void fileOpenMovie(HWND hWnd, char *filename)
{
	MCI_DGV_OPEN_PARMS	mciOpen;
	MCI_DGV_WINDOW_PARMS	mciWindow;
	MCI_DGV_STATUS_PARMS	mciStatus;

	/* we got a filename, now close any old movie and open */
	/* the new one.					*/
	if (gfMovieOpen)
		fileCloseMovie(hWnd);	

	/* we have a .AVI movie to open, use MCI */
	/* set up the open parameters */
	mciOpen.dwCallback = 0L;
	mciOpen.wDeviceID = 0;
	mciOpen.lpstrDeviceType = NULL;
	mciOpen.lpstrElementName = filename;
	mciOpen.lpstrAlias = NULL;
	mciOpen.dwStyle = WS_CHILD;
	mciOpen.hWndParent = hWnd;

	/* try to open the file */
	if (mciSendCommand(0, MCI_OPEN,
		(DWORD)(MCI_OPEN_ELEMENT|MCI_DGV_OPEN_PARENT|MCI_DGV_OPEN_WS),
		(DWORD)(LPMCI_DGV_OPEN_PARMS)&mciOpen) == 0){

		/* we opened the file o.k., now set up to */
		/* play it.				   */
		gwMCIDeviceID = mciOpen.wDeviceID;	/* save ID */
		gfMovieOpen = TRUE;	/* a movie was opened */

		/* show the playback window */
		mciWindow.dwCallback = 0L;
		mciWindow.hWnd = NULL;
		mciWindow.nCmdShow = SW_SHOW;
		mciWindow.lpstrText = (LPSTR)NULL;
		mciSendCommand(gwMCIDeviceID, MCI_WINDOW,
			MCI_DGV_WINDOW_STATE,
			(DWORD)(LPMCI_DGV_WINDOW_PARMS)&mciWindow);

		/* get the window handle */
		mciStatus.dwItem = MCI_DGV_STATUS_HWND;
		mciSendCommand(gwMCIDeviceID,
			MCI_STATUS, MCI_STATUS_ITEM,
			(DWORD)(LPMCI_STATUS_PARMS)&mciStatus);
		ghwndMovie = (HWND)mciStatus.dwReturn;

		/* now get the movie centered */
		positionMovie(hWnd);
	} else {
		/* generic error for open */
		Con_Print("Error opening cutscene\n");
		gfMovieOpen = FALSE;
	}

	InvalidateRect(hWnd, NULL, FALSE);
	UpdateWindow(hWnd);
}

void playMovie(HWND hWnd,int nDirection)
{
	gfPlaying = !gfPlaying;	/* swap the play flag */
	if(!nDirection)
		gfPlaying = FALSE;	/* wDirection == NULL means PAUSE */

	/* play/pause the AVI movie */
	if (gfPlaying){
		DWORD			dwFlags;
		MCI_DGV_PLAY_PARMS	mciPlay;
		
		/* init to play all */
		mciPlay.dwCallback = MAKELONG(hWnd,0);
		mciPlay.dwFrom = mciPlay.dwTo = 0;
		dwFlags = MCI_NOTIFY;
		
		mciSendCommand(gwMCIDeviceID, MCI_PLAY, dwFlags,
		               (DWORD)(LPMCI_DGV_PLAY_PARMS)&mciPlay);
	} else {
		MCI_DGV_PAUSE_PARMS	mciPause;
	
		/* tell it to pause */
		mciSendCommand(gwMCIDeviceID,MCI_PAUSE,0L,
                     (DWORD)(LPMCI_DGV_PAUSE_PARMS)&mciPause);
	}
}