#ifndef __GL_SCRIPT__
#define __GL_SCRIPT__

// Animation loop
typedef struct anim_stage_s {
	image_t					*texture;	// texture
	char					name[48];	// texture name
	struct anim_stage_s		*next;		// next anim stage
} anim_stage_t;

// Blending
typedef struct {
	int			source;		// source blend value
	int			dest;		// dest blend value
	qboolean	blend;		// are we going to blend?
} blendfunc_t;

// Alpha shifting
typedef struct {
	float		min, max;	// min/max alpha values
	float		speed;		// shifting speed
} alphashift_t;

// scaling
typedef struct
{
	char	typeX, typeY;	// scale types
	float	scaleX, scaleY;	// scaling factors
} rs_scale_t;

// scrolling
typedef struct
{
	char	typeX, typeY;	// scroll types
	float	speedX, speedY;	// speed of scroll
} rs_scroll_t;

// Script stage
typedef struct rs_stage_s {
	image_t					*texture;		// texture
	char					name[48];		// tex name
	
	anim_stage_t			*anim_stage;	// first animation stage
	float					anim_delay;		// Delay between anim frames
	float					last_anim_time; // gametime of last frame change
	char					anim_count;		// number of animation frames
	anim_stage_t			*last_anim;		// pointer to last anim

	blendfunc_t				blendfunc;		// image blending
	alphashift_t			alphashift;		// alpha shifting
	rs_scroll_t				scroll;			// tcmod
	rs_scale_t				scale;			// tcmod

	float					rot_speed;		// rotate speed (0 for no rotate);

	qboolean				envmap;			// fake envmapping
	qboolean				lightmap;		// lightmap this stage?
	qboolean				alphamask;		// alpha masking?
	qboolean				lm_only;		// $lightmap

	struct rs_stage_s		*next;			// next stage
} rs_stage_t;

typedef struct rs_stagekey_s
{
	char *stage;
	void (*func)(rs_stage_t *shader, char **token);
} rs_stagekey_t;

// Base script
typedef struct rscript_s {
	char					name[48];	// name of script
	
	unsigned char			subdivide;	// Heffo - chop the surface up this much for vertex warping
	float					warpdist;	// Heffo - vertex warping distance;
	float					warpsmooth;	// Heffo - vertex warping smoothness;
	float					warpspeed;	// Heffo - vertex warping speed;
	qboolean				mirror;		// mirror

	qboolean				dontflush;	// dont flush from memory on map change
	qboolean				ready;		// readied by the engine?
	rs_stage_t				*stage;		// first rendering stage
	struct rscript_s		*next;		// next script in linked list

} rscript_t;

typedef struct rs_scriptkey_s
{
	char *script;
	void (*func)(rscript_t *rs, char **token);
} rs_scriptkey_t;

void RS_LoadScript(char *script);
void RS_FreeAllScripts(void);
void RS_FreeScript(rscript_t *rs);
void RS_FreeUnmarked(void);
rscript_t *RS_FindScript(char *name);
void RS_ReadyScript(rscript_t *rs);

void RS_ScanPathForScripts(char *dir);
//void RS_ScanPathForScripts (void);

int RS_Animate(rs_stage_t *stage);
void RS_UpdateRegistration(void);
void RS_DrawSurface (msurface_t *surf, qboolean lightmap, unsigned int lmtex);
void RS_SetTexcoords (rs_stage_t *stage, float *os, float *ot, msurface_t *fa);

#define RS_DrawPoly(surf,lmtex)	RS_DrawSurface((surf),true,lmtex)
#define RS_DrawPolyNoLightMap(surf)	RS_DrawSurface((surf),false,0)

extern float rs_realtime;

#endif // __GL_SCRIPT__