// 3DWnd.h : header file
//
#ifndef __C3DWND_H
#define __C3DWND_H
#include "MedDLeGFX\MedDLeTypes.h"

enum MedDLeShading {SHADE_NONE, SHADE_FLAT, SHADE_GOUROURD};

class CMedDLeDoc;
/////////////////////////////////////////////////////////////////////////////
// C3DWnd window

class C3DWnd : public CWnd
{
	CMedDLeDoc *GetDocument();
	float win_width;
	float win_height;
	float focus;
// Construction
public:
	C3DWnd();
	CMedDLeMatrix	m_Proj, m_View, m_World;	// Matrices
	CMedDLeMatrix	Scaling;

	CRect m_rcSmall;
	CWnd *m_pParent;
	BOOL m_bFullScreen;
	void FullScreen(BOOL f);

	MedDLeShading	ShadeMode;
	BOOL			bShowWireFrame;
	BOOL			bShowVertices;
	BOOL			bTextureMap;


	// mouse manipulation variables
	BOOL LeftStart, RightStart;
	BOOL LeftClean, RightClean;
	BOOL HasShift;
	BOOL HasCtrl;
	BOOL RotatingLight;
	BOOL MovingEye;
	BOOL RotatingEye;
	CPoint OldPoint;
	CPoint ClickPoint;

	int m_nCamera;

	BOOL m_bTexture;
	BOOL m_bShade;
	BOOL m_bColorLights;
	
	BOOL m_bDrawVerts;
	BOOL m_bDrawLines;
	BOOL m_bDrawFaces;
	BOOL m_bBackFaceCull;
	int  m_cur3dframe;
	int  m_curtexture;

	int NoMotion;
	float sensitivity;  // mouse moving parameter
	void ResetView(void);

// Operations
public:
	void RenderHit(CPoint point);
	void DrawGrid(int resy);

// Attributes
public:

// Operations
public:

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(C3DWnd)
	public:
	virtual BOOL Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext = NULL);
	virtual BOOL DestroyWindow();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo);
	protected:
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~C3DWnd();

	// Generated message map functions
protected:
	//{{AFX_MSG(C3DWnd)
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnPaint();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnEscapepressed();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
#endif
