//JLogAn, a Quake3Arena Log Analyzer
/* Copyright (C) 2000 Josh Faust

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


import java.awt.*;
import java.util.*;
import java.io.*;
import java.lang.*;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.REProgram;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import javax.swing.filechooser.*;
import javax.swing.table.*;

public class jlogan extends JFrame implements ActionListener,Runnable {
    public static int WIDTH = 950;
    public static int HEIGHT = 700;
    public static String TITLE = "JLogAn";
    JTabbedPane tabbedPane = new JTabbedPane();
    JPanel mainPanel = new JPanel(true);
    JPanel pergamePanel = new JPanel(true);
    JPanel panels[] = {mainPanel, pergamePanel};
    JScrollPane KilledWithPane;
    JScrollPane PlayerPane;
    JScrollPane KilledWhoPane;
    JScrollPane GamePanes[];
    JScrollBar pergameScrollBar = new JScrollBar(JScrollBar.VERTICAL, 0, 10, 0, 100);
    TableSorter KilledWithSorter;
    TableSorter PlayerSorter;
    TableSorter KilledWhoSorter;
    TableSorter GameSorters[];
    int yoff = 0;
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = new JMenu("File");
    JMenuItem fileExit = new JMenuItem("Exit");
    JMenuItem fileOpen = new JMenuItem("Open");
	JMenu optionsMenu = new JMenu("Options");
	JCheckBoxMenuItem optionsShowBots = new JCheckBoxMenuItem("Show Bots", false);
    JTable KilledWithTable;
    JTable PlayerTable;
    JTable KilledWhoTable;
    JLabel GameLabels[];
    JTable GameTables[];
    
    JFrame splashFrame = new JFrame("");
    JFrame loadingFrame = new JFrame("");
    
    ImageIcon gauntletIcon = new ImageIcon("weapons/gauntlet.jpg");
    ImageIcon machinegunIcon = new ImageIcon("weapons/machinegun.jpg");
    ImageIcon shotgunIcon = new ImageIcon("weapons/shotgun.jpg");
    ImageIcon rocketlIcon = new ImageIcon("weapons/rocketl.jpg");
    ImageIcon grenadelIcon = new ImageIcon("weapons/grenadel.jpg");
    ImageIcon lightningIcon = new ImageIcon("weapons/lightning.jpg");
    ImageIcon plasmaIcon = new ImageIcon("weapons/plasma.jpg");
    ImageIcon railgunIcon = new ImageIcon("weapons/railgun.jpg");
    ImageIcon bfgIcon = new ImageIcon("weapons/bfg.jpg");
    ImageIcon mainBackgroundImg = new ImageIcon("mainbackground.jpg");
    ImageIcon pergameBackgroundImg = new ImageIcon("pergameBackground.jpg");
    
    JLabel mainBackgroundLabel = new JLabel(mainBackgroundImg);
    JLabel pergameBackgroundLabel = new JLabel(pergameBackgroundImg);
	
	File currentFile;
	boolean doFileChooser = true;
    
    int first = 1;
    static jlogan jl;
    static Thread p;
    static boolean firstRun = true;
    
    jlogan() {
        super(TITLE);
    }
    
    public void run() {
        //this is a hack in order to get the loading pop-up working
        if (firstRun) {
            // Uncomment if you want a Windows look and feel (things don't look as good IMHO)
            /*try {
	            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
	        } catch (Exception ex) {
	            System.out.println(ex);
	        }*/
	        
            setSize(WIDTH,HEIGHT);
            
            setResizable(false);
            addWindowListener(new WindowHandler());
            buildGUI();
            show();
            splashFrame.getContentPane().add("Center", new JLabel(new ImageIcon("jloganlogo.jpg")));
            splashFrame.reshape(WIDTH/2-400, HEIGHT/2-200, 200, 100);
            splashFrame.pack();
    //        splashFrame.setClosable(false);
            splashFrame.setResizable(false);
    //        splashFrame.setMaximizable(false);
    //        splashFrame.setIconifiable(false);
    //        getContentPane().add(splashFrame);
            splashFrame.show();
            splashFrame.setVisible(true);
            
            loadingFrame.getContentPane().add("Center", new JLabel(new ImageIcon("jloganloading.jpg")));
            loadingFrame.reshape(WIDTH/2-300, HEIGHT/2-100, 200, 100);
            loadingFrame.pack();
    //        loadingFrame.setClosable(false);
            loadingFrame.setResizable(false);
    //        loadingFrame.setMaximizable(false);
    //        loadingFrame.setIconifiable(false);
            //getContentPane().add(loadingFrame);
            loadingFrame.hide();
            try {
                p.sleep(2000);
            } catch (InterruptedException ex) {
                System.out.println(ex);
            }
            
            splashFrame.setVisible(false);
    //        getContentPane().remove(splashFrame);
            firstRun = false;
        } else {
            loadFile();
        }
    }
    
    public void buildGUI() {
        String tabs[] = {"Main", "Per Game Data"};
        String tabTips[] = {"Main", "Per Game Data"};
        
        for (int i = 0;i < tabs.length;i++) {
            tabbedPane.addTab(tabs[i],null,panels[i]);
        }
        addComponentsToTabs();
        getContentPane().add("Center", tabbedPane);
    }
    
    public void addComponentsToTabs() {
        setupPanels();
    }
    
    public void setupPanels() {
        fileMenu.add(fileOpen);
        fileMenu.add(fileExit);
		optionsMenu.add(optionsShowBots);
        menuBar.add(fileMenu);
		menuBar.add(optionsMenu);
        setJMenuBar(menuBar);
        fileExit.addActionListener(this);
        fileOpen.addActionListener(this);
		optionsShowBots.addActionListener(this);
        mainPanel.setBackground(Color.black);
        mainBackgroundLabel.reshape(0,0,950,700);
        mainPanel.add(mainBackgroundLabel);
        mainPanel.setLayout(null);
        pergamePanel.setBackground(Color.black);
        pergameBackgroundLabel.reshape(0,0,950,700);
        pergamePanel.add(pergameBackgroundLabel);
        pergamePanel.setLayout(null);
        pergamePanel.add(pergameScrollBar);
        pergameScrollBar.addAdjustmentListener(new ScrollBarHandler());
    }
    
    public void SetPlayerTable(Vector players) {
        String columns[] = {"Name", "Skill", "Frags", "Deaths", "Suicides", "Time (Minutes)", "FPM", "SPF"};
        Object cells[][] = new Object[players.size()][columns.length];
        
        
        //cells[0] = columns;
        
        for (int i = 0;i < players.size();i++) {
            String s[] = new String[columns.length];
            s[0] = ((Player)players.elementAt(i)).name;
            s[1] = "" + ((Player)players.elementAt(i)).skill;
            s[2] = "" + ((Player)players.elementAt(i)).totalfrags;
            s[3] = "" + ((Player)players.elementAt(i)).totaldeaths;
            s[4] = "" + ((Player)players.elementAt(i)).totalsuicides;
            s[5] = "" + ((float)((Player)players.elementAt(i)).time/60);
            s[6] = "" + ((float)(((Player)players.elementAt(i)).totalfrags/((float)((Player)players.elementAt(i)).time/60)));
            s[7] = "" + ((float)(((Player)players.elementAt(i)).time/((float)((Player)players.elementAt(i)).totalfrags)));
            cells[i] = s;
        }
        
        //PlayerTable = new JTable(cells, columns);
        
        DefaultTableModel dataModel = new DefaultTableModel(cells, columns);
        PlayerSorter = new TableSorter(dataModel);
        PlayerTable = new JTable(PlayerSorter);
        PlayerTable.getTableHeader().setReorderingAllowed(false);
        PlayerSorter.addMouseListenerToHeaderInTable(PlayerTable);
        PlayerPane = new JScrollPane(PlayerTable);
        JLabel l = new JLabel("Player Statistics");
        l.setForeground(Color.white);
        l.reshape(200, 10, 500, 20);
        mainPanel.add(l);
        if (cells.length > 7)
            PlayerPane.reshape(20, 30, 850, 17*7+16);
        else
            PlayerPane.reshape(20, 30, 850, 17*cells.length + 16);
        PlayerPane.setBackground(Color.black); // Why won't this actually set the color?
        mainPanel.add(PlayerPane);
        //mainPanel.add(PlayerTable);
    }
    
    public void SetKilledWithTable(Vector players) {
        String columns[] = {"Name", "Gauntlet", "Machine Gun", "Shotgun", "Rocket Launcher", "Grenade Launcher", "Lightning Gun", "Plasma Gun", "Railgun", "BFG"};
        Object cells[][] = new Object[players.size()][columns.length];
        //cells[0] = columns;
        
        for (int i = 0;i < players.size();i++) {
            String s[] = new String[columns.length];
            s[0] = ((Player)players.elementAt(i)).name;
            s[1] = "" + ((Player)players.elementAt(i)).totalkilledwith[0];
            s[2] = "" + ((Player)players.elementAt(i)).totalkilledwith[1];
            s[3] = "" + ((Player)players.elementAt(i)).totalkilledwith[2];
            s[4] = "" + ((Player)players.elementAt(i)).totalkilledwith[3];
            s[5] = "" + ((Player)players.elementAt(i)).totalkilledwith[4];
            s[6] = "" + ((Player)players.elementAt(i)).totalkilledwith[5];
            s[7] = "" + ((Player)players.elementAt(i)).totalkilledwith[6];
            s[8] = "" + ((Player)players.elementAt(i)).totalkilledwith[7];
            s[9] = "" + ((Player)players.elementAt(i)).totalkilledwith[8];
            cells[i] = s;
        }
        
        //KilledWithTable = new JTable(cells, columns);
        
        DefaultTableModel dataModel = new DefaultTableModel(cells, columns);
        
        KilledWithSorter = new TableSorter(dataModel);
        KilledWithTable = new JTable(KilledWithSorter);
        KilledWithTable.getTableHeader().setReorderingAllowed(false);
        KilledWithSorter.addMouseListenerToHeaderInTable(KilledWithTable);
        KilledWithPane = new JScrollPane(KilledWithTable);
        JLabel l = new JLabel("Frags Per Weapon");
        l.setForeground(Color.white);
        l.reshape(200, 190, 500, 20);
        mainPanel.add(l);
        JLabel tmpl = new JLabel(gauntletIcon);
        tmpl.reshape(95, 190, 100, 100);
        mainPanel.add(tmpl);
        tmpl = new JLabel(machinegunIcon);
        tmpl.reshape(185, 190, 100, 100);
        mainPanel.add(tmpl);
        tmpl = new JLabel(shotgunIcon);
        tmpl.reshape(265, 190, 100, 100);
        mainPanel.add(tmpl);
        tmpl = new JLabel(rocketlIcon);
        tmpl.reshape(355, 190, 100, 100);
        mainPanel.add(tmpl);
        tmpl = new JLabel(grenadelIcon);
        tmpl.reshape(440, 190, 100, 100);
        mainPanel.add(tmpl);
        tmpl = new JLabel(lightningIcon);
        tmpl.reshape(520, 190, 100, 100);
        mainPanel.add(tmpl);
        tmpl = new JLabel(plasmaIcon);
        tmpl.reshape(605, 190, 100, 100);
        mainPanel.add(tmpl);
        tmpl = new JLabel(railgunIcon);
        tmpl.reshape(690, 190, 100, 100);
        mainPanel.add(tmpl);
        tmpl = new JLabel(bfgIcon);
        tmpl.reshape(770, 190, 100, 100);
        mainPanel.add(tmpl);
        if (cells.length > 7)
            KilledWithPane.reshape(20, 270, 850, 17*7+16);
        else
            KilledWithPane.reshape(20, 270, 850, 17*cells.length + 16);
        KilledWithPane.setBackground(Color.black); // Why won't this actually set the color?
        mainPanel.add(KilledWithPane);
        //mainPanel.add(KilledWithTable);
    }
    
    public void SetKilledWhoTable(Vector players) {
        String columns[] = new String[players.size() + 1];
        Object cells[][] = new Object[players.size()][columns.length];
        
        columns[0] = "";
        for (int i = 0;i < players.size();i++) {
            columns[i+1] = ((Player)players.elementAt(i)).name;
        }
        
        for (int i = 0;i < players.size();i++) {
            String s[] = new String[columns.length];
            s[0] = ((Player)players.elementAt(i)).name;
            for (int j = 0;j < players.size();j++) {
                if (!((Player)players.elementAt(i)).name.equals(((Player)players.elementAt(j)).name))
                    s[j+1] = "" + ((Player)players.elementAt(i)).GetKillsOf(((Player)players.elementAt(j)).name);
                else
                    s[j+1] = "N/A";
            }
            cells[i] = s;
        }
        
        //PlayerTable = new JTable(cells, columns);
        
        DefaultTableModel dataModel = new DefaultTableModel(cells, columns);
        KilledWhoSorter = new TableSorter(dataModel);
        KilledWhoTable = new JTable(KilledWhoSorter);
        KilledWhoTable.getTableHeader().setReorderingAllowed(false);
        KilledWhoSorter.addMouseListenerToHeaderInTable(KilledWhoTable);
        KilledWhoPane = new JScrollPane(KilledWhoTable);
        JLabel l = new JLabel("Who Killed Who");
        l.setForeground(Color.white);
        l.reshape(200, 440, 500, 20);
        mainPanel.add(l);
        if (cells.length > 7)
            KilledWhoPane.reshape(20, 460, 850, 17*7+16);
        else
            KilledWhoPane.reshape(20, 460, 850, 17*cells.length + 16);
        KilledWhoPane.setBackground(Color.black); // Why won't this actually set the color?
        mainPanel.add(KilledWhoPane);
    }
    
    public void SetGameData(ParsedFile pfile) {
        String columns[] = {"Name", "Skill", "Frags", "Deaths", "Suicides", "FPM", "SPF", "Time"};
        Object cells[][];
        
        GameTables = new JTable[pfile.games.size()];
        GameLabels = new JLabel[pfile.games.size()];
        GamePanes = new JScrollPane[pfile.games.size()];
        GameSorters = new TableSorter[pfile.games.size()];
        
        for (int i = 0;i < pfile.games.size();i++) {
            Game g = ((Game)pfile.games.elementAt(i));
            cells = new Object[g.players.size()][columns.length];
            //cells[0] = columns;
            for (int j = 0;j < g.players.size();j++) {
                String s[] = new String[columns.length];
                Player p;
                p = pfile.GetPlayer(((String)g.players.elementAt(j)));
                s[0] = p.name;
                s[1] = "" + ((float)p.gamefrags[p.gamecount]/(p.gamedeaths[p.gamecount] + p.gamesuicides[p.gamecount]));
                s[2] = "" + p.gamefrags[p.gamecount];
                s[3] = "" + p.gamedeaths[p.gamecount];
                s[4] = "" + p.gamesuicides[p.gamecount];
                s[5] = "" + ((float)(p.gamefrags[p.gamecount]/((float)p.gametime[p.gamecount]/60)));
                s[6] = "" + ((float)(p.gametime[p.gamecount]/((float)p.gamefrags[p.gamecount])));
                s[7] = "" + ((float)p.gametime[p.gamecount]/60);
                p.gamecount++;
                cells[j] = s;
            }
            GameLabels[i] = new JLabel("Game: " + (i+1) + "           Map: " + g.GetMap());
            GameLabels[i].setForeground(Color.white);
            //GameTables[i] = new JTable(cells, columns);
            DefaultTableModel dataModel = new DefaultTableModel(cells, columns);
            GameSorters[i] = new TableSorter(dataModel);
            GameTables[i] = new JTable(GameSorters[i]);
            GameTables[i].getTableHeader().setReorderingAllowed(false);
            GameSorters[i].addMouseListenerToHeaderInTable(GameTables[i]);
            GamePanes[i] = new JScrollPane(GameTables[i]);
            GamePanes[i].setBackground(Color.black); // Why won't this actually set the color?
            
            //pergamePanel.add((new JLabel("Game: " + (i+1) + " Map: " + g.GetMap())));
            //pergamePanel.add((new JTable(cells, columns)));
        }
        pergameScrollBar.setMaximum(pfile.games.size()*15);
    }
    
    public void loadFile() {
		File theFile = new File("");
		int retval = 5489;
		
		if (doFileChooser) {
        	JFileChooser chooser = new JFileChooser("/program files/quake iii arena");
        	retval = chooser.showDialog(jl, null);
			if (retval == JFileChooser.APPROVE_OPTION)
				theFile = chooser.getSelectedFile();
		} else {
			//bah, hack
			if (currentFile != null) {
				retval = JFileChooser.APPROVE_OPTION;
				theFile = currentFile;
			}
		}
	    if(retval == JFileChooser.APPROVE_OPTION) {
	        currentFile = theFile;
            loadingFrame.show();
            mainPanel.updateUI();
            pergamePanel.updateUI();
                    
            mainPanel.remove(mainBackgroundLabel);
            pergamePanel.remove(pergameBackgroundLabel);
            if (first == 0) {
                mainPanel.remove(PlayerPane);
                mainPanel.remove(KilledWithPane);
                mainPanel.remove(KilledWhoPane);
                        
                for (int i = 0;i < GamePanes.length;i++) {
                    pergamePanel.remove(GamePanes[i]);
                    pergamePanel.remove(GameLabels[i]);
                }
            }
            first = 0;
                    
            q3aloganalyzer q3la = new q3aloganalyzer(theFile.getPath(), optionsShowBots.isSelected());
            ParsedFile pfile = new ParsedFile();
            pfile = q3la.GetParsedFile();
                    
            SetPlayerTable(pfile.players);
            SetKilledWithTable(pfile.players);
            SetKilledWhoTable(pfile.players);
            PlayerTable.setCellSelectionEnabled(false);
            KilledWithTable.setCellSelectionEnabled(false);
            KilledWhoTable.setCellSelectionEnabled(false);
            PlayerTable.setColumnSelectionAllowed(true);
            KilledWithTable.setColumnSelectionAllowed(true);
            KilledWhoTable.setColumnSelectionAllowed(true);
            mainBackgroundLabel.reshape(0,0,950,700);
            mainPanel.add(mainBackgroundLabel);
            mainPanel.updateUI();
            SetGameData(pfile);
            pergameScrollBar.reshape(910, 10, 20, 610);
            for (int i = 0;i < GamePanes.length;i++) {
                if (i != 0) {
                    GameLabels[i].reshape(200,(GameTables[i-1].getY() + i*180)-yoff, 200,100);
                    if (GameTables[i].getRowCount() > 7)
                        GamePanes[i].reshape(10,(60+(GameTables[i-1].getY() + i*180))-yoff,800,150);
                    else
                        GamePanes[i].reshape(10,(60+(GameTables[i-1].getY() + i*180))-yoff,800,18*GameTables[i].getRowCount() + 18);
                } else {
                    GameLabels[i].reshape(200,0-yoff, 200,100);
                    if (GameTables[i].getRowCount() > 7)
                        GamePanes[i].reshape(10,60-yoff,800,150);
                    else
                        GamePanes[i].reshape(10,60-yoff,800,18*GameTables[i].getRowCount() + 18);
                }
                GameTables[i].setCellSelectionEnabled(false);
                GameTables[i].setColumnSelectionAllowed(true);
                pergamePanel.add(GameLabels[i]);
                pergamePanel.add(GamePanes[i]);
            }
            pergameBackgroundLabel.reshape(0,0,950,700);
            pergamePanel.add(pergameBackgroundLabel);
            pergamePanel.updateUI();
                    
            loadingFrame.hide();
        }
    }
    
    public class ScrollBarHandler implements AdjustmentListener  {
        public void adjustmentValueChanged(AdjustmentEvent e) {
            yoff = pergameScrollBar.getValue()*12;
            if (GamePanes.length == 0) yoff = 1;
            for (int i = 0;i < GamePanes.length;i++) {
                if (i != 0) {
                    GameLabels[i].reshape(200,(GameTables[i-1].getY() + i*180)-yoff, 200,100);
                    if (GameTables[i].getRowCount() > 7)
                        GamePanes[i].reshape(10,(60+(GameTables[i-1].getY() + i*180))-yoff,800,150);
                    else
                        GamePanes[i].reshape(10,(60+(GameTables[i-1].getY() + i*180))-yoff,800,18*GameTables[i].getRowCount() + 18);
                } else {
                    GameLabels[i].reshape(200,0-yoff, 200,100);
                    if (GameTables[i].getRowCount() > 7)
                        GamePanes[i].reshape(10,60-yoff,800,150);
                    else
                        GamePanes[i].reshape(10,60-yoff,800,18*GameTables[i].getRowCount() + 18);
                }
            }
            pergamePanel.updateUI();
        }
    }
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.trim().equals("Exit"))
            System.exit(0);
        else if (cmd.trim().equals("Open")) {
            //This is a hack, in order to get the loading pop-up working
			doFileChooser = true;
            p = new Thread(jl);
            p.start();
        } else if (cmd.trim().equals("Show Bots")) {
			doFileChooser = false;
			p = new Thread(jl);
			p.start();
		}
    }
    
    public class WindowHandler extends WindowAdapter {
        public void windowClosing(WindowEvent e) {
            System.exit(0);
        }
    }
    
    
    static public void main(String args[]) {
        jl = new jlogan();
        //This is a hack, in order to get the loading pop-up working
        p = new Thread(jl);
        p.start();
    }
}



class q3aloganalyzer {
    ParsedFile pfile;
    boolean addBots = false;
    
    q3aloganalyzer(String fname, boolean showBots) {
        pfile = new ParsedFile();
		addBots = showBots;
        try {
        	ParseLog(fname);
        } catch (Exception e) {
            System.out.println("Unexpected Exception " + e.getMessage());
        }
    }
    
    public ParsedFile GetParsedFile() {
        return pfile;
    }
    
    public void ParseLog(String lname) throws Exception {
        BufferedReader br = new BufferedReader(new FileReader(lname));
        RE rinitgame = new RE();
        RE rbotconnect = new RE();
        RE rclientconnect = new RE();
        RE rkill = new RE();
        RE rexit = new RE();
        RE rshutdowngame = new RE();
        RE ritem = new RE();
        RECompiler compiler = new RECompiler();
        boolean ret;
        String line, lastline;
        int i = 0, g = 0;
        int bot = 0;
        int exit = 0;
        line = new String();
        lastline = new String();
        Game cg = new Game();
        int cgi = 0;
        Player p = new Player();
        pfile = new ParsedFile();
        
        long rtime1, rtime2 = 0, rtime3 = 0;
        long itemtime1 = 0, itemtime2 = 0;
        long begin, end;
        begin = System.currentTimeMillis();
        
        rtime1 = System.currentTimeMillis();
        rinitgame.setProgram(compiler.compile("^([ ]+)([0-9]+):([0-9]+) InitGame:([^]+)mapname\\\\([^]+)\\\\protocol"));
        rbotconnect.setProgram(compiler.compile("^([ ]+)([0-9]+):([0-9]+) ClientUserinfoChanged: ([^]+) n\\\\([^]+)\\\\t\\\\([^]+)skill"));
        rclientconnect.setProgram(compiler.compile("^([ ]+)([0-9]+):([0-9]+) ClientUserinfoChanged: ([^]+) n\\\\([^]+)\\\\t\\\\"));
        rkill.setProgram(compiler.compile("^([ ]+)([0-9]+):([0-9]+) Kill: ([^]+) ([^]+) ([^]+): ([^]+) killed ([^]+) by ([^]+)"));
        rexit.setProgram(compiler.compile("^([ ]+)([0-9]+):([0-9]+) Exit:"));
        rshutdowngame.setProgram(compiler.compile("^([ ]+)([0-9]+):([0-9]+) ShutdownGame:"));
        ritem.setProgram(compiler.compile("Item:"));
        rtime2 = rtime2 + (System.currentTimeMillis() - rtime1);
        
        while (br.ready()) {
            lastline = line;
            line = br.readLine();
            bot = 0;
            try {
                if (line == null)
                    break;
                
                
                //The regexp matches should always be in order of number of occurences in the logfile.  So, for instance,
                //Items are first, kills next, etc.  Also, there should always be a "continue" statement at the end of testing
                //for each match, so that if it matches, it doesn't check the others.
                
                // This regexp match should ALWAYS be first, as "Item:" is the most common (by far) line in any logfile
                // However, if logging of items has been turned off, it can (and should) be commented out ;-)
                // I should probably have that as an option, shouldn't I?
                rtime1 = System.currentTimeMillis();
                itemtime1 = rtime1;
                ret = ritem.match(line);
                rtime2 = rtime2 + (System.currentTimeMillis() - rtime1);
                itemtime2 = itemtime2 + (System.currentTimeMillis() - itemtime1);
                if (ret)
                    continue;
                
                rtime1 = System.currentTimeMillis();
                ret = rkill.match(line);
                rtime2 = rtime2 + (System.currentTimeMillis() - rtime1);
                //Kill
                if (ret && !(rkill.getParen(7).trim().equals(rkill.getParen(8).trim())) && !(rkill.getParen(7).trim().equals("<world>"))) {
                    String weapon = new String(rkill.getParen(9));
                    String killer = new String(rkill.getParen(7));
                    String victim = new String(rkill.getParen(8));
                    Victim v = new Victim();
                    v.killer = killer;
                    v.victim = victim;
                    if (weapon.equals("MOD_GAUNTLET"))
                        v.killedwith[0]++;
                    else if (weapon.equals("MOD_MACHINEGUN"))
                        v.killedwith[1]++;
                    else if (weapon.equals("MOD_SHOTGUN"))
                        v.killedwith[2]++;
                    else if (weapon.equals("MOD_ROCKET") || weapon.equals("MOD_ROCKET_SPLASH"))
                        v.killedwith[3]++;
                    else if (weapon.equals("MOD_GRENADE") || weapon.equals("MOD_GRENADE_SPLASH"))
                        v.killedwith[4]++;
                    else if (weapon.equals("MOD_LIGHTNING"))
                        v.killedwith[5]++;
                    else if (weapon.equals("MOD_PLASMA") || weapon.equals("MOD_PLASMA_SPLASH"))
                        v.killedwith[6]++;
                    else if (weapon.equals("MOD_RAILGUN"))
                        v.killedwith[7]++;
                    else if (weapon.equals("MOD_BFG") || weapon.equals("MOD_BFG_SPLASH"))
                        v.killedwith[8]++;
                    cg.AddKill(v);
                    pfile.AddPlayerKill(v);
                    continue;
                }

                //Suicide
                if (ret && rkill.getParen(7).trim().equals(rkill.getParen(8)) && !(rkill.getParen(7).trim().equals("<world>"))) {
                    for (i = 0;i < pfile.players.size();i++) {
                        if (rkill.getParen(8).equals(((Player)pfile.players.elementAt(i)).name)) {
                            ((Player)pfile.players.elementAt(i)).totalsuicides++;
                            ((Player)pfile.players.elementAt(i)).gamesuicides[((Player)pfile.players.elementAt(i)).numgames]++;
                        }
                    }
                    continue;
                }
                

                //Suicide
                if (ret && rkill.getParen(7).trim().equals("<world>")) {
                    for (i = 0;i < pfile.players.size();i++) {
                        if (rkill.getParen(8).equals(((Player)pfile.players.elementAt(i)).name)) {
                            ((Player)pfile.players.elementAt(i)).totalsuicides++;
                            ((Player)pfile.players.elementAt(i)).gamesuicides[((Player)pfile.players.elementAt(i)).numgames]++;
                        }
                    }
                    continue;
                }
                
                rtime1 = System.currentTimeMillis();
                //Bot Connect
                ret = rbotconnect.match(line);
                rtime2 = rtime2 + (System.currentTimeMillis() - rtime1);
                if (ret) {
                    if (addBots)
                        bot = 0;
                    else
                        bot = 1;
                    //continue;
                }
                
                //Client Connect
                rtime1 = System.currentTimeMillis();
                ret = rclientconnect.match(line);
                rtime2 = rtime2 + (System.currentTimeMillis() - rtime1);
                if (ret && bot == 0) {
                    String n = rclientconnect.getParen(5);
                    RE r = new RE();
                    r.setProgram(compiler.compile("^([^]*):([^]*) ClientConnect: ([^]*)"));
                    if (r.match(lastline)) {
                        p = new Player();
                        p.name = n;
                        cg.AddPlayer(p.name);
                        for (i = 0;i < pfile.players.size();i++) {
                            if (p.name.equals(((Player)pfile.players.elementAt(i)).name))
                                break;
                        }
                        if (i >= pfile.players.size())
                            pfile.players.add(p);
                        ((Player)pfile.players.elementAt(i)).gbegin = (new Integer(rclientconnect.getParen(2).trim()).intValue())*60 + (new Integer(rclientconnect.getParen(3).trim()).intValue());
                    }
                    continue;
                }
                
                
                rtime1 = System.currentTimeMillis();
                //InitGame
                ret = rinitgame.match(line);
                rtime2 = rtime2 + (System.currentTimeMillis() - rtime1);
                if (ret) {
                    
                    if (exit == 1) {
                        cgi++;
                    }
                    cg = new Game();
                    cg.SetMap(rinitgame.getParen(5));
                    exit = 0;
                    continue;
                }
                
                
                
                rtime1 = System.currentTimeMillis();
                ret = rexit.match(line);
                rtime2 = rtime2 + (System.currentTimeMillis() - rtime1);
                //Exit
                if (ret) {
                    exit = 1;
                    continue;
                }
                
                rtime1 = System.currentTimeMillis();
                ret = rshutdowngame.match(line);
                rtime2 = rtime2 + (System.currentTimeMillis() - rtime1);
                //ShutdownGame
                if (ret && exit == 1) {
                    pfile.games.add(cg);
                    for (i = 0;i < ((Game)pfile.games.elementAt(cgi)).players.size();i++) {
                        for (int j = 0;j < pfile.players.size();j++) {
                            if (((String)((Game)pfile.games.elementAt(cgi)).players.elementAt(i)).equals(((Player)pfile.players.elementAt(j)).name)) {
                                ((Player)pfile.players.elementAt(j)).games[((Player)pfile.players.elementAt(j)).numgames] = ((Game)pfile.games.elementAt(cgi));
                                ((Player)pfile.players.elementAt(j)).gend = (new Integer(rshutdowngame.getParen(2).trim()).intValue())*60 + (new Integer(rshutdowngame.getParen(3).trim()).intValue());
                                ((Player)pfile.players.elementAt(j)).gametime[((Player)pfile.players.elementAt(j)).numgames] += ((Player)pfile.players.elementAt(j)).gend - ((Player)pfile.players.elementAt(j)).gbegin;
                                ((Player)pfile.players.elementAt(j)).time += ((Player)pfile.players.elementAt(j)).gametime[((Player)pfile.players.elementAt(j)).numgames];
                                ((Player)pfile.players.elementAt(j)).numgames++;
                            }
                        }
                    }
                    continue;
                } else if (ret && exit == 0) {
                    for (i = 0;i < pfile.players.size();i++) {
                        ((Player)pfile.players.elementAt(i)).gametime[((Player)pfile.players.elementAt(i)).numgames] = 0;
                        ((Player)pfile.players.elementAt(i)).gamefrags[((Player)pfile.players.elementAt(i)).numgames] = 0;
                        ((Player)pfile.players.elementAt(i)).gamedeaths[((Player)pfile.players.elementAt(i)).numgames] = 0;
                        ((Player)pfile.players.elementAt(i)).gamesuicides[((Player)pfile.players.elementAt(i)).numgames] = 0;
                        
                    }
                    continue;
                }
                
            } catch (Exception e) {
                System.err.println("Unexpected Exception: " + e.getMessage());
                e.printStackTrace();
                System.exit(1);
            }
           
        }
        try {
            end = System.currentTimeMillis();
            //System.out.println(((float)rtime2/1000) + " seconds spent in regexp matching, out of " + ((float)(end-begin)/1000) + " total.");
            //System.out.println(((float)itemtime2/1000) + " seconds spent in item matching.");
        for (int j = 0;j < pfile.players.size();j++) {
            Player pl = new Player(((Player)pfile.players.elementAt(j)));
        /*    System.out.println("------------------------------------------");
            System.out.println("Name: " + pl.name);*/
            
            ((Player)pfile.players.elementAt(j)).skill = ((float)pl.totalfrags/((pl.totaldeaths) + (pl.totalsuicides)));
            if (((Player)pfile.players.elementAt(j)).time <= 0) {
		pfile.players.removeElementAt(j);
		j--;
	    }
            /*System.out.println("Skill: " + pl.skill);
            System.out.println("Total Frags: " + pl.totalfrags);
            System.out.println("Total Deaths: " + pl.totaldeaths);
            System.out.println("Total Suicides: " + pl.totalsuicides);
            System.out.println("Total Time: " + ((float)pl.time/60) + " minutes");
            System.out.println("Frags Per Minute: " + ((float)pl.totalfrags/(pl.time/60)));
            for (i = 0;i < pl.numgames;i++) {
                System.out.println("Game: " + pl.games[i].GetMap());
                System.out.println("\tFrags: " + pl.gamefrags[i]);
                System.out.println("\tDeaths: " + pl.gamedeaths[i]);
                System.out.println("\tSuicides: " + pl.gamesuicides[i]);
                System.out.println("\tTime: " + pl.gametime[i]/60 + " minutes");
                if (pl.gametime[i] != 0) System.out.println("\tFPM: " + ((float)pl.gamefrags[i]/(pl.gametime[i]/60)));
            }*/
        }
        } catch (Exception e) {
               System.err.println("Unexpected Exception: " + e.getMessage());
                e.printStackTrace();
                System.exit(1);
        }
    }
}

class ParsedFile {
    public Vector players;
    public Vector games;
    ParsedFile() {
        players = new Vector();
        games = new Vector();
    }
    public void AddPlayerKill(Victim v) {
        Victim newv = new Victim(v);
        for (int i = 0;i < players.size();i++) {
            if (newv.killer.equals(((Player)players.elementAt(i)).name)) {
                for (int j = 0;j < 9;j++) {
                    int cgi = ((Player)players.elementAt(i)).numgames;
                    ((Player)players.elementAt(i)).totalfrags += newv.killedwith[j];
                    ((Player)players.elementAt(i)).totalkilledwith[j] += newv.killedwith[j];
                    ((Player)players.elementAt(i)).gamefrags[cgi] += newv.killedwith[j];
                }
                ((Player)players.elementAt(i)).kills.AddKill(newv);
            }
        }
        for (int i = 0;i < players.size();i++) {
            if (newv.victim.equals(((Player)players.elementAt(i)).name)) {
                for (int j = 0;j < 9;j++) {
                    int cgi = ((Player)players.elementAt(i)).numgames;
                    ((Player)players.elementAt(i)).totaldeaths += newv.killedwith[j];
                    ((Player)players.elementAt(i)).totalkilledby[j] += newv.killedwith[j];
                    ((Player)players.elementAt(i)).gamedeaths[cgi] += newv.killedwith[j];
                }
            }
        }
    }
    public Player GetPlayer(String n) {
        for (int i = 0;i < players.size();i++) {
            if (((Player)players.elementAt(i)).name.equals(n))
                return ((Player)players.elementAt(i));
        }
        return null;
    }
    public void AddPlayer(Player p) {
        players.add(p);
    }
}

class Player {
    int MAX_GAMES;
    public String name;
    public int totalfrags;
    public int totaldeaths;
    public int totalsuicides;
    public int totalkilledby[];
    public int totalkilledwith[];
    public float skill;
    public long time;
    public int numgames;
    public Game games[];
    public int gamefrags[];
    public int gamedeaths[];
    public int gamesuicides[];
    public int gametime[];
    public Kills kills;
    public int gbegin; // temp variable
    public int gend; // temp variable
    public int gamecount; // temp variable
    
    Player() {
        MAX_GAMES = 1000;
        games = new Game[MAX_GAMES];
        gamefrags = new int[MAX_GAMES];
        gamedeaths = new int[MAX_GAMES];
        gamesuicides = new int[MAX_GAMES];
        gametime = new int[MAX_GAMES];
        kills = new Kills();
        totalkilledby = new int[9];
        totalkilledwith = new int[9];
        totalfrags = 0;
        totaldeaths = 0;
        totalsuicides = 0;
        skill = 0;
        time = 0;
        numgames = 0;
        gend = 0;
        gbegin = 0;
        gamecount = 0;
    }
    Player(Player p) {
        MAX_GAMES = p.MAX_GAMES;
        games = new Game[MAX_GAMES];
        gamefrags = new int[MAX_GAMES];
        gamedeaths = new int[MAX_GAMES];
        gamesuicides = new int[MAX_GAMES];
        gametime = new int [MAX_GAMES];
        kills = new Kills(p.kills);
        totalkilledby = new int[9];
        totalkilledwith = new int[9];
        for (int i = 0;i < 9;i++) {
            totalkilledby[i] = p.totalkilledby[i];
            totalkilledwith[i] = p.totalkilledwith[i];
        }
        for (int i = 0;i < p.numgames;i++) {
            games[i] = new Game(p.games[i]);
            gamefrags[i] = p.gamefrags[i];
            gamedeaths[i] = p.gamedeaths[i];
            gamesuicides[i] = p.gamesuicides[i];
            gametime[i] = p.gametime[i];
        }
        totalfrags = p.totalfrags;
        totaldeaths = p.totaldeaths;
        totalsuicides = p.totalsuicides;
        skill = p.skill;
        time = p.time;
        numgames = p.numgames;
        name = p.name;
        gend = p.gend;
        gbegin = p.gbegin;
        gamecount = p.gamecount;
    }
    
    int GetKillsOf(String vict) {
        Vector v = new Vector(kills.GetKills());
        int ks = 0;
        
        for (int i = 0;i < v.size();i++) {
            if (vict.equals(((Victim)v.elementAt(i)).victim)) {
                for (int j = 0;j < 9;j++)
                    ks += ((Victim)v.elementAt(i)).killedwith[j];
                return ks;
            }
        }
        return 0;
    }
}

class Kills {
    private Vector victims;
    
    Kills() {
        victims = new Vector();
    }
    Kills(Kills k) {
        victims = k.victims;
    }
    
    public void AddKill(Victim vict) {
        Victim v = new Victim(vict);
        int newkiller = 1;
        for (int i = 0;i < victims.size();i++) {
            if (((Victim)victims.elementAt(i)).killer.equals(v.killer) && ((Victim)victims.elementAt(i)).victim.equals(v.victim)) {
                for (int j = 0;j < 9;j++) {
                    ((Victim)victims.elementAt(i)).killedwith[j] += v.killedwith[j];
                }
                newkiller = 0;
            }
        }
        if (newkiller == 1) {
            victims.add(v);
        }
    }
    public void UpdateKill(String killer, String victim, int killedwith) {
        for (int i = 0;i < victims.size();i++) {
            if (((Victim)victims.elementAt(i)).killer.equals(killer) && ((Victim)victims.elementAt(i)).victim.equals(victim)) {
                ((Victim)victims.elementAt(i)).killedwith[killedwith]++;
            }
        }
    }
    public Vector GetKills() {
        return victims;
    }
}

class Victim {
    public String killer;
    public String victim;
    public int killedwith[];
    Victim() {
        killedwith = new int[9];
        killer = new String();
        victim = new String();
        for (int i = 0;i < 9;i++)
            killedwith[i] = 0;
    }
    Victim(Victim v) {
        killedwith = new int[9];
        killer = v.killer;
        victim = v.victim;
        for (int i = 0;i < 9;i++)
            killedwith[i] = v.killedwith[i];
    }
}

class Game {
    public Vector players;
    private Kills kills;
    private String map;
    
    Game() {
        map = new String();
        players = new Vector();
        kills = new Kills();
    }
    Game(Game g) {
        map = new String(g.map);
        players = new Vector(g.players);
        kills = new Kills(g.kills);
    }
    
    public void AddKill(Victim v) {
        kills.AddKill(v);
    }
    public void AddPlayer(String player) {
        for (int i = 0;i < players.size();i++) {
            if (player.equals(((String)players.elementAt(i))))
                return;
        }
        players.add(player);
    }
    public void SetMap(String m) {
        map = m;
    }
    public String GetMap() {
        return map;
    }
    public Kills GetKills() {
        return kills;
    }
    public Vector GetPlayers() {
        return players;
    }
}
