
// random.c

#include "random.h"

static long r[100]; // "global" random table -- must be visible to rand and init_rand

// return a random number in the range 0 to 999999999
int rand (void)
{
	long i = r[98];
	long j = r[99];

	long k = 0, t = 0;

	if ( (t = r[i] - r[j]) < 0)
		t += 1000000000;

	r[i] = t;

	r[98]--; 
	if (r[98] == 0)
		r[98] = 55;
	
	r[99]--;	
	if (r[99] == 0)
		r[99] = 55;

	k = r[100] % 42 + 56;

	r[100] = r[k];

	r[k] = t;

	return (r[100]);

}

// seed the random number table
long init_rand (char *seed)
{
	char buf[101];
	long i = 0, j = 0, k = 0;

	if (strlen (seed) > 85)
		return 0;

	sprintf (buf, "aEbFcGdHeI  %s", seed);

	while (strlen(buf) < 98)
		strcat (buf, " ");

	for (i = 1; i < 98; i++)
		r[i] = buf[i] * 8171717 + i * 997;

	i = 97;
	j = 12;

	for (k = 0; k < 998; k++)
	{
		r[i] -= r[j];
		if (r[i] < 0)
			r[i] += 1000000000;

		i--;
		if (i == 0)
			i = 97;

		j--;
		if (j == 0)
			j = 97;
	}

	r[98] = 55;
	r[99] = 24;
	r[100] = 77;

}
