
// PathFinder Algorithm II (PFA II)
#include "pfa.h"

extern	node_info Graph[MAX_NODES];

void main (void)
{

	int		i, j;
	distance_t dist=(distance_t)0;					// needed for Dijkstra
	int	path[MAX_NODES];							// needed for Dijkstra
	char	c;
	int		loops = 0;

	int	source, target;

	source = 1;//1;
	target = 7;//100;

	init_rand ("legion");
	
	printf ("Please be patient.   Preparing tables.\n");
	
	start_time ();

	create_tables ();
	
	printf ("Tables completed\n");
	prn_time ();

	InitGraph (Graph);
	
	if (numnodes == -1)
		exit(1);

	iterations = 0;
	for (j = 0; j <numnodes;j++)
	{
		for (i = 0; i < numnodes; i++)
		{
		
			if (link_table[j][i] == NO_LINK)
				break;

			iterations++;			
		}
	}


	source = 1;//1;
	target = 100;//100;

	printf ("Number of nodes = %d, source = %d, target = %d, links = %d\n\n", numnodes, source, target, iterations);
	loops = 1;

	start_time ();
	iterations = 0;
	printf ("Dijkstra's Algorithm: Original\n");
	for (i = 0; i < loops; i++)
		Dijkstra_ShortestPath (source, target, path);

	display_dijkstra_path (source, target );

	Dijkstra_ShortestPath (target, source, path);
	display_dijkstra_path (target, source);


	prn_time ();

	InitGraph (Graph);
	start_time ();

	printf ("New Navigator Algorithm\n");
	//for (i = 0; i < loops; i++)
	//Graphweb (Graph, source, target);

	if (!load_graph(Graph))
		Graphmon (Graph);

	//display_navigator_path (Graph, source, target);
	display_dijkstra_path (source, target);
	display_dijkstra_path (target, source);

	//display_navigator_path (Graph, target, source);

	prn_time ();
	printf ("Saving graph matrix\n");
	save_graph (Graph);




	printf ("Press enter to continue\n");
	scanf ("%c", &c);

	InitGraph (Graph);
	printf ("Modified Navigator Algorithm for one-way paths\n");
	start_time ();
	slow_Graphmon (Graph);
	
	display_dijkstra_path (source, target);
	display_dijkstra_path (target, source);

	prn_time ();


	InitGraph (Graph);
	printf ("Original Navigator Algorithm \n");
	start_time ();
	//for (i = 0; i < loops; i++)
	//	original_Graphweb (Graph, source, target);
	original_Graphmon (Graph);

	//display_dijkstra_path (source, target);
	//display_dijkstra_path (target, source);
	printf ("Paths are printed in reverse!!!\n");
	display_navigator_path (Graph, source, target);
	display_navigator_path (Graph, target, source);

	prn_time ();

}


