#include "navigator.h"

#include <stdio.h>

void InitGraph(node_info Graph[])  
{
	// InitGraph goes through the used portion of the Graph[] array and initializes the array's and nodes' values to acceptable beginning parameters for the algorithm. 
	int i = 0, j = 0;

	for (i = 0; i <numnodes; i++)
	{
		Graph[i].visited = 0;
		for (j = 0; j < numnodes; j++)
		{
			Graph[i].dist[j] = (distance_t)INFINITY;
			Graph[i].last[j] = NO_LINK;
		}
	}
}	

void save_graph (node_info Graph[])
{
	int		i, j;
	distance_t	dist;
	int		last;
	FILE	*output;

	output = fopen ("nodes.pth", "wb");

	fwrite (&numnodes, sizeof(int), 1, output);

	
	for (i = 0; i < numnodes; i++)
	{
		for (j = 0; j < numnodes; j++)
		{
			last = Graph[i].last[j];
			dist = Graph[i].dist[j];
			
			fwrite (&last, sizeof (int), 1, output);
			fwrite (&dist, sizeof (distance_t), 1, output);

		}
	}
	

	fclose (output);

}

int load_graph (node_info Graph[])
{
	int		i, j;
	distance_t	dist;
	int		last;
	FILE	*input;

	input = fopen ("nodes.pth", "rb");

	if (!input)
	{
		printf ("No path file found\n");
		return 0;
	}

	printf ("Loading path file\n");

	fread (&numnodes, sizeof(int), 1, input);

	for (i = 0; i < numnodes; i++)
	{
		for (j = 0; j < numnodes; j++)
		{
			fread (&last, sizeof (int), 1, input);
			fread (&dist, sizeof (distance_t), 1, input);

			Graph[i].last[j] = last;
			Graph[i].dist[j] = dist;
			
		}
	}

	fclose (input);
	return 1;

}

// graphmon simply calls Graphweb for each node in the graph.  It was separated for debugging and timing concerns. 
void Graphmon (node_info Graph[])
{
	int i = 0;

	// comment out the following two lines of code
	// if you want to calculate paths to a final
	// destination only.
	for (i = 0; i < numnodes; i++)
		Graphweb (Graph, ALL_PATHS, i);
	
	//Graphweb (Graph, 100); //100 = node #100 is final destination
}	

void slow_Graphmon (node_info Graph[])
{
	int i = 0;

	// comment out the following two lines of code
	// if you want to calculate paths to a final
	// destination only.
	for (i = 0; i < numnodes; i++)
		slow_Graphweb (Graph, ALL_PATHS, i);
	
	//Graphweb (Graph, 100); //100 = node #100 is final destination
}	

void original_Graphmon (node_info Graph[])
{
	int i = 0;

	// comment out the following two lines of code
	// if you want to calculate paths to a final
	// destination only.
	for (i = 0; i < numnodes; i++)
		original_Graphweb (Graph, ALL_PATHS, i);
	
	//Graphweb (Graph, 100); //100 = node #100 is final destination
}	

void Graphweb(node_info Graph[], int src, int k)	// k is the node to be used as a base. 
{

	int i, w, v = 0;
	distance_t min;

	link			*element			= NULL;
	link			*counter			= NULL;
	link			*open_list			= NULL;
	link			*previous_element	= NULL;
	link			*previous			= NULL;


	Graph[k].dist[k] = (distance_t)0;	// itself to zero.
	
	for(i=0; i < numnodes; i++)		// check direct connections 
	if( i != k ) 					// make sure we don't repeat ourselves. . . 
	{
			 
		Graph[i].last[k] = k;
		Graph[i].dist[k] = distance_table[i][k];

		// create the list of visited nodes
		if (!open_list)
		{
			open_list = malloc(sizeof (link));
			open_list->id = i;
			counter = open_list;
		}
		else
		{
			add_element_to_list (counter, i);
			counter = counter->next;
		}

	}

	// clean up list, end list with NULL 
	counter->next = NULL;

	for(i = 0; i < numnodes; i ++)	// now, for a sweep through the 
	{		  
		if (i != k) 						// non-connected nodes! 
		{
			min = (distance_t)INFINITY;

			previous = NULL;
			previous_element = NULL;
			counter = open_list;
			element = NULL;
			while (counter)
			{
				w = counter->id;

				if (Graph[w].dist[k] < min)	// if not, has it a shorter path to k? 
				{
						
					if (Graph[w].dist[k] < INFINITY)
					{
						v=w;
						min=Graph[w].dist[k];		// if so, mark it down as the new 
													// shortest path!

						// mark element for deletion
						element = counter;

						// mark previous element for attachment
						previous_element = previous;
					}						

				}
			
				// save previous counter for use in deletion process
				previous = counter;

				// increment counter
				counter = counter->next;

			}
		
			// if element exists, delete the element from the list
			if (previous_element)
			{
			
				if (element)
				{
					previous_element->next = element->next;
					free (element);
				}				

			}		
			else
			{
				if (element)
				{
					open_list = element->next;
					free (element);
				}
		
			}

			counter = open_list;
			while (counter)
			{
				w = counter->id;
	
				
				if (distance_table[w][v] != INFINITY)
				{
					if (min + distance_table [w][v] < Graph[w].dist[k])
					{
						// Change the shortest path between this node and k! 
						Graph[w].dist[k] = min + distance_table[w][v];	// for asymetric node systems, this can be inaccurate
						Graph[w].last[k] = v;  // accurate even if node systems is not symmetrical (e.g. there's one way links)			
	
					}
				}
				counter = counter->next;
			}

		}

		if (v == src)  // use value of src like -10 if you want to calculate all paths
			break;

	}// for-i

	// now delete any remaining elements in the open list
	delete_list (open_list);
}


void slow_Graphweb(node_info Graph[], int src, int k)	// k is the node to be used as a base. 
{

	int i, w, v = 0;
	distance_t min;


	Graph[k].dist[k] = (distance_t)0;	// itself to zero.
	Graph[k].visited = 1;
	
	for(i=0; i < numnodes; i++)		// check direct connections 
	if( i != k ) 					// make sure we don't repeat ourselves. . . 
	{
			 
		Graph[i].visited = 0;
		Graph[i].last[k] = k;
		Graph[i].dist[k] = distance_table[i][k];
	}

	for(i = 0; i < numnodes; i ++)	// now, for a sweep through the 
	{		  
		if (i != k) 						// non-connected nodes! 
		{
			min = (distance_t)INFINITY;

			for (w = 0; w < numnodes; w++)
			{

				if (w != k)
				{
					if (Graph[w].visited != 1)
					{
						if (Graph[w].dist[k] < min)	// if not, has it a shorter path to k? 
						{
								
							if (Graph[w].dist[k] < INFINITY)
							{
								v=w;
								min=Graph[w].dist[k];		// if so, mark it down as the new 
														// shortest path!
							}						
	
						}
					}
				}			
			}

			Graph[v].visited = 1;
		
			for (w = 0; w < numnodes; w++)
			{
				if (w != k)
				{
					if (Graph[w].visited != 1)
					{
						if (distance_table[w][v] != INFINITY)
						{
							if (min + distance_table [w][v] < Graph[w].dist[k])
							{
								// Change the shortest path between this node and k! 
								Graph[w].dist[k] = min + distance_table[w][v];	// for asymetric node systems, this can be inaccurate
								Graph[w].last[k] = v;  // accurate even if node systems is not symmetrical (e.g. there's one way links)			
	
							}
						}
					}
				}

			}

		}

		if (v == src)  // use value of src like -10 if you want to calculate all paths
			break;

	}// for-i

}

void original_Graphweb(node_info Graph[], int src, int k)	// k is the node to be used as a base. 
{

	int i, w, v = 0;
	distance_t min;


	Graph[k].dist[k] = (distance_t)0;	// itself to zero.
	Graph[k].visited = 1;
	
	for(i=0; i < numnodes; i++)		// check direct connections 
	if( i != k ) 					// make sure we don't repeat ourselves. . . 
	{
			 
		Graph[i].visited = 0;
		Graph[i].last[k] = k;
		Graph[i].dist[k] = distance_table[i][k];
		Graph[k].dist[i] = distance_table[k][i];
	}

	for(i = 0; i < numnodes; i ++)	// now, for a sweep through the 
	{		  
		if (i != k) 						// non-connected nodes! 
		{
			min = (distance_t)INFINITY;

			for (w = 0; w < numnodes; w++)
			{

				if (w != k)
				{
					if (Graph[w].visited != 1)
					{
						if (Graph[w].dist[k] < min)	// if not, has it a shorter path to k? 
						{
								
							v=w;
							min=Graph[w].dist[k];		// if so, mark it down as the new 
														// shortest path!
						}
					}
				}			
			}

			Graph[v].visited = 1;
		
			for (w = 0; w < numnodes; w++)
			{
				if (w != k)
				{
					if (Graph[w].visited != 1)
					{
						if (distance_table[v][w] < INFINITY) // bug in original, this
							// if statement is needed to make sure distances don't go
							// over max allowable valuable for integers.  Otherwise,
							// adding something to that value will make it negative
							// which satisfies the second if statement below!
						{
							if (min + distance_table [v][w] < Graph[w].dist[k])
							{
								// Change the shortest path between this node and k! 
								Graph[w].dist[k] = min + distance_table[v][w];	// for asymetric node systems, this can be inaccurate
								Graph[k].dist[w] = min + distance_table[w][v];
								Graph[w].last[k] = v;  // accurate even if node systems is not symmetrical (e.g. there's one way links)			
	
							}
						}
					}
				}

			}

		}

		if (v == src)  // use value of src like -10 if you want to calculate all paths
			break;

	}// for-i

}

void display_list_path (int source, int target)
{
	int i = 0, ptr;

	// NOTE: if a path exists from a->b but matrix was not fully calculated yet,
	// this function can lead to infinite looping or accessing an element in the
	// the matrix that does not exist.  So check for bad results.

	ptr = source;
	
	printf ("Display path list: ");
	if (Graph[source].dist[target] >= INFINITY)
		printf (" No connection exists.\n");
	else
	{
		//printf (" Shortest Path between nodes %d and %d = %f  \n", last, first, dist);
		printf (" %d", source);
		while (ptr != target)
		{
			//iterations++;
			if (ptr < 0 || ptr>numnodes)
				break;
			
			printf (" %d", Graph[ptr].last[target]);
			ptr = Graph[ptr].last[target];
		}

	}
	printf ("\n");
	//printf ("\ndist to target: %d\n", Graph[source].dist[target]);
	

}
// DisplayPath takes two points on the graph specified by the user and returns the (already calculated) shortest path between them. 
void display_navigator_path (node_info Graph[], int first, int last)
{

	// want
	// first = source
	// last = target
	int i = 0, ptr;

	// NOTE: if a path exists from a->b but matrix was not fully calculated yet,
	// this function can lead to infinite looping or accessing an element in the
	// the matrix that does not exist.  So check for bad results.

	ptr = last;
	
	//if (Graph[first].dist[last] >= INFINITY)
	if (Graph[last].dist[first] >= INFINITY )
		printf (" No connection exists.\n");
	else
	{
		//printf (" Shortest Path between nodes %d and %d = %f  \n", last, first, dist);
		printf ("Path list: ");
		printf (" %d", last);
		while (ptr != first)
		{
			//iterations++;
			//if (ptr < 0 || ptr>numnodes)
			//	break;
			
			printf (" %d", Graph[ptr].last[first]);
			ptr = Graph[ptr].last[first];
		}

	}

	printf (" Dist = %d\n", Graph[last].dist[first]);

	// first = source
	// last = target
}	


