
#include "distance.h"
#include <stdio.h>
#include <math.h>

// ----------------------------------------------
// create_tables
// 
// randomly creates the distance table and
// creates the associate link table
// ----------------------------------------------
void create_tables (void)
{

	int i = 0, j = 0, k = 0;
	int l = 0, m = 0, n = 0;
	int	o = 0;

	
	FILE	*input;

	input = fopen("nodes.dat", "rb");

	if (input)
	{
		fclose (input);
		load_distance_table ();
		return;
	}
	
	printf ("No nodes.dat found.  Creating table.\n");

	
	init_rand ("legion");
	initialize_tables ();

	for (i = 0; i < MAX_NODES; i++)
	{
		location[i][0] = (int)(100000 + i * 32);
		location[i][1] = (int)(110000 + i * 16);		
		location[i][2] = (int)(120000 + i * 24);

		location[i][0] = (int)(10 + i * 3);
		location[i][1] = (int)(11 + i * 1);		
		location[i][2] = (int)(12 + i * 2);


	}

	for (i = 0; i < MAX_NODES; i++)
	{
		for (k = 0; k < MAX_LINKS; k++)
		{
			if (link_table[i][k] != NO_LINK)
				continue;

			m = 0;
			while (m == 0)
			{
				
				j = rand () % MAX_NODES;
				n = 0;
				for (l = 0; l < k; l++)			
					if (link_table[i][l] == j)
				{
					n = 1;
				}

				if (i == j)
					n = 1;

				if (!n)
				{
					int x, y, z, d;

					link_table[i][k] = j;

					x = location[i][0] - location[j][0];
					y = location[i][1] - location[j][1];
					z = location[i][2] - location[j][2];
					
					d = (x*x) + (y* y) + (z*z);
					distance_table[i][j] = d;//(int)sqrt((double) d);						

					m = 1;
					
					
					if (random() < 0.88)
					{

						for (o = 0; o < MAX_LINKS; o++)
						{
							if (link_table[j][o] == NO_LINK || link_table[j][o] == i)
							{								
								link_table[j][o] = i;
								distance_table[j][i] = distance_table[i][j];

								break;
							}

						}
					}

				}
			}
		}
	}

	numnodes = MAX_NODES;

	save_distance_table ();
	
}

// ----------------------------------------------
// initialize_tables
// 
// resets the values for distance table and
// resets link table
// ----------------------------------------------
void initialize_tables (void)
{
	int i = 0, j = 0;

	for (i = 0; i < MAX_NODES; i++)
		for (j = 0; j < MAX_NODES; j++)
	{
		distance_table[i][j] = (distance_t)INFINITY;
		link_table[i][j] = NO_LINK;
	}

}

void save_distance_table (void)
{
	int		i, j;
	distance_t	dist;
	FILE	*output;
	int		l;
	int		loc_x;
	int		loc_y;
	int		loc_z;

	distance_t	NO_DIST = (distance_t)INFINITY;

	output = fopen ("nodes.dat", "wb");
	
	printf ("Saving file...\n");

	fwrite (&numnodes, sizeof(int), 1, output);

	for (i = 0; i < numnodes; i++)
	{
		loc_x = location[i][0];
		loc_y = location[i][1];
		loc_z = location[i][2];
		fwrite (&loc_x, sizeof(int), 1, output);
		fwrite (&loc_y, sizeof(int), 1, output);
		fwrite (&loc_z, sizeof(int), 1, output);


		for (j = 0; j < MAX_LINKS; j++)
		{
			l = link_table[i][j];
			if (l != NO_LINK)
			{
				dist = (distance_t)distance_table[i][l];
				fwrite (&l, sizeof(int),1, output);
				fwrite (&dist, sizeof(distance_t),1, output);
			}
			else
			{
				fwrite (&l, sizeof(int), 1, output);
				break;					
			}
		}
	}
	fclose (output);

}

void load_distance_table (void)
{
	int		i, j;
	distance_t	dist;
	FILE	*input;
	int		l;

	int		loc_x;
	int		loc_y;
	int		loc_z;

	initialize_tables ();

	input = fopen ("nodes.dat", "rb");

	numnodes = 0;
	fread (&numnodes, sizeof(int), 1, input);

	printf ("Loading table...");
	if (numnodes > MAX_NODES)
	{
		printf ("\nMoron Alert: trying to load a file with too many nodes\n");
		numnodes = -1;
		return;
	}

	printf ("Number of nodes = %d\n", numnodes);

	for (i = 0; i < numnodes; i++)
	{
		fread (&loc_x, sizeof(int), 1, input);
		fread (&loc_y, sizeof(int), 1, input);
		fread (&loc_z, sizeof(int), 1, input);

		location[i][0] = loc_x;
		location[i][1] = loc_y;
		location[i][2] = loc_z;

		for (j = 0; j < MAX_LINKS; j++)
		{
			
			fread(&l, sizeof(int), 1, input);

			if (l != NO_LINK)
			{
				fread(&dist, sizeof(distance_t), 1, input);
				distance_table[i][l] = (distance_t)dist;

			}
				
			link_table[i][j] = l;
								
			if (l == NO_LINK)
				break;
		}
	}

	fclose (input);
}
