
#include "distance.h"

#ifndef __PFA_DIJKSTRA_H
#define __PFA_DIJKSTRA_H

#define kNoPredecessor   INFINITY

typedef enum {false, true}	bool;


// data types and typedefs
enum nodestate {SP_permanent, SP_tentative};

typedef  int	distance_t;


typedef unsigned short int	nodeid_t;  
typedef enum				nodestate     nodestate_t;

struct nodeinfo
{
	int				iPredecessor;
	distance_t				iDistance;

	nodestate_t		iState;
};

typedef struct	nodeinfo	nodeinfo_t;
	
nodeinfo_t NodeInfo[MAX_NODES];

bool Dijkstra_ShortestPath (int, int, int path[]);
bool dj (int source, int target, int path[]);

void display_dijkstra_path (int source, int target);


#endif
