
#include "dijkstra.h"
#include "navigator.h"



void add_element_to_list (link *current_element, int node)
{
   link *head;

   head =  malloc (sizeof ( struct link));
   current_element->next = head;

   head->id = node;
}

void delete_list (link *head)
{
   if (head)
   {
      delete_list (head->next);
      free (head);
   }
}


/* dj is a faster version ON AVERAGE than Dijkstra_ShortestPath */

bool dj (int source, int target, int path[])
{

	int		i, k, kNew;
	//double	minDist;
	distance_t		minDist;
   link           *element = NULL;
   link           *counter = NULL;
   link           *open_list = NULL;
   link           *previous_element = NULL;
   link           *previous = NULL;


	if (source == target)
		return false;

   // open_list is a linked list of nodes that have not
   // been visited yet.  Once a node has been visited,
   // it is removed from the list.
   // Maximum number of iterations for do loop approaches
   // 0.5 * NxN.  Original Dijkstra's maximum number
   // approaches NxN.

	// initialize state
	for (i = 0; i < numnodes; i++)
	{
		NodeInfo[i].iPredecessor	= kNoPredecessor;
		NodeInfo[i].iDistance		= (distance_t)INFINITY;
		if (i != source)
		{

			if (!open_list)
			{
				open_list = malloc(sizeof (link));
				open_list->id = i;
				counter = open_list;
				//printf ("Created open list\n");
			}
			else
			{
				add_element_to_list (counter, i);
				counter = counter->next;
			}
		}

	}

	counter->next = NULL;

	// start position, find a path from source to target
	NodeInfo[source].iDistance = (distance_t)0;
	NodeInfo[source].iState = SP_permanent;

	// k is working (permanent) node
	k = source;

	do
	{
		// kNew is the tentatively labeled node with smallest path size
		kNew	= INFINITY; 
		minDist = (distance_t)INFINITY;
	
		// is there a better path from k

		previous = NULL;
		previous_element = NULL;
		counter = open_list;
		while(counter)
		{
			distance_t	nodeIDistance;
			distance_t	nodeKDistance;
			distance_t	distanceKI;

			i = counter->id;

			nodeIDistance = NodeInfo[i].iDistance;
			nodeKDistance = NodeInfo[k].iDistance;
			distanceKI = distance_table[k][i];

			if ( (distanceKI != INFINITY) )// && (NodeInfo[i].iState == SP_tentative) )
			{
				if ( (nodeKDistance + distanceKI) < nodeIDistance)
				{
					NodeInfo[i].iPredecessor = k;
					NodeInfo[i].iDistance = nodeIDistance = nodeKDistance + distanceKI;
				}
			}

			if ( (nodeIDistance < minDist) )// && (NodeInfo[i].iState == SP_tentative) )
			{
				kNew = i;
				minDist = nodeIDistance;

				element = counter;
				previous_element = previous;
			}

         // since it is at end of i-loop, previous is always the
         // element prior to counter except for counter is at
         // the beginning of the list.  In such instances, previous
         // is NULL.
         previous = counter;
		 counter = counter->next;

		} // end for-i

		// bail out if no path can be found

		if (kNew == INFINITY)
			return false;

		// make that node permanent; there cannot exist a shorter path from source to k
		k = kNew;	

	    // remove element from list
		if (previous_element)
		{
			previous_element->next = element->next;
			free (element);

		}		
		else
		{
			open_list = element->next;
			free (element);
		
		}
		

	} while (k != target);

   // no longer need list so delete it
   delete_list (open_list);

	// copy path to output array
	i = 0; k = target;

	do
	{
		path[i++]	= k;
		k			= NodeInfo[k].iPredecessor;


	} while (k != INFINITY);

	i = 0; minDist = (distance_t)0;	
	do
	{
		if (i > 0)
		{
			minDist = minDist + distance_table[path[i]][path[i-1]];
			Graph[path[i]].last[target] = path[i-1];
			Graph[path[i]].dist[target] = (distance_t)minDist;

		}
	} while (path[i++] != source);

	return true;
}




bool Dijkstra_ShortestPath (int source, int target, int path[])
{

	int		i, k, kNew;
	//double	minDist;
	distance_t		minDist;

	if (source == target)
		return false;

	// initialize state
	for (i = 0; i < numnodes; i++)
	{
		NodeInfo[i].iPredecessor	= kNoPredecessor;
		NodeInfo[i].iDistance		= (distance_t)INFINITY;
		NodeInfo[i].iState			= SP_tentative;
	}

	// start position, find a path from source to target
	NodeInfo[source].iDistance = (distance_t)0;
	NodeInfo[source].iState = SP_permanent;

	// k is working (permanent) node
	k = source;

	do
	{
		// kNew is the tentatively labeled node with smallest path size
		kNew	= INFINITY; 
		minDist = (distance_t)INFINITY;
	
		// is there a better path from k
		for (i = 0; i < numnodes; i++)
		{
			distance_t	nodeIDistance;
			distance_t	nodeKDistance;
			distance_t	distanceKI;

			nodeIDistance = NodeInfo[i].iDistance;
			nodeKDistance = NodeInfo[k].iDistance;
			distanceKI = distance_table[k][i];

			if ( (distanceKI != INFINITY) && (NodeInfo[i].iState == SP_tentative) )
			{
				if ( (nodeKDistance + distanceKI) < nodeIDistance)
				{
					NodeInfo[i].iPredecessor = k;
					NodeInfo[i].iDistance = nodeIDistance = nodeKDistance + distanceKI;
				}
			}

			if ( (nodeIDistance < minDist)  && (NodeInfo[i].iState == SP_tentative) )
			{
				kNew = i;
				minDist = nodeIDistance;
			}
		} // end for-i

		// bail out if no path can be found

		if (kNew == INFINITY)
			return false;

		// make that node permanent; there cannot exist a shorter path from source to k
		k = kNew;	
		//NodeInfo[k].iDistance	= 0;
		NodeInfo[k].iState		= SP_permanent;
	} while (k != target);

	// copy path to output array
	i = 0; k = target;

	do
	{
		path[i++]	= k;
		k			= NodeInfo[k].iPredecessor;


	} while (k != INFINITY);


	i = 0; minDist = (distance_t)0;	
	do
	{
		if (i > 0)
		{
			minDist = minDist + distance_table[path[i]][path[i-1]];
			Graph[path[i]].last[target] = path[i-1];
			Graph[path[i]].dist[target] = (distance_t)minDist;
		}
	} while (path[i++] != source);

	return true;
}



void display_dijkstra_path (int source, int target)
{
	int i = 0, ptr;

	// NOTE: if a path exists from a->b but matrix was not fully calculated yet,
	// this function can lead to infinite looping or accessing an element in the
	// the matrix that does not exist.  So check for bad results.

	ptr = source;
	
	printf ("Display path list: ");
	if (Graph[source].dist[target] >= INFINITY)
		printf (" No connection exists.\n");
	else
	{
		printf (" %d", source);
		while (ptr != target)
		{
			if (ptr < 0 || ptr>numnodes)
				break;
			
			printf (" %d", Graph[ptr].last[target]);
			ptr = Graph[ptr].last[target];
		}

	}

	printf ("\ndist to target: %d\n", Graph[source].dist[target]);
	

}