
#include "time_keeper.h"

static time_keeper	tk;

void start_time (void)
{
	tk.begin_clock = tk.save_clock = clock ();
	tk.begin_time = tk.save_time = time (NULL);
}	

double prn_time (void)
{
	char	s1[MAX_STRING], s2[MAX_STRING];
	int		field_width, n1, n2;
	double	clocks_per_sec = (double) CLOCKS_PER_SEC, user_time, real_time;
	double	approx_time;

	user_time = (clock () - tk.save_clock) / clocks_per_sec;
	real_time = difftime (time(NULL), tk.save_time);
	tk.save_clock = clock ();
	tk.save_time = time (NULL);


	sprintf (s1, "%.1f", user_time);
	n1 = strlen (s1);
	sprintf (s2, "%.1f", real_time);
	n2 = strlen (s2);
	field_width = (n1 > n2) ? n1 : n2;

	approx_time = (user_time + real_time)/2;

	printf ("%s%*.1f%s  \n\n",
		"Approx. time: ", field_width, approx_time, " seconds");

	/*
	printf ("%s%*.1f%s  %s%*.1f%s\n\n",
		"User time: ", field_width, user_time, " seconds",
		"Real time: ", field_width, real_time, " seconds");
	*/
	return user_time;
}
