
// PathFinder Algorithm (PFA)
#include "pfa.h"

extern	double Fmatrix[MAX_NODES][MAX_NODES];
extern	node_info Graph[MAX_NODES];

void main (void)
{

	int		i, j;
	char	c;
	double dist;					// needed for Dijkstra
	int	path[MAX_NODES];			// needed for Dijkstra
	

	int	source, target;

	source = 0;//1;
	target = 3;//100;

	init_rand ("legion");
	
	printf ("Please be patient.   Preparing tables.\n");
	
	create_tables ();
	InitGraph (Graph);		
	//exit(1);

	if (numnodes == -1)
		exit(1);

	iterations = 0;
	for (j = 0; j <numnodes;j++)
	{
		for (i = 0; i < numnodes; i++)
		{
		
			if (link_table[j][i] == NO_LINK)
				break;

			iterations++;			
		}
	}


	printf ("Number of nodes = %d, source = %d, target = %d, links = %d\n\n", numnodes, source, target, iterations);
	start_time ();	// don't start time until AFTER tables were created

/*	
	printf ("Floyd's Algorithm: Worst Case\n");

	iterations = 0;
	setup_floyd ();
	printf ("Number of iterations to set up adjacency matrix: %d\n", iterations);
	printf ("Path list: %d ", source);
	iterations = 0;
	solve_floyd (target, source);
	printf ("%d\n", target);
	printf ("Floyd dist = %f,  ", Fmatrix[source][target]);
	printf ("Reverse Floyd dist = %f\n", Fmatrix[target][source]);
	if (Fmatrix[source][target] != Fmatrix[target][source])
		printf ("Path is not reversible. ");
	else
		printf ("Path is reversible. ");

	printf ("%d iterations for Floyd look-up\n", iterations);

	prn_time ();
*/
	iterations = 0;
	printf ("Dijkstra's algorithm, source to target ONLY\n");
	printf ("Path list: ");
	if (Dijkstra_ShortestPath(source, target, path))
    {
		i = 0;
		do
		{ 
			printf ("%d ", path[i]);
			if (i > 0 )
				dist = dist + distance_table[path[i]][path[i-1]];
		}
		while (path[i++] != source);
    }

	printf ("\ndist = %f, ", dist);
	printf ("%d iterations to calculate path\n", iterations);

	prn_time ();
	


	iterations = 0;
	printf ("Link-Reduction Dijkstra's algorithm (slow), source to target ONLY\n");
	Dijkstra_ShortestPath2(source, target);
		
	display_dijkstra_path (source, target);
	printf ("%d iterations to calculate path\n", iterations);
	prn_time ();

	iterations = 0;
	printf ("Link-Reduction Dijkstra's algorithm (fast), source to target ONLY\n");
	Dijkstra_ShortestPath3(source, target);
		
	display_dijkstra_path (source, target);
	printf ("%d iterations to calculate path\n", iterations);
	prn_time ();


	iterations = 0;
	printf ("Original Navigator algorithm, all paths calculation\n");
	Graphmon (Graph);
	display_navigator_path (Graph, target, source);
	printf ("\nNavigator dist = %f, ", Graph[target].dist[source]);
	printf ("Reverse Navigator dist = %f\n", Graph[source].dist[target]);

	if (Graph[target].dist[source] != Graph[source].dist[target])
		printf ("Path is not reversible. ");
	else
		printf ("Path is reversible. ");
	
	printf ("%d iterations to calculate path.\n", iterations);
	prn_time ();
	
	printf ("Press enter to continue\n");
	scanf ("%c", &c);	
	start_time ();

	iterations = 0;
	printf ("Original Navigator algorithm, all paths to target calculation\n");
	Graphweb (Graph, source, target);
	display_navigator_path (Graph, target, source);
	printf ("\nNavigator dist = %f, ", Graph[target].dist[source]);
	printf ("Reverse Navigator dist = %f\n", Graph[source].dist[target]);

	if (Graph[target].dist[source] != Graph[source].dist[target])
		printf ("Path is not reversible. ");
	else
		printf ("Path is reversible. ");
	
	printf ("%d iterations to calculate path.\n", iterations);
	prn_time ();

	iterations = 0;
	printf ("Link-Reduction Navigator algorithm, all paths calculation\n");
	Graphmon2 (Graph);
	display_navigator_path (Graph, target, source);
	printf ("\nNavigator dist = %f, ", Graph[target].dist[source]);
	printf ("Reverse Navigator dist = %f\n", Graph[source].dist[target]);

	if (Graph[target].dist[source] != Graph[source].dist[target])
		printf ("Path is not reversible. ");
	else
		printf ("Path is reversible. ");
	
	printf ("%d iterations to calculate path.\n", iterations);
	prn_time ();

	iterations = 0;
	printf ("Link-Reduction Navigator algorithm, all paths to target calculation\n");
	Graphweb2 (Graph, source, target);
	display_navigator_path (Graph, target, source);
	printf ("\nNavigator dist = %f, ", Graph[target].dist[source]);
	printf ("Reverse Navigator dist = %f\n", Graph[source].dist[target]);

	if (Graph[target].dist[source] != Graph[source].dist[target])
		printf ("Path is not reversible. ");
	else
		printf ("Path is reversible. ");
	
	printf ("%d iterations to calculate path.\n", iterations);
	prn_time ();

	printf ("Press enter to continue\n");
	scanf ("%c", &c);	
	start_time ();

}