#include "navigator.h"


void InitGraph(node_info Graph[])  
{
	// InitGraph goes through the used portion of the Graph[] array and initializes the array's and nodes' values to acceptable beginning parameters for the algorithm. 
	int i = 0, j = 0;

	for (i = 0; i <numnodes; i++)
	{
		Graph[i].visited = 0;
		for (j = 0; j < numnodes; j++)
		{
			Graph[i].dist[j] = (double)INFINITY;
			Graph[i].last[j] = NO_LINK;
		}
	}
}	

// graphmon simply calls Graphweb for each node in the graph.  It was separated for debugging and timing concerns. 
void Graphmon (node_info Graph[])
{
	int i = 0;

	// comment out the following two lines of code
	// if you want to calculate paths to a final
	// destination only.
	for (i = 0; i < numnodes; i++)
		Graphweb (Graph, ALL_PATHS, i);
	
	//Graphweb (Graph, 100); //100 = node #100 is final destination
}	

void Graphweb(node_info Graph[], int src, int k)	// k is the node to be used as a base. 
{


  int i, w, v = 0;
  double min;
  
  Graph[k].visited = 1;			// mark k itself as visited and set its dist to 
  Graph[k].dist[k] = (double)0;	// itself to zero.
  
  for(i=0; i < numnodes; i++)	// check direct connections 
  if( i != k ) 					// make sure we don't repeat ourselves. . . 
   {
	 
	  Graph[i].visited = 0;				// enter the correct information 
	  Graph[i].last[k] = k;
	  Graph[k].dist[i] = distance_table[k][i];
	  Graph[i].dist[k] = distance_table[i][k];
	  iterations++;
	 
   }
  
  for(i = 0; i < numnodes; i ++)	// now, for a sweep through the 
  {		  
	if (i != k) 						// non-connected nodes! 
	{
		min = (float)50000;				// set minimum value to effective infinity 	
		for (w = 0; w < numnodes; w++) // for each node. . . 
		{
			if (w !=k)
			{
				iterations++;
				if (Graph[w].visited != 1)	// have we already serviced this node? //
				{
					if (Graph[w].dist[k] < min)	// if not, has it a shorter path to k? /
					{
						v=w;
						min=Graph[w].dist[k];		// if so, mark it down as the new /
					}								// shortest path! //
				}
			}

		}
	
		Graph[v].visited=1;			// now process the new shortest path. 
	
		for(w = 0; w < numnodes; w++)	// we'll go through all of the other 
		{
			if(w !=k) 						// nodes. . . 
			{		
				iterations++;
				if (Graph[w].visited != 1)	// and if they've been visited. . . 
				{		  
					if (min + distance_table [v][w] < Graph[w].dist[k])
					// and this new shortest path means a shorter path exists between this node (w) and k via v. . . 
					{
						// Change the shortest path between this node and k! 
						Graph[w].dist[k] = min + distance_table[v][w];	// for asymetric node systems, this can be inaccurate
						Graph[k].dist[w] = min + distance_table[w][v];	// for asymetric node systems, this can be inaccurate
																		// this means distances can be inaccurate if path from 
																		// a->b is not the reverse direction of b->a.
						Graph[w].last[k] = v;  // accurate even if node systems is not symmetrical (e.g. there's one way links)			
					}
			
				}
			}
		}

	}


	if (v == src)  // use value of src like -10 if you want to calculate all paths
		break;

  }// for-i

}

// DisplayPath takes two points on the graph specified by the user and returns the (already calculated) shortest path between them. 
void display_navigator_path (node_info Graph[], int first, int last)
{
	int i = 0, ptr;

	// NOTE: if a path exists from a->b but matrix was not fully calculated yet,
	// this function can lead to infinite looping or accessing an element in the
	// the matrix that does not exist.  So check for bad results.

	ptr = last;
	
	if (Graph[first].dist[last] >= INFINITY)
		printf (" No connection exists.\n");
	else
	{
		//printf (" Shortest Path between nodes %d and %d = %f  \n", last, first, dist);
		printf ("Path list: ");
		printf (" %d", last);
		while (ptr != first)
		{
			iterations++;
			if (ptr < 0 || ptr>numnodes)
				break;
			
			printf (" %d", Graph[ptr].last[first]);
			ptr = Graph[ptr].last[first];
		}

	}

}	

void Graphmon2 (node_info Graph[])
{
	int i = 0;

	// comment out the following two lines of code
	// if you want to calculate paths to a final
	// destination only.
	for (i = 0; i < numnodes; i++)
		Graphweb2 (Graph, ALL_PATHS, i);
	
	//Graphweb2 (Graph, 100); //100 = node #100 is final destination
}	

void Graphweb2(node_info Graph[], int src, int k)	// k is the node to be used as a base. 
{


  int		i, w, v = 0;
  double	min;
  int		l;

  Graph[k].visited = 1;			// mark k itself as visited and set its dist to 
  Graph[k].dist[k] = (double)0;	// itself to zero.
  
  for(i=0; i < numnodes; i++)	// check direct connections 
  if( i != k ) 					// make sure we don't repeat ourselves. . . 
   {
	 
	  Graph[i].visited = 0;				// enter the correct information 
	  Graph[i].last[k] = k;
	  Graph[k].dist[i] = distance_table[k][i];
	  Graph[i].dist[k] = distance_table[i][k];
	  iterations++;
	 
   }
  
  for(i = 0; i < numnodes; i ++)	// now, for a sweep through the 
  {		  
	if (i != k) 						// non-connected nodes! 
	{
		min = (float)50000;				// set minimum value to effective infinity 	
		for (w = 0; w < numnodes; w++) // for each node. . . 
		{
			if (w !=k)
			{
				iterations++;
				if (Graph[w].visited != 1)	// have we already serviced this node? //
				{
					if (Graph[w].dist[k] < min)	// if not, has it a shorter path to k? /
					{
						v=w;
						min=Graph[w].dist[k];		// if so, mark it down as the new /
					}								// shortest path! //
				}
			}

		}
	
		Graph[v].visited=1;			// now process the new shortest path. 
	
		for(w = 0; w < MAX_LINKS; w++)	// we'll go through all of the other 
		{
			l = link_table[v][w];
			if (l == NO_LINK)
				break;

			if(l !=k) 						// nodes. . . 
			{		
				iterations++;
				if (Graph[l].visited != 1)	// and if they've been visited. . . 
				{		  
					if (min + distance_table [v][l] < Graph[l].dist[k])
					// and this new shortest path means a shorter path exists between this node (w) and k via v. . . 
					{
						// Change the shortest path between this node and k! 
						Graph[l].dist[k] = min + distance_table[v][l];	// for asymetric node systems, this can be inaccurate
						Graph[k].dist[l] = min + distance_table[l][v];	// for asymetric node systems, this can be inaccurate
																		// this means distances can be inaccurate if path from 
																		// a->b is not the reverse direction of b->a.
						Graph[l].last[k] = v;  // accurate even if node systems is not symmetrical (e.g. there's one way links)			
					}
			
				}
			}
		}

	}


	if (v == src)  // use value of src like -10 if you want to calculate all paths
		break;

  }// for-i

}


void Graphmon3 (node_info Graph[])
{
	int i = 0;

	// comment out the following two lines of code
	// if you want to calculate paths to a final
	// destination only.
	for (i = 0; i < numnodes; i++)
		Graphweb3 (Graph, ALL_PATHS, i);
	
	//Graphweb2 (Graph, 100); //100 = node #100 is final destination
}	


void Graphweb3 (node_info Graph[], int src, int k)	// k is the node to be used as a base. 
{


}
