
#include "floyd.h"


void compute_floyd(void)
{
	int		i, j, k;
	double	dij, dik, dkj;


	for (k=0; k<numnodes; k++)
	{

		for (i=0; i<numnodes; i++)
		{
			
			for (j=0; j<numnodes; j++)
			{
				dij = Fmatrix[i][j];
				dkj = Fmatrix[k][j];
				dik = Fmatrix[i][k];
				iterations = iterations + 1;

				if (dik == INFINITY)
					continue;


				if (dkj == INFINITY)
					continue;

				if (dik + dkj < dij)
					Fmatrix[i][j] = dik + dkj;
			}
		}
	}
}

void solve_floyd(int node1, int node2)
{
	double	d12, d1i, di2, d12r;
	int		i;


	if (node1 == node2)
		return;						// you are already there
	
	d12 = Fmatrix[node1][node2];	// known minimal distance
	d12 = Fmatrix[node2][node1];	// known reverse minimal distance

	// The variable node_count is the number of nodes
	// currently in use.  This variable is defined
	// elsewhere.  I defined it in my mapping routine.

	for (i=0; i<numnodes; i++)	// walk over all possible incoming links
	{
		if (i==node2)
			continue;				// skip link (node2, node2)

		d1i = Fmatrix[node1][i];	// distance from node1 to i
		di2 = distance_table[i][node2];	// distance from i to node 2
		iterations++;
		if (d1i + di2 == d12)
		{
			
			printf ("%d ", i);
			solve_floyd (node1, i);
			break;
		}		
		else if (d1i + di2 == d12r)
		{
			printf ("%d ", i);
			solve_floyd (node1, i);
			break;
		}
		
	}	

	// if you reach this point, then this means NO PATH FOUND or
	// you have reached the final node and are exiting out of the
	// recursive loop, one at a time (see "break;" in the loop
	// above).
	
}		

void copy_matrix (void)
{
	int r, c;
	int n = numnodes;

	for (r = 0; r<n; r++)
	{
		for (c = 0; c < n; c++)
		{
			Fmatrix[r][c] = distance_table[r][c];
		}
	}

}

void setup_floyd (void)
{
	copy_matrix ();
	compute_floyd ();
}