
#include "random.h"

#ifndef __PFA_DISTANCE_H
#define __PFA_DISTANCE_H

// max_nodes == maximum number of nodes in system
// infinity == no link used in distance table
// no link == no link used in link table
// max links == maximum number of OUTGOING links
//				a node can have more than MAX_LINKS number of
//				links linking TO it but it won't have no more
//				than MAX_LINKS number of links to link to.
//
// MAX_LINKS must be at most one less than MAX_NODES
// MAX_LINKS must be at least 6 due to the fact that
// some paths are hard coded into the distance and
// link tables

#define		MAX_NODES		256
#define		INFINITY		65536
#define		NO_LINK			-1
#define		ALL_PATHS		-10
#define		MAX_LINKS		14
double		distance_table[MAX_NODES][MAX_NODES];
int			link_table[MAX_NODES][MAX_NODES];
int			numnodes;
int			iterations;

void create_tables (void);
void initialize_tables (void);
void save_distance_table (void);
void load_distance_table (void);


#endif