
#include "distance.h"
#include <stdio.h>

// ----------------------------------------------
// create_tables
// 
// randomly creates the distance table and
// creates the associate link table
// ----------------------------------------------
void create_tables (void)
{

	int i = 0, j = 0, k = 0;
	int l = 0, m = 0, n = 0;
	int	o = 0;
	FILE	*input;

	input = fopen("distance.nt0", "rb");

	if (input)
	{
		fclose (input);
		load_distance_table ();
		return;
	}

	printf ("No distance.nt0 found.  Creating table.\n");

	init_rand ("legion");
	initialize_tables ();

	for (i = 0; i < MAX_NODES; i++)
	{
		for (k = 0; k < MAX_LINKS - 5; k++)
		{
			if (link_table[i][k] != NO_LINK)
				continue;

			m = 0;
			while (m == 0)
			{
				
				j = rand () % MAX_NODES;
				n = 0;
				for (l = 0; l < k; l++)			
					if (link_table[i][l] == j)
				{
					n = 1;
				}

				if (i == j)
					n = 1;

				if (!n)
				{
					link_table[i][k] = j;
					distance_table[i][j] = 320 + rand () % 320;
					m = 1;
					
					if (random() < 0.88)
					{
						distance_table[j][i] = distance_table[i][j];
						for (o = 0; o < MAX_LINKS - 5; o++)
						{
							if (link_table[j][o] == NO_LINK || link_table[j][o] == i)
							{								
								link_table[j][o] = i;
								break;
							}
						}
					}

				}
			}
		}
	}


	// now hard code a path in the distance table itself
	// this is to check to see if it works
	// path:
	// 1->25->80->13->99->37->40->64->15->100

	
	distance_table[1][25] = (double)25;
	distance_table[25][1] = (double)25;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[1][k] == NO_LINK || link_table[1][k] == 25)
		{
			link_table[1][k] = 25;
			break;
		}
	}		

	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[25][k] == NO_LINK || link_table[25][k] == 1)
		{
			link_table[25][k] = 1;
			break;
		}
	}		

	distance_table[25][80] = (double)10;
	distance_table[80][25] = (double)10;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[25][k] == NO_LINK || link_table[25][k] == 80)
		{
			link_table[25][k] = 80;
			break;
		}
	}		

	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[80][k] == NO_LINK || link_table[80][k] == 25)
		{
			link_table[80][k] = 25;
			break;
		}
	}		


	distance_table[80][13] = (double)17;
	distance_table[13][80] = (double)17;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[80][k] == NO_LINK || link_table[80][k] == 13)
		{
			link_table[80][k] = 13;
			break;
		}
	}		

	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[13][k] == NO_LINK || link_table[13][k] == 80)
		{
			link_table[13][k] = 80;
			break;
		}
	}		


	distance_table[13][99] = (double)15;
	distance_table[99][13] = (double)15;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[13][k] == NO_LINK || link_table[13][k] == 99)
		{
			link_table[13][k] = 99;
			break;
		}
	}		

	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[99][k] == NO_LINK || link_table[99][k] == 13)
		{
			link_table[99][k] = 13;
			break;
		}
	}		

	distance_table[99][37] = (double)40;
	distance_table[37][99] = (double)40;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[99][k] == NO_LINK || link_table[99][k] == 37)
		{
			link_table[99][k] = 37;
			break;
		}
	}		

	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[37][k] == NO_LINK || link_table[37][k] == 99)
		{
			link_table[37][k] = 99;
			break;
		}
	}		

	//distance_table[37][40] = (double)INFINITY;
	distance_table[37][40] = (double)64;
	//distance_table[40][37] = (double)INFINITY;
	distance_table[40][37] = (double)64;

	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[37][k] == NO_LINK || link_table[37][k] == 40)
		{
			link_table[37][k] = 40;
			break;
		}
	}		

	
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[40][k] == NO_LINK || link_table[40][k] == 37)
		{
			link_table[40][k] = 37;
			break;
		}
	}
	

	distance_table[40][64] = (double)15;
	distance_table[64][40] = (double)15;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[40][k] == NO_LINK || link_table[40][k] == 64)
		{
			link_table[40][k] = 64;
			break;
		}
	}		

	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[64][k] == NO_LINK || link_table[64][k] == 40)
		{
			link_table[64][k] = 40;
			break;
		}
	}		

	distance_table[64][15] = (double)84;
	distance_table[15][64] = (double)84;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[64][k] == NO_LINK || link_table[64][k] == 15)
		{
			link_table[64][k] = 15;
			break;
		}
	}		

	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[15][k] == NO_LINK || link_table[15][k] == 64)
		{
			link_table[15][k] = 64;
			break;
		}
	}		

	distance_table[15][100] = (double)33;
	distance_table[100][15] = (double)33;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[15][k] == NO_LINK || link_table[15][k] == 100)
		{
			link_table[15][k] = 100;
			break;
		}
	}		

	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[100][k] == NO_LINK || link_table[100][k] == 15)
		{
			link_table[100][k] = 15;
			break;
		}
	}		

	
	// secondary path
	// path:
	// 0->1->3, length = 9
	// wrong path:
	// 0->1->4->5->7->3, length = 10

	
	distance_table[0][1] = 2;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[0][k] == NO_LINK || link_table[0][k] == 1)
		{
			link_table[0][k] = 1;
			break;
		}
	}		

	distance_table[0][6] = 6;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[0][k] == NO_LINK || link_table[0][k] == 6)
		{
			link_table[0][k] = 6;
			break;
		}
	}		

	distance_table[1][2] = 7;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[1][k] == NO_LINK || link_table[1][k] == 2)
		{
			link_table[1][k] = 2;
			break;
		}
	}
	
	distance_table[1][4] = 2;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[1][k] == NO_LINK || link_table[1][k] == 4)
		{
			link_table[1][k] = 4;
			break;
		}
	}		

	distance_table[2][3] = 3;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[2][k] == NO_LINK || link_table[2][k] == 3)
		{
			link_table[2][k] = 3;
			break;
		}
	}		

	distance_table[4][5] = 2;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[4][k] == NO_LINK || link_table[4][k] == 5)
		{
			link_table[4][k] = 5;
			break;
		}
	}		

	distance_table[5][2] = 3;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[5][k] == NO_LINK || link_table[5][k] == 2)
		{
			link_table[5][k] = 2;
			break;
		}
	}		

	distance_table[5][7] = 2;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[5][k] == NO_LINK || link_table[5][k] == 7)
		{
			link_table[5][k] = 7;
			break;
		}
	}		

	distance_table[6][4] = 1;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[6][k] == NO_LINK || link_table[6][k] == 4)
		{
			link_table[6][k] = 4;
			break;
		}
	}		

	distance_table[6][7] = 4;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[6][k] == NO_LINK || link_table[6][k] == 7)
		{
			link_table[6][k] = 7;
			break;
		}
	}		

	distance_table[7][3] = 2;
	for (k = 0; k < MAX_NODES; k++)
	{
		if (link_table[7][k] == NO_LINK || link_table[7][k] == 3)
		{
			link_table[7][k] = 3;
			break;
		}
	}		

	numnodes = MAX_NODES;

	save_distance_table ();
}

// ----------------------------------------------
// initialize_tables
// 
// resets the values for distance table and
// resets link table
// ----------------------------------------------
void initialize_tables (void)
{
	int i = 0, j = 0;

	for (i = 0; i < MAX_NODES; i++)
		for (j = 0; j < MAX_NODES; j++)
	{
		distance_table[i][j] = (double)INFINITY;
		link_table[i][j] = NO_LINK;
	}

}

void save_distance_table (void)
{
	int		i, j;
	float	dist;
	FILE	*output;
	int		l;
	
	double	NO_DIST = (double)INFINITY;

	output = fopen ("distance.nt0", "wb");
	
	printf ("Saving file...\n");
	//fprintf (output, "%f", (double)numnodes);

	fwrite (&numnodes, sizeof(int), 1, output);

	for (i = 0; i < numnodes; i++)
	{
		for (j = 0; j < MAX_LINKS; j++)
		{
			l = link_table[i][j];
			if (l != NO_LINK)
			{
				dist = (float)distance_table[i][l];
				fwrite (&l, sizeof(int),1, output);
				fwrite (&dist, sizeof(float),1, output);
			}
			else
			{
				fwrite (&l, sizeof(int), 1, output);
				break;					
			}
		}
	}
	fclose (output);

}

void load_distance_table (void)
{
	int		i, j;
	float	dist;
	FILE	*input;
	int		l;

	initialize_tables ();

	input = fopen ("distance.nt0", "rb");

	numnodes = 0;
	fread (&numnodes, sizeof(int), 1, input);

	printf ("Loading table...");
	if (numnodes > MAX_NODES)
	{
		printf ("\nMoron Alert: trying to load a file with too many nodes\n");
		numnodes = -1;
		return;
	}

	printf ("Number of nodes = %d\n", numnodes);


	for (i = 0; i < numnodes; i++)
	{
		for (j = 0; j < MAX_LINKS; j++)
		{
			
			fread(&l, sizeof(int), 1, input);

			if (l != NO_LINK)
			{
				fread(&dist, sizeof(float), 1, input);
				distance_table[i][l] = (double)dist;
			}
				
			link_table[i][j] = l;
								
			if (l == NO_LINK)
				break;
		}
	}

	fclose (input);
}
