
#include "dijkstra.h"
#include "navigator.h"

bool Dijkstra_ShortestPath (int source, int target, int path[])
{

	int		i, k, kNew;
	double	minDist;

	if (source == target)
		return false;

	// initialize state
	for (i = 0; i < numnodes; i++)
	{
		NodeInfo[i].iPredecessor	= kNoPredecessor;
		NodeInfo[i].iDistance		= (double)INFINITY;
		NodeInfo[i].iState			= SP_tentative;
		iterations++;
	}

	// start position, find a path from source to target
	NodeInfo[source].iDistance = 0;
	NodeInfo[source].iState = SP_permanent;

	// k is working (permanent) node
	k = source;

	do
	{
		// kNew is the tentatively labeled node with smallest path size
		kNew	= INFINITY; 
		minDist = (double)INFINITY;
	
		// is there a better path from k
		for (i = 0; i < numnodes; i++)
		{
			double	nodeIDistance;
			double	nodeKDistance;
			double	distanceKI;

			iterations++;

			nodeIDistance = NodeInfo[i].iDistance;
			nodeKDistance = NodeInfo[k].iDistance;
			distanceKI = distance_table[k][i];

			if ( (distanceKI != INFINITY) && (NodeInfo[i].iState == SP_tentative) )
			{
				if ( (nodeKDistance + distanceKI) < nodeIDistance)
				{
					NodeInfo[i].iPredecessor = k;
					NodeInfo[i].iDistance = nodeIDistance = nodeKDistance + distanceKI;
				}
			}

			if ( (nodeIDistance < minDist) && (NodeInfo[i].iState == SP_tentative) )
			{
				kNew = i;
				minDist = nodeIDistance;
			}
		} // end for-i

		// bail out if no path can be found

		if (kNew == INFINITY)
			return false;

		// make that node permanent; there cannot exist a shorter path from source to k
		k = kNew;	
		//NodeInfo[k].iDistance	= 0;
		NodeInfo[k].iState		= SP_permanent;
	} while (k != target);

	// copy path to output array
	i = 0; k = target;

	do
	{
		iterations++;
		path[i++]	= k;
		k			= NodeInfo[k].iPredecessor;


	} while (k != INFINITY);

	i = 0; minDist = (double)0;	
	do
	{
		if (i > 0)
		{
			iterations++;
			minDist = minDist + distance_table[path[i]][path[i-1]];
			Graph[path[i]].last[target] = path[i-1];
			Graph[path[i]].dist[path[i-1]] = minDist;
		}
	} while (path[i++] != source);

	return true;
}

bool Dijkstra_ShortestPath2 (int source, int target)
{

	int		i, k, kNew;
	double	minDist;
	int		path[MAX_NODES];

	if (source == target)
		return false;

	// initialize state
	for (i = 0; i < numnodes; i++)
	{
		NodeInfo[i].iPredecessor	= kNoPredecessor;
		NodeInfo[i].iDistance		= (double)INFINITY;
		NodeInfo[i].iState			= SP_tentative;
		iterations++;
	}

	// start position, find a path from source to target
	NodeInfo[source].iDistance = 0;
	NodeInfo[source].iState = SP_permanent;

	// k is working (permanent) node
	k = source;

	do
	{
		// kNew is the tentatively labeled node with smallest path size
		kNew	= INFINITY; 
		minDist = (double)INFINITY;
	
		// is there a better path from k
		for (i = 0; i < numnodes; i++)
		{
			double	nodeIDistance;
			double	nodeKDistance;
			double	distanceKI;
			int		l;

			l = link_table[k][i];
			if (l == NO_LINK)
			{
				if (NodeInfo[i].iState == SP_permanent)
					break;
				l = i;
			}

			//l = i;
			//if (l == 13) avoid node #13
			//	continue;


			iterations++;

			nodeIDistance = NodeInfo[l].iDistance;
			nodeKDistance = NodeInfo[k].iDistance;
			distanceKI = distance_table[k][l];

			if ( (distanceKI != INFINITY) && (NodeInfo[l].iState == SP_tentative) )
			{
				if ( (nodeKDistance + distanceKI) < nodeIDistance)
				{
					NodeInfo[l].iPredecessor = k;
					NodeInfo[l].iDistance = nodeIDistance = nodeKDistance + distanceKI;
				}
			}

			if ( (nodeIDistance < minDist) && (NodeInfo[l].iState == SP_tentative) )
			{
				kNew = l;
				minDist = nodeIDistance;
			}
		} // end for-i

		// bail out if no path can be found

		if (kNew == INFINITY)
			return false;

		// make that node permanent; there cannot exist a shorter path from source to k
		k = kNew;	
		//NodeInfo[k].iDistance	= 0;
		NodeInfo[k].iState		= SP_permanent;
	} while (k != target);

	// copy path to output array
	i = 0; k = target;
	do
	{
		iterations++;
		path[i++]	= k;
		k			= NodeInfo[k].iPredecessor;		

	} while (k != INFINITY);

	i = 0; minDist = (double)0;	
	do
	{
		if (i > 0)
		{
			iterations++;
			minDist = minDist + distance_table[path[i]][path[i-1]];
			Graph[path[i]].last[target] = path[i-1];
			Graph[path[i]].dist[target] = minDist;
		}
	} while (path[i++] != source);	

	return true;
}

bool Dijkstra_ShortestPath3 (int source, int target)
{

	int		i, k, kNew;
	double	minDist;
	int		path[MAX_NODES];

	if (source == target)
		return false;

	// initialize state
	for (i = 0; i < numnodes; i++)
	{
		NodeInfo[i].iPredecessor	= kNoPredecessor;
		NodeInfo[i].iDistance		= (double)INFINITY;
		NodeInfo[i].iState			= SP_tentative;
		iterations++;
	}

	// start position, find a path from source to target
	NodeInfo[source].iDistance = 0;
	NodeInfo[source].iState = SP_permanent;

	// k is working (permanent) node
	k = source;

	do
	{
		// kNew is the tentatively labeled node with smallest path size
		kNew	= INFINITY; 
		minDist = (double)INFINITY;
	
		// is there a better path from k
		for (i = 0; i < MAX_LINKS; /*numnodes;*/ i++)
		{
			double	nodeIDistance;
			double	nodeKDistance;
			double	distanceKI;
			int		l;

			l = link_table[k][i];
			if (l == NO_LINK)
				break;

			iterations++;

			nodeIDistance = NodeInfo[l].iDistance;
			nodeKDistance = NodeInfo[k].iDistance;
			distanceKI = distance_table[k][l];

			if ( (distanceKI != INFINITY) && (NodeInfo[l].iState == SP_tentative) )
			{
				if ( (nodeKDistance + distanceKI) < nodeIDistance)
				{
					NodeInfo[l].iPredecessor = k;
					NodeInfo[l].iDistance = nodeIDistance = nodeKDistance + distanceKI;
				}
			}

			if ( (nodeIDistance < minDist) && (NodeInfo[l].iState == SP_tentative) )
			{
				kNew = l;
				minDist = nodeIDistance;
			}
		} // end for-i

		// bail out if no path can be found

		if (kNew == INFINITY)
			return false;

		// make that node permanent; there cannot exist a shorter path from source to k
		k = kNew;	
		//NodeInfo[k].iDistance	= 0;
		NodeInfo[k].iState		= SP_permanent;
	} while (k != target);

	// copy path to output array
	i = 0; k = target;
	do
	{
		iterations++;
		path[i++]	= k;
		k			= NodeInfo[k].iPredecessor;		

	} while (k != INFINITY);

	i = 0; minDist = (double)0;	
	do
	{
		if (i > 0)
		{
			iterations++;
			minDist = minDist + distance_table[path[i]][path[i-1]];
			Graph[path[i]].last[target] = path[i-1];
			Graph[path[i]].dist[target] = minDist;
		}
	} while (path[i++] != source);	

	return true;
}

void display_dijkstra_path (int source, int target)
{
	int i = 0, ptr;

	// NOTE: if a path exists from a->b but matrix was not fully calculated yet,
	// this function can lead to infinite looping or accessing an element in the
	// the matrix that does not exist.  So check for bad results.

	ptr = source;
	
	printf ("Display path list: ");
	if (Graph[source].dist[target] >= INFINITY)
		printf (" No connection exists.\n");
	else
	{
		//printf (" Shortest Path between nodes %d and %d = %f  \n", last, first, dist);
		printf (" %d", source);
		while (ptr != target)
		{
			iterations++;
			if (ptr < 0 || ptr>numnodes)
				break;
			
			printf (" %d", Graph[ptr].last[target]);
			ptr = Graph[ptr].last[target];
		}

	}

	printf ("\ndist to target: %f\n", Graph[source].dist[target]);
	

}