#!/usr/bin/python
import pak_reader
import sys

def PrintHelp():
	print "Usage: ", sys.argv[0], " function pak_file [files]"
	print "   Functions:"
	print "      x   Extract file(s)"
	print "      l   List files"
	print "      h   Display this message"

if(len(sys.argv) == 1):
	PrintHelp()
else:
	if(sys.argv[1] == "h"):
		PrintHelp()
	else:
		pak_file = open(sys.argv[2], "rb")
		pak = pak_reader.PakReader(pak_file)

		if(sys.argv[1] == "x"):
			entry = pak.findFile(sys.argv[3])
			if(entry):
				if(len(sys.argv) == 5):
					out = sys.argv[4]
				else:
					out = "a.out"
				pak.extract(entry[0], out)
				print sys.argv[3], " extracted to ", out
			else:
				print sys.argv[3], " not found in pak"
		elif(sys.argv[1] == "l"):
			print "Size\tName"
			print "================================="
			for i in pak.listing():
				print "%i\t%s" % (i[2], i[0])
