# An id Software pak file reader programmed in Python

import struct

PakError = "PakError"

class PakReader:
	"The main class for pak file reading"
	def __init__(self, file):
		"Constructs the pak file class, accepts a file object"
		self.file = file
		self.file.seek(0, 0)
		header = struct.unpack("<4sll", self.file.read(struct.calcsize("<4sll")))
		if(header[0] != "PACK"):
			raise PakError, "file not a PAK file"
		self.header = { "id": header[0], "offset": header[1],
				"length": header[2] }

	def findFile(self, file):
		self.file.seek(self.header["offset"])
		num_ents = self.header["length"] / 64
		for i in range(num_ents):
			entry = struct.unpack("<56sll", self.file.read(struct.calcsize("<56sll")))
			end = 0
			for i in entry[0]:
				if(i == "\0"):
					break
				else:
					end = end + 1

			# remove trailing \0 bytes
			name = entry[0][0:end]
			if(name == file):
				return ( name, entry[1], entry[2] )
		return None

	def listing(self):
		"Returns a list of all the files contained in the pak file"
		self.file.seek(self.header["offset"], 0)
		num_ents = self.header["length"] / 64;
		entries = []
		for i in range(num_ents):
			entry = struct.unpack("<56sll", self.file.read(struct.calcsize("<56sll")))
			end = 0
			for i in entry[0]:
				if(i == "\0"):
					break
				else:
					end = end + 1

			# remove trailing \0 bytes
			name = entry[0][0:end]

			entries.append((name, entry[1], entry[2]))
		return entries

	def extract(self, in_path, out_path):
		"Extrats a file from the pak file storing it in the file you want"
		entry = self.findFile(in_path)
		self.file.seek(entry[1], 0)
		out = open(out_path, "wb")
		out.write(self.file.read(entry[2]))
