/* bezier.h - Bezier surface header file
 * Programmed by Kilbert <kilbert@inside3d.com>
 */
#ifndef _BEZIER_H_
#define _BEZIER_H_

// Define the number of verts to calculate. Should be done dynamically
// must be > 0, smoother curves the >
#define BEZIER_RES_X       64
#define BEZIER_RES_Y       64

typedef float vec3d[3]; // simple vector typedef

// Structure for a bezier curve
typedef struct
{
   vec3d ctrl_pts[9]; // 9 control points for a quadratic bezier
   // These are the actual calculated points. Should be allocated dynamically
   // for size variations
   vec3d verts[BEZIER_RES_Y+1][BEZIER_RES_X+1];
} bezier_t;

// Calculates the points
void BezierCalc(bezier_t *);

#endif
