/* bezier.c - Bezier surface generation
 * Programmed by Kilbert <kilbert@inside3d.com>
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "bezier.h"

// Copies vector in to vector out
void VecCopy(vec3d in, vec3d out)
{
   int i;
   for(i = 0; i < 3; i++)
      out[i] = in[i];
}

// Calculates a row of points
// v1, v2, v3: control points for the curve
// out: array of vectors for the points
void BezierCalcRow(vec3d v1, vec3d v2, vec3d v3, vec3d *out)
{
   float step, t, it;
   int i, j;

   step = 1.0f / BEZIER_RES_X;
   for(i = 0, t = 0.0f; i <= BEZIER_RES_X; i++, t += step)
   {
      it = 1.0f - t;
      for(j = 0; j < 3; j++)
         out[i][j] = it*it*v1[j] + 2*t*it*v2[j] + t*t*v3[j];
   }
}

void BezierCalc(bezier_t *bez)
{
   vec3d sides[3][BEZIER_RES_Y+1]; // holds the 3 main curves
   float step, t, it; // curve parameters
   int i, j; // loop counters

   step = 1.0f / BEZIER_RES_Y; // size we increse t by
   for(i = 0, t = 0.0f; i <= BEZIER_RES_Y; i++, t += step)
   {
      it = 1.0f - t;
      // calculate each of the 3 main curves' point
      for(j = 0; j < 3; j++)
      {
         sides[0][i][j] = it*it*bez->ctrl_pts[0][j] +
            2*t*it*bez->ctrl_pts[3][j] + t*t*bez->ctrl_pts[6][j];
         sides[1][i][j] = it*it*bez->ctrl_pts[1][j] +
            2*t*it*bez->ctrl_pts[4][j] + t*t*bez->ctrl_pts[7][j];
         sides[2][i][j] = it*it*bez->ctrl_pts[2][j] +
            2*t*it*bez->ctrl_pts[5][j] + t*t*bez->ctrl_pts[8][j];
      }
   }

   // Calculate each of the rows' points
   for(i = 0; i <= BEZIER_RES_X; i++)
      BezierCalcRow(sides[0][i], sides[1][i], sides[2][i], bez->verts[i]);
}
