/* world.h - Header file for the world
 */
#ifndef _WORLD_H_
#define _WORLD_H_

class Camera
{
public:
	Camera(Vector &pos, Vector &angle, float fov = 90.0f);
	Camera();
	~Camera();

	Vector &getPos();
	Vector &getAngle();
	float getFOV();

	void setPos(Vector &pos);
	void setAngle(Vector &pos);
	void setFOV(float fov);

private:
	Vector m_pos, m_angle;
	float m_fov;
};

class World
{
public:
	World(const char *path);
	World(const World &world);
	World();
	~World();

	bool isLoaded();
	bool load(const char *path);
	bool save(const char *path);

	bool render();
};

#endif