/* vid_win.cpp - Video and input driver for Windows
 */
//#include <GL/gl.h>
#include "system.h"
#include "util.h"
#include "console.h"
#include "concmd.h"
#include "convar.h"
#include "engine.h"
#include "video.h"

Variable<int> vid_width("vid_width", 640, true), vid_height("vid_height", 480, true);
Variable<int> vid_bpp("vid_bpp", 16, true), vid_zdepth("vid_zdepth", 16, true);
Variable<int> vid_stencil("vid_stencil", 0, true);
Variable<bool> vid_fullscreen("vid_fullscreen", false, true);
ReadOnlyVariable<std::string> gl_vendor("gl_vendor", "");
ReadOnlyVariable<std::string> gl_renderer("gl_renderer", "");
ReadOnlyVariable<std::string> gl_extensions("gl_extensions", "");
ReadOnlyVariable<std::string> gl_version("gl_version", "");

bool vid_initted = false;

bool Vid_OpenWindow();
bool Vid_CloseWindow();

COMMAND(vid_restart)
{
	if(!vid_initted)
	{
		console << "Video not initted..." << std::endl;
		return;
	}

	console << "Restarting video...";
	Vid_CloseWindow();
	if(!Vid_OpenWindow())
	{
		vid_width.reset();
		vid_height.reset();
		vid_bpp.reset();
		vid_zdepth.reset();
		vid_stencil.reset();
		vid_fullscreen.reset();
		if(!Vid_OpenWindow())
		{
			Sys_Hide(false);
			console << "unable to open video mode" << std::endl;
		}
	}

	console << "mode set" << std::endl;
}

bool Vid_SetupPixelFormat()
{
	return true;
}

bool Vid_ChangeRes()
{
	return true;
}

bool Vid_OpenWindow()
{
	return true;
}

bool Vid_CloseWindow()
{
	return true;
}

void Vid_Swap()
{
}

void Vid_Update()
{
	// system takes care of this in windows
}

bool Vid_Initted()
{
	return vid_initted;
}

bool Vid_Init()
{
	if(Vid_OpenWindow())
	{
		/*(*gl_renderer) = (const char *)glGetString(GL_RENDERER);
		(*gl_vendor) = (const char *)glGetString(GL_VENDOR);
		(*gl_extensions) = (const char *)glGetString(GL_EXTENSIONS);
		(*gl_version) = (const char *)glGetString(GL_VERSION);*/
		vid_initted = true;
		return true;
	}
	else
		return false;
}

bool Vid_Close()
{
	if(vid_initted)
	{
		Vid_CloseWindow();
		(*gl_renderer) = "";
		(*gl_vendor) = "";
		(*gl_extensions) = "";
		(*gl_version) = "";
		vid_initted = false;
		return true;
	}
	else
		return false;
}
