/* vfs.h - File system stuff
 */
#ifndef _VFS_H_
#define _VFS_H_

#ifdef _WIN32
#include <streambuf>
#else
#include <streambuf.h>
#endif
#include <iostream>
#include <fstream>

using std::streambuf;
using std::istream;
using std::ostream;
using std::iostream;
using std::filebuf;

// Temporary streams to be used until the VFS is written, they just wrap std::fstream
class vfs_istream: public istream
{
public:
	vfs_istream() : istream(&m_buf) { }
	vfs_istream(const char *path, istream::openmode mode = istream::in)
		: istream(&m_buf) { open(path, mode); }
	~vfs_istream() { }

	streambuf *rdbuf() { return &m_buf; }
	bool is_open() { return m_buf.is_open(); }

	void open(const char *path, istream::openmode mode = istream::in);
	void close() { m_buf.close(); }

private:
	std::filebuf m_buf;
};

class vfs_ostream: public ostream
{
public:
	vfs_ostream() : ostream(&m_buf) { }
	vfs_ostream(const char *path, ostream::openmode mode = ostream::out | ostream::trunc)
		: ostream(&m_buf) { open(path, mode); }
	~vfs_ostream() { }

	streambuf *rdbuf() { return &m_buf; }
	bool is_open() { return m_buf.is_open(); }

	void open(const char *path, ostream::openmode mode = ostream::out | ostream::trunc);
	void close() { m_buf.close(); }

private:
	std::filebuf m_buf;
};

class vfs_stream: public iostream
{
public:
	vfs_stream() : iostream(&m_buf) { }
	vfs_stream(const char *path, iostream::openmode mode = iostream::in | iostream::out)
		: iostream(&m_buf) { open(path, mode); }
	~vfs_stream() { }

	streambuf *rdbuf() { return &m_buf; }
	bool is_open() { return m_buf.is_open(); }

	void open(const char *path, iostream::openmode mode = iostream::in | iostream::out);
	void close() { m_buf.close(); }

private:
	std::filebuf m_buf;
};

/*class VFS_streambuf: public streambuf
{
public:
	VFS_streambuf();
	~VFS_streambuf();

	VFS_streambuf *open(const char *, std::ios::open_mode mode);
	VFS_streambuf *close();

protected:
	int overflow(int c = EOF);
	int underflow();

private:
	streambuf *m_stream; // streambuf that is internal to the VFS
};*/

bool VFS_Init();
bool VFS_Close();
bool VFS_AddPath(const char *path);

#endif
