/* vector.cpp - Implementation of vector.h
 */
#include <math.h>
#include "vector.h"

const scalar_t epsilon = (scalar_t)0.001;

Vector3d::Vector3d(scalar_t x, scalar_t y, scalar_t z)
{
	set(x, y, z);
}

Vector3d::Vector3d(const scalar_t *array)
{
	set(array);
}

Vector3d::Vector3d(const Vector3d &v)
{
	set(v);
}

void Vector3d::set(scalar_t x, scalar_t y, scalar_t z)
{
	m_data[0] = x;
	m_data[1] = y;
	m_data[2] = z;
}

void Vector3d::set(const scalar_t *array)
{
	set(array[0], array[1], array[2]);
}

void Vector3d::set(const Vector3d &v)
{
	set(v[0], v[1], v[2]);
}

scalar_t Vector3d::magnitude() const
{
	return ((scalar_t)sqrt(m_data[0]*m_data[0] + m_data[1]*m_data[1] + m_data[2]*m_data[2]));
}

scalar_t Vector3d::normalize()
{
	scalar_t len = magnitude();
	*this = *this/len;
	return len;
}

Vector3d Vector3d::add(const Vector3d &v) const
{
	return Vector3d(m_data[0]+v[0], m_data[1]+v[1], m_data[2]+v[2]);
}

Vector3d Vector3d::sub(const Vector3d &v) const
{
	return Vector3d(m_data[0]-v[0], m_data[1]-v[1], m_data[2]-v[2]);
}

Vector3d Vector3d::mul(const Vector3d &v) const
{
	return Vector3d(m_data[0]*v[0], m_data[1]*v[1], m_data[2]*v[2]);
}

Vector3d Vector3d::div(const Vector3d &v) const
{
	return Vector3d(m_data[0]/v[0], m_data[1]/v[1], m_data[2]/v[2]);
}

scalar_t Vector3d::dot(const Vector3d &v) const
{
	return (m_data[0]*v[0] + m_data[1]*v[1] + m_data[2]*v[2]);
}

Vector3d Vector3d::cross(const Vector3d &v) const
{
	return Vector3d(m_data[1]*v[2] - m_data[2]*v[1],
						 m_data[2]*v[0] - m_data[0]*v[2],
						 m_data[0]*v[1] - m_data[1]*v[0]);
}

Vector3d Vector3d::mul(const scalar_t &s) const
{
	return Vector3d(m_data[0]*s, m_data[1]*s, m_data[2]*s);
}

Vector3d Vector3d::div(const scalar_t &s) const
{
	return mul((scalar_t)1.0/s);
}