/* util.h - Utility functions common to a lot of parts of the engine
 */
#ifndef _UTIL_H_

#include "concmd.h"

#ifndef _WIN32
#define stricmp strcasecmp
#endif

void Util_Init(Arguments &args);
Arguments &Util_Args();

// endian functions
bool Util_BigEndian(); // spelling on endian right?
extern short (*Util_LittleShort)(short);
extern long (*Util_LittleLong)(long);
extern float (*Util_LittleFloat)(float);

extern short (*Util_BigShort)(short);
extern long (*Util_BigLong)(long);
extern float (*Util_BigFloat)(float);

// string functions
char *Util_StrCopy(const char *s);

#endif
