/* util.cpp - Utility functions common to a lot of parts of the engine
 */
#include <string.h>
#include "concmd.h"
#include "util.h"

Arguments *util_args = NULL;

bool big_endian = true;
bool Util_BigEndian() { return big_endian; }

short (*Util_LittleShort)(short) = NULL;
long (*Util_LittleLong)(long) = NULL;
float (*Util_LittleFloat)(float) = NULL;

short (*Util_BigShort)(short) = NULL;
long (*Util_BigLong)(long) = NULL;
float (*Util_BigFloat)(float) = NULL;

short Util_SwapShort(short s)
{
	unsigned char c1 = s & 255, c2 = (s>>8) & 255;
	return ((c1<<8)+c2);
}

long Util_SwapLong(long l)
{
	unsigned char c1 = l & 255, c2 = (l>>8) & 255, c3 = (l>>16) & 255, c4 = (l>>24) & 255;
	return ((c1<<24)+(c2<<16)+(c3<<8)+c4);
}

float Util_SwapFloat(float f)
{
	union
	{
		float f;
		unsigned char c[4];
	} u1, u2;

	u1.f = f;
	for(int i = 0; i < 4; i++)
		u2.c[i] = u1.c[3-i];

	return u2.f;
}

short Util_NoSwapShort(short s)
{
	return s;
}

long Util_NoSwapLong(long l)
{
	return l;
}

float Util_NoSwapFloat(float f)
{
	return f;
}

void Util_EndianInit()
{
	unsigned char test[2] = { 1, 0 };

	if(*(short *)test == 1)
	{
		big_endian = false;
		Util_BigShort = Util_SwapShort;
		Util_BigLong = Util_SwapLong;
		Util_BigFloat = Util_SwapFloat;
		Util_LittleShort = Util_NoSwapShort;
		Util_LittleLong = Util_NoSwapLong;
		Util_LittleFloat = Util_NoSwapFloat;
	}
	else
	{
		big_endian = true;
		Util_BigShort = Util_NoSwapShort;
		Util_BigLong = Util_NoSwapLong;
		Util_BigFloat = Util_NoSwapFloat;
		Util_LittleShort = Util_SwapShort;
		Util_LittleLong = Util_SwapLong;
		Util_LittleFloat = Util_SwapFloat;
	}
}

void Util_Init(Arguments &args)
{
	Util_EndianInit();
	util_args = &args;
}

Arguments &Util_Args()
{
	return *util_args;
}

char *Util_StrCopy(const char *s)
{
	if(!s)
		return NULL;

	char *t = new char[strlen(s)+1];
	strcpy(t, s);
	return t;
}