/* tokenizer.h - A simple and advanced tokenizer classes
 * Programmed by Nolan Eakins <kilbert@inside3d.com>
 */
#ifndef _TOKENIZER_H_
#define _TOKENIZER_H_

// Tokenizer ABC
class Tokenizer
{
public:
	Tokenizer();
	virtual ~Tokenizer();

	virtual void reset() = 0;
	virtual const char *next() = 0;
	virtual const char *token() = 0;
	virtual void putback(const char *token) = 0;

	const char *lastError() { return m_error; }

protected:
	void setError(int line, const char *error);
	bool errorSet() { if(m_error) return true; else return false; }

private:
	char *m_error;
};

// SimpleTokenizer parses out tokens seperated by spaces if not quoted
class SimpleTokenizer: public Tokenizer
{
public:
	SimpleTokenizer(const char *str);
	~SimpleTokenizer();

	void reset();

	const char *next();
	const char *token() { return m_token; }
	void putback(const char *token);

private:
	int m_line_number;
	char m_token[1024];
	char *m_buffer;
	char *m_pos_start, *m_pos_end;
};

// AdvancedTokenizer that parses out C/C++ tokens
class AdvancedTokenizer: public Tokenizer
{
public:
	AdvancedTokenizer(const char *str);
	~AdvancedTokenizer();

	void reset();

	const char *next(); // next token
	const char *token() { return m_token; } // last token read
	void putback(const char *token); // put token back in token stream

private:
	static const char *double_token_set[], single_token_set[];

	bool isToken(char c);
	bool isToken(char c1, char c2);

	int m_line_number;
	char m_token[1024];
	char *m_buffer;
	char *m_pos_start, *m_pos_end;
};

#endif
