#include <windows.h>
#include <stdio.h>
#include <iostream>
#include <streambuf>
#include <string>
#include <math.h>
#include "resource.h"
#include "engine.h"
#include "system.h"
#include "video.h"
#include "console.h"
#include "concmd.h"
#include "convar.h"

HINSTANCE sys_instance;
HWND sys_dialog;
unsigned long sys_execute_oldproc = 0;
bool sys_hidden = false;

// FIXME: move this into a seperate file and clean up
class Color
{
public:
	Color(unsigned char r = 0, unsigned char g = 0, unsigned char b = 0, unsigned char a = 255) { set(r, g, b, a); }
	Color(const char *s) { set(s); }

	void set(unsigned char r, unsigned char g, unsigned char b, unsigned char a = 255)
	{
		m_c[0] = r;
		m_c[1] = g;
		m_c[2] = b;
		m_c[3] = a;
	}

	void set(const char *s)
	{
		sscanf(s, "%i %i %i %i", &m_c[0], &m_c[1], &m_c[2], &m_c[3]);
	}

	void setRed(unsigned char r) { m_c[0] = r; }
	void setGreen(unsigned char g) { m_c[1] = g; }
	void setBlue(unsigned char b) { m_c[2] = b; }
	void setAlpha(unsigned char a) { m_c[3] = a; }

	unsigned char &getRed() { return m_c[0]; }
	unsigned char &getGreen() { return m_c[1]; }
	unsigned char &getBlue() { return m_c[2]; }
	unsigned char &getAlpha() { return m_c[3]; }

	unsigned char getRed() const { return m_c[0]; }
	unsigned char getGreen() const { return m_c[1]; }
	unsigned char getBlue() const { return m_c[2]; }
	unsigned char getAlpha() const { return m_c[3]; }

private:
	unsigned char m_c[4];
};
std::istream &operator>>(std::istream &str, Color &c)
{
	int t;
	str >> t;
	c.setRed(t);
	str >> t;
	c.setGreen(t);
	str >> t;
	c.setBlue(t);
	str >> t;
	c.setAlpha(t);
	return str;
}
std::ostream &operator<<(std::ostream &str, Color &c) { return str << (int)c.getRed() << " " << (int)c.getGreen() << " " << (int)c.getBlue() << " " << (int)c.getAlpha(); }

void Sys_UpdateColor();
FuncVariable<Color> sys_color_bg("sys_color_bg", Color(0, 32, 64), Sys_UpdateColor, true);
FuncVariable<Color> sys_color_fg("sys_color_fg", Color(0, 255, 255), Sys_UpdateColor, true);

COMMAND(toggle_sys)
{
	if(Vid_Initted())
	{
		Sys_Hide(!Sys_IsHidden());
		ShowCursor(!Sys_IsHidden());
	}
}

void Sys_UpdateColor()
{
	if( GetProp(sys_dialog,"bkbrush") )
	{
		DeleteObject( GetProp(sys_dialog,"bkbrush") );
		RemoveProp(sys_dialog,"bkbrush");
	}
	SetProp(sys_dialog, "bkbrush", CreateSolidBrush(RGB(sys_color_bg->getRed(), sys_color_bg->getGreen(), sys_color_bg->getBlue())));

	if(console.initted())
		RedrawWindow(sys_dialog, NULL, NULL, RDW_INVALIDATE);
}

void Sys_Quit(bool killed)
{
	Eng_Close();

	if(killed)
		exit(1);
	else
		exit(0);
}

void Sys_Clear()
{
	SendDlgItemMessage(sys_dialog, IDE_OUTPUT, WM_SETTEXT, 0, (LPARAM)"");
}

class Sys_StreamBuf: public std::streambuf
{
protected:
	int overflow(int c = EOF)
	{
		if(c != EOF)
		{
			// get old selection
			int old_start = 0, old_end = 0;
			SendDlgItemMessage(sys_dialog, IDE_OUTPUT, EM_GETSEL, (WPARAM)(LPDWORD)&old_start, (LPARAM)(LPDWORD)&old_end);

			// remove any selection and move cursor to the end
			SendDlgItemMessage(sys_dialog, IDE_OUTPUT, EM_SETSEL, 0, -1);
			int end_pos = 0;
			SendDlgItemMessage(sys_dialog, IDE_OUTPUT, EM_GETSEL, NULL, (LPARAM)(LPDWORD)&end_pos);
			SendDlgItemMessage(sys_dialog, IDE_OUTPUT, EM_SETSEL, end_pos, end_pos);

			if(c == '\n')
			{
				char s[3] = "\r\n";
				SendDlgItemMessage(sys_dialog, IDE_OUTPUT, EM_REPLACESEL, 0, (LPARAM)s);
			}
			else
			{
				char s[2] = { c, '\0' };
				SendDlgItemMessage(sys_dialog, IDE_OUTPUT, EM_REPLACESEL, 0, (LPARAM)s);
			}

			// set old position
			SendDlgItemMessage(sys_dialog, IDE_OUTPUT, EM_SETSEL, old_start, old_end);

			return traits_type::not_eof(c);
		}
		else
			return traits_type::eof();
	}
};

void Sys_DialogResize(HWND wnd, int width, int height)
{
	MoveWindow(GetDlgItem(wnd, IDE_OUTPUT), 7, 7, width-14, height-60, true);
	MoveWindow(GetDlgItem(wnd, IDE_EXECUTE), 7, height-53, width-14, 20, true);
	MoveWindow(GetDlgItem(wnd, IDC_CLEAR), width-114, height-27, 50, 20, true);
	MoveWindow(GetDlgItem(wnd, IDC_QUIT), width-57, height-27, 50, 20, true);
}

int CALLBACK Sys_ExecuteProc(HWND wnd, unsigned int msg, WPARAM wparam, LPARAM lparam)
{
	if(msg == WM_KEYDOWN && wparam == VK_RETURN)
	{
		int length = (WORD)SendMessage(wnd, EM_LINELENGTH, (WPARAM)0, (LPARAM)0);
		if(length > 0)
		{
			char *text = new char[length+1];
			SendMessage(wnd, EM_GETLINE, (WPARAM)0, (LPARAM)text);
			text[length] = '\0';
			console(text);
			delete[] text;
		}
		SendMessage(wnd, WM_SETTEXT, 0, (LPARAM)"");
		return TRUE;
	}
	else if(msg == WM_KEYUP && wparam == VK_RETURN)
		return TRUE;
	else if(msg == WM_CHAR && wparam == '\n')
		return TRUE;

	return CallWindowProc((WNDPROC)sys_execute_oldproc, wnd, msg, wparam, lparam);
}

int CALLBACK Sys_DialogProc(HWND wnd, unsigned int msg, WPARAM wparam, LPARAM lparam)
{
	switch(msg)
	{
	case WM_INITDIALOG:
		SetProp(wnd,"bkbrush",CreateSolidBrush(RGB(sys_color_bg->getRed(), sys_color_bg->getGreen(), sys_color_bg->getBlue())));
		SendDlgItemMessage(wnd, IDE_EXECUTE, EM_SETLIMITTEXT, 0, 0);
		sys_execute_oldproc = SetWindowLong(GetDlgItem(wnd, IDE_EXECUTE), GWL_WNDPROC, (unsigned long)Sys_ExecuteProc);
		SetWindowText(GetDlgItem(wnd, IDE_EXECUTE), "");

		SendMessage(wnd, WM_SETICON, ICON_SMALL, (LPARAM)LoadIcon(sys_instance, MAKEINTRESOURCE(IDI_ICON)));
		SendMessage(wnd, WM_SETICON, ICON_BIG, (LPARAM)LoadIcon(sys_instance, MAKEINTRESOURCE(IDI_ICON)));
		MoveWindow(wnd, GetSystemMetrics(SM_CXFULLSCREEN)/2-200, GetSystemMetrics(SM_CYFULLSCREEN)/2-125, 400, 250, true);
		break;
	case WM_CLOSE:
		if( GetProp(wnd,"bkbrush") )
		{
			DeleteObject( GetProp(wnd,"bkbrush") );
			RemoveProp(wnd,"bkbrush");
		}
		Sys_Quit();
	case WM_COMMAND:
		if(HIWORD(wparam) == BN_CLICKED)
		{
			switch(LOWORD(wparam))
			{
			case IDOK:
				console << "Ok pressed" << std::endl;
				break;
			case IDC_QUIT:
				Sys_Quit();
				break;
			case IDC_CLEAR:
				Sys_Clear();
				break;
			}
			break;
		}
		break;
	case WM_SIZE:
		if(wparam == SIZE_RESTORED || wparam == SIZE_MAXIMIZED)
		{
			Sys_DialogResize(wnd, LOWORD(lparam), HIWORD(lparam));
			break;
		}
	case WM_CTLCOLOREDIT:
	case WM_CTLCOLORSTATIC:
		SetBkColor((HDC)wparam, RGB(sys_color_bg->getRed(), sys_color_bg->getGreen(), sys_color_bg->getBlue()));
		SetTextColor((HDC)wparam, RGB(sys_color_fg->getRed(), sys_color_fg->getGreen(), sys_color_fg->getBlue()));
		return (int)GetProp(wnd, "bkbrush");
	default:
		return FALSE;
	}

	return TRUE;
}

void Sys_Update()
{
	MSG msg;
	while(PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE))
	{
		if(GetMessage(&msg, NULL, 0, 0))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}
}

void Sys_Hide(bool yes)
{
	if(yes)
	{
		ShowWindow(sys_dialog, SW_HIDE);
		sys_hidden = true;
	}
	else
	{
		ShowWindow(sys_dialog, SW_SHOW);
		sys_hidden = false;
	}
}

bool Sys_IsHidden()
{
	return sys_hidden;
}

int APIENTRY WinMain(HINSTANCE instance, HINSTANCE prev_instance, LPSTR cmd_line, int cmd_show)
{
	sys_instance = instance;
	sys_dialog = CreateDialog(instance, MAKEINTRESOURCE(IDD_SYSTEM_WINDOW), NULL, Sys_DialogProc);
	ShowWindow(sys_dialog, cmd_show);

	Arguments cmdline_args(cmd_line);

	Sys_StreamBuf s_buf;
	std::ostream s(&s_buf);
	console.addStream(s);
	Eng_Main(cmdline_args);

	return 0;
}
