/* sys_linux.cpp - Linux system interface
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/time.h>
#include <termios.h>
#include <iostream>
#include <string>
#include <math.h>
#include "engine.h"
#include "util.h"
#include "console.h"
#include "concmd.h"
#include "vfs.h"
#include "net.h"
#include "timer.h"

Variable<string> sys_prompt("sys_prompt", "]", true);
static char system_input[1024];
static int system_input_pos = 0;

void Sys_Quit(bool killed = false)
{
	Eng_Close();

	if(killed)
		exit(1);
	else
		exit(0);
}

void Sys_Clear()
{
}

void Sys_Hide(bool hidden = true)
{
	return;
}

bool Kbhit()
{
	// probably should use select since I don't know how portable this is
	fd_set fdset;
	FD_ZERO(&fdset);
	FD_SET(STDIN_FILENO, &fdset);

	struct timeval timeout;
	timeout.tv_sec = 0;
	timeout.tv_usec = 0;

	if(select(1, &fdset, NULL, NULL, &timeout) > 0)
	{
		if(FD_ISSET(STDIN_FILENO, &fdset))
			return true;
	}

	return false;
}

void Sys_PrintPrompt()
{
	memset(system_input, 0, 1024);
	std::cout << *sys_prompt << " ";
	std::cout.flush();
}

void Sys_Update()
{
	static bool run_once = false;

	if(!run_once)
	{
		Sys_PrintPrompt();
		run_once = true;
	}

	if(Kbhit())
	{
		cin.getline(system_input, 1024);
		console(system_input, false);
		Sys_PrintPrompt();
	}
}

int main(int argc, char **argv)
{
	Arguments cmdline_args(argc, argv);
	console.addStream(std::cout);
	Eng_Main(cmdline_args);
	return 0;
}
