/* pointer.h - Template pointer class
 */
#ifndef _POINTER_H_
#define _POINTER_H_

template<class T> class Pointer
{
public:
	typedef T data_type;

	Pointer(data_type *p) : m_p(p) { }
	Pointer(const Pointer &p) : m_p(p.get()) { }
	~Pointer() { }

	data_type *get() { return m_p; }
	data_type * const get() const { return m_p; }

	data_type &operator*() { return *m_p; }
	data_type *operator->() { return m_p; }
	operator data_type() { return m_p; }

	Pointer<data_type> operator+(Pointer<data_type> &p)
		{ return Pointer<data_type>(m_p + p.get()); }
	Pointer<data_type> operator-(Pointer<data_type> &p)
		{ return Pointer<data_type>(m_p - p.get()); }
	Pointer<data_type> &operator++()
		{ m_p++; return *this; }
	Pointer<data_type> &operator--()
		{ m_p--; return *this; }

private:
	data_type *m_p;
};

#endif
