/* net.h - Main network header
 */
#ifndef _NET_H_
#define _NET_H_

#ifndef SOCKET
#define SOCKET int
#endif

/* The network interface is pure TCP/IP and UDP/IP. No IPX, modem, or
 * whatever is supported, just anything built on top of IPv4 or IPv6.
 * It is just easier this way, and any computer today should support
 * some kind of IP.
 */

// Creates a connectionless socket
class Net_UDPSocket
{
public:
	class Packet
	{
	public:
		Packet();
		Packet(const char *dest_name, int dest_port, const char *data, int len); // prepares data for sending to addr
		Packet(Packet &msg);
		~Packet();

		char *getData() { return m_data; }
		const char *getData() const { return m_data; }
		int getLength() const { return m_len; }
		const char *getHostname() const { return m_hostname; }
		int getPort() const { return m_port; }

		bool set(Packet &msg);
		bool setData(const char *data, int len);
		bool setLength(int len);
		void setHostname(const char *name);
		void setPort(int port);

	private:
		char *m_hostname, *m_data;
		int m_port, m_len;
	};

	Net_UDPSocket(); // unopened socket
	Net_UDPSocket(int port); // binds to port, if port < 0 then port is randomly choosen
	~Net_UDPSocket();

	bool open(int port);
	bool close();

	int getPort() const { return m_port; }
	bool isOpen() const { return m_open; }

	bool msgPending(); // true if the socket has any data waiting
	bool send(Packet &msg);
	bool receive(Packet &msg);

private:
	SOCKET m_socket;
	int m_port;
	bool m_open;
};

/* TCP Socket class will act and operate like a normal C++ stream
 * so the >> and << operators will work on it. There will only be
 * one class that handles both input and output, instead of 3
 * seperate classes.
 */
/* class Net_TCPSocket: public iostream
 * {
 * };
 */

// Exported functions
bool Net_Init();
bool Net_Close();
//const Net_Address &Net_LocalAddress();

#endif
