/* eng_main.cpp - Main engine file
 */
#include <stdio.h>
#include <iostream>
//#include <streambuf>
#include <string>
#include <math.h>
#include "engine.h"
#include "system.h"
#include "util.h"
#include "console.h"
#include "concmd.h"
#include "convar.h"
#include "vfs.h"
#include "net.h"
#include "host.h"
#include "client.h"
#include "video.h"
#include "timer.h"

ConstVariable<std::string> eng_name("eng_name", "The Engine", false);
ReadOnlyVariable<Timer> eng_time("eng_time", 0.0);

COMMAND(time_start) { eng_time->start(); }
COMMAND(time_stop) { eng_time->stop(); }

void Net_PollTestSock();

void Eng_Close()
{
	 if(!*host_dedicated)
	// {
	//		Client_Close();
	//		Snd_Close();
			Vid_Close();
	// }
	if(Host_Initted())
		Host_Close();
	Net_Close();

	BaseVariable::writeOutVars("default.cfg");
	VFS_Close();
}

void Eng_Main(Arguments &cmdline_args)
{
	Util_Init(cmdline_args);

	// I'm going to have to move all the init functions before any
	// console commands get executed, and add open/start functions for
	// subsystems that will need them.

	//Con_StuffCmds();
	console("exec init.cfg", false); // execute master config file
	console.init(); // console is now all setup

	VFS_Init();
	Net_Init();
	if(*host_dedicated)
		Host_Init();
	else
	//	{
		Vid_Init();
	//		Snd_Init();
	//		Client_Init(); // client can call Host_Init when it creates a game
	//	}

	while(1)
	{
		// update subsystems for input
		Sys_Update();
		Net_PollTestSock();
		if(Host_Initted())
			Host_Update();
		if(Client_Initted())
		{
			Vid_Update();
			Client_Update();
		}
		Vid_Swap();
	}
}
