/* convar.cpp - Console variable source file
 */
#include <vector>
#include <string>
#include "console.h"
#include "concmd.h"
#include "convar.h"
#include "vfs.h"

/*
 * BaseVariable
 */
BaseVariable::BaseVariable(const char *name, const char *type, bool write_out)
: Function(name, type), m_next_var(NULL), m_write_out(write_out)
{
	if(!name)
		return;

	BaseVariable *temp = variables();
	while(temp)
	{
		if(!temp->m_next_var)
			break;
		else
			temp = temp->m_next_var;
	}

	temp->m_next_var = this;
}

BaseVariable::~BaseVariable()
{
	BaseVariable *var = variables();
	while(var)
	{
		if(var->m_next_var == this)
		{
			var->m_next_var = m_next_var;
			break;
		}
		else
			var = var->m_next_var;
	}
}

BaseVariable *BaseVariable::variables()
{
	static BaseVariable root(NULL, NULL, false);
	return &root;
}

bool BaseVariable::setVariable(const char *name, const char *value)
{
	BaseVariable *var = findVariable(name);
	if(var)
	{
		var->set(value);
		return true;
	}
	else
		return false;
}

bool BaseVariable::resetVariable(const char *name)
{
	BaseVariable *var = findVariable(name);
	if(var)
	{
		var->reset();
		return true;
	}
	else
		return false;
}

BaseVariable *BaseVariable::findVariable(const char *name)
{
	BaseVariable *temp = variables();
	while(temp)
	{
		if(!temp->getName() ||
#ifdef _WIN32
			stricmp(temp->getName(), name)
#else
			strcasecmp(temp->getName(), name)
#endif
			)
			temp = temp->m_next_var;
		else
			return temp;
	}

	return NULL;
}

bool BaseVariable::writeOutVars(const char *path)
{
	vfs_ostream f(path);
	if(!f)
		return false;

	f << "// This file generated by The Engine, do not edit." << std::endl;

	BaseVariable *var = variables();
	while(var)
	{
		if(var->writeOut())
			var->write(f);
		var = var->nextVariable();
	}

	f.close();
	return true;
}

// Console commands that operate on variables
// FIXME: the use of a pointer here may cause some problems?
std::vector<BaseVariable *> con_variables; // user variables

COMMAND(ls_vars)
{
	int count = 0;
	BaseVariable *var = BaseVariable::variables();
	while(var)
	{
		if(var->getName())
		{
			console << var->getName() << std::endl;
			count++;
		}
		var = var->nextVariable();
	}
	console << count << " total variables" << std::endl;
}

COMMAND(set)
{
	if(args.count() == 2)
	{
		BaseVariable *var = BaseVariable::findVariable(args[1]);
		if(var)
			var->run(Arguments(args[1]));
		else
			console << args[1] << " was not found" << std::endl;
	}
	else if(args.count() == 3)
	{
		if(!BaseVariable::setVariable(args[1], args[2]))
		{
			bool write_out = false; // if the variable was created in the config file, we want it written out
			if(!console.initted())
				write_out = true;

			con_variables.push_back(new Variable<std::string>(args[1], args[2], write_out));

			if(console.initted())
				console << args[1] << " was created with the value of " << args[2] << std::endl;
		}
	}
	else
		console << "Usage: " << args[0] << " variable [value]" << std::endl;
}

COMMAND(del)
{
	if(args.count() == 2)
	{
		std::vector<BaseVariable *>::iterator i = con_variables.begin();
		while(i != con_variables.end())
		{
			if(!stricmp((*(*i)).getName(), args[1]))
			{
				delete *i;
				con_variables.erase(i);
				console << args[1] << " has been deleted" << std::endl;
				return;
			}
			else
				i = i++;
		}

		if(BaseVariable::findVariable(args[1]))
			console << "Unable to delete \"" << args[1] << "\"" << std::endl;
		else
			console << args[1] << " was not found" << std::endl;
	}
	else
		console << "Usage: " << args[0] << " variable" << std::endl;
}

COMMAND(reset)
{
	if(args.count() == 2)
	{
		if(BaseVariable::resetVariable(args[1]))
			console << args[1] << " reset to default value" << std::endl;
		else
			console << args[1] << " was not found" << std::endl;
	}
	else
		console << "Usage: " << args[0] << " variable" << std::endl;
}

COMMAND(reset_all)
{
	console << "Reseting all variables to default values..." << std::endl;
	BaseVariable *var = BaseVariable::variables();
	while(var)
	{
		var->reset();
		var = var->nextVariable();
	}
}
