/* constream.h - Console stream classes
 */
#ifndef _CONSTREAM_H_
#define _CONSTREAM_H_

#include <iostream>
#ifdef _WIN32
#include <streambuf>
#else
#include <streambuf.h>
#endif
#include <map>
#include "pointer.h"

class ConsoleStreamBuffer: public std::streambuf
{
public:
	ConsoleStreamBuffer();
	~ConsoleStreamBuffer();

	void init(int size);
	void clear();

	int addStream(std::ostream &s);
	bool rmStream(int s);

	bool getInitted() { return m_initted; }
	int getSize() { return m_size; }
	int getCurPos() { return m_cur_pos; }

	const char &operator[](int i) const;

protected:
	int overflow(int c = EOF);
	//int showmanyc() { return m_byte_size; }

private:
	char *m_buffer;
	int m_size, m_cur_pos;
	bool m_initted;
	std::map<int, Pointer<std::ostream> > m_streams;
	int m_stream_count;
};

#endif
