/* constream.cpp - Console stream classes
 */
#include <iostream>
#ifdef _WIN32
#include <streambuf>
#else
#include <streambuf.h>
#endif
#include <string>
#include <list>
#include "constream.h"
#include "pointer.h"

using namespace std;

ConsoleStreamBuffer::ConsoleStreamBuffer()
: m_buffer(NULL), m_size(0), m_cur_pos(0), m_initted(false), m_stream_count(0)
{
}

ConsoleStreamBuffer::~ConsoleStreamBuffer()
{
	delete[] m_buffer;
}

void ConsoleStreamBuffer::init(int size)
{
	delete[] m_buffer;
	m_buffer = new char[size];
	m_size = size;
	m_cur_pos = 0;
	m_initted = true;
	m_streams.clear();
	m_stream_count = 0;
}

int ConsoleStreamBuffer::addStream(std::ostream &str)
{
	std::map<int, Pointer<std::ostream> >::iterator i = m_streams.insert(m_streams.end(), make_pair(m_stream_count++, Pointer<std::ostream>(&str)));
	return i->first;
}

bool ConsoleStreamBuffer::rmStream(int i)
{
	std::map<int, Pointer<std::ostream> >::iterator iter = m_streams.find(i);
	m_streams.erase(iter);
	return true;
}

int ConsoleStreamBuffer::overflow(int c)
{
	if(c == EOF || c == '\0')
		return EOF;
	else if(m_initted)
	{
		m_buffer[m_cur_pos++ % m_size] = c;
		m_buffer[m_cur_pos % m_size] = '\0';

		for(std::map<int, Pointer<std::ostream> >::iterator i = m_streams.begin();
			 i != m_streams.end(); i++)
		{
			char t = (char)c;
			i->second->write(&t, 1);
		}
	}

	return c;
}

void ConsoleStreamBuffer::clear()
{
	if(m_initted)
	{
		memset(m_buffer, 0, m_size);
		m_cur_pos = 0;
	}
}

const char &ConsoleStreamBuffer::operator[](int i) const
{
	if(m_initted)
		return m_buffer[i % m_size];
	else
		return 0;
}
