/* console.h - Console header
 */
#ifndef _CONSOLE_H_
#define _CONSOLE_H_

#include <iostream>
#include <map>
#include "constream.h"
#include "concmd.h"

using std::ostream;

class Console: public ostream
{
public:
	Console(int size = 16384);
	~Console();

	bool initted() { return m_initted; }
	void init();

	int addStream(std::ostream &str) { return m_buf.addStream(str); }
	bool rmStream(int s) { return m_buf.rmStream(s); }

	void stuffCmds();
	bool call(Arguments &cmd, bool display_cmd = true);
	bool call(const char *cmd, bool display_cmd = true);

	void exec(const char *cmd_line);

	bool operator()(const char *cmd, bool display_cmd = true)
		{ return call(cmd, display_cmd); }
	bool operator()(Arguments &cmd, bool display_cmd = true)
		{ return call(cmd, display_cmd); }

	/* Stream operations and methods */
	ConsoleStreamBuffer &getBuf() { return m_buf; }
	void clear() { m_buf.clear(); }
	char operator[](int i) const { return m_buf[i]; }

private:
	ConsoleStreamBuffer m_buf;
	bool m_initted;
};

extern Console console;

#endif
