/* console.cpp - Cosole init code
 */
#include <iostream>
#include "system.h"
#include "util.h"
#include "vfs.h"
#include "console.h"
#include "concmd.h"
#include "convar.h"

Console console;

COMMAND(echo)
{
	for(int i = 1; i < args.count(); i++)
		console << args[i] << " ";
	console << std::endl;
}

COMMAND(clear)
{
	console.clear();
	Sys_Clear();
}

COMMAND(quit)
{
	Sys_Quit();
}

COMMAND(exec)
{
	if(args.count() > 1)
	{
		vfs_istream f(args[1]);
		if(!f.is_open())
		{
			console << "Error executing \"" << args[1] << "\"" << std::endl;
			return;
		}
		else
		{
			while(!f.eof())
			{
				char buffer[1024];
				f.getline(buffer, 1024);
				console(buffer, false);
			}
		}

		f.close();
	}
	else
		console << "Usage: " << args[0] << " script" << std::endl;
}

COMMAND(eval)
{
	if(args.count() == 2)
		console(args[1]);
	else
		console << "Usage: " << args[0] << " string" << std::endl;
}

void Console::stuffCmds()
{
	console << "Executing commands from command line..." << std::endl;
	Arguments &args = Util_Args();

	// FIXME: should check args[??] for NULL
	for(int i = 0; i < args.count(); i++)
	{
		if(args[i][0] == '+')
		{
			int count = 1, j;
			for(j = i+1; j < args.count(); j++)
			{
				if(args[j][0] == '+' || args[j][0] == '-')
					break;
				else
					count++;
			}

			char **tokens = new char*[count];
			tokens[0] = Util_StrCopy(&args[i][1]);

			for(j = 1; j < count; j++)
				tokens[j] = Util_StrCopy(args[i+j]);

			console(Arguments(count, tokens), false);

			for(j = count; j > 0; j--)
				delete[] tokens[j-1];
			delete[] tokens;
		}
	}
}

Console::Console(int size /* = 16384 */)
	: ostream(&m_buf), m_initted(false)
{
	m_buf.init(size);
	console << "Console initialized" << std::endl;
}

Console::~Console()
{
}

void Console::init()
{
	m_initted = true;
}

bool Console::call(Arguments &args, bool display_cmd)
{
	if(display_cmd)
	{
		if(args.str())
			console << "] " << args.str() << std::endl;
		else
			console << "] " << args[0] << std::endl;
	}

	if(args.count() > 0)
	{
		if(!Function::execute(args))
		{
			// see if game dll has command
			/*if(!Game_Call(args))
			{
				if(!UI_Call(args))
				{*/
					console << "Command \"" << args[0] << "\" not found" << std::endl;
					return false;
				/*}
			}*/
		}
		return true;
	}

	return false;
}

bool Console::call(const char *cmd, bool display_cmd)
{
	if(!cmd && strlen(cmd) == 0)
		return false;

	Arguments args(cmd);
	return call(args, display_cmd);
}

void Console::exec(const char *cmd_line)
{
	if(!cmd_line || strlen(cmd_line) < 1)
		return;

	bool last_loop = false;
	char *temp = Util_StrCopy(cmd_line);
	char *start = temp, *end = temp;

	do
	{
		while(*end != '\r' && *end != '\n' && *end != ';' && *end != '\0')
			end++;
		if(*end == '\0')
			last_loop = true;

		*end++ = '\0'; // null terminate command

		call(start, false);
		start = end;
	} while(!last_loop);

	delete[] temp;
}
