/* concmd.h - Console command and variable classes
 */
#ifndef _CONCMD_H_
#define _CONCMD_H_

#include <strstream>
#include <iostream>

// Helpful defines
#define COMMAND(name) void cmd_##name##_f(Arguments &); Command cmd_##name##(#name, cmd_##name##_f); void cmd_##name##_f(Arguments &args)

class Arguments
{
public:
	Arguments(const char *str);
	Arguments(int c, char **args);
	~Arguments();

	int count() { return m_count; }
	const char *arg(int i);
	bool arg(const char *a);
	const char *str() { return m_str; }

	const char *operator[](int i) { return arg(i); }

protected:
	bool tokenize();

private:
	int m_count;
	char *m_str, **m_tokens;
};

class Function
{
public:
	Function(const char *name, const char *type = "Function");
	virtual ~Function();

	const char *getName() { return m_name; }
	const char *getType() { return m_type; }
	virtual void run(Arguments &args);

	Function *next() { return m_next; }

	static Function *root();
	static Function *findFunction(const char *name);
	static bool execute(Arguments &args);

private:
	class Function *m_next;
	char *m_name, *m_type;
};

class Command: public Function
{
public:
	typedef void (*func_t)(Arguments &);

	Command(const char *name, func_t function);
	~Command();

	void run(Arguments &args);

private:
	func_t m_function;
};

#endif
