-- IOUV v0.7
-- 
-- by Elmek (elmek@mail.bip.net)

utility IOUV "IOUV v0.7"
(
------------------------------
-- ASCII file writer
-- take object obj and export
-- from start st to end et
------------------------------
	fn asciie obj fname =
	(
		file = createfile fname
		format "Named Object: \"%\"\n" obj.name to: file
		format "Tri-mesh, Vertices: %\tFaces: %\n" obj.numtverts obj.numfaces to: file
		format "Vertex List:\n" to: file
		
		for i = 1 to obj.numtverts do
		(
			format "Vertex %: X: %\tY: %\tZ: %\n" (i-1) (iouv.iomap.width.text as float *(gettvert obj i).x) (iouv.iomap.height.text as float * (1-(gettvert obj i).y)) (0 as float)to: file
		)
		format "Face List:\n" to: file
		for i = 1 to obj.numfaces do
		(
			format "Face %: A: % B: % C: % AB: 1 BC: 1 CA: 1\n" (i-1) ((gettvface obj i).z - 1) ((gettvface obj i).y - 1) ((gettvface obj i).x - 1) to: file
		)
		close file
		messagebox "All done"
	)	

----------------------------
----------------------------
-- scanner function scans .asc files in any
-- directory and crosschecks facecounts with
-- the targeted obj to see if they are compatible
-----------------------------
-----------------------------
	fn scanner asc_dir obj =
	(
		temp_f_array = getfiles (asc_dir + "\\*.asc")
		temp_checkstring = "Faces: " + (obj.numfaces as String)
		f_array = #()
		
		for i=1 to temp_f_array.count do
		(
			current_f = openfile temp_f_array[i]
			if (skiptostring current_f temp_checkstring) != undefined do
			(
					append f_array (filenamefrompath temp_f_array[i])
			)
		close current_f
		)
	)
---------------------------
---------------------------
-- getnfo funtion puts a bit of object info
-- into some accessable arrays. Uses a switch
-- to see if it should set up the newfindex
-- as well.
-----------------------------
-----------------------------
	fn getnfo obj bool =
	(
		findex = #()
		cindex = #()
		newfindex = #()
		numb = 0	
		
		for i=1 to obj.numfaces do
		(
			append findex (getTVFace obj i)
		)
		for i=1 to obj.numtverts do
		(
			append cindex (gettvert obj i)
		)
		
		if bool == 1 do
		(
			for i=1 to (findex.count) do
			(
				append newfindex [numb+=1,numb+=1,numb+=1]
			)
		)
	)
--------------------------------
-------------------------------
-- setnfo function finds duplicate tverts and sets 
-- a new facelist to elimiate them. Must have arrays
-- produced by getnfo
-- I wish i knew how to do this a bit smoother and faster,
-- but brute processorforce does work.
----------------------------------
----------------------------------	
	fn setnfo obj =
	(
		local cords = #()
		for i=1 to cindex.count do
		(
			for j=1 to cindex.count do
			(
				if (i!=j) do
				(
					if cindex[i] == cindex[j] do
					(
						for k=1 to newfindex.count do
						(
							if newfindex[k].x == i then \
							   newfindex[k].x =  j
							if newfindex[k].y == i then \
							   newfindex[k].y =  j
							if newfindex[k].z == i then \
							   newfindex[k].z =  j
						)
					)
				)
			)
		)
		for i=1 to newfindex.count do
		(
			if (finditem cords newfindex[i].x == 0) then \
			      append cords newfindex[i].x
			if (finditem cords newfindex[i].y == 0) then \
				  append cords newfindex[i].y
			if (finditem cords newfindex[i].z == 0) then \
				  append cords newfindex[i].z
		)
		newcindex=#()
		for i=1 to cords.count do
		(
			newcindex[i]=cindex[cords[i]]
			
			for j=1 to newfindex.count do
			(
				if cords[i] == newfindex[j].x then \
					newfindex[j].x = i
				if cords[i] == newfindex[j].y then \
					newfindex[j].y = i
				if cords[i] == newfindex[j].z then \
					newfindex[j].z = i
			)
		)
	)
-----------------------------------------------------------------
-- Just a skiptostring variation that always starts from the top of the file
-----------------------------------------------------------------
	fn sts file string =
	(
		seek file 0
		skiptostring file string
	)
	
-----------------------------------
-----------------------------------
-- ascCol() collects information about how
-- the asc file looks and sets up variables
-- about were to find information
-----------------------------------
-----------------------------------
	fn ascCol obj file =
	(
		badfile = 0
		current_f = openfile file
		sts current_f "Vertices: "
		numv = (readDelimitedString current_f " " as Integer)
		sts current_f "Faces: "
		numf = (readDelimitedString current_f "\n" as Integer)

		-- Check L or l
		if sts current_f "Vertex List:" == undefined then
		(
			sts current_f "Vertex list:"
			skiptonextline current_f
			s_vlist = filepos current_f		
		)
		else
		(
			sts current_f "Vertex List:"
			skiptonextline current_f
			s_vlist = filepos current_f
		)

		if sts current_f "Face List:" == undefined then
		(
			sts current_f "Face list:"
			skiptonextline current_f
			s_flist = filepos current_f
		)
		else
		(
			sts current_f "Face List:"
			skiptonextline current_f
			s_flist = filepos current_f
		)
		
		seek current_f s_vlist
		temp_checkstring = readline current_f
		for i=1 to temp_checkstring.count do
		(
			if temp_checkstring[i] == "," do
			(
				delimit = ","
			)
			if temp_checkstring[i] == "." do
			(
				delimit = "."
			)
		)
		
		-- quake2modeller writes a bad facelist it, misses one end of line character
		seek current_f s_flist
		if readchar current_f != "F" do
		(
			badfile = 1
		)	
		
		close current_f
	)
----------------------------------
----------------------------------
-- setCords() sets the new imported
-- cords.
----------------------------------
----------------------------------
	fn setCords obj file =
	(
		current_f = openfile file
		newvert = [0,0]
		newface = [0,0,0]
		if badfile != 0 then
		(
			messagebox "This is a badly formated .ASC file\nread about to the ASC error in\nthe readme file"
		)
		else
		(
			if obj.modifiers.count > 0 then
			(
				messagebox "You must remove all modifiers\nbefore you proceed"
			)
			else
			(
				setnumtverts obj numv false
				seek current_f s_vlist
				for i = 1 to numv do
				(
					skiptostring current_f "X: "
					newvert.x = ((readDelimitedString current_f delimit as Float) / iouv.iomap.width.text as float)
					
					skiptostring current_f "Y: "
					-- Must invert the Y cords due to differances in UV and pixel cords, uv is max at the top pixel is max at bottom
					newvert.y = 1.0-((readDelimitedString current_f delimit as Float) / iouv.iomap.height.text as float)	

					skiptonextline current_f
					settvert obj i newvert.x newvert.y 0
				)
				
				buildtvfaces obj
				seek current_f s_flist
				for i=1 to numf do
				(
					--facesetup is reversed in md2 compared to max
					skiptostring current_f "A:"
					newface.z = readDelimitedString current_f " " as float
					skiptostring current_f "B:"
					newface.y = readDelimitedString current_f " " as float		
					skiptostring current_f "C:"
					newface.x = readDelimitedString current_f " " as float
					if i != numf do -- just so we dont skip to long on the last line
					(
						skiptonextline current_f
			--			skiptonextline current_f
					)
					newface += 1 -- add one so that vert index match
					settvface obj i newface
				)
		
				-- all done
				close current_f
				update obj
				messagebox "All done..."
			)
		)
	)
	
----------------------------------
-- IOUV main gui
----------------------------------

	pickbutton pick_obj "Pick Object"
	button b_float "Open" align:#left across:2
	spinner s_float "Size: " range:[200,800,400] type:#integer fieldWidth:30
	
-----------------------------------	
-- Project information rollout
-----------------------------------
	rollout prj_info "Project Info"
	(
		group ""
		(
			label topic "Project Path:" align:#left across:2
			button set_prjpath "set" align:#right
			label prjpath "undefined" align:#left
		)
		group ""
		(
			label l_c_obj "Current Object:" align:#left across:2
			button upd_c_obj "update" align:#right
			label l_name_c_obj "Name:" align:#left across:2
			label name_c_obj "n/a" align:#right
			label l_fc_c_obj "Faces:" align:#left across:2
			label fc_c_obj "n/a"align:#right
			label l_tv_c_obj "TVerts:" align:#left across:2
			label tv_c_obj "n/a" align:#right
		)
		
		on prj_info open do
		(
			prjpath.enabled = false
			name_c_obj.enabled = false
			fc_c_obj.enabled = false
			tv_c_obj.enabled = false
		)
		
		on set_prjpath pressed do
		(
			c_prjpath = getsavepath caption:"Project Path"
			if (c_prjpath != undefined) do
			(
				prjpath.text = c_prjpath
				prjpath.enabled = true
				scanner c_prjpath c_obj
				iouv.iomap.asc_files.items = f_array				
			)
		)
		
		on upd_c_obj pressed do
		(
			if name_c_obj.enabled == false do
			(
				name_c_obj.enabled = true
				fc_c_obj.enabled = true
				tv_c_obj.enabled = true
			)
			name_c_obj.text = c_obj.name
			fc_c_obj.text = c_obj.numfaces as String
			tv_c_obj.text = c_obj.numtverts as String
		)
	)
	
-------------------------------------
-- Mapping import/export rollout
-------------------------------------

	rollout iomap "I/O Mapping"
	(
		listbox asc_files "Compatible mapping files:"
		label empty1
		label lw "Width" across: 2
		label lh "Height"
		edittext width "" across: 2
		edittext height ""
		button map_imp "import" align:#right across: 2 
		button map_exp "export" align:#left
	
		on iomap open do
		(
			map_imp.enabled = false
			width.text = "256"
			height.text = "256"
		)
		
		on asc_files selected i do
		(
			f_name = iouv.prj_info.prjpath.text + "\\" + asc_files.items[i]
			map_imp.enabled = true
		)
	
		on map_imp pressed do
		(
			ascCol c_obj f_name
			setcords c_obj f_name
		)
		on map_exp pressed do
		(
			if (c_file = getsavefilename caption:"Export ASC mapping") != undefined do
			(
				asciie c_obj c_file
			)
		)
	)

----------------------------------------------
-- Splitter rollout, used to join/split cords
-----------------------------------------------

	rollout splitter "Splitter"
	(
		button split "Split all" across:2
		-- button split2 "Split this" across:2
		button join "Join"
	
		on split pressed do
		(
			if c_obj == undefined then
			(
				messagebox "No object specified"
			)
			else
			(
				--collect information
				getnfo c_obj 1
				--set information	
				setnumtverts c_obj (newfindex.count * 3)
				buildtvfaces c_obj		
				for i=1 to newfindex.count do
				(
					settvface c_obj i newfindex[i]
				)
				c_count = 0			
				for i=1 to newfindex.count do
				(
					settvert c_obj (c_count+=1) (cindex[findex[i].x])
					settvert c_obj (c_count+=1) (cindex[findex[i].y])
					settvert c_obj (c_count+=1) (cindex[findex[i].z])
				)
			
				--done so update object
				update c_obj
			)
		)		
		
		on join pressed do
		(
			getnfo c_obj 1
			setnfo c_obj
		
			setnumtverts c_obj newcindex.count false
		
			for i=1 to newcindex.count do
			(
				settvert c_obj i newcindex[i]
			)
			
			buildtvfaces c_obj		
			for i=1 to newfindex.count do
			(
				settvface c_obj i newfindex[i]
			)			
	
			update c_obj
		)
	)
	
---------------------------
-- Main IOUV actions
---------------------------
	
	on iouv open do
	(
		b_float.enabled = false
	)
	
	on pick_obj picked obj do
	(
		c_obj = obj
		pick_obj.text = obj.name
		b_float.enabled = true
	)
	
	on b_float pressed do
	(
		r_iouv = newRolloutFloater "IOUV toolbox" 200 s_float.value
		addrollout prj_info r_iouv
		addRollout iomap r_iouv
		addRollout splitter r_iouv
	)
)


