// Laser Beam Color Codes
#define Laser_Red         0xf2f2f0f0  // bright red
#define Laser_Green       0xd0d1d2d3  // bright green
#define Laser_Blue        0xf3f3f1f1  // bright blue
#define Laser_Yellow      0xdcdddedf  // bright yellow
#define Laser_YellowS     0xe0e1e2e3  // yellow strobe
#define Laser_DkPurple    0x80818283  // dark purple
#define Laser_LtBlue      0x70717273  // light blue
#define Laser_Green2      0x90919293  // different green
#define Laser_Purple      0xb0b1b2b3  // purple
#define Laser_Red2        0x40414243  // different red
#define Laser_Orange      0xe2e5e3e6  // orange
#define Laser_Mix         0xd0f1d3f3  // mixture
#define Laser_RedBlue     0xf2f3f0f1  // inner = red, outer = blue
#define Laser_BlueRed     0xf3f2f1f0  // inner = blue, outer = red
#define Laser_GreenY      0xdad0dcd2  // inner = green, outer = yellow
#define Laser_YellowG     0xd0dad2dc  // inner = yellow, outer = green

#define steplen 24
#define jumplen 96

#define STATE_UP   2
#define STATE_DOWN 3

#define bBACKWARD -1
#define bUP        0
#define bFORWARD   1
#define bLEFT      2
#define bRIGHT     3

// new mask for anti-lava traces
#define MASK_LAVASTOP (CONTENTS_LAVA|CONTENTS_SLIME)

void SelectSpawnPoint(edict_t *ent, vec3_t origin, vec3_t angles);
void ClientUserinfoChanged (edict_t *ent, char *userinfo);
void CopyToBodyQue(edict_t *ent);
void ClientThink(edict_t *ent, usercmd_t *cmd);
void Use_Plat (edict_t *ent, edict_t *other, edict_t *activator);
void TossClientWeapon (edict_t *self);

qboolean ClientConnect (edict_t *ent, char *userinfo);

void Svcmd_Bot_f(void);
void Bot_Create(void);
void Bot_Spawn(edict_t *ent);
void Bot_Respawn(edict_t *ent);
void bThink(edict_t *bot);
void bAI(edict_t *bot, usercmd_t *cmd, vec3_t cmd_angles);
void bChangeYaw(edict_t *bot, vec3_t cmd_angles);
void bSwim(edict_t *bot, usercmd_t *cmd, vec3_t cmd_angles);
void bClimbLadder(edict_t  *bot, usercmd_t *cmd, vec3_t cmd_angles);
void bRidePlatform(edict_t *bot, usercmd_t *cmd, vec3_t cmd_angles);
void GetBestWeapon(edict_t *self);
void bMoveToGoal(edict_t *bot, edict_t *goal, usercmd_t *cmd, vec3_t cmd_angles);
void GetFarWeapon(edict_t *self);
void GetCloseWeapon(edict_t *self);
void bFace(edict_t *bot, edict_t *target, vec3_t angles);
void wItemSearch (edict_t *bot);
void bNewChaseDir(edict_t *bot, edict_t *goal, float dist, vec3_t cmd_angles);
void bMoveToEnemy(edict_t *bot, usercmd_t *cmd, vec3_t cmd_angles);
void wEnemySearch (edict_t *bot);
void bMoveToItem(edict_t *bot, usercmd_t *cmd, vec3_t cmd_angles);
void gi_cprintf(edict_t *ent, int printlevel, char *fmt, ...);
void gi_centerprintf(edict_t *ent, char *fmt, ...);
void gi_bprintf(int printlevel, char *fmt, ...);
void Bot_Spawn(edict_t *ent);
void bPain(edict_t *bot, edict_t *other, float kickback, int damage);
void bTouch(edict_t *bot, edict_t *other, cplane_t *plane, csurface_t *surf);

qboolean G_EntExists(edict_t *ent);
qboolean G_ClientNotDead(edict_t *ent);
qboolean G_ClientInGame(edict_t *ent);
qboolean bDodgeFire(edict_t *bot, usercmd_t *cmd, vec3_t cmd_angles);
qboolean bAttack(edict_t *bot, usercmd_t *cmd, vec3_t cmd_angles);
qboolean bGetItem(edict_t *bot, usercmd_t *cmd, vec3_t cmd_angles);
qboolean visible2(edict_t *self, edict_t *other);
qboolean bCanStep(edict_t *bot, float yaw, float dist, vec3_t cmd_angles);
qboolean HasItemInInventory(edict_t *self, gitem_t *item);
qboolean G_ClientInGame(edict_t *ent);
qboolean IsWeapon(gitem_t *item);
qboolean bCanMove(edict_t *bot, float length, int dir);
qboolean bRun(edict_t *bot, usercmd_t *cmd, int dir);
qboolean wVisible (vec3_t spot1, vec3_t spot2);

edict_t *bSeekEnemy(edict_t *bot);
edict_t *bSeekItem(edict_t *bot);
edict_t *bSeekHealth(edict_t *bot);

float G_Distance(edict_t *ent1, edict_t *ent2);
float bDistance(vec3_t spot1, vec3_t spot2);

#define ent_isabot (Q_stricmp(ent->classname, "bot") == 0)
#define self_isabot (Q_stricmp(self->classname, "bot") == 0)
#define other_isabot (Q_stricmp(other->classname, "bot") == 0)
#define not_ent_isabot (Q_stricmp(ent->classname, "bot") != 0)
#define not_self_isabot (Q_stricmp(self->classname, "bot") != 0)
#define not_other_isabot (Q_stricmp(other->classname, "bot") != 0)