#include "g_local.h"

void Svcmd_Bot_f(void)
{
	char *arg = gi.argv(2);

	if (Q_stricmp(arg, "spawn") == 0)
		Bot_Create();
}

void Bot_Create(void)
{
	int 	 i;
	char	 userinfo[MAX_INFO_STRING];
	edict_t *bot;

	// quick and functional replacement for Maj.Bitch's clientnum system
	for (i = maxclients->value; i > 0; i--)
	{
		bot = g_edicts + i + 1;
		if (!bot->inuse)
			break;
	}

	if (bot->inuse)
		bot = NULL;

	if (bot)
	{
		char handstr[2];
		char namestr[30];
		char skinstr[256];
		char genderstr[30];

		memset(userinfo, 0, MAX_INFO_STRING);
		
		sprintf(handstr,"%d", rand()&2);
		sprintf(namestr,"%s", "RainBot"); // ini file?
		strcpy(skinstr, "male/kw_aqua"); // and here too
		strcpy(genderstr, "male"); // here.. we need to check the skin?
		
		// Set the pertinent user information..
		Info_SetValueForKey(userinfo, "name", namestr);
		Info_SetValueForKey(userinfo, "ip",   "127.0.0.1");
		Info_SetValueForKey(userinfo, "skin", skinstr);
		Info_SetValueForKey(userinfo, "hand", handstr);
		Info_SetValueForKey(userinfo, "fov",  "90");
		Info_SetValueForKey(userinfo, "gender", genderstr);
		
		G_InitEdict(bot);

		bot->client=&game.clients[bot-g_edicts-1];
		
		InitClientResp(bot->client);
		
		InitClientPersistant(bot->client);

		ClientUserinfoChanged(bot, userinfo);

		Bot_Spawn(bot);

		gi.WriteByte(svc_muzzleflash);
		gi.WriteShort(bot - g_edicts);
		gi.WriteByte(MZ_LOGIN);
		gi.multicast(bot->s.origin, MULTICAST_PVS);

		gi_bprintf(PRINT_HIGH, "%s entered the game\n", bot->client->pers.netname);
		ClientEndServerFrame(bot);

		StartWaypointSystem(bot);
	}
	else
		gi.dprintf("%s cannot connect - server is full\n", "RainBot");
}

void Bot_Spawn(edict_t *ent)
{
	vec3_t	mins = {-16, -16, -24};
	vec3_t	maxs = {16, 16, 32};
	int		index;
	vec3_t	spawn_origin, spawn_angles;
	gclient_t	*client;
	int		i;
	client_persistant_t	saved;
	client_respawn_t	resp;
	char		userinfo[MAX_INFO_STRING];

	// find a spawn point
	// do it before setting health back up, so farthest
	// ranging doesn't count this client
	SelectSpawnPoint (ent, spawn_origin, spawn_angles);

	index = ent-g_edicts-1;
	client = ent->client;

	resp = client->resp;
	memcpy (userinfo, client->pers.userinfo, sizeof(userinfo));
	InitClientPersistant (client);
	ClientUserinfoChanged (ent, userinfo);

	// clear everything but the persistant data
	saved = client->pers;
	memset (client, 0, sizeof(*client));
	client->pers = saved;
	if (client->pers.health <= 0)
		InitClientPersistant(client);
	client->resp = resp;

	// copy some data from the client to the entity
	FetchClientEntData (ent);

	// clear entity values
	ent->groundentity = NULL;
	ent->client = &game.clients[index];
	ent->takedamage = DAMAGE_YES;
	ent->movetype = MOVETYPE_WALK;
	ent->viewheight = 22;
	ent->inuse = true;
	ent->classname = "bot";
	ent->mass = 200;
	ent->solid = SOLID_BBOX;
	ent->deadflag = DEAD_NO;
	ent->air_finished = level.time + 12;
	ent->clipmask = MASK_PLAYERSOLID;
	ent->model = "players/male/tris.md2";
	ent->pain = bPain;
	ent->die = player_die;
	ent->waterlevel = 0;
	ent->watertype = 0;
	ent->flags &= ~FL_NO_KNOCKBACK;
	ent->svflags &= ~SVF_DEADMONSTER;
	ent->think = bThink;
	ent->nextthink = level.time + 0.1;

    ent->yaw_speed = 50;
    ent->enemy=NULL;
    ent->itemwant=NULL;

    ent->weap_delay = level.time;
    ent->last_jump = level.time;
    ent->pausetime = level.time;

    ent->on_platform=false;
    ent->on_ladder=false;
	ent->attacked = false;

    ent->pain = bPain;
    ent->touch = bTouch;
    ent->think = bThink;
    ent->nextthink = level.time + 0.1;

	VectorCopy (mins, ent->mins);
	VectorCopy (maxs, ent->maxs);
	VectorClear (ent->velocity);

	// clear playerstate values
	memset (&ent->client->ps, 0, sizeof(client->ps));

	client->ps.pmove.origin[0] = spawn_origin[0]*8;
	client->ps.pmove.origin[1] = spawn_origin[1]*8;
	client->ps.pmove.origin[2] = spawn_origin[2]*8;

	// clear entity state values
	ent->s.effects = 0;
	ent->s.modelindex = 255;		// will use the skin specified model
	ent->s.modelindex2 = 255;		// custom gun model
	// sknum is player num and weapon number
	// weapon number will be added in changeweapon
	ent->s.skinnum = ent - g_edicts - 1;

	ent->s.frame = 0;
	VectorCopy (spawn_origin, ent->s.origin);
	ent->s.origin[2] += 1;	// make sure off ground
	VectorCopy (ent->s.origin, ent->s.old_origin);

	// set the delta angle
	for (i=0 ; i<3 ; i++)
	{
		client->ps.pmove.delta_angles[i] = ANGLE2SHORT(spawn_angles[i] - client->resp.cmd_angles[i]);
	}

	ent->s.angles[PITCH] = 0;
	ent->s.angles[YAW] = spawn_angles[YAW];
	ent->s.angles[ROLL] = 0;
	VectorCopy (ent->s.angles, client->ps.viewangles);
	VectorCopy (ent->s.angles, client->v_angle);

	if (!KillBox (ent))
	{	// could't spawn in?
	}

	gi.linkentity (ent);

	// force the current weapon up
	client->newweapon = client->pers.weapon;
	ChangeWeapon (ent);
}
